local E, C, L, DB = unpack(select(2, ...)) -- Import Functions/Constants, Config, Locales
if C["skin"].enable ~= true or C["skin"].Character ~= true then return end

local function LoadSkin()
	E.SkinCloseButton(CharacterFrameCloseButton)
	
	local slots = { "HeadSlot", "NeckSlot", "ShoulderSlot", "BackSlot", "ChestSlot", "ShirtSlot", "TabardSlot", "WristSlot", "HandsSlot", "WaistSlot", "LegsSlot", "FeetSlot", "Finger0Slot", "Finger1Slot", "Trinket0Slot", "Trinket1Slot", "MainHandSlot", "SecondaryHandSlot", "RangedSlot",'AmmoSlot' }
	
	for _, slot in pairs(slots) do
		local icon = _G["Character"..slot.."IconTexture"]
		local slot = _G["Character"..slot]
		slot:StripTextures()
		slot:StyleButton(false)
		slot:SetTemplate("Default", true)
		icon:SetTexCoord(unpack(E.TexCoords))
		icon:ClearAllPoints()
		icon:SetInside()
	end	

	local function ColorItemBorder()
		for _, slot in pairs(slots) do
			local target = _G["Character"..slot]
			local slotId, _, _ = GetInventorySlotInfo(slot)
			local itemId = GetInventoryItemID("player", slotId)

			if itemId then
				local _, _, rarity, _, _, _, _, _, _, _, _ = GetItemInfo(itemId)
				if rarity and rarity > 1 then
					target:SetBackdropBorderColor(GetItemQualityColor(rarity))
				else
					target:SetBackdropBorderColor(unpack(C.media.bordercolor))
				end
			else
				target:SetBackdropBorderColor(unpack(C.media.bordercolor))
			end
		end
	end

	local CheckItemBorderColor = CreateFrame("Frame")
	CheckItemBorderColor:RegisterEvent("PLAYER_EQUIPMENT_CHANGED")
	CheckItemBorderColor:SetScript("OnEvent", ColorItemBorder)	
	CharacterFrame:HookScript("OnShow", ColorItemBorder)
	ColorItemBorder()
	
	local KillTextures = {
		"CharacterFramePortrait",
	}

	for _, texture in pairs(KillTextures) do
		_G[texture]:Kill()
	end
	
	local StripAllTextures = {
		'CharacterFrame',
		'PlayerTitleFrame',
		'PlayerTitlePickerScrollFrame',
		'PlayerTitlePickerFrame',
		'PaperDollFrame',
		'CharacterAttributesFrame',
		'PlayerStatFrameLeftDropDown',
		'PlayerStatFrameRightDropDown',
		'PetPaperDollFrame',
		'PetPaperDollFrameCompanionFrame',
		'ReputationFrame',
		'SkillFrame',
		'TokenFrame',
	}

	for _, object in pairs(StripAllTextures) do
		_G[object]:StripTextures()
	end
	
	CharacterFrame:CreateBackdrop("Transparent")
	CharacterFrame.backdrop:Point("TOPLEFT", 10, -12)
	CharacterFrame.backdrop:Point("BOTTOMRIGHT", -31, 76)
	
	E.SkinNextPrevButton(PlayerTitleFrameButton)
	PlayerTitlePickerFrame:SetTemplate("Transparent")
	E.SkinScrollBar(PlayerTitlePickerScrollFrameScrollBar)
	
	local SkinRotateButton = {
		'CharacterModelFrameRotateLeftButton',
		'CharacterModelFrameRotateRightButton',
		'CompanionModelFrameRotateLeftButton',
		'CompanionModelFrameRotateRightButton',
	}
	
	for _, object in pairs(SkinRotateButton) do
		E.SkinRotateButton(_G[object])
	end
	
	E.SkinNextPrevButton(PlayerStatFrameLeftDropDownButton)
	E.SkinNextPrevButton(PlayerStatFrameRightDropDownButton)
	
	for i=1, 5 do
		E.SkinTab(_G["CharacterFrameTab"..i])
	end
	
	for i=1, 3 do
		E.SkinTab(_G["PetPaperDollFrameTab"..i])
	end
	
	E.SkinButton(CompanionSummonButton)
	
	E.SkinNextPrevButton(CompanionPrevPageButton)
	E.SkinNextPrevButton(CompanionNextPageButton)
	
	local function UpdateFactionSkins()
		ReputationListScrollFrame:StripTextures()
		E.SkinScrollBar(ReputationListScrollFrameScrollBar)

		for i=1, GetNumFactions() do
			local statusbar = _G["ReputationBar"..i.."ReputationBar"]

			if statusbar then
				statusbar:SetStatusBarTexture(C["media"].normTex)
				
				if not statusbar.backdrop then
					statusbar:CreateBackdrop("Default")
				end
				
				_G["ReputationBar"..i.."Background"]:SetTexture(nil)
				_G["ReputationBar"..i.."LeftLine"]:Kill()
				_G["ReputationBar"..i.."BottomLine"]:Kill()
				_G["ReputationBar"..i.."ReputationBarHighlight1"]:SetTexture(nil)
				_G["ReputationBar"..i.."ReputationBarHighlight2"]:SetTexture(nil)	
				_G["ReputationBar"..i.."ReputationBarAtWarHighlight1"]:SetTexture(nil)
				_G["ReputationBar"..i.."ReputationBarAtWarHighlight2"]:SetTexture(nil)
				_G["ReputationBar"..i.."ReputationBarLeftTexture"]:SetTexture(nil)
				_G["ReputationBar"..i.."ReputationBarRightTexture"]:SetTexture(nil)
				
			end		
		end
		ReputationDetailFrame:StripTextures()
		ReputationDetailFrame:CreateBackdrop("Transparent")
		E.SkinCloseButton(ReputationDetailCloseButton)
		E.SkinCheckBox(ReputationDetailAtWarCheckBox)
		E.SkinCheckBox(ReputationDetailMainScreenCheckBox)
		E.SkinCheckBox(ReputationDetailInactiveCheckBox)
	end	
	ReputationFrame:HookScript("OnShow", UpdateFactionSkins)
	hooksecurefunc("ExpandFactionHeader", UpdateFactionSkins)
	hooksecurefunc("CollapseFactionHeader", UpdateFactionSkins)
	
	for i = 1, NUM_FACTIONS_DISPLAYED do
		local bu = _G["ReputationBar"..i.."ExpandOrCollapseButton"]
		E.SkinExpandOrCollapse(bu)
	end
	
	hooksecurefunc("ReputationFrame_Update", function()
		local numFactions = GetNumFactions()
		local factionIndex, factionButton, isCollapsed
		local factionOffset = FauxScrollFrame_GetOffset(ReputationListScrollFrame)

		for i = 1, NUM_FACTIONS_DISPLAYED do
			factionIndex = factionOffset + i
			factionButton = _G["ReputationBar"..i.."ExpandOrCollapseButton"]

			if factionIndex <= numFactions then
				_, _, _, _, _, _, _, _, _, isCollapsed = GetFactionInfo(factionIndex)
				if isCollapsed then
					factionButton.plus:Show()
				else
					factionButton.plus:Hide()
				end
			end
		end
	end)
	
	local function UpdateSkillFrame()
		for i=1, GetNumSkillLines() do
			local statusbar = _G["SkillRankFrame"..i]
			if statusbar then
				statusbar:SetStatusBarTexture(C["media"].normTex)
				
				if not statusbar.backdrop then
					statusbar:CreateBackdrop("Default")
				end
				
				_G["SkillRankFrame"..i.."Background"]:SetTexture(nil)
				_G["SkillRankFrame"..i.."Border"]:StripTextures()
				
			end	
		end
		SkillFrameExpandButtonFrame:StripTextures()
		SkillListScrollFrame:StripTextures()
		SkillDetailScrollFrame:StripTextures()
		E.SkinScrollBar(SkillListScrollFrameScrollBar)
		E.SkinScrollBar(SkillDetailScrollFrameScrollBar)
		E.SkinButton(SkillFrameCancelButton)
	end
	SkillFrame:HookScript("OnShow", UpdateSkillFrame)
	
	TokenFrame:HookScript("OnShow", function()
		TokenFrameContainerScrollChild:StripTextures()
		TokenFramePopup:StripTextures()
		TokenFramePopup:SetTemplate("Transparent")
		E.SkinCloseButton(TokenFramePopupCloseButton)
		E.SkinCheckBox(TokenFramePopupInactiveCheckBox)
		E.SkinCheckBox(TokenFramePopupBackpackCheckBox)
		E.SkinScrollBar(TokenFrameContainerScrollBar)
		E.SkinButton(TokenFrameCancelButton)
	end)
end

tinsert(E.SkinFuncs["ElvUI"], LoadSkin)