local E, C, L, DB = unpack(select(2, ...)) -- Import Functions/Constants, Config, Locales

local function SpellName(id)
	local name, _, _, _, _, _, _, _, _ = GetSpellInfo(id) 	
	return name
end

--[[
		This file is for adding of deleting a spellID.
		
		The best way to add or delete spell is to go at www.wowhead.com, search for a spell :
		Example : Incinerate Flesh from Lord Jaraxxus -> http://www.wowhead.com/?spell=67049
		Take the number ID at the end of the URL, and add it to the list
		
		That's it, That's all! 
		
		Elv
]]-- 


--List of spells to display ticks
E.ChannelTicks = {
	--Warlock
	[SpellName(689)] = 3, -- "Drain Life"
	[SpellName(5740)] = 4, -- "Rain of Fire"
	[SpellName(755)] = 3, -- Health Funnel
	--Druid
	[SpellName(44203)] = 4, -- "Tranquility"
	[SpellName(16914)] = 10, -- "Hurricane"
	--Priest
	[SpellName(15407)] = 3, -- "Mind Flay"
	[SpellName(48045)] = 5, -- "Mind Sear"
	[SpellName(47540)] = 2, -- "Penance"
	--Mage
	[SpellName(5143)] = 5, -- "Arcane Missiles"
	[SpellName(10)] = 5, -- "Blizzard"
	[SpellName(12051)] = 4, -- "Evocation"
}

--List of buffs to watch for on arena frames
E.ArenaBuffWhiteList = {
	-- Buffs
		[SpellName(1022)] = true, --hop
		[SpellName(12051)] = true, --evoc
		[SpellName(2825)] = true, --BL
		[SpellName(32182)] = true, --Heroism
		[SpellName(33206)] = true, --Pain Suppression
		[SpellName(29166)] = true, --Innervate
		[SpellName(18708)] = true, --"Fel Domination"
		[SpellName(54428)] = true, --divine plea
		[SpellName(31821)] = true, -- aura mastery

	-- Turtling abilities
		[SpellName(871)] = true, --Shield Wall
		[SpellName(48707)] = true, --"Anti-Magic Shell"
		[SpellName(31224)] = true, -- cloak of shadows
		[SpellName(19263)] = true, -- deterance

	-- Immunities
		[SpellName(45438)] = true, -- ice Brock
		[SpellName(642)] = true, -- pally bubble from hell
		
	-- Offensive Shit
		[SpellName(31884)] = true,
		[SpellName(34471)] = true, -- beast within
}

-- Target/Arena Frames/ Nameplates use these
E.DebuffWhiteList = {
	-- Death Knight
		[SpellName(51209)] = true, --hungering cold
		[SpellName(47476)] = true, --strangulate
	-- Druid
		[SpellName(33786)] = true, --Cyclone
		[SpellName(2637)] = true, --Hibernate
		[SpellName(339)] = true, --Entangling Roots
	-- Hunter
		[SpellName(3355)] = true, --Freezing Trap Effect
		[SpellName(60210)] = true, --Freezing Arrow Effect
		[SpellName(1513)] = true, --scare beast
		[SpellName(19503)] = true, --scatter shot
		[SpellName(34490)] = true, --silence shot
	-- Mage
		[SpellName(31661)] = true, --Dragon's Breath
		[SpellName(61305)] = true, --Polymorph
		[SpellName(31589)] = true, --Slow
		[SpellName(18469)] = true, --Silenced - Improved Counterspell
		[SpellName(122)] = true, --Frost Nova
		[SpellName(55080)] = true, --Shattered Barrier
	-- Paladin
		[SpellName(20066)] = true, --Repentance
		[SpellName(10326)] = true, --Turn Evil
		[SpellName(853)] = true, --Hammer of Justice
	-- Priest
		[SpellName(605)] = true, --Mind Control
		[SpellName(64044)] = true, --Psychic Horror
		[SpellName(8122)] = true, --Psychic Scream
		[SpellName(9484)] = true, --Shackle Undead
		[SpellName(15487)] = true, --Silence
	-- Rogue
		[SpellName(2094)] = true, --Blind
		[SpellName(1776)] = true, --Gouge
		[SpellName(6770)] = true, --Sap
		[SpellName(18425)] = true, --Silenced - Improved Kick
	-- Shaman
		[SpellName(51514)] = true, --Hex
		[SpellName(3600)] = true, --Earthbind
		[SpellName(8056)] = true, --Frost Shock
		[SpellName(63685)] = true, --Freeze
		[SpellName(39796)] = true, --Stoneclaw Stun
	-- Warlock
		[SpellName(710)] = true, --Banish
		[SpellName(6789)] = true, --Death Coil
		[SpellName(5782)] = true, --Fear
		[SpellName(17928)] = true, --Howl of Terror
		[SpellName(6358)] = true, --Seduction
		[SpellName(30283)] = true, --Shadowfury
	-- Warrior
		[SpellName(20511)] = true, --Intimidating Shout
	-- Racial
		[SpellName(25046)] = true, --Arcane Torrent
		
	--PVE Debuffs
		
	-- Lich King
		[SpellName(73787)] = true, --Necrotic Plague
}

--List of debuffs for targetframe for pvp only (when inside a bg/arena
--We do this because in PVE Situations we don't want to see these debuffs on our target frame, arena frames will always show these.
E.TargetPVPOnly = {
	[SpellName(34438)] = true, --UA
	[SpellName(34914)] = true, --VT
	[SpellName(31935)] = true, --avengers shield
	[SpellName(63529)] = true, --shield of the templar
	[SpellName(19386)] = true, --wyvern sting
	[SpellName(116)] = true, --frostbolt
	[SpellName(58179)] = true, --infected wounds
	[SpellName(18223)] = true, -- curse of exhaustion
	[SpellName(18118)] = true, --aftermath
	[SpellName(31589)] = true, --Slow
	--not sure if this one belongs here but i do know frost pve uses this
	[SpellName(44572)] = true, --deep freeze
}

-------------------------------------------------------------
-- Debuff Filters
-------------------------------------------------------------

-- Debuffs to always hide
-- DPS Raid vertical frames use this. Player, TargetTarget, Focus always use it.
E.DebuffBlacklist = {
	[SpellName(57724)] = true, --Sated
	[SpellName(25771)] = true, --forbearance
	[SpellName(36032)] = true, --arcane blast
	[SpellName(58539)] = true, --watchers corpse
	[SpellName(26013)] = true, --deserter
	[SpellName(6788)] = true, --weakended soul
	[SpellName(71041)] = true, --dungeon deserter
	[SpellName(41425)] = true, --"Hypothermia"
	[SpellName(55711)] = true, --Weakened Heart
	[SpellName(28531)] = true, --frost aura (naxx)
	[SpellName(67604)] = true, --Powering Up toc
	[SpellName(69127)] = true, --chill of the throne.. fucking gay ass icc debuff
	[SpellName(8326)] = true, --ghost
	[SpellName(20584)] = true, --ghost
	[SpellName(23445)] = true, --evil twin
	[SpellName(25163)] = true, --fucking annoying pet debuff oozeling disgusting aura
	
	--Blood Princes
	[SpellName(71911)] = true, --shadow resonance
	
	--Festergut
	[SpellName(72144)] = true, --"Orange Blight Residue"
	[SpellName(73034)] = true, --Blighted Spores
	[SpellName(70852)] = true, --Malleable Goo
	
	--Rotface
	[SpellName(72145)] = true, --"Green Blight Residue"
	
	--Putricide
	[SpellName(72511)] = true, --Mutated Transformation
	
	[SpellName(72460)] = true, --Choking Gas
}

--RAID DEBUFFS
E.RaidDebuffs = {
-- Naxxramas
	[SpellName(27808)] = true, -- Frost Blast
	[SpellName(32407)] = true, -- Strange Aura
	[SpellName(28408)] = true, -- Chains of Kel'Thuzad

-- Ulduar
	[SpellName(66313)] = true, -- Fire Bomb
	[SpellName(63134)] = true, -- Sara's Blessing
	[SpellName(62717)] = true, -- Slag Pot
	[SpellName(63018)] = true, -- Searing Light
	[SpellName(64233)] = true, -- Gravity Bomb
	[SpellName(63495)] = true, -- Static Disruption

-- Trial of the Crusader
	[SpellName(66406)] = true, -- Snobolled!
	[SpellName(67574)] = true, -- Pursued by Anub'arak
	[SpellName(68509)] = true, -- Penetrating Cold
	[SpellName(67651)] = true, -- Arctic Breath
	[SpellName(68127)] = true, -- Legion Flame
	[SpellName(67049)] = true, -- Incinerate Flesh
	[SpellName(66869)] = true, -- Burning Bile
	[SpellName(66823)] = true, -- Paralytic Toxin

-- Icecrown Citadel
	[SpellName(71224)] = true, -- Mutated Infection
	[SpellName(71822)] = true, -- Shadow Resonance
	[SpellName(70447)] = true, -- Volatile Ooze Adhesive
	[SpellName(72293)] = true, -- Mark of the Fallen Champion
	[SpellName(72448)] = true, -- Rune of Blood
	[SpellName(71473)] = true, -- Essence of the Blood Queen
	[SpellName(71624)] = true, -- Delirious Slash
	[SpellName(70923)] = true, -- Uncontrollable Frenzy
	[SpellName(70588)] = true, -- Suppression
	[SpellName(71738)] = true, -- Corrosion
	[SpellName(71733)] = true, -- Acid Burst
	[SpellName(72108)] = true, -- Death and Decay
	[SpellName(71289)] = true, -- Dominate Mind
	[SpellName(69762)] = true, -- Unchained Magic
	[SpellName(69651)] = true, -- Wounding Strike
	[SpellName(69065)] = true, -- Impaled
	[SpellName(71218)] = true, -- Vile Gas
	[SpellName(72442)] = true, -- Boiling Blood
	[SpellName(72769)] = true, -- Scent of Blood (heroic)
	[SpellName(69279)] = true, -- Gas Spore
	[SpellName(70949)] = true, -- Essence of the Blood Queen (hand icon)
	[SpellName(72151)] = true, -- Frenzied Bloodthirst (bite icon)
	[SpellName(71474)] = true, -- Frenzied Bloodthirst (red bite icon)
	[SpellName(71340)] = true, -- Pact of the Darkfallen
	[SpellName(72985)] = true, -- Swarming Shadows (pink icon)
	[SpellName(71267)] = true, -- Swarming Shadows (black purple icon)
	[SpellName(71264)] = true, -- Swarming Shadows (swirl icon)
	[SpellName(71807)] = true, -- Glittering Sparks
	[SpellName(70873)] = true, -- Emerald Vigor
	[SpellName(71283)] = true, -- Gut Spray
	[SpellName(69766)] = true, -- Instability
	[SpellName(70126)] = true, -- Frost Beacon
	[SpellName(70157)] = true, -- Ice Tomb
	[SpellName(71056)] = true, -- Frost Breath
	[SpellName(70106)] = true, -- Chilled to the Bone
	[SpellName(70128)] = true, -- Mystic Buffet
	[SpellName(73785)] = true, -- Necrotic Plague
	[SpellName(73779)] = true, -- Infest
	[SpellName(73800)] = true, -- Soul Shriek
	[SpellName(73797)] = true, -- Soul Reaper
	[SpellName(73708)] = true, -- Defile
	[SpellName(74322)] = true, -- Harvested Soul
		
--Ruby Sanctum
	[SpellName(74502)] = true, --Enervating Brand
	[SpellName(75887)] = true, --Blazing Aura  
	[SpellName(74562)] = true, --Fiery Combustion
	[SpellName(74567)] = true, --Mark of Combustion (Fire)
	[SpellName(74792)] = true, --Soul Consumption
	[SpellName(74795)] = true, --Mark Of Consumption (Soul)

-- Other debuff
	[SpellName(67479)] = true, -- Impale
}


E.ReverseTimer = {
	[92956] = true, -- Sinestra (Wrack)
	[89435] = true, -- Sinestra (Wrack)
	[92955] = true, -- Sinestra (Wrack)
	[89421] = true, -- Sinestra (Wrack)
}