﻿---------------------------------------------------------------------------------------------
-- AddOn Name: ElvUI 3.x
-- Author: Bunny
-- Description: ElvUI
-- Credits:
local E, C, L, DB = unpack(select(2, ...))

if not( C['unitframes']['enable'] == true ) then return end

local PLAYER_WIDTH = C['unitframes']['playtarwidth']
local PLAYER_HEIGHT = C['unitframes']['playtarheight']
local TARGET_WIDTH = C['unitframes']['playtarwidth']
local TARGET_HEIGHT = C['unitframes']['playtarheight']
local SMALL_WIDTH = C['unitframes']['smallwidth']
local SMALL_HEIGHT = C['unitframes']['smallheight']
local TANK_WIDTH = C['unitframes']['assisttankwidth']
local TANK_HEIGHT = C['unitframes']['assisttankheight']
local BOSS_WIDTH = C['unitframes']['arenabosswidth']
local BOSS_HEIGHT = C['unitframes']['arenabossheight']
local BORDER = E.Border
local SPACING = E.Spacing
local FONTSIZE = C['unitframes']['fontsize']
local FONT = C['unitframes']['font']
local NORMTEX = C['media']['normTex']
local POWERTHEME = C['unitframes']['mini_powerbar']
local USE_POWERBAR_OFFSET = C['unitframes']['powerbar_offset'] ~= 0
local POWERBAR_OFFSET = C['unitframes']['powerbar_offset']
local MINI_CLASSBAR = C['unitframes']['mini_classbar'] and ( E.myclass == 'SHAMAN' or E.myclass == 'DEATHKNIGHT' )

local function Shared(self, unit)

	self.colors = E.oUF_colors
	
	self:RegisterForClicks( 'AnyUp' )
	self:SetScript( 'OnEnter', UnitFrame_OnEnter )
	self:SetScript( 'OnLeave', UnitFrame_OnLeave )
	
	self.menu = E.SpawnMenu
	self:SetAttribute( 'type2', 'menu' )
	
	self:SetFrameLevel( 5 )

	if unit == 'player' then
		local POWERBAR_WIDTH = C['unitframes']['playtarwidth'] / 2
		local POWERBAR_HEIGHT = ( C['unitframes']['powerbar_height'] )
		local CLASSBAR_WIDTH = ( C['unitframes']['playtarwidth'] - ( 2 * 2 ) )
		local CLASSBAR_HEIGHT = ( C['unitframes']['classbar_height'] )
		local CASTBAR_HEIGHT = C['unitframes']['castplayerheight']
		local CASTBAR_WIDTH = C['unitframes']['castplayerwidth']
		local PORTRAIT_WIDTH = C['unitframes']['portaitwidth']
		local PORTRAIT_HEIGHT = C['unitframes']['portaitheight']
		
		local mini_classbarY = 0
		
		if MINI_CLASSBAR then
			mini_classbarY = - ( SPACING + ( CLASSBAR_HEIGHT / 2 ) )
		end
		
		if MINI_CLASSBAR then
			CLASSBAR_WIDTH = CLASSBAR_WIDTH * 2 / 3
		end

		local health = E.ContructHealthBar( self, true, true )
		
		health:Point( 'TOPRIGHT', self, 'TOPRIGHT', - BORDER, - BORDER )
		
		if USE_POWERBAR_OFFSET then
			health:Point( 'TOPRIGHT', self, 'TOPRIGHT', - ( BORDER + POWERBAR_OFFSET ), -BORDER )
			health:Point( 'BOTTOMLEFT', self, 'BOTTOMLEFT', BORDER, BORDER + POWERBAR_OFFSET )
		elseif POWERTHEME == true then
			health:Point( 'BOTTOMLEFT', self, 'BOTTOMLEFT', BORDER, BORDER + ( POWERBAR_HEIGHT / 2 ) )
		else
			health:Point( 'BOTTOMLEFT', self, 'BOTTOMLEFT', BORDER, BORDER + POWERBAR_HEIGHT )
		end
		
		health.value:Point( 'RIGHT', health, 'RIGHT', - 4, 0 )
		
		self.Health = health

		local power = E.ConstructPowerBar( self, true, true )
		if USE_POWERBAR_OFFSET then
			power:Point( 'TOPRIGHT', health, 'TOPRIGHT', POWERBAR_OFFSET, - POWERBAR_OFFSET )
			power:Point( 'BOTTOMLEFT', health, 'BOTTOMLEFT', POWERBAR_OFFSET, - POWERBAR_OFFSET )
			power:SetFrameStrata( 'LOW' )
			power:SetFrameLevel( 2 )
		elseif POWERTHEME == true then
			power:Width( POWERBAR_WIDTH - BORDER * 2 )
			power:Height( POWERBAR_HEIGHT - BORDER * 2 )
			power:Point( 'RIGHT', self, 'BOTTOMRIGHT', - (BORDER * 2 + 4 ), BORDER + ( POWERBAR_HEIGHT / 2 ) )
			power:SetFrameStrata( 'MEDIUM' )
			power:SetFrameLevel( self:GetFrameLevel() + 3 )
		else
			power:Point( 'TOPLEFT', health.backdrop, 'BOTTOMLEFT', BORDER, - ( E.PixelMode and 0 or ( BORDER + SPACING ) ) )
			power:Point( 'BOTTOMRIGHT', self, 'BOTTOMRIGHT', - BORDER, BORDER )
		end
		
		power.value:Point( 'LEFT', health, 'LEFT', 4, 0 )
		
		self.Power = power
		
		if C['unitframes']['unitname'] == true then
			self:FontString( 'Name', FONT, C['unitframes']['namefontsize'], C['unitframes']['fontoutline'] )
			self.Name:Point( 'CENTER', health, 'CENTER' )
			self.Name:SetShadowColor( 0, 0, 0, 0 )
			self.Name.frequentUpdates = 0.5
			self:Tag( self.Name, '[ElvUI:getnamecolor][ElvUI:namemedium]' )
		end
		
		if( C['unitframes']['charportrait'] == true ) then
			if( C["unitframes"]['charportraithealth'] == true ) then
			
				local portrait = CreateFrame( 'PlayerModel', nil, health )
				portrait:SetFrameLevel( health:GetFrameLevel() )
				portrait:SetAllPoints( health )
				
				portrait.PostUpdate = E.PortraitUpdate
				
				self.Portrait = portrait

				health.bg:ClearAllPoints()
				health.bg:Point( 'BOTTOMLEFT', health:GetStatusBarTexture(), 'BOTTOMRIGHT' )
				health.bg:Point( 'TOPRIGHT', health )
				health.bg:SetDrawLayer( 'OVERLAY', 7 )
			else
				local PFramep = CreateFrame( 'Frame', nil, self )
				PFramep:SetPoint( 'TOPRIGHT', self,'TOPLEFT', - BORDER * BORDER, 0 )
				PFramep:SetWidth( PORTRAIT_WIDTH )
				PFramep:SetHeight( PORTRAIT_HEIGHT )
				PFramep:SetTemplate( 'Default', true )
				PFramep:SetBackdropBorderColor( unpack( C["media"]['bordercolor'] ) )
				
				self.PFramep = PFramep
				local portrait = CreateFrame( 'PlayerModel', nil, PFramep )
				portrait:SetFrameLevel( portrait:GetFrameLevel() - 1 )
				portrait:SetPoint( 'TOPLEFT', PFramep, 'TOPLEFT', E.mult * 2.2, - E.mult * 2 )
				portrait:SetPoint('BOTTOMRIGHT', PFramep, 'BOTTOMRIGHT', -E.mult * 2, E.mult * 2 )
				
				table.insert( self.__elements, E.HidePortrait )
				
				self.Portrait = portrait
				
				E.CreateMover( PFramep, 'PFramepMover', 'PFramep Frame' )
			end
		end
		
		if( C['unitframes']['playerbuffs'] == true ) then
			local buffs = CreateFrame( 'Frame', nil, self )
			buffs.num = C['unitframes']['playeraurasperrow'] * C['unitframes']['playernumbuffrows']
			
			if USE_POWERBAR_OFFSET then
				buffs:SetWidth( PLAYER_WIDTH - POWERBAR_OFFSET )
			else
				buffs:SetWidth( PLAYER_WIDTH )
			end
			
			buffs.spacing = E.Scale( SPACING )
			
			if USE_POWERBAR_OFFSET then
				buffs.size = ( ( ( ( ( C['unitframes']['playtarwidth'] - POWERBAR_OFFSET ) - ( buffs.spacing * ( buffs.num / C['unitframes']['playernumbuffrows'] - 1) ) ) / buffs.num ) ) * C['unitframes']['playernumbuffrows'] )
			else
				buffs.size = ( ( ( ( C['unitframes']['playtarwidth'] - ( buffs.spacing * ( buffs.num / C['unitframes']['playernumbuffrows'] - 1) ) ) / buffs.num ) ) * C['unitframes']['playernumbuffrows'] )
			end
			buffs:Point( 'BOTTOMLEFT', self, 'TOPLEFT', 0, SPACING )
			buffs:SetHeight( buffs.size * C['unitframes']['playernumbuffrows'] )
			buffs.initialAnchor = 'BOTTOMLEFT'
			buffs['growth-y'] = 'UP'	
			buffs['growth-x'] = 'RIGHT'
			
			buffs.PostCreateIcon = E.PostCreateAura
			buffs.PostUpdateIcon = E.PostUpdateAura
			
			self.Buffs = buffs
		end
		
		if( C['unitframes']['playerdebuffs'] == true ) then
			local debuffs = CreateFrame( 'Frame', nil, self )
			debuffs.num = C['unitframes']['playeraurasperrow'] * C['unitframes']['playernumdebuffrows']
			
			if USE_POWERBAR_OFFSET then
				debuffs:SetWidth( PLAYER_WIDTH - POWERBAR_OFFSET )
			else
				debuffs:SetWidth( PLAYER_WIDTH )
			end
			
			debuffs.spacing = E.Scale( SPACING )
			
			if USE_POWERBAR_OFFSET then
				debuffs.size = ( ( ( ( C['unitframes']['playtarwidth'] - POWERBAR_OFFSET ) - ( debuffs.spacing * ( debuffs.num / C['unitframes']['playernumdebuffrows'] - 1 ) ) ) / debuffs.num ) * C['unitframes']['playernumbuffrows'] )
			else
				debuffs.size = ( ( ( C['unitframes']['playtarwidth'] - ( debuffs.spacing * ( debuffs.num / C['unitframes']['playernumdebuffrows'] - 1 ) ) ) / debuffs.num ) * C['unitframes']['playernumbuffrows'] )
			end
			
			debuffs:SetHeight( debuffs.size * C['unitframes']['playernumdebuffrows'] )
			
			if( C['unitframes']['playerbuffs'] == true ) then
				debuffs:Point( 'BOTTOM', self.Buffs, 'TOP', 0, SPACING )
			else
				debuffs:Point( 'BOTTOMLEFT', self, 'TOPLEFT', 0, SPACING )
			end
			
			debuffs.initialAnchor = 'BOTTOMRIGHT'
			debuffs['growth-y'] = 'UP'
			debuffs['growth-x'] = 'LEFT'
			
			debuffs.PostCreateIcon = E.PostCreateAura
			debuffs.PostUpdateIcon = E.PostUpdateAura
			debuffs.CustomFilter = E.AuraFilter
			
			self.Debuffs = debuffs
		end
		--Cast Bar
		if C["unitframes"].unitcastbar == true then
			local castbar = E.ConstructCastBar(self, 'LEFT')
			castbar:Width( CASTBAR_WIDTH - ( E.PixelMode and 2 or ( BORDER * 2 ) ) )
			castbar:Height( CASTBAR_HEIGHT )
			
			if C['unitframes']['cbicons'] then
				castbar.Icon = castbar.ButtonIcon
				castbar.Icon.bg:Width( CASTBAR_HEIGHT + ( E.Border * 2 ) )
				castbar.Icon.bg:Height( CASTBAR_HEIGHT + ( E.Border * 2 ) )
				
				castbar:Width( CASTBAR_WIDTH - castbar.Icon.bg:GetWidth() - ( E.PixelMode and 1 or 5 ) )
				castbar.Icon.bg:Show()
			else
				castbar.ButtonIcon.bg:Hide()
				castbar.Icon = nil
			end
			
			castbar:Point( 'TOPRIGHT', self, 'BOTTOMRIGHT', - BORDER, - ( E.Border * 2 + E.Border ) )

			self.Castbar = castbar
		end
		-- Debuff Highlight
		if C["unitframes"].debuffhighlight == true then
			local dbh = self:CreateTexture(nil, "OVERLAY")
			dbh:SetAllPoints(self.Health.backdrop)
			dbh:SetTexture(C["media"].blank)
			dbh:SetBlendMode("ADD")
			dbh:SetVertexColor(0,0,0,0)
			self.DebuffHighlight = dbh
			self.DebuffHighlightFilter = true
			self.DebuffHighlightAlpha = 0.35
		end
		--Combat Feedback
		if C["unitframes"].combatfeedback == true then
			self:FontString("CombatFeedbackText", FONT, FONTSIZE, C["unitframes"].fontoutline)
			self.CombatFeedbackText:SetPoint("CENTER", health, "CENTER", 0, -5)
			
			self.CombatFeedbackText.colors = {
				DAMAGE = {0.69, 0.31, 0.31},
				CRUSHING = {0.69, 0.31, 0.31},
				CRITICAL = {0.69, 0.31, 0.31},
				GLANCING = {0.69, 0.31, 0.31},
				STANDARD = {0.84, 0.75, 0.65},
				IMMUNE = {0.84, 0.75, 0.65},
				ABSORB = {0.84, 0.75, 0.65},
				BLOCK = {0.84, 0.75, 0.65},
				RESIST = {0.84, 0.75, 0.65},
				MISS = {0.84, 0.75, 0.65},
				HEAL = {0.33, 0.59, 0.33},
				CRITHEAL = {0.33, 0.59, 0.33},
				ENERGIZE = {0.31, 0.45, 0.63},
				CRITENERGIZE = {0.31, 0.45, 0.63},
			}
		end
		--Low Mana
		self:FontString("ManaLevel", FONT, FONTSIZE, C["unitframes"].fontoutline)
		self.ManaLevel:Point("CENTER", health, "CENTER", 0, -5)
		self:HookScript("OnUpdate", E.UpdateManaLevel)
		--PvP Text
		self:FontString("PvP", FONT, FONTSIZE, C["unitframes"].fontoutline)
		self.PvP:Point("CENTER", health, "CENTER", 0, -5)
		self.PvP:SetTextColor(0.69, 0.31, 0.31)
		self.PvP:Hide()
		self.PvP.Override = E.dummy		
		
		self:HookScript("OnUpdate", E.PvPUpdate)
		self:HookScript("OnEnter", function(self) self.ManaLevel:Hide() self.PvP:Show() end)
		self:HookScript("OnLeave", function(self) self.ManaLevel:Show() self.PvP:Hide() end)
		--Combat Icon
		local combat = self:CreateTexture(nil, "OVERLAY")
		combat:Size(19, 19)
		combat:Point("CENTER", health, "CENTER", 0,7)
		combat:SetVertexColor(0.69, 0.31, 0.31)
		self.Combat = combat
		if not MINI_CLASSBAR then
			--Leader Icon
			local leader = self:CreateTexture(nil, "OVERLAY")
			leader:Size(14)
			leader:Point("TOPRIGHT", self.Health.backdrop, "TOPRIGHT", -4, 8)
			self.Leader = leader
		
			--Master Looter Icon
			local ml = self:CreateTexture(nil, "OVERLAY")
			ml:Size(14)
			self.MasterLooter = ml
			self:RegisterEvent("PARTY_LEADER_CHANGED", E.MLAnchorUpdate)
			self:RegisterEvent("PARTY_MEMBERS_CHANGED", E.MLAnchorUpdate)	
		end
		--Aggro Glow
		if C["raidframes"].displayaggro == true then
			table.insert(self.__elements, E.UpdateThreat)
			self:RegisterEvent('PLAYER_TARGET_CHANGED', E.UpdateThreat)
			self:RegisterEvent('UNIT_THREAT_LIST_UPDATE', E.UpdateThreat)
			self:RegisterEvent('UNIT_THREAT_SITUATION_UPDATE', E.UpdateThreat)
		end
		--Auto Hide
		if C["unitframes"].combat == true then
			self:RegisterEvent("PLAYER_ENTERING_WORLD", E.Fader)
			self:RegisterEvent("PLAYER_REGEN_ENABLED", E.Fader)
			self:RegisterEvent("PLAYER_REGEN_DISABLED", E.Fader)
			self:RegisterEvent("PLAYER_TARGET_CHANGED", E.Fader)
			self:RegisterEvent("PLAYER_FOCUS_CHANGED", E.Fader)
			self:RegisterEvent("UNIT_HEALTH", E.Fader)
			self:RegisterEvent("UNIT_SPELLCAST_START", E.Fader)
			self:RegisterEvent("UNIT_SPELLCAST_STOP", E.Fader)
			self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START", E.Fader)
			self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP", E.Fader)
			self:RegisterEvent("UNIT_PORTRAIT_UPDATE", E.Fader)
			self:RegisterEvent("UNIT_MODEL_CHANGED", E.Fader)			
			self:HookScript("OnEnter", function(self) E.Fader(self, true) end)
			self:HookScript("OnLeave", function(self) E.Fader(self, false) end)
		end
		--Experience Bar
		if E.level ~= MAX_PLAYER_LEVEL then
			local experience = CreateFrame("StatusBar", nil, self)
			experience:SetStatusBarTexture(NORMTEX)
			experience:SetStatusBarColor(0, 0.4, 1, .8)
			if C["others"].raidbuffreminder == true then
				experience:Size((E.MiniMapSize - ( E.PixelMode and 8 or 4 ) ) + 1 + (((E.MiniMapSize - 9) / 6)) + ( E.PixelMode and 3 or 4 ), 10)
			else
				experience:Size((E.MiniMapSize - ( E.PixelMode and 8 or 4 ) ), 10)
			end
			experience:Point("TOPLEFT", LeftMiniPanel, "BOTTOMLEFT", 2, -2)
			experience:SetFrameLevel(Minimap:GetFrameLevel() + 1)
			experience:SetFrameStrata(Minimap:GetFrameStrata())
			
			if C["unitframes"].combat == true then
				experience:HookScript("OnEnter", function(self) E.Fader(self:GetParent(), true) end)
				experience:HookScript("OnLeave", function(self) E.Fader(self:GetParent(), false) end)
			end
			
			experience.Rested = CreateFrame('StatusBar', nil, experience)
			experience.Rested:SetStatusBarTexture(NORMTEX)
			experience.Rested:SetStatusBarColor(1, 0, 1, 0.2)
			experience.Rested:SetFrameLevel(experience:GetFrameLevel() - 1)
			experience.Rested.SetFrameLevel = E.dummy --oUF_Experience thinks its a good idea to set frame level to 1
			experience.Rested:SetAllPoints(experience)
			
			local resting = self:CreateTexture(nil, "OVERLAY")
			resting:Size(22)
			resting:Point("CENTER", health, "TOPLEFT", -3, 6)
			resting:SetTexture([=[Interface\CharacterFrame\UI-StateIcon]=])
			resting:SetTexCoord(0, 0.5, 0, 0.421875)
			resting:Hide()
			self:RegisterEvent("PLAYER_UPDATE_RESTING", E.RestingIconUpdate)
			self.Resting = resting
			
			experience.backdrop = CreateFrame("Frame", nil, experience)
			experience.backdrop:SetTemplate("Default")
			experience.backdrop:SetInside(experience)
			experience.backdrop:SetFrameLevel(experience:GetFrameLevel() - 1)
			experience.PostUpdate = E.ReputationPositionUpdate
			experience:SetScript('OnShow', E.ReputationPositionUpdate)
			experience:SetScript('OnHide', E.ReputationPositionUpdate)
			self.Experience = experience
		end

		local reputation = CreateFrame("StatusBar", nil, self)
		reputation:SetStatusBarTexture(NORMTEX)
		reputation:SetStatusBarColor(0, 1, 0.2, 1)
		reputation.color = true
		if C["others"].raidbuffreminder == true then
			reputation:Size((E.MiniMapSize - ( E.PixelMode and 8 or 4 ) ) + 1 + (((E.MiniMapSize - 9) / 6)) + ( E.PixelMode and 3 or 4 ), 10)
		else
			reputation:Size((E.MiniMapSize - ( E.PixelMode and 8 or 4 ) ), 10)
		end
		reputation:Point("TOPLEFT", LeftMiniPanel, "BOTTOMLEFT", 2, -3)
		reputation:SetFrameLevel(Minimap:GetFrameLevel() + 1)
		reputation:SetFrameStrata(Minimap:GetFrameStrata())
		
		reputation.Tooltip = true
		if C["unitframes"].combat == true then
			reputation:HookScript("OnEnter", function(self) E.Fader(self:GetParent(), true) end)
			reputation:HookScript("OnLeave", function(self) E.Fader(self:GetParent(), false) end)
		end

		reputation.backdrop = CreateFrame("Frame", nil, reputation)
		reputation.backdrop:SetTemplate("Default")
		reputation.backdrop:Point("TOPLEFT", reputation, "TOPLEFT", -2, 2)
		reputation.backdrop:Point("BOTTOMRIGHT", reputation, "BOTTOMRIGHT", 2, -2)
		reputation.backdrop:SetFrameLevel(reputation:GetFrameLevel() - 1)
		reputation.PostUpdate = E.ReputationPositionUpdate
		self:RegisterEvent("DISABLE_XP_GAIN", E.ReputationPositionUpdate)
		self:RegisterEvent("ENABLE_XP_GAIN", E.ReputationPositionUpdate)		
		self.Reputation = reputation
		--Class Resource Bars
		if C["unitframes"].classbar == true and (E.myclass == "SHAMAN" or E.myclass == "DEATHKNIGHT") then
			--Reposition Health Bar for ClassBars
			local DEPTH
			if MINI_CLASSBAR == true then
				DEPTH = -(BORDER+(CLASSBAR_HEIGHT/2))
			else
				DEPTH = -(BORDER+CLASSBAR_HEIGHT+SPACING)
			end
			
			if USE_POWERBAR_OFFSET then
				health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER+POWERBAR_OFFSET), DEPTH)
			else
				health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, DEPTH)
			end
			health:Point("TOPLEFT", self, "TOPLEFT", BORDER, DEPTH)
			
			--Rune Bar
			if E.myclass == "DEATHKNIGHT" then				
				local runes = CreateFrame("Frame", nil, self)
				if MINI_CLASSBAR then
					CLASSBAR_WIDTH = CLASSBAR_WIDTH * 3/2 --Multiply by reciprocal to reset previous setting
					CLASSBAR_WIDTH = CLASSBAR_WIDTH * 4/5
					runes:Point("CENTER", health.backdrop, "TOP", -(BORDER*3 + 8), 0)
					runes:SetFrameStrata("MEDIUM")
				else
					runes:Point("BOTTOMLEFT", health.backdrop, "TOPLEFT", BORDER, BORDER+SPACING)
					runes:SetFrameStrata("LOW")
				end
				runes:Width(CLASSBAR_WIDTH)
				runes:Height(CLASSBAR_HEIGHT - (BORDER*2))

				for i = 1, 6 do
					runes[i] = CreateFrame("StatusBar", nil, runes)
					runes[i]:Height(runes:GetHeight())
					runes[i]:SetWidth(E.Scale(runes:GetWidth() - 5) / 6)
					
					if MINI_CLASSBAR then
						runes[i].backdrop = CreateFrame("Frame", nil, runes)
						runes[i].backdrop:SetTemplate("Default")
						runes[i].backdrop:Point("TOPLEFT", runes[i], "TOPLEFT", -BORDER, BORDER)
						runes[i].backdrop:Point("BOTTOMRIGHT", runes[i], "BOTTOMRIGHT", BORDER, -BORDER)
						runes[i].backdrop:SetFrameLevel(runes[i]:GetFrameLevel() - 1)
					end					

					if (i == 1) then
						runes[i]:SetPoint("LEFT", runes)
					else
						if MINI_CLASSBAR then
							runes[i]:Point("LEFT", runes[i-1], "RIGHT", SPACING+(BORDER*2)+2, 0)
						else
							runes[i]:Point("LEFT", runes[i-1], "RIGHT", SPACING, 0)
						end
					end
					runes[i]:SetStatusBarTexture(NORMTEX)
					runes[i]:GetStatusBarTexture():SetHorizTile(false)
				end
				
				if not MINI_CLASSBAR then
					runes.backdrop = CreateFrame("Frame", nil, runes)
					runes.backdrop:SetTemplate("Default")
					runes.backdrop:Point("TOPLEFT", -BORDER, BORDER)
					runes.backdrop:Point("BOTTOMRIGHT", BORDER, -BORDER)
					runes.backdrop:SetFrameLevel(runes:GetFrameLevel() - 1)

					runes:HookScript("OnShow", function()
						if USE_POWERBAR_OFFSET then
							health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER+POWERBAR_OFFSET), -(BORDER+CLASSBAR_HEIGHT+SPACING))
						else
							health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -(BORDER+CLASSBAR_HEIGHT+SPACING))
						end
						health:Point("TOPLEFT", self, "TOPLEFT", BORDER, -(BORDER+CLASSBAR_HEIGHT+SPACING))
					end)
					runes:HookScript("OnHide", function()
						if USE_POWERBAR_OFFSET then
							health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER+POWERBAR_OFFSET), -BORDER)
						else
							health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER)
						end
						health:Point("TOPLEFT", self, "TOPLEFT", BORDER, -BORDER)		
					end)	
				end
				
				self.Runes = runes
			end
			
			--Totem Bar
			if E.myclass == "SHAMAN" then
				local totems = CreateFrame("Frame", nil, self)
				if not MINI_CLASSBAR then
					totems:Point("BOTTOMLEFT", health.backdrop, "TOPLEFT", BORDER, BORDER+SPACING)
					totems:SetFrameStrata("LOW")
				else
					CLASSBAR_WIDTH = CLASSBAR_WIDTH * 3/2 --Multiply by reciprocal to reset previous setting
					CLASSBAR_WIDTH = CLASSBAR_WIDTH * 4/5
					totems:Point("CENTER", health.backdrop, "TOP", -(BORDER*3 + 6), 0)
					totems:SetFrameStrata("MEDIUM")			
				end
				totems:Width(CLASSBAR_WIDTH)
				totems:Height(CLASSBAR_HEIGHT - (BORDER*2))
				totems.Destroy = true

				for i = 1, 4 do
					totems[i] = CreateFrame("StatusBar", nil, totems)
					totems[i]:SetHeight(totems:GetHeight())
					totems[i]:SetFrameStrata(self:GetFrameStrata())
					totems[i]:SetFrameLevel(self:GetFrameLevel())
					totems[i]:SetWidth(E.Scale(totems:GetWidth() - 3) / 4)

					if MINI_CLASSBAR then
						totems[i].backdrop = CreateFrame("Frame", nil, totems[i])
						totems[i].backdrop:SetTemplate("Default")
						totems[i].backdrop:Point("TOPLEFT", totems[i], "TOPLEFT", -BORDER, BORDER)
						totems[i].backdrop:Point("BOTTOMRIGHT", totems[i], "BOTTOMRIGHT", BORDER, -BORDER)
						totems[i].backdrop:SetFrameLevel(totems[i]:GetFrameLevel() - 2)
					end						
					
					if (i == 1) then
						totems[i]:SetPoint("LEFT", totems)
					else
						if MINI_CLASSBAR then
							totems[i]:Point("LEFT", totems[i-1], "RIGHT", SPACING+(BORDER*2)+4, 0)
						else
							totems[i]:Point("LEFT", totems[i-1], "RIGHT", SPACING, 0)
						end
					end
					totems[i]:SetStatusBarTexture(NORMTEX)
					totems[i]:GetStatusBarTexture():SetHorizTile(false)
					totems[i]:SetMinMaxValues(0, 1)

					
					totems[i].bg = totems[i]:CreateTexture(nil, "BORDER")
					totems[i].bg:SetAllPoints()
					totems[i].bg:SetTexture(NORMTEX)
					totems[i].bg.multiplier = 0.3
				end
				
				if not MINI_CLASSBAR then
					totems.backdrop = CreateFrame("Frame", nil, totems)
					totems.backdrop:SetTemplate("Default")
					totems.backdrop:Point("TOPLEFT", -BORDER, BORDER)
					totems.backdrop:Point("BOTTOMRIGHT", BORDER, -BORDER)
					totems.backdrop:SetFrameLevel(totems:GetFrameLevel() - 1)
					
					totems:HookScript("OnShow", function()
						if USE_POWERBAR_OFFSET then
							health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER+POWERBAR_OFFSET), -(BORDER+CLASSBAR_HEIGHT+SPACING))
						else
							health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -(BORDER+CLASSBAR_HEIGHT+SPACING))
						end
						health:Point("TOPLEFT", self, "TOPLEFT", BORDER, -(BORDER+CLASSBAR_HEIGHT+SPACING))
					end)
					totems:HookScript("OnHide", function()
						if USE_POWERBAR_OFFSET then
							health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER+POWERBAR_OFFSET), -BORDER)
						else
							health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER)
						end
						health:Point("TOPLEFT", self, "TOPLEFT", BORDER, -BORDER)		
					end)
				end
				
				self.TotemBar = totems			
			end
		end
		
		self:SetAttribute('initial-width', PLAYER_WIDTH)
		self:SetAttribute('initial-height', PLAYER_HEIGHT)
	end
	------------------------------------------------------------------------
	-- Target
	------------------------------------------------------------------------
	if unit == "target" then
		local POWERBAR_WIDTH = C["unitframes"].playtarwidth/2
		local CLASSBAR_WIDTH = (C["unitframes"].playtarwidth - (2*2))
		local CLASSBAR_HEIGHT = (C["unitframes"].classbar_height)
		local POWERBAR_HEIGHT = (C["unitframes"].powerbar_height)
		local CASTBAR_HEIGHT = C["unitframes"].casttargetheight
		local CASTBAR_WIDTH = C["unitframes"].casttargetwidth
		local PORTRAIT_WIDTH = C["unitframes"].portaitwidth
		local PORTRAIT_HEIGHT = C["unitframes"].portaitheight
		-- Health Bar
		local health = E.ContructHealthBar(self, true, true)
		health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER)
		
		if USE_POWERBAR_OFFSET then
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER+POWERBAR_OFFSET, BORDER+POWERBAR_OFFSET)
		elseif POWERTHEME == true then
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER + (POWERBAR_HEIGHT/2))
		else
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER + POWERBAR_HEIGHT)
		end

		health.value:Point("RIGHT", health, "RIGHT", -4, 0)
		self.Health = health
		-- Power
		local power = E.ConstructPowerBar(self, true, true)
		if USE_POWERBAR_OFFSET then
			power:Point("TOPLEFT", health, "TOPLEFT", -POWERBAR_OFFSET, -POWERBAR_OFFSET)
			power:Point("BOTTOMRIGHT", health, "BOTTOMRIGHT", -POWERBAR_OFFSET, -POWERBAR_OFFSET)
			power:SetFrameStrata("LOW")
			power:SetFrameLevel(2)
		elseif POWERTHEME == true then
			power:Width(POWERBAR_WIDTH - BORDER*2)
			power:Height(POWERBAR_HEIGHT - BORDER*2)
			power:Point("LEFT", self, "BOTTOMLEFT", BORDER*2 + 4, BORDER + (POWERBAR_HEIGHT/2))
			power:SetFrameStrata("MEDIUM")
			power:SetFrameLevel(self:GetFrameLevel() + 3)
		else
			power:Point("TOPRIGHT", health.backdrop, "BOTTOMRIGHT", -BORDER, -(E.PixelMode and 0 or (BORDER + SPACING)))
			power:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER)
		end		
		power.value:Point("LEFT", health, "LEFT", 4, 0)
		self.Power = power
		-- Name
		self:FontString("Name", FONT, FONTSIZE, C["unitframes"].fontoutline)
		self.Name:SetJustifyH("LEFT")
		self.Name.frequentUpdates = 0.2
		self.Name:SetShadowColor(0, 0, 0, 0)
		self:Tag(self.Name, '[ElvUI:getnamecolor][ElvUI:namelong] [ElvUI:diffcolor][level] [shortclassification]')
		-- Portait
		if (C["unitframes"].charportrait == true) then
			if C["unitframes"].charportraithealth == true then
				local portrait = CreateFrame("PlayerModel", nil, health)
				portrait:SetFrameLevel(health:GetFrameLevel())
				portrait:SetAllPoints(health)
				portrait.PostUpdate = E.PortraitUpdate
				self.Portrait = portrait

				health.bg:ClearAllPoints()
				health.bg:Point('BOTTOMLEFT', health:GetStatusBarTexture(), 'BOTTOMRIGHT')
				health.bg:Point('TOPRIGHT', health)
				health.bg:SetDrawLayer("OVERLAY", 7)
			else
				local PFramet = CreateFrame("Frame", nil, self)
				PFramet:SetPoint('TOPLEFT', self,'TOPRIGHT', BORDER*BORDER, 0)
				PFramet:SetWidth(PORTRAIT_WIDTH)
				PFramet:SetHeight(PORTRAIT_HEIGHT)
				PFramet:SetTemplate('Default', true)
				PFramet:SetBackdropBorderColor(unpack(C["media"].bordercolor))
				self.PFramet = PFramet
				local portrait = CreateFrame("PlayerModel", nil, PFramet)
				portrait:SetFrameLevel(portrait:GetFrameLevel() - 1)					
				portrait:SetPoint('TOPLEFT', PFramet, 'TOPLEFT', E.mult*2, -E.mult*2)
				portrait:SetPoint('BOTTOMRIGHT', PFramet, 'BOTTOMRIGHT', -E.mult*2, E.mult*2)
				table.insert(self.__elements, E.HidePortrait)
				self.Portrait = portrait
				E.CreateMover(PFramet, "PFrametMover", "PFramet Frame")
			end
		end
		-- Auras
		if C["unitframes"].targetbuffs then
			local buffs = CreateFrame("Frame", nil, self)
			buffs.num = C["unitframes"].targetaurasperrow * C["unitframes"].targetnumbuffrows
			buffs.spacing = E.Scale(SPACING)
			if USE_POWERBAR_OFFSET then
				buffs:SetWidth(TARGET_WIDTH - POWERBAR_OFFSET)
				buffs.size = (((((C["unitframes"].playtarwidth - POWERBAR_OFFSET) - (buffs.spacing*(buffs.num/C["unitframes"].targetnumbuffrows - 1))) / buffs.num)) * C["unitframes"].targetnumbuffrows)
				buffs:Point("BOTTOMRIGHT", self, "TOPRIGHT", 0, SPACING)				
			else
				buffs:SetWidth(TARGET_WIDTH)
				buffs.size = ((((C["unitframes"].playtarwidth - (buffs.spacing*(buffs.num/C["unitframes"].targetnumbuffrows - 1))) / buffs.num)) * C["unitframes"].targetnumbuffrows)
				buffs:Point("BOTTOM", self, "TOP", 0, SPACING)
			end
			
			buffs:SetHeight(buffs.size * C["unitframes"].targetnumbuffrows)
			buffs.initialAnchor = 'BOTTOMLEFT'
			buffs["growth-y"] = "UP"	
			buffs["growth-x"] = "RIGHT"
			buffs.PostCreateIcon = E.PostCreateAura
			buffs.PostUpdateIcon = E.PostUpdateAura
			self.Buffs = buffs	
		end
		
		if C["unitframes"].targetdebuffs then
			local debuffs = CreateFrame("Frame", nil, self)
			debuffs.num = C["unitframes"].targetaurasperrow * C["unitframes"].targetnumdebuffrows
			debuffs.spacing = E.Scale(SPACING)
			if USE_POWERBAR_OFFSET then
				debuffs:SetWidth(TARGET_WIDTH - POWERBAR_OFFSET)
				debuffs.size = (((((C["unitframes"].playtarwidth - POWERBAR_OFFSET) - (debuffs.spacing*(debuffs.num/C["unitframes"].targetnumdebuffrows - 1))) / debuffs.num)) * C["unitframes"].targetnumbuffrows)
			else
				debuffs:SetWidth(TARGET_WIDTH)
				debuffs.size = (((C["unitframes"].playtarwidth - (debuffs.spacing*(debuffs.num/C["unitframes"].targetnumdebuffrows - 1))) / debuffs.num) * C["unitframes"].targetnumdebuffrows)
			end
			debuffs:SetHeight(debuffs.size * C["unitframes"].targetnumdebuffrows)
			if C["unitframes"].targetbuffs then
				debuffs:Point("BOTTOM", self.Buffs, "TOP", 0, SPACING)
			else
				debuffs:Point("BOTTOM", self, "TOP", 0, SPACING)
			end
			debuffs.initialAnchor = 'BOTTOMRIGHT'
			debuffs["growth-y"] = "UP"
			debuffs["growth-x"] = "LEFT"
			debuffs.PostCreateIcon = E.PostCreateAura
			debuffs.PostUpdateIcon = E.PostUpdateAura
			debuffs.CustomFilter = E.AuraFilter
			self.Debuffs = debuffs
		end
		-- Cast Bar
		if C['unitframes']['unitcastbar'] == true then
			local castbar = E.ConstructCastBar( self, 'RIGHT' )
			castbar:Width( CASTBAR_WIDTH - ( E.PixelMode and 2 or ( BORDER * 2 ) ) )
			castbar:Height( CASTBAR_HEIGHT )
			
			if C['unitframes']['cbicons'] then
				castbar.Icon = castbar.ButtonIcon
				castbar.Icon.bg:Width( CASTBAR_HEIGHT + ( E.Border * 2 ) )
				castbar.Icon.bg:Height( CASTBAR_HEIGHT + ( E.Border * 2 ) )
				
				castbar:Width( CASTBAR_WIDTH - castbar.Icon.bg:GetWidth() - ( E.PixelMode and 1 or 5 ) )
				castbar.Icon.bg:Show()
			else
				castbar.ButtonIcon.bg:Hide()
				castbar.Icon = nil
			end
			
			castbar:Point( 'TOPLEFT', self, 'BOTTOMLEFT', BORDER, - ( E.Border * 2 + E.Border ) )
			
			self.Castbar = castbar
		end
		-- Combat Feedback
		if C["unitframes"].combatfeedback == true then
			self:FontString("CombatFeedbackText", FONT, FONTSIZE, C["unitframes"].fontoutline)
			self.CombatFeedbackText:SetPoint("CENTER", health, "CENTER", 0, -5)
			
			self.CombatFeedbackText.colors = {
				DAMAGE = {0.69, 0.31, 0.31},
				CRUSHING = {0.69, 0.31, 0.31},
				CRITICAL = {0.69, 0.31, 0.31},
				GLANCING = {0.69, 0.31, 0.31},
				STANDARD = {0.84, 0.75, 0.65},
				IMMUNE = {0.84, 0.75, 0.65},
				ABSORB = {0.84, 0.75, 0.65},
				BLOCK = {0.84, 0.75, 0.65},
				RESIST = {0.84, 0.75, 0.65},
				MISS = {0.84, 0.75, 0.65},
				HEAL = {0.33, 0.59, 0.33},
				CRITHEAL = {0.33, 0.59, 0.33},
				ENERGIZE = {0.31, 0.45, 0.63},
				CRITENERGIZE = {0.31, 0.45, 0.63},
			}
		end
		-- Combo Bar
		local combo = CreateFrame("Frame", nil, self)
		if C["unitframes"].mini_classbar then
			CLASSBAR_WIDTH = CLASSBAR_WIDTH * 4/5
			combo:Point("CENTER", health.backdrop, "TOP", -(BORDER*3 + 6), 0)
			combo:SetFrameStrata("MEDIUM")
		else
			combo:Point("BOTTOMLEFT", health.backdrop, "TOPLEFT", BORDER, BORDER+SPACING)
			combo:SetFrameStrata("LOW")
		end
		combo:Width(CLASSBAR_WIDTH)
		combo:Height(CLASSBAR_HEIGHT - (BORDER*2))

		for i = 1, 5 do					
			combo[i] = CreateFrame("StatusBar", nil, combo)
			combo[i]:SetHeight(combo:GetHeight())					
			combo[i]:SetStatusBarTexture(NORMTEX)
			combo[i]:GetStatusBarTexture():SetHorizTile(false)
			
			if C["unitframes"].mini_classbar then
				combo[i].backdrop = CreateFrame("Frame", nil, combo)
				combo[i].backdrop:SetTemplate("Default")
				combo[i].backdrop:Point("TOPLEFT", combo[i], "TOPLEFT", -BORDER, BORDER)
				combo[i].backdrop:Point("BOTTOMRIGHT", combo[i], "BOTTOMRIGHT", BORDER, -BORDER)
				combo[i].backdrop:SetFrameLevel(combo[i]:GetFrameLevel() - 1)
			end	
					
			if i == 1 then
				combo[i]:SetPoint("LEFT", combo)
			else
				if C["unitframes"].mini_classbar then
					combo[i]:Point("LEFT", combo[i-1], "RIGHT", SPACING+(BORDER*2)+2, 0)
				else
					combo[i]:Point("LEFT", combo[i-1], "RIGHT", SPACING, 0)
				end
			end
			combo[i]:SetAlpha(0.15)
			combo[i]:SetWidth(E.Scale(CLASSBAR_WIDTH - 4)/5)
		end
		
		combo[1]:SetStatusBarColor(0.69, 0.31, 0.31)		
		combo[2]:SetStatusBarColor(0.69, 0.31, 0.31)
		combo[3]:SetStatusBarColor(0.65, 0.63, 0.35)
		combo[4]:SetStatusBarColor(0.65, 0.63, 0.35)
		combo[5]:SetStatusBarColor(0.33, 0.59, 0.33)
		
		
		if not C["unitframes"].mini_classbar then
			combo.backdrop = CreateFrame("Frame", nil, combo)
			combo.backdrop:SetTemplate("Default")
			combo.backdrop:Point("TOPLEFT", -BORDER, BORDER)
			combo.backdrop:Point("BOTTOMRIGHT", BORDER, -BORDER)
			combo.backdrop:SetFrameLevel(combo:GetFrameLevel() - 1)
			
			--[[This is a little differant than everything else because we have to take into account 
			the combobar is movable with the /moveele command, this should make it work correctly only 
			after a reloadui.]]
			combo:HookScript("OnShow", function()		
				if E["elements"] and DPSComboBar and E["elements"]["DPSComboBar"] and E.CreatedMoveEleFrames["DPSComboBar"] then return end
				combo:ClearAllPoints()
				combo:Point("BOTTOMLEFT", health.backdrop, "TOPLEFT", BORDER, BORDER+SPACING)
				
				health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER), -(BORDER+POWERBAR_HEIGHT+SPACING))
			end)
			combo:HookScript("OnHide", function()
				health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER), -BORDER)
			end)
		else
			combo:HookScript("OnShow", function()
				if E["elements"] and DPSComboBar and E["elements"]["DPSComboBar"] and E.CreatedMoveEleFrames["DPSComboBar"] then return end
				combo:ClearAllPoints()
				combo:Point("CENTER", health.backdrop, "TOP", -(BORDER*3 + 6), 0)

				if self.Portrait and self.Portrait.backdrop then
					health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER), -BORDER-(POWERBAR_HEIGHT/2))
					self.Portrait.backdrop:SetPoint("TOPRIGHT", self, "TOPRIGHT", 0, -(POWERBAR_HEIGHT/2))
				else
					health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER-(POWERBAR_HEIGHT/2))
				end
			end)
			
			combo:HookScript("OnHide", function()
				if self.Portrait and self.Portrait.backdrop then
					self.Portrait.backdrop:SetPoint("TOPRIGHT", self, "TOPRIGHT", 0, 0)
					health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER), -BORDER)
				else
					health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER)
				end				
			end)
		end
		
		combo:SetScript("OnUpdate", function()
			if C["general"].classcolortheme == true and combo:IsShown() then
				if combo.backdrop then
					combo.backdrop:SetBackdropBorderColor(unpack(self.Health.defaultColor))
				else
					for i=1, 5 do
						combo[i].backdrop:SetBackdropBorderColor(unpack(self.Health.defaultColor))
					end
				end
			elseif C["general"].classcolortheme ~= true then
				combo:SetScript("OnUpdate", nil)
			end			
		end)
			
		combo:Hide()
		
		combo.Override = E.ComboDisplay
		self.CPoints = combo
		
		self:SetAttribute('initial-width', PLAYER_WIDTH)
		self:SetAttribute('initial-height', PLAYER_HEIGHT)
	end
	---------------------------------------------------------------
	-- Focus, FocusTarget
	---------------------------------------------------------------
	if (unit == "focustarget" or unit == "focus") then
		local POWERBAR_WIDTH = C["unitframes"].smallwidth/1.5
		local POWERBAR_HEIGHT = C["unitframes"].powerbar_height*0.8
		local CASTBAR_WIDTH = C["unitframes"].castfocuswidth
		local CASTBAR_HEIGHT = C["unitframes"].castfocusheight
		-- Health
		local health = E.ContructHealthBar(self, true, nil)
		health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER)
		if USE_POWERBAR_OFFSET then
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER+POWERBAR_OFFSET, BORDER+POWERBAR_OFFSET)
		elseif POWERTHEME == true then
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER + (POWERBAR_HEIGHT/2))
		else
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER + POWERBAR_HEIGHT)
		end
		self.Health = health
		-- Power
		local power = E.ConstructPowerBar(self, true, nil)
		if USE_POWERBAR_OFFSET then
			power:Point("TOPLEFT", health, "TOPLEFT", -POWERBAR_OFFSET, -POWERBAR_OFFSET)
			power:Point("BOTTOMRIGHT", health, "BOTTOMRIGHT", -POWERBAR_OFFSET, -POWERBAR_OFFSET)
			power:SetFrameStrata("LOW")
			power:SetFrameLevel(2)
		elseif POWERTHEME == true then
			power:Width(POWERBAR_WIDTH - BORDER*2)
			power:Height(POWERBAR_HEIGHT - BORDER*2)
			power:Point("LEFT", self, "BOTTOMLEFT", BORDER*2 + 4, BORDER + (POWERBAR_HEIGHT/2))
			power:SetFrameStrata("MEDIUM")
			power:SetFrameLevel(self:GetFrameLevel() + 3)
		else
			power:Point("TOPRIGHT", health.backdrop, "BOTTOMRIGHT", -BORDER, -(E.PixelMode and 0 or (BORDER + SPACING)))
			power:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER)
		end					
		self.Power = power
		-- Name
		self:FontString("Name", FONT, FONTSIZE, C["unitframes"].fontoutline)
		self.Name:Point("CENTER", health, "CENTER", 0, 2)
		self.Name:SetShadowColor(0, 0, 0, 0)
		self.Name.frequentUpdates = 0.5
		self:Tag(self.Name, '[ElvUI:getnamecolor][ElvUI:namemedium]')		
		-- Auras
		if (unit == "focus" and C["unitframes"].focusdebuffs == true) then	
			local debuffs = CreateFrame("Frame", nil, self)
			debuffs.num = C["unitframes"].smallaurasperrow
			debuffs:SetWidth(SMALL_WIDTH)
			debuffs.spacing = E.Scale(SPACING)
			debuffs.size = ((C["unitframes"].smallwidth - (debuffs.spacing*(debuffs.num - 1))) / debuffs.num)
			debuffs:SetHeight(debuffs.size)
			debuffs:Point("TOP", self, "BOTTOM", 0, -SPACING)	
			debuffs.initialAnchor = 'BOTTOMRIGHT'
			debuffs["growth-y"] = "UP"
			debuffs["growth-x"] = "LEFT"
			debuffs.PostCreateIcon = E.PostCreateAura
			debuffs.PostUpdateIcon = E.PostUpdateAura
			debuffs.CustomFilter = E.AuraFilter
			self.Debuffs = debuffs
		end
		-- Debuff Highlight
		if C["unitframes"].debuffhighlight == true then
			local dbh = self:CreateTexture(nil, "OVERLAY")
			dbh:SetAllPoints(self.Health.backdrop)
			dbh:SetTexture(C["media"].blank)
			dbh:SetBlendMode("ADD")
			dbh:SetVertexColor(0,0,0,0)
			self.DebuffHighlight = dbh
			self.DebuffHighlightFilter = true
			self.DebuffHighlightAlpha = 0.35
		end
		
		if unit == "focus" and C['unitframes']['unitcastbar'] == true	then
			local castbar = E.ConstructCastBar( self, 'LEFT' )
			castbar:Width( CASTBAR_WIDTH - ( E.PixelMode and 2 or ( BORDER * 2 ) ) )
			castbar:Height( CASTBAR_HEIGHT )
			
			if C['unitframes']['cbicons'] then
				castbar.Icon = castbar.ButtonIcon
				castbar.Icon.bg:Width( CASTBAR_HEIGHT + ( E.Border * 2 ) )
				castbar.Icon.bg:Height( CASTBAR_HEIGHT + ( E.Border * 2 ) )
				
				castbar:Width( CASTBAR_WIDTH - castbar.Icon.bg:GetWidth() - ( E.PixelMode and 1 or 5 ) )
				castbar.Icon.bg:Show()
			else
				castbar.ButtonIcon.bg:Hide()
				castbar.Icon = nil
			end
			
			castbar:Point( 'TOP', UIParent, 'TOP', 0, -150 )
			
			self.Castbar = castbar
		end

		self:SetAttribute("initial-height", SMALL_HEIGHT)
		self:SetAttribute("initial-width", SMALL_WIDTH)
	end
	------------------------------------------------------------------------
	--	TargetofTarget, Pet, PetTarget
	------------------------------------------------------------------------
	if (unit == "targettarget" or unit == "pet" or unit == "pettarget") then
		local POWERBAR_WIDTH = C["unitframes"].smallwidth/1.5
		local POWERBAR_HEIGHT = C["unitframes"].powerbar_height*0.8
		local CASTBAR_WIDTH = C["unitframes"].castfocuswidth
		local CASTBAR_HEIGHT = C["unitframes"].castfocusheight
		--Health Bar
		local health = E.ContructHealthBar(self, true, nil)
		health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER)
		if USE_POWERBAR_OFFSET then			
			health:Point("TOPRIGHT", self, "TOPRIGHT", -(BORDER+POWERBAR_OFFSET), -BORDER)
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER+POWERBAR_OFFSET, BORDER+POWERBAR_OFFSET)
		elseif POWERTHEME then
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER + (POWERBAR_HEIGHT/2))
		else
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER + POWERBAR_HEIGHT)
		end
		self.Health = health
		-- Power
		if unit ~= "pettarget" then
			local power = E.ConstructPowerBar(self, true, nil)
			if USE_POWERBAR_OFFSET then
				power:Point("TOPLEFT", self, "TOPLEFT", BORDER, -POWERBAR_OFFSET)
				power:Point("BOTTOMRIGHT", self, "BOTTOMRIGHT", -BORDER, BORDER)
				power:SetFrameStrata("LOW")
				power:SetFrameLevel(2)
			elseif POWERTHEME then
				power:Width(POWERBAR_WIDTH - BORDER*2)
				power:Height(POWERBAR_HEIGHT - BORDER*2)
				power:Point("CENTER", self, "BOTTOM", 0, BORDER + (POWERBAR_HEIGHT/2))
				power:SetFrameStrata("MEDIUM")
				power:SetFrameLevel(self:GetFrameLevel() + 3)
			else
				power:Point("TOPLEFT", self.Health.backdrop, "BOTTOMLEFT", BORDER, -(E.PixelMode and 0 or (BORDER + SPACING)))
				power:Point("BOTTOMRIGHT", self, "BOTTOMRIGHT", -BORDER, BORDER)
			end				
			self.Power = power
		end
		-- Name
		self:FontString("Name", FONT, FONTSIZE, C["unitframes"].fontoutline)
		self.Name:Point("CENTER", health, "CENTER", 0, 2)
		self.Name:SetShadowColor(0, 0, 0, 0)
		self.Name.frequentUpdates = 0.5
		self:Tag(self.Name, '[ElvUI:getnamecolor][ElvUI:namemedium]')		
		-- Auras
		if (unit == "targettarget" and C["unitframes"].totdebuffs == true) then	
			local debuffs = CreateFrame("Frame", nil, self)
			debuffs.num = C["unitframes"].smallaurasperrow
			debuffs:SetWidth(SMALL_WIDTH)
			debuffs.spacing = E.Scale(SPACING)
			debuffs.size = ((C["unitframes"].smallwidth - (debuffs.spacing*(debuffs.num - 1))) / debuffs.num)
			debuffs:SetHeight(debuffs.size)
			debuffs:Point("TOP", self, "BOTTOM", 0, -SPACING)	
			debuffs.initialAnchor = 'BOTTOMRIGHT'
			debuffs["growth-y"] = "UP"
			debuffs["growth-x"] = "LEFT"
			debuffs.PostCreateIcon = E.PostCreateAura
			debuffs.PostUpdateIcon = E.PostUpdateAura
			debuffs.CustomFilter = E.AuraFilter
			self.Debuffs = debuffs
		end
		-- Debuff Highlight
		if C["unitframes"].debuffhighlight == true then
			local dbh = self:CreateTexture(nil, "OVERLAY")
			dbh:SetAllPoints(self.Health.backdrop)
			dbh:SetTexture(C["media"].blank)
			dbh:SetBlendMode("ADD")
			dbh:SetVertexColor(0,0,0,0)
			self.DebuffHighlight = dbh
			self.DebuffHighlightFilter = true
			self.DebuffHighlightAlpha = 0.35
		end
		
		if unit == 'pet' then
			if C['unitframes']['unitcastbar'] == true then
				local castbar = CreateFrame( 'StatusBar', nil, self )
				self.Castbar = castbar
			end
			-- Incoming Pet Heals
			if C["raidframes"].raidunitbuffwatch == true then
				E.createAuraWatch(self,unit)
			end
			-- Autohide in combat
			if C["unitframes"].combat == true then
				self:HookScript("OnEnter", function(self) E.Fader(self, true) end)
				self:HookScript("OnLeave", function(self) E.Fader(self, false) end)
			end
		end

		self:SetAttribute("initial-height", SMALL_HEIGHT)
		self:SetAttribute("initial-width", SMALL_WIDTH)
	end
	------------------------------------------------------------------------
	--	Arena and Boss
	------------------------------------------------------------------------
	if (unit and unit:find("arena%d") and C["unitframes"].arena == true) or (unit and unit:find("boss%d") and C["unitframes"].showboss == true) then
		local POWERBAR_WIDTH = C["unitframes"].arenabosswidth/2
		local TRINKET_WIDTH = BOSS_HEIGHT * 0.9
		local POWERBAR_HEIGHT = C["unitframes"].powerbar_height*0.7
		local CASTBAR_HEIGHT = 18
		local CASTBAR_WIDTH = BOSS_WIDTH

		if unit:find("arena%d") then
			POWERBAR_WIDTH = C["unitframes"].arenabosswidth/2.3
		end
		-- Right-click focus on arena or boss units
		self:SetAttribute("type2", "focus")
		--Health
		local health = E.ContructHealthBar(self, true, true)
		health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER)
		if USE_POWERBAR_OFFSET then
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER+POWERBAR_OFFSET, BORDER+POWERBAR_OFFSET)
		elseif POWERTHEME == true then
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER + (POWERBAR_HEIGHT/2))
		else
			health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER + POWERBAR_HEIGHT)
		end
		health.value:Point("TOPRIGHT", health, "TOPRIGHT", 0, -2)
		self.Health = health
		-- Power
		local power = E.ConstructPowerBar(self, true, true)
		if USE_POWERBAR_OFFSET then
			power:Point("TOPLEFT", health, "TOPLEFT", -POWERBAR_OFFSET, -POWERBAR_OFFSET)
			power:Point("BOTTOMRIGHT", health, "BOTTOMRIGHT", -POWERBAR_OFFSET, -POWERBAR_OFFSET)
			power:SetFrameStrata("LOW")
			power:SetFrameLevel(2)
		elseif POWERTHEME == true then
			power:Width(POWERBAR_WIDTH - BORDER*2)
			power:Height(POWERBAR_HEIGHT - BORDER*2)
			power:Point("LEFT", self, "BOTTOMLEFT", BORDER*2 + 4, BORDER + (POWERBAR_HEIGHT/2))
			power:SetFrameStrata("MEDIUM")
			power:SetFrameLevel(self:GetFrameLevel() + 3)
		else
			power:Point("TOPRIGHT", health.backdrop, "BOTTOMRIGHT", -BORDER, -(E.PixelMode and 0 or (BORDER + SPACING)))
			power:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER)
		end	
		power.value:Point("BOTTOMRIGHT", health, "BOTTOMRIGHT")
		self.Power = power
		-- Name & Trinkets
		if (unit and unit:find('arena%d')) then
			health:Point("TOPRIGHT", self, "TOPRIGHT", -(TRINKET_WIDTH + BORDER), -BORDER)
			
			local trinket = CreateFrame("Frame", nil, self)
			trinket.trinketUseAnnounce = true
			
			trinket.bg = CreateFrame("Frame", nil, trinket)
			trinket.bg:Point("TOPRIGHT", self, "TOPRIGHT")
			if POWERTHEME == true or USE_POWERBAR_OFFSET == true then
				trinket.bg:SetPoint("BOTTOMLEFT", health.backdrop, "BOTTOMRIGHT", SPACING, 0)
			else
				trinket.bg:SetPoint("BOTTOMLEFT", power.backdrop, "BOTTOMRIGHT", SPACING, 0)		
			end
			trinket.bg:SetTemplate("Default")
			trinket.bg:SetFrameLevel(trinket:GetFrameLevel() - 1)
			
			trinket:Point("TOPLEFT", trinket.bg, BORDER, -BORDER)
			trinket:Point("BOTTOMRIGHT", trinket.bg, -BORDER, BORDER)
			
			self.Trinket = trinket			
		end
		-- Name
		self:FontString("Name", FONT, FONTSIZE, C["unitframes"].fontoutline)
		self.Name:Point("LEFT", health, "LEFT", 4, 0)
		self.Name:SetShadowColor(0, 0, 0, 0)
		self.Name.frequentUpdates = 0.5
		self:Tag(self.Name, '[ElvUI:getnamecolor][ElvUI:namemedium]')
		-- Auras
		if (unit and unit:find("arena%d") and C["unitframes"].arenabuffs == true) or (unit and unit:find("boss%d") and C["unitframes"].bossbuffs == true) then
			local buffs = CreateFrame("Frame", nil, self)
			buffs.num = 3
			buffs:SetWidth(BOSS_WIDTH)
			buffs.spacing = E.Scale(SPACING)
			if POWERTHEME == true or USE_POWERBAR_OFFSET == true then
				buffs.size = BOSS_HEIGHT - (POWERBAR_HEIGHT - BORDER - SPACING)
			else
				buffs.size = BOSS_HEIGHT
			end
			buffs:Point("TOPRIGHT", self, "TOPLEFT", -4, 0)
			buffs:SetHeight(buffs.size)
			buffs.initialAnchor = 'RIGHT'
			buffs["growth-y"] = "UP"	
			buffs["growth-x"] = "LEFT"
			buffs.PostCreateIcon = E.PostCreateAura
			buffs.PostUpdateIcon = E.PostUpdateAura
			if (unit and unit:find('arena%d')) then
				buffs.CustomFilter = E.AuraFilter
			end
			self.Buffs = buffs	
		end
		
		if (unit and unit:find("arena%d") and C["unitframes"].arenadebuffs == true) or (unit and unit:find("boss%d") and C["unitframes"].bossdebuffs == true) then
			local debuffs = CreateFrame("Frame", nil, self)
			debuffs.num = 3
			debuffs:SetWidth(BOSS_WIDTH)
			debuffs.spacing = E.Scale(2)
			if POWERTHEME == true or USE_POWERBAR_OFFSET == true then
				debuffs.size = BOSS_HEIGHT - (POWERBAR_HEIGHT - BORDER - SPACING)
			else
				debuffs.size = BOSS_HEIGHT
			end
			debuffs:SetHeight(debuffs.size)
			debuffs:Point("TOPLEFT", self, "TOPRIGHT", 4, 0)
			debuffs.initialAnchor = 'LEFT'
			debuffs["growth-y"] = "UP"
			debuffs["growth-x"] = "RIGHT"
			debuffs.PostCreateIcon = E.PostCreateAura
			debuffs.PostUpdateIcon = E.PostUpdateAura
			debuffs.CustomFilter = E.AuraFilter
			self.Debuffs = debuffs
		end
		--Cast Bar
		if C['unitframes']['unitcastbar'] == true then
			local castbar = E.ConstructCastBar( self, 'RIGHT' )
			castbar:Width( CASTBAR_WIDTH - ( E.PixelMode and 2 or ( BORDER * 2 ) ) )
			castbar:Height( CASTBAR_HEIGHT )
			
			if C['unitframes']['cbicons'] then
				castbar.Icon = castbar.ButtonIcon
				castbar.Icon.bg:Width( CASTBAR_HEIGHT + ( E.Border * 2 ) )
				castbar.Icon.bg:Height( CASTBAR_HEIGHT + ( E.Border * 2 ) )
				
				castbar:Width( CASTBAR_WIDTH - castbar.Icon.bg:GetWidth() - ( E.PixelMode and 1 or 5 ) )
				castbar.Icon.bg:Show()
			else
				castbar.ButtonIcon.bg:Hide()
				castbar.Icon = nil
			end
			
			castbar:Point( 'TOPLEFT', self, 'BOTTOMLEFT', BORDER, - ( E.Border * 2 + E.Border ) )
			
			self.Castbar = castbar
		end

		self:SetAttribute( 'initial-height', BOSS_HEIGHT )
		self:SetAttribute( 'initial-width', BOSS_WIDTH )
	end
	------------------------------------------------------------------------
	--	Main tanks and Main Assists
	------------------------------------------------------------------------
	if unit == "maintank" or unit == "mainassist" or unit == "maintanktarget" or unit == "mainassisttarget" then
		-- Health Bar
		local health = E.ContructHealthBar(self, true, nil)
		health:Point("TOPRIGHT", self, "TOPRIGHT", -BORDER, -BORDER)
		health:Point("BOTTOMLEFT", self, "BOTTOMLEFT", BORDER, BORDER)
		self.Health = health
		-- Name
		self:FontString("Name", FONT, FONTSIZE, C["unitframes"].fontoutline)
		self.Name:Point("CENTER", health, "CENTER", 0, 2)
		self.Name:SetShadowColor(0, 0, 0, 0)
		self.Name.frequentUpdates = 0.5
		self:Tag(self.Name, '[ElvUI:getnamecolor][ElvUI:namemedium]')			
		
		self:SetAttribute("initial-height", TANK_HEIGHT)
		self:SetAttribute("initial-width", TANK_WIDTH)	
	end
	
	return self
end
------------------------------------------------------------------------
--	Default position of ElvUI unitframes
------------------------------------------------------------------------
oUF:RegisterStyle('ElvUI', Shared)

oUF:SetActiveStyle('ElvUI')
oUF:Spawn('player', "oUF_ElvUI_player"):Point("BOTTOM", ElvuiMainMenuBar, "TOPLEFT", 12, 120)
oUF:Spawn('target', "oUF_ElvUI_target"):Point("BOTTOM", ElvuiMainMenuBar, "TOPRIGHT", -12, 120)
oUF:Spawn('focus', "oUF_ElvUI_focus"):Point("BOTTOMLEFT", oUF_ElvUI_target, "TOPRIGHT", 10, 90)
if C["unitframes"].showfocustarget == true then
	oUF:Spawn('focustarget', "oUF_ElvUI_focustarget"):Point("BOTTOM", oUF_ElvUI_focus, "TOP", 0, 15)
end
oUF:Spawn('targettarget', "oUF_ElvUI_targettarget"):Point("BOTTOM", ElvuiMainMenuBar, "TOP", 0, 120)
oUF:Spawn('pet', "oUF_ElvUI_pet"):Point("BOTTOM", oUF_ElvUI_targettarget, "TOP", 0, 15)
if C["unitframes"].pettarget == true then
	oUF:Spawn('pettarget', "oUF_ElvUI_pettarget"):Point("BOTTOM", oUF_ElvUI_pet, "TOP", 0, 8)	
end

if C.unitframes.arena then
	local arena = {}
	for i = 1, 5 do
		arena[i] = oUF:Spawn("arena"..i, "oUF_Arena"..i)
		if i == 1 then
			arena[i]:Point("BOTTOMLEFT", RightChatPanel, "TOPLEFT", -40, 185)
		else
			arena[i]:Point("BOTTOM", arena[i-1], "TOP", 0, 34)
		end
	end
end

for i = 1,MAX_BOSS_FRAMES do
	local t_boss = _G["Boss"..i.."TargetFrame"]
	t_boss:UnregisterAllEvents()
	t_boss.Show = E.dummy
	t_boss:Hide()
	_G["Boss"..i.."TargetFrame".."HealthBar"]:UnregisterAllEvents()
	_G["Boss"..i.."TargetFrame".."ManaBar"]:UnregisterAllEvents()
end

local boss = {}
for i = 1, MAX_BOSS_FRAMES do
	boss[i] = oUF:Spawn("boss"..i, "oUF_Boss"..i)
	if i == 1 then
		boss[i]:Point("BOTTOMLEFT", RightChatPanel, "TOPLEFT", -40, 185)
	else
		boss[i]:Point('BOTTOM', boss[i-1], 'TOP', 0, 34)             
	end
end

local party
if C["raidframes"].disableblizz == true then
	for i = 1,MAX_BOSS_FRAMES do
		local t_boss = _G["Boss"..i.."TargetFrame"]
		t_boss:UnregisterAllEvents()
		t_boss.Show = E.dummy
		t_boss:Hide()
		_G["Boss"..i.."TargetFrame".."HealthBar"]:UnregisterAllEvents()
		_G["Boss"..i.."TargetFrame".."ManaBar"]:UnregisterAllEvents()
	end
	
	party = oUF:SpawnHeader("oUF_noParty", nil, "party", "showParty", true)
end

if C["classtimer"].enable == true then
	E.LoadClassTimers(oUF_ElvUI_player, oUF_ElvUI_target)
end

--	Right Click Menu
do
	UnitPopupMenus["SELF"] = { "SET_FOCUS", "PVP_FLAG", "LOOT_METHOD", "LOOT_THRESHOLD", "OPT_OUT_LOOT_TITLE", "LOOT_PROMOTE", "DUNGEON_DIFFICULTY", "RESET_INSTANCES", "RAID_TARGET_ICON", "LEAVE", "CANCEL" };
	UnitPopupMenus["PET"] = { "SET_FOCUS", "PET_PAPERDOLL", "PET_RENAME", "PET_ABANDON", "PET_DISMISS", "CANCEL" };
	UnitPopupMenus["PARTY"] = { "SET_FOCUS", "MUTE", "UNMUTE", "PARTY_SILENCE", "PARTY_UNSILENCE", "RAID_SILENCE", "RAID_UNSILENCE", "BATTLEGROUND_SILENCE", "BATTLEGROUND_UNSILENCE", "WHISPER", "PROMOTE", "LOOT_PROMOTE", "UNINVITE", "INSPECT", "ACHIEVEMENTS", "TRADE", "FOLLOW", "DUEL", "RAID_TARGET_ICON", "PVP_REPORT_AFK", "RAF_SUMMON", "RAF_GRANT_LEVEL", "CANCEL" };
	UnitPopupMenus["PLAYER"] = { "SET_FOCUS", "WHISPER", "INSPECT", "INVITE", "ACHIEVEMENTS", "TRADE", "FOLLOW", "DUEL", "RAID_TARGET_ICON", "RAF_SUMMON", "RAF_GRANT_LEVEL", "CANCEL" };
	UnitPopupMenus["RAID_PLAYER"] = { "SET_FOCUS", "MUTE", "UNMUTE", "RAID_SILENCE", "RAID_UNSILENCE", "BATTLEGROUND_SILENCE", "BATTLEGROUND_UNSILENCE", "WHISPER", "INSPECT", "ACHIEVEMENTS", "TRADE", "FOLLOW", "DUEL", "RAID_TARGET_ICON", "RAID_LEADER", "RAID_PROMOTE", "RAID_DEMOTE", "LOOT_PROMOTE", "RAID_REMOVE", "PVP_REPORT_AFK", "RAF_SUMMON", "RAF_GRANT_LEVEL", "CANCEL" };
	UnitPopupMenus["RAID"] = { "SET_FOCUS", "MUTE", "UNMUTE", "RAID_SILENCE", "RAID_UNSILENCE", "BATTLEGROUND_SILENCE", "BATTLEGROUND_UNSILENCE", "RAID_LEADER", "RAID_PROMOTE", "RAID_MAINTANK", "RAID_MAINASSIST", "LOOT_PROMOTE", "RAID_DEMOTE", "RAID_REMOVE", "PVP_REPORT_AFK", "CANCEL" };
	UnitPopupMenus["RAID_TARGET_ICON"] = { "RAID_TARGET_1", "RAID_TARGET_2", "RAID_TARGET_3", "RAID_TARGET_4", "RAID_TARGET_5", "RAID_TARGET_6", "RAID_TARGET_7", "RAID_TARGET_8", "RAID_TARGET_NONE" };
	UnitPopupMenus["VEHICLE"] = { "RAID_TARGET_ICON", "VEHICLE_LEAVE", "CANCEL" };
	UnitPopupMenus["TARGET"] = { "SET_FOCUS", "RAID_TARGET_ICON", "CANCEL" };
	UnitPopupMenus["FOCUS"] = { "CLEAR_FOCUS", "LOCK_FOCUS_FRAME", "UNLOCK_FOCUS_FRAME", "RAID_TARGET_ICON", "CANCEL" };
end