---------------------------------------------------------------------------------------------
-- AddOn Name: BunnyUI 1.x
-- Author: Bunny
-- Description: BunnyUI
-- Credits:
---------------------------------------------------------------------------------------------
local E, C, L, DB = unpack( select( 2, ... ) )

if C['others']['autoacceptinv'] then
	local tAutoAcceptInvite = CreateFrame( 'Frame' )
	tAutoAcceptInvite:RegisterEvent( 'PARTY_INVITE_REQUEST' )
	tAutoAcceptInvite:RegisterEvent( 'PARTY_MEMBERS_CHANGED' )
	
	local hidestatic
	
	tAutoAcceptInvite:SetScript( 'OnEvent', function( self, event, ... )
		arg1 = ...
		local leader = arg1
		local ingroup = false
		
		if event == 'PARTY_INVITE_REQUEST' then
			if MiniMapLFGFrame:IsShown() then return end
			if GetNumPartyMembers() > 0 or GetNumRaidMembers() > 0 then return end
			hidestatic = true
			
			if GetNumFriends() > 0 then ShowFriends() end
			if IsInGuild() then GuildRoster() end
			
			for friendIndex = 1, GetNumFriends() do
				local friendName = GetFriendInfo(friendIndex)
				if friendName == leader then
					AcceptGroup()
					ingroup = true
					break
				end
			end
			
			if not ingroup then
				for guildIndex = 1, GetNumGuildMembers(true) do
					local guildMemberName = GetGuildRosterInfo(guildIndex)
					if guildMemberName == leader then
						AcceptGroup()
						break
					end
				end
			end
		elseif event == 'PARTY_MEMBERS_CHANGED' and hidestatic == true then
			StaticPopup_Hide( 'PARTY_INVITE' )
			hidestatic = false
		end
	end )
end