﻿---------------------------------------------------------------------------------------------
-- AddOn Name: BunnyUI 1.x
-- Author: Bunny
-- Description: BunnyUI
-- Credits:
---------------------------------------------------------------------------------------------
local E, C, L, DB = unpack( select( 2, ... ) )

if C['chat']['chatbar'] ~= true then return end

local BunnyUIChatBar = CreateFrame( 'Frame', 'BunnyUIChatBar', UIParent )
BunnyUIChatBar:Size( 101, 16 )
BunnyUIChatBar:Point( 'RIGHT', LeftChatTab, 'RIGHT', -3, 0 )
BunnyUIChatBar:SetTemplate( 'Transparent' )
BunnyUIChatBar:SetParent( LeftChatToggleButton )

function BunnyUIChatBar:SW( button )
	if( button == 'RightButton' ) then
		ChatFrame_OpenChat( '/w ', SELECTED_DOCK_FRAME )
	elseif( button == 'MiddleButton' ) then
		ChatFrame_OpenChat( '/y ', SELECTED_DOCK_FRAME )
	else
		ChatFrame_OpenChat( '/s ', SELECTED_DOCK_FRAME )
	end
end

function BunnyUIChatBar:GO( button )
	if( button == 'RightButton' ) then
		ChatFrame_OpenChat( '/o ', SELECTED_DOCK_FRAME )
	else
		ChatFrame_OpenChat( '/g ', SELECTED_DOCK_FRAME )
	end
end

function BunnyUIChatBar:RP( button )
	if( button == 'RightButton' ) then
		ChatFrame_OpenChat( '/bg ', SELECTED_DOCK_FRAME )
	else
		ChatFrame_OpenChat( '/p ', SELECTED_DOCK_FRAME )
	end
end

function BunnyUIChatBar:GT( button )
	if( button == 'RightButton' ) then
		ChatFrame_OpenChat( '/2 ', SELECTED_DOCK_FRAME )
	else
		ChatFrame_OpenChat( '/1 ', SELECTED_DOCK_FRAME )
	end
end

function BunnyUIChatBar:LG( button )
	if( button == 'RightButton' ) then
		ChatFrame_OpenChat( '/4 ', SELECTED_DOCK_FRAME )
	else
		ChatFrame_OpenChat( '/3 ', SELECTED_DOCK_FRAME )
	end
end

function BunnyUIChatBar:YR( button )
	if( button == 'RightButton' ) then
		ChatFrame_OpenChat( '/rw ', SELECTED_DOCK_FRAME )
	else
		ChatFrame_OpenChat( '/raid ', SELECTED_DOCK_FRAME )
	end
end

local function CreateButton( b, f )
	b:Width( 16 )
	b:Height( 16 )
	b:SetTemplate( 'Default' )
	b:RegisterForClicks( 'AnyUp' )
	b:SetScript( 'OnClick', f )

	b.t = b:CreateTexture( nil, 'ARTWORK' )
	b.t:SetTexture( C['media']['normTex'] )
	b.t:SetInside()
end

local sw = CreateFrame( 'Button', 'sw', BunnyUIChatBar )
CreateButton( sw, BunnyUIChatBar.SW )
sw:Point( 'LEFT', BunnyUIChatBar, 'LEFT', 0, 0 )
sw:SetBackdropBorderColor( 0.7, 0.33, 0.82, 1 )
sw.t:SetVertexColor( 0.8, 0.8, 0.8, 1 )
sw:SetScript('OnEnter', function( self )
	GameTooltip:ClearLines()
	GameTooltip:SetOwner( self )
	GameTooltip:AddDoubleLine( KEY_BUTTON1, '/s' )
	GameTooltip:AddDoubleLine( KEY_BUTTON2, '/w' )
	GameTooltip:AddDoubleLine( KEY_BUTTON3, '/y' )
	GameTooltip:Show()
end )
sw:SetScript( 'OnLeave', function( self )
	GameTooltip:Hide()
end )

local go = CreateFrame( 'Button', 'go', BunnyUIChatBar )
CreateButton( go, BunnyUIChatBar.GO )
go:Point( 'LEFT', sw, 'RIGHT', 1, 0 )
go:SetBackdropBorderColor( 0, 0.54, 0, 1 )
go.t:SetVertexColor( 0, 0.8, 0, 1 )
go:SetScript('OnEnter', function( self )
	GameTooltip:ClearLines()
	GameTooltip:SetOwner( self )
	GameTooltip:AddDoubleLine( KEY_BUTTON1, '/g' )
	GameTooltip:AddDoubleLine( KEY_BUTTON2, '/o' )
	GameTooltip:Show()
end )
go:SetScript( 'OnLeave', function( self )
	GameTooltip:Hide()
end )

local rp = CreateFrame( 'Button', 'rp', BunnyUIChatBar )
CreateButton( rp, BunnyUIChatBar.RP )
rp:Point( 'LEFT', go, 'RIGHT', 1, 0 )
rp:SetBackdropBorderColor( 0.8, 0.4, 0.1, 1 )
rp.t:SetVertexColor( 0.11, 0.5, 0.7, 1 )
rp:SetScript('OnEnter', function( self )
	GameTooltip:ClearLines()
	GameTooltip:SetOwner( self )
	GameTooltip:AddDoubleLine( KEY_BUTTON1, '/p' )
	GameTooltip:AddDoubleLine( KEY_BUTTON2, '/bg' )
	GameTooltip:Show()
end )
rp:SetScript( 'OnLeave', function( self )
	GameTooltip:Hide()
end )

local yr = CreateFrame( 'Button', 'yr', BunnyUIChatBar )
CreateButton( yr, BunnyUIChatBar.YR )
yr:Point( 'LEFT', rp, 'RIGHT', 1, 0 )
yr:SetBackdropBorderColor( 0.96, 0.2, 0.2, 1 )
yr.t:SetVertexColor( 1, 0.3, 0, 1 )
yr:SetScript('OnEnter', function( self )
	GameTooltip:ClearLines()
	GameTooltip:SetOwner( self )
	GameTooltip:AddDoubleLine( KEY_BUTTON1, '/raid' )
	GameTooltip:AddDoubleLine( KEY_BUTTON2, '/rw' )
	GameTooltip:Show()
end )
yr:SetScript( 'OnLeave', function( self )
	GameTooltip:Hide()
end )

local gt = CreateFrame( 'Button', 'gt', BunnyUIChatBar )
CreateButton( gt, BunnyUIChatBar.GT )
gt:Point( 'LEFT', yr, 'RIGHT', 1, 0 )
gt:SetBackdropBorderColor( 0.7, 0.7, 0, 1 )
gt.t:SetVertexColor( 0.93, 0.8, 0.8, 1 )
gt:SetScript('OnEnter', function( self )
	GameTooltip:ClearLines()
	GameTooltip:SetOwner( self )
	GameTooltip:AddDoubleLine( KEY_BUTTON1, '/1' )
	GameTooltip:AddDoubleLine( KEY_BUTTON2, '/2' )
	GameTooltip:Show()
end )
gt:SetScript( 'OnLeave', function( self )
	GameTooltip:Hide()
end )

local lg = CreateFrame( 'Button', 'lg', BunnyUIChatBar )
CreateButton( lg, BunnyUIChatBar.LG )
lg:Point( 'LEFT', gt, 'RIGHT', 1, 0 )
lg:SetBackdropBorderColor( 0.5, 1, 0.83, 1 )
lg.t:SetVertexColor( 1, 0.75, 0.75, 1 )
lg:SetScript('OnEnter', function( self )
	GameTooltip:ClearLines()
	GameTooltip:SetOwner( self )
	GameTooltip:AddDoubleLine( KEY_BUTTON1, '/3' )
	GameTooltip:AddDoubleLine( KEY_BUTTON2, '/4' )
	GameTooltip:Show()
end )
lg:SetScript( 'OnLeave', function( self )
	GameTooltip:Hide()
end )