local E, C, L, DB = unpack(select(2, ...))
	
if C['datatext']['Durability'] and C['datatext']['Durability'] > 0 then
	local Stat = CreateFrame('Frame')
	Stat:SetFrameStrata('MEDIUM')
	Stat:SetFrameLevel(3)
	Stat:EnableMouse(true)
	
	local Text = Stat:CreateFontString(nil, 'OVERLAY')
	Text:SetFont(C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'])
	E.PP(C['datatext']['Durability'], Text)

	local function OnEvent(self)
		Total = 0
		local current, max
		
		for i = 1, 11 do
			if GetInventoryItemLink('player', L.Slots[i][1]) ~= nil then
				current, max = GetInventoryItemDurability(L.Slots[i][1])
				if current then 
					L.Slots[i][3] = current/max
					Total = Total + 1
				end
			end
		end
		table.sort(L.Slots, function(a, b) return a[3] < b[3] end)

		if Total > 0 then
			Text:SetFormattedText(string.join('', DURABILITY, ': ', E.ValColor, '%d%%|r'), floor(L.Slots[1][3]*100))
			if floor(L.Slots[1][3]*100) <= 20 then
				local int = -1
				Stat:SetScript('OnUpdate', function(self, t)
					int = int - t
					if int < 0 then
						int = 1
					end
				end)				
			else
				Stat:SetScript('OnUpdate', function() end)
			end
		else
			Text:SetFormattedText(string.join('', DURABILITY, ': ', E.ValColor, '%d%%|r'), 100)
		end

		self:SetAllPoints(Text)
	end
	
	Stat:RegisterEvent('UPDATE_INVENTORY_DURABILITY')
	Stat:RegisterEvent('MERCHANT_SHOW')
	Stat:RegisterEvent('PLAYER_ENTERING_WORLD')
	Stat:SetScript('OnMouseDown', function() ToggleCharacter('PaperDollFrame') end)
	Stat:SetScript('OnEvent', OnEvent)
	Stat:SetScript('OnEnter', function()
		if not InCombatLockdown() then
			local anchor, panel, xoff, yoff = E.DataTextTooltipAnchor(Text)
			GameTooltip:SetOwner(panel, anchor, xoff, yoff)
			GameTooltip:ClearLines()
			for i = 1, 11 do
				if L.Slots[i][3] ~= 1000 then
					green = L.Slots[i][3]*2
					red = 1 - green
					GameTooltip:AddDoubleLine(L.Slots[i][2], format('%d %%', floor(L.Slots[i][3]*100)), 1 ,1 , 1, red + 1, green, 0)
				end
			end
			GameTooltip:Show()
		end
	end)
	Stat:SetScript('OnLeave', function() GameTooltip:Hide() end)
end