local E, C, L, DB = unpack(select(2, ...))

if not C['actionbar']['enable'] == true then return end

local ElvuiShift = CreateFrame('Frame', 'ElvuiShiftBar', E.UIParent)
ElvuiShift:Point('TOPLEFT', E.UIParent, 'TOPLEFT', 0, 0)
ElvuiShift:Width((C['actionbar']['shiftbarbtnsize'] + C['actionbar']['shiftbarspacing']) * NUM_SHAPESHIFT_SLOTS)
ElvuiShift:Height(C['actionbar']['shiftbarbtnsize'])

if C['actionbar']['hideshapeshift'] == true then
	ElvuiShift:Hide()
end

E.CreateMover(ElvuiShift, 'ShapeShiftMover', L.actionbar_barshift, true)

if C['actionbar']['hideshapeshift'] then ElvuiShift:Hide() return end

local bar = CreateFrame('Frame', 'ElvuiShapeShift', ElvuiShift, 'SecureHandlerStateTemplate')
bar:ClearAllPoints()
bar:SetAllPoints(ElvuiShift)

local States = {
	['DRUID'] = 'show',
	['WARRIOR'] = 'show',
	['PALADIN'] = 'show',
	['DEATHKNIGHT'] = 'show',
	['ROGUE'] = 'show,',
	['PRIEST'] = 'show,',
	['HUNTER'] = 'show,',
	['WARLOCK'] = 'show,',
}

bar:RegisterEvent('PLAYER_LOGIN')
bar:RegisterEvent('PLAYER_ENTERING_WORLD')
bar:RegisterEvent('UPDATE_SHAPESHIFT_FORMS')
bar:RegisterEvent('UPDATE_SHAPESHIFT_USABLE')
bar:RegisterEvent('UPDATE_SHAPESHIFT_COOLDOWN')
bar:RegisterEvent('UPDATE_SHAPESHIFT_FORM')
bar:RegisterEvent('ACTIONBAR_PAGE_CHANGED')
bar:SetScript('OnEvent', function(self, event, ...)
	if event == 'PLAYER_LOGIN' then
		local button
		for i = 1, NUM_SHAPESHIFT_SLOTS do
			button = _G['ShapeshiftButton'..i]
			button:ClearAllPoints()
			button:SetParent(self)
			if C['actionbar']['verticalstance'] ~= true then
				if i == 1 then
					button:Point('BOTTOMLEFT', ElvuiShift, 0, 0)
				else
					local previous = _G['ShapeshiftButton'..i-1]
					button:Point('LEFT', previous, 'RIGHT', C['actionbar']['shiftbarspacing'], 0)
				end
			else
				if i == 1 then
					button:Point('BOTTOMLEFT', ElvuiShift, 0, 0)
				else
					local previous = _G['ShapeshiftButton'..i-1]
					button:Point('TOP', previous, 'BOTTOM', 0, -C['actionbar']['shiftbarspacing'])
				end			
			end
			local _, name = GetShapeshiftFormInfo(i)
			if name then
				button:Show()
			end
		end
		RegisterStateDriver(self, 'visibility', States[E.myclass] or 'hide')
	elseif event == 'UPDATE_SHAPESHIFT_FORMS' then
		if InCombatLockdown() then return end
		local button
		for i = 1, NUM_SHAPESHIFT_SLOTS do
			button = _G['ShapeshiftButton'..i]
			local _, name = GetShapeshiftFormInfo(i)
			if name then
				button:Show()
			else
				button:Hide()
			end
		end
		E.ElvuiShiftBarUpdate()
	elseif event == 'PLAYER_ENTERING_WORLD' then
		E.StyleShift()
	else
		E.ElvuiShiftBarUpdate()
	end
end)