local E, C, L, DB = unpack(select(2, ...))
E.TexCoords = {.08, .92, .08, .92}
E.SkinFuncs = {}
E.SkinFuncs['ElvUI'] = {}

local ButtonColor = E.PixelMode and {0.31, 0.31, 0.31} or C['media']['bordercolor']

local function SetModifiedBackdrop(self)
	if self.backdrop then self = self.backdrop end
	self:SetBackdropBorderColor(unpack(C['media']['valuecolor']))	
end

local function SetOriginalBackdrop(self)
	if self.backdrop then self = self.backdrop end
	self:SetBackdropBorderColor(unpack(C['media']['bordercolor']))	
end

function E.SkinButton(Frame, Strip)
	if Frame:GetName() then
		local l = _G[Frame:GetName()..'Left']
		local m = _G[Frame:GetName()..'Middle']
		local r = _G[Frame:GetName()..'Right']

		if l then l:SetAlpha(0) end
		if m then m:SetAlpha(0) end
		if r then r:SetAlpha(0) end
	end

	if Frame.Left then Frame.Left:SetAlpha(0) end
	if Frame.Right then Frame.Right:SetAlpha(0) end
	if Frame.Middle then Frame.Middle:SetAlpha(0) end
	if Frame.SetNormalTexture then Frame:SetNormalTexture('') end
	if Frame.SetHighlightTexture then Frame:SetHighlightTexture('') end
	if Frame.SetPushedTexture then Frame:SetPushedTexture('') end
	if Frame.SetDisabledTexture then Frame:SetDisabledTexture('') end
	
	if Strip then Frame:StripTextures() end
	
	Frame:SetTemplate('Default', true)
	Frame:HookScript('OnEnter', SetModifiedBackdrop)
	Frame:HookScript('OnLeave', SetOriginalBackdrop)
end

function E.SkinScrollBar(Frame, thumbTrim)
	if _G[Frame:GetName()..'BG'] then _G[Frame:GetName()..'BG']:SetTexture(nil) end
	if _G[Frame:GetName()..'Track'] then _G[Frame:GetName()..'Track']:SetTexture(nil) end

	if _G[Frame:GetName()..'Top'] then
		_G[Frame:GetName()..'Top']:SetTexture(nil)
	end
	
	if _G[Frame:GetName()..'Bottom'] then
		_G[Frame:GetName()..'Bottom']:SetTexture(nil)
	end
	
	if _G[Frame:GetName()..'Middle'] then
		_G[Frame:GetName()..'Middle']:SetTexture(nil)
	end

	if _G[Frame:GetName()..'ScrollUpButton'] and _G[Frame:GetName()..'ScrollDownButton'] then
		_G[Frame:GetName()..'ScrollUpButton']:StripTextures()
		_G[Frame:GetName()..'ScrollUpButton']:SetTemplate('Default', true)
		if not _G[Frame:GetName()..'ScrollUpButton'].texture then
			_G[Frame:GetName()..'ScrollUpButton'].texture = _G[Frame:GetName()..'ScrollUpButton']:CreateTexture(nil, 'OVERLAY')
			_G[Frame:GetName()..'ScrollUpButton'].texture:SetInside()
			_G[Frame:GetName()..'ScrollUpButton'].texture:SetTexture([[Interface\AddOns\ElvUI\media\textures\arrowup.tga]])
			_G[Frame:GetName()..'ScrollUpButton'].texture:SetVertexColor(unpack(ButtonColor))
		end	
		
		_G[Frame:GetName()..'ScrollUpButton']:HookScript('OnEnter', function(self)
			SetModifiedBackdrop(self)
			self.texture:SetVertexColor(unpack(C['media']['valuecolor']))
		end)
		
		_G[Frame:GetName()..'ScrollUpButton']:HookScript('OnLeave', function(self)
			SetOriginalBackdrop(self)
			self.texture:SetVertexColor(unpack(ButtonColor))
		end)
		
		_G[Frame:GetName()..'ScrollDownButton']:StripTextures()
		_G[Frame:GetName()..'ScrollDownButton']:SetTemplate('Default', true)
	
		if not _G[Frame:GetName()..'ScrollDownButton'].texture then
			_G[Frame:GetName()..'ScrollDownButton'].texture = _G[Frame:GetName()..'ScrollDownButton']:CreateTexture(nil, 'OVERLAY')
			_G[Frame:GetName()..'ScrollDownButton'].texture:SetInside()
			_G[Frame:GetName()..'ScrollDownButton'].texture:SetTexture([[Interface\AddOns\ElvUI\media\textures\arrowdown.tga]])
			_G[Frame:GetName()..'ScrollDownButton'].texture:SetVertexColor(unpack(ButtonColor))
		end				
		
		_G[Frame:GetName()..'ScrollDownButton']:HookScript('OnEnter', function(self)
			SetModifiedBackdrop(self)
			self.texture:SetVertexColor(unpack(C['media']['valuecolor']))
		end)
		
		_G[Frame:GetName()..'ScrollDownButton']:HookScript('OnLeave', function(self)
			SetOriginalBackdrop(self)
			self.texture:SetVertexColor(unpack(ButtonColor))
		end)
		
		if not Frame.trackbg then
			Frame.trackbg = CreateFrame('Frame', nil, Frame)
			Frame.trackbg:Point('TOPLEFT', _G[Frame:GetName()..'ScrollUpButton'], 'BOTTOMLEFT', 0, -1)
			Frame.trackbg:Point('BOTTOMRIGHT', _G[Frame:GetName()..'ScrollDownButton'], 'TOPRIGHT', 0, 1)
			Frame.trackbg:SetTemplate('Transparent')
		end
		
		if Frame:GetThumbTexture() then
			if not thumbTrim then thumbTrim = 3 end
			Frame:GetThumbTexture():SetTexture(nil)
			if not Frame.thumbbg then
				Frame.thumbbg = CreateFrame('Frame', nil, Frame)
				Frame.thumbbg:Point('TOPLEFT', Frame:GetThumbTexture(), 'TOPLEFT', 2, -thumbTrim)
				Frame.thumbbg:Point('BOTTOMRIGHT', Frame:GetThumbTexture(), 'BOTTOMRIGHT', -2, thumbTrim)
				Frame.thumbbg:SetTemplate('Default', true)
				if Frame.trackbg then
					Frame.thumbbg:SetFrameLevel(Frame.trackbg:GetFrameLevel())
				end
			end
		end	
	end	
end

local TabRegion = {'LeftDisabled', 'MiddleDisabled', 'RightDisabled', 'Left', 'Middle', 'Right'}

function E.SkinTab(Tab)
	if not Tab then return end
	for _, object in pairs(TabRegion) do
		local Texture = _G[Tab:GetName()..object]
		if Texture then
			Texture:SetTexture(nil)
		end
	end
	
	if Tab.GetHighlightTexture and Tab:GetHighlightTexture() then
		Tab:GetHighlightTexture():SetTexture(nil)
	else
		Tab:StripTextures()
	end
	
	Tab.Backdrop = CreateFrame('Frame', nil, Tab)
	Tab.Backdrop:CreateBackdrop('Default')
	Tab.Backdrop.backdrop:SetInside()
	Tab.Backdrop:SetFrameLevel(Tab:GetFrameLevel() - 1)
	Tab.Backdrop:Point('TOPLEFT', 8, E.PixelMode and 0 or -1)
	Tab.Backdrop:Point('BOTTOMRIGHT', -8, 1)				
end

function E.SkinNextPrevButton(btn, horizonal)
	local norm, pushed, disabled
	if btn:GetNormalTexture() then
		norm = btn:GetNormalTexture():GetTexture()
	end

	if btn:GetPushedTexture() then
		pushed = btn:GetPushedTexture():GetTexture()
	end
	
	if btn:GetDisabledTexture() then
		disabled = btn:GetDisabledTexture():GetTexture()
	end	
	
	btn:StripTextures()

	if not norm then
		norm = 'Interface\\Buttons\\UI-SpellbookIcon-NextPage-Up'
	end

	if not pushed then
		pushed = 'Interface\\Buttons\\UI-SpellbookIcon-NextPage-Down'
	end
	
	if not disabled then
		disabled = 'Interface\\Buttons\\UI-SpellbookIcon-NextPage-Disabled'
	end	
	
	btn:SetNormalTexture(norm)
	btn:SetPushedTexture(pushed)
	btn:SetDisabledTexture(disabled)
	
	btn:SetTemplate('Default')
	btn:Size(btn:GetWidth() - 7, btn:GetHeight() - 7)	
	
	if norm and pushed and disabled then
		if horizonal then
			btn:GetNormalTexture():SetTexCoord(0.3, 0.29, 0.3, 0.72, 0.65, 0.29, 0.65, 0.72)
			btn:GetPushedTexture():SetTexCoord(0.3, 0.35, 0.3, 0.8, 0.65, 0.35, 0.65, 0.8)
			btn:GetDisabledTexture():SetTexCoord(0.3, 0.29, 0.3, 0.75, 0.65, 0.29, 0.65, 0.75)	
		else
			btn:GetNormalTexture():SetTexCoord(0.3, 0.29, 0.3, 0.81, 0.65, 0.29, 0.65, 0.81)
			
			if btn:GetPushedTexture() then
				btn:GetPushedTexture():SetTexCoord(0.3, 0.35, 0.3, 0.81, 0.65, 0.35, 0.65, 0.81)
			end
			if btn:GetDisabledTexture() then
				btn:GetDisabledTexture():SetTexCoord(0.3, 0.29, 0.3, 0.75, 0.65, 0.29, 0.65, 0.75)
			end
		end
		
		btn:GetNormalTexture():ClearAllPoints()
		btn:GetNormalTexture():SetInside()
		if btn:GetDisabledTexture() then
			btn:GetDisabledTexture():SetAllPoints(btn:GetNormalTexture())
		end
		
		if btn:GetPushedTexture() then
			btn:GetPushedTexture():SetAllPoints(btn:GetNormalTexture())
		end
		
		btn:GetHighlightTexture():SetTexture(1, 1, 1, 0.3)
		btn:GetHighlightTexture():SetAllPoints(btn:GetNormalTexture())
	end
end

function E.SkinRotateButton(btn)
	btn:SetTemplate('Default')
	btn:Size(btn:GetWidth() - 14, btn:GetHeight() - 14)	
	
	btn:GetNormalTexture():SetTexCoord(0.3, 0.29, 0.3, 0.65, 0.69, 0.29, 0.69, 0.65)
	btn:GetPushedTexture():SetTexCoord(0.3, 0.29, 0.3, 0.65, 0.69, 0.29, 0.69, 0.65)	
	
	btn:GetHighlightTexture():SetTexture(1, 1, 1, 0.3)
	
	btn:GetNormalTexture():SetInside()
	btn:GetPushedTexture():SetAllPoints(btn:GetNormalTexture())	
	btn:GetHighlightTexture():SetAllPoints(btn:GetNormalTexture())
end

function E.SkinEditBox(frame)
	if _G[frame:GetName()..'Left'] then _G[frame:GetName()..'Left']:Kill() end
	if _G[frame:GetName()..'Middle'] then _G[frame:GetName()..'Middle']:Kill() end
	if _G[frame:GetName()..'Right'] then _G[frame:GetName()..'Right']:Kill() end
	if _G[frame:GetName()..'Mid'] then _G[frame:GetName()..'Mid']:Kill() end
	frame:CreateBackdrop('Default')
	
	if frame:GetName() and frame:GetName():find('Silver') or frame:GetName():find('Copper') then
		frame.backdrop:Point('BOTTOMRIGHT', -12, -2)
	end
end

function E.SkinDropDownBox(frame, width)
	local button = _G[frame:GetName()..'Button']
	if not width then width = 155 end
	
	frame:StripTextures()
	frame:Width(width)
	
	_G[frame:GetName()..'Text']:ClearAllPoints()
	_G[frame:GetName()..'Text']:Point('RIGHT', button, 'LEFT', -2, 0)

	
	button:ClearAllPoints()
	button:Point('RIGHT', frame, 'RIGHT', -10, 3)
	button.SetPoint = E.dummy
	
	E.SkinNextPrevButton(button, true)
	
	frame:CreateBackdrop('Default')
	frame.backdrop:Point('TOPLEFT', 20, -2)
	frame.backdrop:Point('BOTTOMRIGHT', button, 'BOTTOMRIGHT', 2, -2)
end

function E.SkinCheckBox(Frame)
	Frame:StripTextures()
	Frame:CreateBackdrop('Default')
	Frame.backdrop:Point('TOPLEFT', 4, -4)
	Frame.backdrop:Point('BOTTOMRIGHT', -4, 4)
	
	if Frame.SetCheckedTexture then
		Frame:SetCheckedTexture('Interface\\Buttons\\UI-CheckBox-Check')
	end
	
	if Frame.SetDisabledTexture then
		Frame:SetDisabledTexture('Interface\\Buttons\\UI-CheckBox-Check-Disabled')
	end
	
	Frame.SetNormalTexture = E.noop
	Frame.SetPushedTexture = E.noop
	Frame.SetHighlightTexture = E.noop
end

function E.SkinCloseButton(f, point, text)
	f:StripTextures()
	
	if not f.backdrop then
		f:CreateBackdrop('Default', true)
		f.backdrop:Point('TOPLEFT', 7, -8)
		f.backdrop:Point('BOTTOMRIGHT', -8, 8)
		f:HookScript('OnEnter', SetModifiedBackdrop)
		f:HookScript('OnLeave', SetOriginalBackdrop)	
	end
	if not text then text = 'x' end
	if not f.text then
		f.text = f:CreateFontString(nil, 'OVERLAY')
		f.text:SetFont([[Interface\AddOns\ElvUI\media\fonts\Homespun.ttf]], 12, 'MONOCHROMEOUTLINE')
		f.text:SetText(text)
		f.text:SetJustifyH('CENTER')
		f.text:SetPoint('CENTER', f, 'CENTER')
	end
	
	if point then
		f:Point('TOPRIGHT', point, 'TOPRIGHT', 2, 2)
	end
end

function E.SkinSliderFrame(Frame, Height, MoveText)
	Frame:SetTemplate('Default')

	if not Height then
		Height = Frame:GetHeight()
	end
	
	if MoveText then
		if(_G[frame:GetName() .. 'Low']) then _G[Frame:GetName() .. 'Low']:Point('BOTTOM', 0, -18) end
		if(_G[frame:GetName() .. 'High']) then _G[Frame:GetName() .. 'High']:Point('BOTTOM', 0, -18) end
		if(_G[frame:GetName() .. 'Text']) then _G[Frame:GetName() .. 'Text']:Point('TOP', 0, 19) end
	end
	
	_G[Frame:GetName()]:SetThumbTexture(C['media']['blank'])
	_G[Frame:GetName()]:GetThumbTexture():SetVertexColor(unpack(ButtonColor))
	
	if Frame:GetWidth() < Frame:GetHeight() then
		Frame:Width(Height)
		_G[frame:GetName()]:GetThumbTexture():Size(Frame:GetWidth(), Frame:GetWidth() + 4)
	else
		Frame:Height(Height)
		_G[Frame:GetName()]:GetThumbTexture():Size(Height + 4, Height)
	end
end

local function colourExpandOrCollapse(f)
	if f:IsEnabled() then
		f.plus:SetVertexColor(1, 1, 1)
		f.minus:SetVertexColor(1, 1, 1)
	end
end

local function clearExpandOrCollapse(f)
	f.plus:SetVertexColor(1, 1, 1)
	f.minus:SetVertexColor(1, 1, 1)
end

E.SkincolourExpandOrCollapse = colourExpandOrCollapse
E.SkinclearExpandOrCollapse = clearExpandOrCollapse

function E.SkinExpandOrCollapse(f)
	f:SetSize(13, 13)

	E.SkinButton(f, true)
	f.SetNormalTexture = E.dummy

	f.minus = f:CreateTexture(nil, 'OVERLAY')
	f.minus:SetSize(7, 1)
	f.minus:SetPoint('CENTER')
	f.minus:SetTexture(C['media'].glossTex)
	f.minus:SetVertexColor(1, 1, 1)

	f.plus = f:CreateTexture(nil, 'OVERLAY')
	f.plus:SetSize(1, 7)
	f.plus:SetPoint('CENTER')
	f.plus:SetTexture(C['media'].glossTex)
	f.plus:SetVertexColor(1, 1, 1)

	f:HookScript('OnEnter', colourExpandOrCollapse)
	f:HookScript('OnLeave', clearExpandOrCollapse)
end

local ElvuiSkin = CreateFrame('Frame')
ElvuiSkin:RegisterEvent('ADDON_LOADED')
ElvuiSkin:SetScript('OnEvent', function(self, event, addon)
	if IsAddOnLoaded('Skinner') or IsAddOnLoaded('Aurora') then return end
	for _addon, skinfunc in pairs(E.SkinFuncs) do
		if type(skinfunc) == 'function' then
			if _addon == addon then
				if skinfunc then
					skinfunc()
				end
			end
		elseif type(skinfunc) == 'table' then
			if _addon == addon then
				for _, skinfunc in pairs(E.SkinFuncs[_addon]) do
					if skinfunc then
						skinfunc()
					end
				end
			end
		end
	end
end)