local E, C, L, DB = unpack(select(2, ...))
if C['skin'].enable ~= true or C['skin']['TradeSkillUI'] ~= true then return end

local function LoadSkin()
	local AllTradeSkillUIStripTextures = {'TradeSkillFrame', 'TradeSkillListScrollFrame', 'TradeSkillDetailScrollFrame', 'TradeSkillExpandButtonFrame', 'TradeSkillDetailScrollChildFrame'}
	for i = 1, #AllTradeSkillUIStripTextures do
		_G[AllTradeSkillUIStripTextures[i]]:StripTextures(true)
	end

	local AllTradeSkillUIDropDowns = {'TradeSkillSubClassDropDown', 'TradeSkillInvSlotDropDown'}
	for i = 1, #AllTradeSkillUIDropDowns do
		E.SkinDropDownBox(_G[AllTradeSkillUIDropDowns[i]])
	end

	local AllTradeSkillUIScrollbars = {'TradeSkillListScrollFrameScrollBar', 'TradeSkillDetailScrollFrameScrollBar'}
	for i = 1, #AllTradeSkillUIScrollbars do
		E.SkinScrollBar(_G[AllTradeSkillUIScrollbars[i]])
	end

	local AllTradeSkillUIInputs = {'TradeSkillFrameEditBox', 'TradeSkillInputBox'}
	for i = 1, #AllTradeSkillUIInputs do
		E.SkinEditBox(_G[AllTradeSkillUIInputs[i]])
	end

	local AllTradeSkillUICheckBoxes = {'TradeSkillFrameAvailableFilterCheckButton'}
	for i = 1, #AllTradeSkillUICheckBoxes do
		E.SkinCheckBox(_G[AllTradeSkillUICheckBoxes[i]])
	end

	local AllTradeSkillUIButtons = {'TradeSkillCreateAllButton', 'TradeSkillCreateButton', 'TradeSkillCancelButton'}
	for i = 1, #AllTradeSkillUIButtons do
		E.SkinButton(_G[AllTradeSkillUIButtons[i]])
	end
	
	local once = false
	hooksecurefunc('TradeSkillFrame_SetSelection', function(id)
		TradeSkillSkillIcon:StyleButton()
		if TradeSkillSkillIcon:GetNormalTexture() then
			TradeSkillSkillIcon:GetNormalTexture():SetTexCoord(unpack(E.TexCoords))
			TradeSkillSkillIcon:GetNormalTexture():SetInside()
		end
		TradeSkillSkillIcon:SetTemplate('Default')

		for i=1, MAX_TRADE_SKILL_REAGENTS do
			local button = _G['TradeSkillReagent'..i]
			local icon = _G['TradeSkillReagent'..i..'IconTexture']
			local count = _G['TradeSkillReagent'..i..'Count']
			
			icon:SetTexCoord(unpack(E.TexCoords))
			icon:SetDrawLayer('OVERLAY')
			if not icon.backdrop then
				icon.backdrop = CreateFrame('Frame', nil, button)
				icon.backdrop:SetFrameLevel(button:GetFrameLevel() - 1)
				icon.backdrop:SetTemplate('Default')
				icon.backdrop:SetOutside(icon)
			end
			
			icon:SetParent(icon.backdrop)
			count:SetParent(icon.backdrop)
			count:SetDrawLayer('OVERLAY')
			
			if i > 2 and once == false then
				local point, anchoredto, point2, x, y = button:GetPoint()
				button:ClearAllPoints()
				button:Point(point, anchoredto, point2, x, y - 3)
				once = true
			end
			
			_G['TradeSkillReagent'..i..'NameFrame']:Kill()
		end
	end)
	
	TradeSkillFrame:CreateBackdrop('Transparent')
	TradeSkillFrame.backdrop:Point('TOPLEFT', 10, -12)
	TradeSkillFrame.backdrop:Point('BOTTOMRIGHT', -31, 74)
	E.SkinCloseButton(TradeSkillFrameCloseButton)
	
	TradeSkillRankFrame:StripTextures(true)
	TradeSkillRankFrame:CreateBackdrop('Default')
	TradeSkillRankFrame:SetStatusBarTexture(C['media']['normTex'])
	
	E.SkinNextPrevButton(TradeSkillDecrementButton)
	E.SkinNextPrevButton(TradeSkillIncrementButton)
end

E.SkinFuncs['Blizzard_TradeSkillUI'] = LoadSkin