local E, C, L, DB = unpack(select(2, ...))
if C['skin']['enable'] ~= true or C['skin']['SpellBook'] ~= true then return end

local function LoadSkin()
	--  
	local SpellBookStrip = { 'SpellBookFrame' }
	for _, object in pairs(SpellBookStrip) do
		_G[object]:StripTextures()
	end
	-- 
	for i=1, MAX_SKILLLINE_TABS do
		local tab = _G["SpellBookSkillLineTab"..i]
		_G["SpellBookSkillLineTab"..i.."Flash"]:Kill()
		if tab then
			tab:StripTextures()
			tab:GetNormalTexture():SetTexCoord(unpack(E.TexCoords))
			tab:GetNormalTexture():ClearAllPoints()
			tab:GetNormalTexture():SetInside()
			
			tab:CreateBackdrop("Default")
			tab.backdrop:SetAllPoints()
			tab:StyleButton(true)
		end
	end
	
	for i=1, 3 do
		_G["SpellBookFrameTabButton"..i]:StripTextures()
		E.SkinTab(_G["SpellBookFrameTabButton"..i])
		_G["SpellBookFrameTabButton"..i]:Height(33)
	end
	-- 
	local function SpellButtons(self, first)
		for i=1, SPELLS_PER_PAGE do
			local button = _G["SpellButton"..i]
			local icon = _G["SpellButton"..i.."IconTexture"]
			
			if first then
				for i=1, button:GetNumRegions() do
					local region = select(i, button:GetRegions())
					if region:GetObjectType() == "Texture" then
						if region:GetTexture() ~= "Interface\\Buttons\\ActionBarFlyoutButton" then
							region:SetTexture(nil)
						end
					end
				end
			end
			
			if _G["SpellButton"..i.."Highlight"] then
				_G["SpellButton"..i.."Highlight"]:SetTexture(1, 1, 1, 0.3)
				_G["SpellButton"..i.."Highlight"]:ClearAllPoints()
				_G["SpellButton"..i.."Highlight"]:SetAllPoints(icon)
			end

			if icon then
				icon:SetTexCoord(unpack(E.TexCoords))
				icon:ClearAllPoints()
				icon:SetAllPoints()

				if not button.backdrop then
					button:CreateBackdrop("Default", true)	
				end
			end	
			
			local r, g, b = _G["SpellButton"..i.."SpellName"]:GetTextColor()

			if r < 0.8 then
				_G["SpellButton"..i.."SpellName"]:SetTextColor(0.6, 0.6, 0.6)
			end
			_G["SpellButton"..i.."SubSpellName"]:SetTextColor(0.6, 0.6, 0.6)
		end
	end
	SpellButtons(nil, true)
	hooksecurefunc("SpellButton_UpdateButton", SpellButtons)
	
	SpellBookPageText:SetTextColor(0.6, 0.6, 0.6)
	
	SpellBookFrame:CreateBackdrop("Transparent")
	SpellBookFrame.backdrop:Point("TOPLEFT", 10, -12)
	SpellBookFrame.backdrop:Point("BOTTOMRIGHT", -33, 76)
	
	E.SkinCloseButton(SpellBookCloseButton)
	E.SkinCheckBox(ShowAllSpellRanksCheckBox)
	E.SkinNextPrevButton(SpellBookPrevPageButton)
	E.SkinNextPrevButton(SpellBookNextPageButton)
end

tinsert(E.SkinFuncs["ElvUI"], LoadSkin)