local E, C, L, DB = unpack(select(2, ...))
if C['skin']['enable'] ~= true or C['skin']['Quest'] ~= true then return end

local function LoadSkin()
	--  
	local QuestStrip = { 'QuestFrame', 'QuestLogFrame', 'QuestLogCount', 'EmptyQuestLogFrame', 'QuestFrameDetailPanel', 'QuestDetailScrollFrame', 'QuestDetailScrollChildFrame', 'QuestRewardScrollFrame', 'QuestRewardScrollChildFrame', 'QuestFrameProgressPanel', 'QuestFrameRewardPanel' }
	for _, object in pairs(QuestStrip) do
		_G[object]:StripTextures(true)
	end
	-- 
	local QuestButtons = { 'QuestLogFrameAbandonButton', 'QuestLogFramePushQuestButton', 'QuestLogFrameTrackButton', 'QuestLogFrameCancelButton' }
	for i = 1, #QuestButtons do
		_G[QuestButtons[i]]:StripTextures()
		E.SkinButton(_G[QuestButtons[i]])
	end
	
	E.SkinButton(QuestFrameAcceptButton, true)
	E.SkinButton(QuestFrameDeclineButton, true)
	E.SkinButton(QuestFrameCompleteButton, true)
	E.SkinButton(QuestFrameGoodbyeButton, true)
	E.SkinButton(QuestFrameCompleteQuestButton, true)
	E.SkinButton(QuestFrameCancelButton, true)
	
	QuestLogFrameShowMapButton:StripTextures()
	E.SkinButton(QuestLogFrameShowMapButton)
	QuestLogFrameShowMapButton.text:ClearAllPoints()
	QuestLogFrameShowMapButton.text:SetPoint('CENTER')
	QuestLogFrameShowMapButton:Size(QuestLogFrameShowMapButton:GetWidth() - 30, QuestLogFrameShowMapButton:GetHeight(), - 40)
	
	QuestLogFramePushQuestButton:Point('LEFT', QuestLogFrameAbandonButton, 'RIGHT', 2, 0)
	QuestLogFramePushQuestButton:Point('RIGHT', QuestLogFrameTrackButton, 'LEFT', -2, 0)

	for i=1, MAX_NUM_ITEMS do
		_G['QuestInfoItem'..i]:StripTextures()
		_G['QuestInfoItem'..i]:StyleButton()
		_G['QuestInfoItem'..i]:Width(_G['QuestInfoItem'..i]:GetWidth() - 4)
		_G['QuestInfoItem'..i]:SetFrameLevel(_G['QuestInfoItem'..i]:GetFrameLevel() + 2)
		_G['QuestInfoItem'..i..'IconTexture']:SetTexCoord(unpack(E.TexCoords))
		_G['QuestInfoItem'..i..'IconTexture']:SetDrawLayer('OVERLAY')
		_G['QuestInfoItem'..i..'IconTexture']:Point('TOPLEFT', 2, -2)
		_G['QuestInfoItem'..i..'IconTexture']:Size(_G['QuestInfoItem'..i..'IconTexture']:GetWidth() - 2, _G['QuestInfoItem'..i..'IconTexture']:GetHeight() - 2)
		_G['QuestInfoItem'..i]:SetTemplate('Default')
		_G['QuestInfoItem'..i..'Count']:SetDrawLayer('OVERLAY')
	end
	
	QuestInfoItemHighlight:StripTextures()
	QuestInfoItemHighlight:SetTemplate('Default')
	QuestInfoItemHighlight:SetBackdropBorderColor(1, 1, 0)
	QuestInfoItemHighlight:SetBackdropColor(0, 0, 0, 0)
	QuestInfoItemHighlight:Size(142, 40)
	
	hooksecurefunc('QuestInfoItem_OnClick', function(self)
		QuestInfoItemHighlight:ClearAllPoints()
		QuestInfoItemHighlight:SetAllPoints(self)
	end)
	
	local function QuestObjectiveText()
		local numObjectives = GetNumQuestLeaderBoards()
		local objective
		local type, finished
		local numVisibleObjectives = 0
		for i = 1, numObjectives do
			_, type, finished = GetQuestLogLeaderBoard(i)
			if (type ~= 'spell') then
				numVisibleObjectives = numVisibleObjectives+1
				objective = _G['QuestInfoObjective'..numVisibleObjectives]
				if ( finished ) then
					objective:SetTextColor(1, 1, 0)
				else
					objective:SetTextColor(0.6, 0.6, 0.6)
				end
			end
		end			
	end
	
	hooksecurefunc('QuestInfo_Display', function(template, parentFrame, acceptButton, material)								
		local textColor = {1, 1, 1}
		local titleTextColor = {1, 1, 0}
		
		QuestInfoTitleHeader:SetTextColor(unpack(titleTextColor))
		QuestInfoDescriptionHeader:SetTextColor(unpack(titleTextColor))
		QuestInfoObjectivesHeader:SetTextColor(unpack(titleTextColor))
		QuestInfoRewardsHeader:SetTextColor(unpack(titleTextColor))
		QuestInfoDescriptionText:SetTextColor(unpack(textColor))
		QuestInfoObjectivesText:SetTextColor(unpack(textColor))
		QuestInfoGroupSize:SetTextColor(unpack(textColor))
		QuestInfoRewardText:SetTextColor(unpack(textColor))
		QuestInfoItemChooseText:SetTextColor(unpack(textColor))
		QuestInfoItemReceiveText:SetTextColor(unpack(textColor))
		QuestInfoSpellLearnText:SetTextColor(unpack(textColor))
		QuestInfoHonorFrameReceiveText:SetTextColor(unpack(textColor))
		QuestInfoArenaPointsFrameReceiveText:SetTextColor(unpack(textColor))
		QuestInfoTalentFrameReceiveText:SetTextColor(unpack(textColor))
		QuestInfoXPFrameReceiveText:SetTextColor(unpack(textColor))
		QuestInfoReputationText:SetTextColor(unpack(textColor))

		QuestInfoTimerText:SetTextColor(unpack(textColor))
		QuestInfoAnchor:SetTextColor(unpack(textColor))
		QuestObjectiveText()
	end)
	
	hooksecurefunc('QuestInfo_ShowRequiredMoney', function()
		local requiredMoney = GetQuestLogRequiredMoney()
		if ( requiredMoney > 0 ) then
			if ( requiredMoney > GetMoney() ) then
				QuestInfoRequiredMoneyText:SetTextColor(0.6, 0.6, 0.6)
			else
				QuestInfoRequiredMoneyText:SetTextColor(1, 1, 0)
			end
		end			
	end)	
	
	QuestLogDetailScrollFrame:StripTextures()
	QuestLogFrame:HookScript('OnShow', function()
		QuestLogScrollFrame:Height(331)
		QuestLogDetailScrollFrame:Height(328)
		
		if not QuestLogDetailScrollFrame.backdrop then
			QuestLogScrollFrame:SetTemplate('Default')
			QuestLogDetailScrollFrame:CreateBackdrop('Default')
		end
	end)
	
	QuestFrame:CreateBackdrop('Transparent')
	QuestFrame.backdrop:Point('TOPLEFT', QuestFrame, 'TOPLEFT', 10, -12)
	QuestFrame.backdrop:Point('BOTTOMRIGHT', QuestFrame, 'BOTTOMRIGHT', -31, 67)

	QuestLogDetailFrame:StripTextures()
	QuestLogDetailFrame:CreateBackdrop('Transparent')
	QuestLogDetailFrame.backdrop:Point('TOPLEFT', QuestLogDetailFrame, 'TOPLEFT', 10, -12)
	QuestLogDetailFrame.backdrop:Point('BOTTOMRIGHT', QuestLogDetailFrame, 'BOTTOMRIGHT', 0, 4)
	
	QuestLogFrame:CreateBackdrop('Transparent')
	QuestLogFrame.backdrop:Point('TOPLEFT', QuestLogFrame, 'TOPLEFT', 10, -12)
	QuestLogFrame.backdrop:Point('BOTTOMRIGHT', QuestLogFrame, 'BOTTOMRIGHT', -1, 8)
	
	E.SkinCloseButton(QuestFrameCloseButton, QuestFrame.backdrop)
	E.SkinCloseButton(QuestLogDetailFrameCloseButton)
	E.SkinCloseButton(QuestLogFrameCloseButton)
	
	E.SkinScrollBar(QuestLogDetailScrollFrameScrollBar)
	E.SkinScrollBar(QuestDetailScrollFrameScrollBar)
	E.SkinScrollBar(QuestLogScrollFrameScrollBar, 5)
	E.SkinScrollBar(QuestProgressScrollFrameScrollBar)
	E.SkinScrollBar(QuestRewardScrollFrameScrollBar)
	
	for i=1, 6 do
		local button = _G['QuestProgressItem'..i]
		local texture = _G['QuestProgressItem'..i..'IconTexture']
		button:StripTextures()
		button:StyleButton()
		button:Width(_G['QuestProgressItem'..i]:GetWidth() - 4)
		button:SetFrameLevel(button:GetFrameLevel() + 2)
		texture:SetTexCoord(.08, .92, .08, .92)
		texture:SetDrawLayer('OVERLAY')
		texture:Point('TOPLEFT', 2, -2)
		texture:Size(texture:GetWidth() - 2, texture:GetHeight() - 2)
		_G['QuestProgressItem'..i..'Count']:SetDrawLayer('OVERLAY')
		button:SetTemplate('Default')				
	end
	
	hooksecurefunc('QuestFrameProgressItems_Update', function()
		QuestProgressTitleText:SetTextColor(1, 1, 0)
		QuestProgressText:SetTextColor(1, 1, 1)
		QuestProgressRequiredItemsText:SetTextColor(1, 1, 0)
		QuestProgressRequiredMoneyText:SetTextColor(1, 1, 0)
	end)
end

tinsert(E.SkinFuncs['ElvUI'], LoadSkin)