local E, C, L, DB = unpack(select(2, ...))
if C['skin'].enable ~= true or C['skin']['MacroUI'] ~= true then return end

local function LoadSkin()
	local AllMacroUIStripTextures = {'MacroFrame', 'MacroFrameTab1', 'MacroFrameTab2', 'MacroFrameSelectedMacroButton', 'MacroFrameTextBackground', 'MacroButtonScrollFrame', 'MacroPopupFrame', 'MacroPopupScrollFrame'}
	for i = 1, #AllMacroUIStripTextures do
		_G[AllMacroUIStripTextures[i]]:StripTextures()
	end
	
	MacroPopupNameLeft:SetTexture(nil)
	MacroPopupNameMiddle:SetTexture(nil)
	MacroPopupNameRight:SetTexture(nil)
	
	local AllMacroUIScrollbars = {'MacroFrameScrollFrameScrollBar', 'MacroButtonScrollFrameScrollBar', 'MacroPopupScrollFrameScrollBar'}
	for i = 1, #AllMacroUIScrollbars do
		E.SkinScrollBar(_G[AllMacroUIScrollbars[i]])
	end
	
	E.SkinEditBox(MacroPopupEditBox)
	
	local AllMacroUIButtons = {'MacroFrameTab1', 'MacroFrameTab2', 'MacroDeleteButton', 'MacroNewButton', 'MacroExitButton', 'MacroEditButton', 'MacroPopupOkayButton', 'MacroPopupCancelButton'}
	for i = 1, #AllMacroUIButtons do
		E.SkinButton(_G[AllMacroUIButtons[i]])
	end
	
	for i = 1, 2 do
		tab = _G[format("MacroFrameTab%s", i)]
		tab:Height(20)
	end
	
	MacroFrameTab1:Point("TOPLEFT", MacroFrame, "TOPLEFT", 85, -39)
	MacroFrameTab2:Point("LEFT", MacroFrameTab1, "RIGHT", 4, 0)
	
	MacroFrameSelectedMacroButton:StyleButton(true)
	MacroFrameSelectedMacroButton:GetNormalTexture():SetTexture(nil)
	MacroFrameSelectedMacroButton:SetTemplate('Default')
	MacroFrameSelectedMacroButtonIcon:SetTexCoord(unpack(E.TexCoords))
	MacroFrameSelectedMacroButtonIcon:SetInside()
	
	for i = 1, MAX_ACCOUNT_MACROS do
		local b = _G["MacroButton"..i]
		local t = _G["MacroButton"..i.."Icon"]
		local pb = _G["MacroPopupButton"..i]
		local pt = _G["MacroPopupButton"..i.."Icon"]
		
		if b then
			b:StripTextures()
			b:StyleButton(true)
			b:SetTemplate("Default", true)
		end
		
		if t then
			t:SetTexCoord(unpack(E.TexCoords))
			t:SetInside()
		end

		if pb then
			pb:StripTextures()
			pb:StyleButton(true)
			pb:SetTemplate("Default")					
		end
		
		if pt then
			pt:SetTexCoord(unpack(E.TexCoords))
			pt:SetInside()
		end
	end
	
	MacroFrameCharLimitText:ClearAllPoints()
	MacroFrameCharLimitText:Point("BOTTOM", MacroFrameTextBackground, -40, -30)
	
	MacroFrame:CreateBackdrop('Transparent')
	MacroFrame.backdrop:Point('TOPLEFT', 10, -11)
	MacroFrame.backdrop:Point('BOTTOMRIGHT', -32, 71)
	E.SkinCloseButton(MacroFrameCloseButton)
	MacroFrameTextBackground:SetTemplate('Default')
	MacroPopupFrame:CreateBackdrop('Transparent')
	MacroPopupFrame.backdrop:Point('TOPLEFT', 9, -9)
	MacroPopupFrame.backdrop:Point('BOTTOMRIGHT', -7, 9)
end

E.SkinFuncs['Blizzard_MacroUI'] = LoadSkin