local E, C, L, DB = unpack( select( 2, ... ) )

E.RBRWidth = ( ( E.MiniMapSize - 9 ) / 6 + (E.PixelMode and 3 or 4) )

local mmholder = CreateFrame('Frame', 'MMHolder', Minimap)
mmholder:Point("TOPRIGHT", E.UIParent, "TOPRIGHT", -3, -3 )
mmholder:Width( ( Minimap:GetWidth() + ( E.PixelMode and 23 or 26 ) ) + E.RBRWidth )
mmholder:Height( Minimap:GetHeight() + ( E.PixelMode and 23 or 26 ) )

Minimap:ClearAllPoints()
Minimap:Point("TOPLEFT", mmholder, "TOPLEFT", 2, - 2 )
Minimap:SetSize( E.MiniMapSize - 4, E.MiniMapSize - 4 )
Minimap:CreateBackdrop('Default')

E.CreateMover(MMHolder, 'MinimapMover', 'Minimap', nil, nil)

MinimapBorder:Hide()
MinimapBorderTop:Hide()
MinimapZoomIn:Hide()
MinimapZoomOut:Hide()
MiniMapVoiceChatFrame:Hide()
MinimapNorthTag:SetTexture( nil )
GameTimeFrame:Hide()
MinimapZoneTextButton:Hide()
MiniMapTracking:Hide()

MiniMapMailFrame:ClearAllPoints()
MiniMapMailFrame:SetPoint( 'TOPRIGHT', Minimap, 3, 4 )
MiniMapMailBorder:Hide()
MiniMapMailIcon:SetTexture( 'Interface\\AddOns\\ElvUI\\media\\textures\\mail' )

MiniMapBattlefieldFrame:ClearAllPoints()
MiniMapBattlefieldFrame:SetPoint( 'BOTTOMRIGHT', Minimap, 3, 0 )
MiniMapBattlefieldBorder:Hide()
MiniMapWorldMapButton:Hide()

MiniMapInstanceDifficulty:ClearAllPoints()
MiniMapInstanceDifficulty:SetParent( Minimap )
MiniMapInstanceDifficulty:SetPoint( 'TOPLEFT', Minimap, 'TOPLEFT', 0, 0 )

local function UpdateLFG()
	MiniMapLFGFrame:ClearAllPoints()
	MiniMapLFGFrame:SetPoint( 'BOTTOMRIGHT', Minimap, 'BOTTOMRIGHT', 2, 1 )
	MiniMapLFGFrameBorder:Hide()
end
hooksecurefunc( 'MiniMapLFG_UpdateIsShown', UpdateLFG )

Minimap:EnableMouseWheel( true )
Minimap:SetScript( 'OnMouseWheel', function( self, d )
	if d > 0 then
		_G.MinimapZoomIn:Click()
	elseif d < 0 then
		_G.MinimapZoomOut:Click()
	end
end)

Minimap:RegisterEvent( 'ADDON_LOADED' )
Minimap:SetScript( 'OnEvent', function( self, event, addon )
	if addon == 'Blizzard_TimeManager' then
		TimeManagerClockButton:Kill()
	elseif addon == 'Blizzard_FeedbackUI' then
		FeedbackUIButton:Kill()
	end
end)

if FeedbackUIButton then
	FeedbackUIButton:Kill()
end

local calendar_string = string.gsub( SLASH_CALENDAR1, '/', '' )
calendar_string = string.gsub( calendar_string, '^%l', string.upper )

local menuFrame = CreateFrame( 'Frame', 'MinimapRightClickMenu', E.UIParent, 'UIDropDownMenuTemplate' )
local menuList = {
    {text = CHARACTER_BUTTON,
    func = function() ToggleCharacter( 'PaperDollFrame') end},
    {text = SPELLBOOK_ABILITIES_BUTTON,
    func = function() ToggleFrame( SpellBookFrame ) end},
    {text = TALENTS_BUTTON,
    func = function() ToggleTalentFrame() end},
    {text = ACHIEVEMENT_BUTTON,
    func = function() ToggleAchievementFrame() end},
    {text = QUESTLOG_BUTTON,
    func = function() ToggleFrame( QuestLogFrame ) end},
    {text = SOCIAL_BUTTON,
    func = function() ToggleFriendsFrame( 1 ) end},
    {text = PLAYER_V_PLAYER,
    func = function() ToggleFrame( PVPParentFrame ) end},
    {text = LFG_TITLE,
    func = function() ToggleFrame( LFDParentFrame ) end},
    {text = L_LFRAID,
    func = function() ToggleFrame( LFRParentFrame ) end},
    {text = HELP_BUTTON,
    func = function() ToggleHelpFrame() end},
    {text = L_CALENDAR,
    func = function()
    if( not CalendarFrame ) then LoadAddOn( 'Blizzard_Calendar' ) end
        Calendar_Toggle()
    end},
}

Minimap:SetScript( 'OnMouseUp', function( self, btn )
	local position = Minimap:GetPoint()
	if btn == 'RightButton' then
		local xoff = 0
		
		if position:match( 'RIGHT' ) then xoff = -16 end
		ToggleDropDownMenu( 1, nil, MiniMapTrackingDropDown, Minimap, xoff, -1 )
	elseif ( btn == 'MiddleButton' or  btn == 'LeftButton' and IsShiftKeyDown() ) and C['actionbar']['enable'] == true and C['actionbar']['microbar'] ~= true then
		if position:match( 'LEFT' ) then
			EasyMenu( menuList, menuFrame, 'cursor', 0, 0, 'MENU', 2 )
		else
			EasyMenu( menuList, menuFrame, 'cursor', -160, 0, 'MENU', 2 )
		end
	else
		Minimap_OnClick( self )
	end
end)

Minimap:SetMaskTexture( 'Interface\\ChatFrame\\ChatFrameBackground' )

function GetMinimapShape() return 'SQUARE' end

local function GetLocTextColor()
	local pvpType = GetZonePVPInfo()
	if pvpType == "arena" then
		return 0.84, 0.03, 0.03
	elseif pvpType == "friendly" then
		return 0.05, 0.85, 0.03
	elseif pvpType == "contested" then
		return 0.9, 0.85, 0.05
	elseif pvpType == "hostile" then 
		return 0.84, 0.03, 0.03
	elseif pvpType == "sanctuary" then
		return 0.035, 0.58, 0.84
	elseif pvpType == "combat" then
		return 0.84, 0.03, 0.03
	else
		return 0.84, 0.03, 0.03
	end	
end

local m_zone = CreateFrame( 'Frame', nil, E.UIParent )
m_zone:Height( 20 )
m_zone:SetFrameLevel( 5 )
m_zone:SetFrameStrata( 'LOW' )
m_zone:Point( 'TOPLEFT', Minimap, 'TOPLEFT', 2, -2 )
m_zone:Point( 'TOPRIGHT', Minimap, -2, -2 )

local m_zone_text = m_zone:CreateFontString( nil, 'Overlay' )
m_zone_text:SetFont( C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'] )
m_zone_text:SetPoint( 'Center',0,0 )
m_zone_text:SetJustifyH( 'CENTER' )
m_zone_text:SetJustifyV( 'MIDDLE' )
m_zone_text:SetHeight( 12 )

local m_coord = CreateFrame( 'Frame', nil, E.UIParent )
m_coord:Width( 40 )
m_coord:Height( 20 )
m_coord:Point( 'BOTTOMLEFT', Minimap, 'BOTTOMLEFT', 2, 2 )
m_coord:SetFrameStrata( 'LOW' )

local m_coord_text = m_coord:CreateFontString(nil,"Overlay")
m_coord_text:SetFont( C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'] )
m_coord_text:SetPoint( 'Center', -1, 0 )
m_coord_text:SetJustifyH( 'CENTER' )
m_coord_text:SetJustifyV( 'MIDDLE' )

local ela = 0
local coord_Update = function(self,t)
	local inInstance, _ = IsInInstance()
	ela = ela - t
	if ela > 0 then return end
	local x,y = GetPlayerMapPosition( 'player' )
	local xt,yt
	x = math.floor(100 * x)
	y = math.floor(100 * y)
	if x ==0 and y==0 then
		m_coord_text:SetText( ' ' )	
	else
		if x < 10 then
			xt = '0'..x
		else
			xt = x
		end
		if y < 10 then
			yt = '0'..y
		else
			yt = y
		end
		m_coord_text:SetText( xt..E.ValColor..',|r'..yt )
	end
	ela = .2
end
 
m_coord:SetScript( 'OnUpdate',coord_Update )
 
local zone_Update = function()
	local pvpType = GetZonePVPInfo()
	m_zone_text:SetText( strsub( GetMinimapZoneText(), 1, 23 ) )
	m_zone_text:SetTextColor( GetLocTextColor() )
end
 
m_zone:RegisterEvent( 'PLAYER_ENTERING_WORLD' )
m_zone:RegisterEvent( 'ZONE_CHANGED_NEW_AREA' )
m_zone:RegisterEvent( 'ZONE_CHANGED' )
m_zone:RegisterEvent( 'ZONE_CHANGED_INDOORS' )
m_zone:SetScript( 'OnEvent',zone_Update ) 
 
local a,k = CreateFrame( 'Frame' ),4
a:SetScript("OnUpdate",function( self,t )
	k = k - t
	if k > 0 then return end
	self:Hide()
	zone_Update()
end )