﻿local E, C, L, DB = unpack(select(2, ...))

E.buttonsize = C['actionbar'].buttonsize
E.buttonspacing = C['actionbar'].buttonspacing
E.petbuttonsize = C['actionbar'].petbuttonsize
E.buttonspacing = C['actionbar'].buttonspacing

E.MiniMapSize = 165

-- VEHICLE BAR
if C["actionbar"].enable == true then
	local vbarbg = CreateFrame("Frame", "ElvuiVehicleBarBackground", E.UIParent)
	vbarbg:SetWidth((C["actionbar"].vehiclebarsize * 12) + (C["actionbar"].vehiclebarspacing * 12))
	vbarbg:SetHeight(C["actionbar"].vehiclebarsize + (C["actionbar"].vehiclebarspacing * 2))
	vbarbg:Point("BOTTOM", E.UIParent, "BOTTOM", 0, 2)
	vbarbg:SetFrameLevel(4)
end

local PANEL_HEIGHT = 22;
local SIDE_BUTTON_WIDTH = 16;

if C['general'].lowerpanel == true then
	BottomPanel = CreateFrame('Frame', 'ElvUI_BottomPanel', E.UIParent)
	BottomPanel:SetTemplate('Transparent')
	BottomPanel:Point('BOTTOMLEFT', E.UIParent, 'BOTTOMLEFT', -1, -1)
	BottomPanel:Point('BOTTOMRIGHT', E.UIParent, 'BOTTOMRIGHT', 1, -1)
	BottomPanel:Height(PANEL_HEIGHT)
	BottomPanel:SetFrameLevel(0)
	BottomPanel:SetFrameStrata('BACKGROUND')
end
if C['general'].upperpanel == true then
	TopPanel = CreateFrame('Frame', 'ElvUI_TopPanel', E.UIParent)
	TopPanel:SetTemplate('Transparent')
	TopPanel:Point('TOPLEFT', E.UIParent, 'TOPLEFT', -1, 1)
	TopPanel:Point('TOPRIGHT', E.UIParent, 'TOPRIGHT', 1, 1)
	TopPanel:Height(PANEL_HEIGHT)
	TopPanel:SetFrameLevel(0)
	TopPanel:SetFrameStrata('BACKGROUND')
end
local function ChatPanelLeft_OnFade(self)
	LeftChatPanel:Hide()
end

local function ChatPanelRight_OnFade(self)
	RightChatPanel:Hide()
end

local function ChatButton_OnEnter(self, ...)
	if E[self.parent:GetName()..'Faded'] then
		self.parent:Show()
		UIFrameFadeIn(self.parent, 0.2, self.parent:GetAlpha(), 1)
		UIFrameFadeIn(self, 0.2, self:GetAlpha(), 1)
	end

	if self == LeftChatToggleButton then
		GameTooltip:SetOwner(self, 'ANCHOR_TOPLEFT', 0, 4)
		GameTooltip:ClearLines()
		GameTooltip:AddDoubleLine(L.chat_left_click, L.chat_hide_chat, 1, 1, 1)
	else
		GameTooltip:SetOwner(self, 'ANCHOR_TOPRIGHT', 0, 4)
		GameTooltip:ClearLines()
		GameTooltip:AddDoubleLine(L.chat_left_click, L.chat_hide_chat, 1, 1, 1)
		GameTooltip:AddDoubleLine(L.chat_right_click, L.chat_hide_addons, 1, 1, 1)
	end
	GameTooltip:Show()
end

local function ChatButton_OnLeave(self, ...)
	if E[self.parent:GetName()..'Faded'] then
		UIFrameFadeOut(self.parent, 0.2, self.parent:GetAlpha(), 0)
		UIFrameFadeOut(self, 0.2, self:GetAlpha(), 0)
		self.parent.fadeInfo.finishedFunc = self.parent.fadeFunc
	end
	GameTooltip:Hide()
end

local function ChatButton_OnClick(self, btn)
	GameTooltip:Hide()
	if btn == 'RightButton' then
		if IsAddOnLoaded('Recount') and C['skin'].embedright == 'Recount' then
			ToggleFrame(Recount_MainWindow)
		elseif IsAddOnLoaded('Omen') and C['skin'].embedright == 'Omen' then
			ToggleFrame(OmenAnchor)
		end
	else
		if E[self.parent:GetName()..'Faded'] then
			E[self.parent:GetName()..'Faded'] = nil
			UIFrameFadeIn(self.parent, 0.2, self.parent:GetAlpha(), 1)
			UIFrameFadeIn(self, 0.2, self:GetAlpha(), 1)
		else
			E[self.parent:GetName()..'Faded'] = true
			UIFrameFadeOut(self.parent, 0.2, self.parent:GetAlpha(), 0)
			UIFrameFadeOut(self, 0.2, self:GetAlpha(), 0)
			self.parent.fadeInfo.finishedFunc = self.parent.fadeFunc
		end
	end
end

function HideLeftChat()
	ChatButton_OnClick(LeftChatToggleButton)
end

function HideRightChat()
	ChatButton_OnClick(RightChatToggleButton)
end

function HideBothChat()
	ChatButton_OnClick(LeftChatToggleButton)
	ChatButton_OnClick(RightChatToggleButton)
end
local SPACING = (E.PixelMode and 3 or 5)
--Left Chat
local lchat = CreateFrame('Frame', 'LeftChatPanel', E.UIParent)
lchat:SetFrameStrata('BACKGROUND')
lchat:Size(E.SavePath['chat'].chatwidth, C['chat'].chatheight)	
lchat:Point('BOTTOMLEFT', E.UIParent, 4, 4)
lchat:SetFrameLevel(lchat:GetFrameLevel() + 2)
lchat:CreateBackdrop('Transparent')
lchat.backdrop:SetAllPoints()
E.CreateMover(LeftChatPanel, 'LeftChatMover', 'Left Chat')
--Background Texture
lchat.tex = lchat:CreateTexture(nil, 'OVERLAY')
lchat.tex:SetInside()
lchat.tex:SetTexture(C['chat'].panelBackdropNameLeft)
--Left Chat Tab
local lchattab = CreateFrame('Frame', 'LeftChatTab', LeftChatPanel)
lchattab:Point('TOPLEFT', lchat, 'TOPLEFT', SPACING, -SPACING)
lchattab:Point('BOTTOMRIGHT', lchat, 'TOPRIGHT', -SPACING, -(SPACING + PANEL_HEIGHT))
lchattab:SetTemplate('Default', true)
--Left Chat Data Panel
local lchatdp = CreateFrame('Frame', 'LeftChatDataPanel', LeftChatPanel)
lchatdp:Point('BOTTOMLEFT', lchat, 'BOTTOMLEFT', SPACING + SIDE_BUTTON_WIDTH, SPACING)
lchatdp:Point('TOPRIGHT', lchat, 'BOTTOMRIGHT', -SPACING, (SPACING + PANEL_HEIGHT))
lchatdp:SetTemplate('Default', true)
--Left Chat Toggle Button
local lchattb = CreateFrame('Button', 'LeftChatToggleButton', E.UIParent)
lchattb.parent = LeftChatPanel
LeftChatPanel.fadeFunc = ChatPanelLeft_OnFade
lchattb:Point('TOPRIGHT', lchatdp, 'TOPLEFT', -1, 0)
lchattb:Point('BOTTOMLEFT', lchat, 'BOTTOMLEFT', SPACING, SPACING)
lchattb:SetTemplate('Default', true)
lchattb:SetScript('OnEnter', ChatButton_OnEnter)
lchattb:SetScript('OnLeave', ChatButton_OnLeave)
lchattb:SetScript('OnClick', ChatButton_OnClick)
lchattb:FontString(nil, C['datatext'].font, C['datatext'].fontsize, C['datatext'].fontoutline)
lchattb.text:SetPoint('CENTER')
lchattb.text:SetJustifyH('CENTER')
lchattb.text:SetText('<')
--Right Chat
local rchat = CreateFrame('Frame', 'RightChatPanel', E.UIParent)
rchat:SetFrameStrata('BACKGROUND')
rchat:Size(C['chat'].chatwidth, C['chat'].chatheight)
rchat:Point('BOTTOMRIGHT', E.UIParent, -4, 4)
rchat:SetFrameLevel(lchat:GetFrameLevel() + 2)
rchat:CreateBackdrop('Transparent')
rchat.backdrop:SetAllPoints()
E.CreateMover(RightChatPanel, 'RightChatMover', 'Right Chat')
--Background Texture
rchat.tex = rchat:CreateTexture(nil, 'OVERLAY')
rchat.tex:SetInside()
rchat.tex:SetTexture(C['chat'].panelBackdropNameRight)
--Right Chat Tab
local rchattab = CreateFrame('Frame', 'RightChatTab', RightChatPanel)
rchattab:Point('TOPRIGHT', rchat, 'TOPRIGHT', -SPACING, -SPACING)
rchattab:Point('BOTTOMLEFT', rchat, 'TOPLEFT', SPACING, -(SPACING + PANEL_HEIGHT))
rchattab:SetTemplate('Default', true)
--Right Chat Data Panel
local rchatdp = CreateFrame('Frame', 'RightChatDataPanel', RightChatPanel)
rchatdp:Point('BOTTOMLEFT', rchat, 'BOTTOMLEFT', SPACING, SPACING)
rchatdp:Point('TOPRIGHT', rchat, 'BOTTOMRIGHT', -(SPACING + SIDE_BUTTON_WIDTH), SPACING + PANEL_HEIGHT)
rchatdp:SetTemplate('Default', true)
--Right Chat Toggle Button
local rchattb = CreateFrame('Button', 'RightChatToggleButton', E.UIParent)
rchattb.parent = RightChatPanel
RightChatPanel.fadeFunc = ChatPanelRight_OnFade
rchattb:Point('TOPLEFT', rchatdp, 'TOPRIGHT', 1, 0)
rchattb:Point('BOTTOMRIGHT', rchat, 'BOTTOMRIGHT', -SPACING, SPACING)
rchattb:SetTemplate('Default', true)
rchattb:RegisterForClicks('AnyUp')
rchattb:SetScript('OnEnter', ChatButton_OnEnter)
rchattb:SetScript('OnLeave', ChatButton_OnLeave)
rchattb:SetScript('OnClick', ChatButton_OnClick)
rchattb:FontString(nil, C['datatext'].font, C['datatext'].fontsize, C['datatext'].fontoutline)
rchattb.text:SetPoint('CENTER')
rchattb.text:SetJustifyH('CENTER')
rchattb.text:SetText('>')
--Load Settings
if E['LeftChatPanelFaded'] then
	LeftChatToggleButton:SetAlpha(0)
	LeftChatPanel:Hide()
end	

if E['RightChatPanelFaded'] then
	RightChatToggleButton:SetAlpha(0)
	RightChatPanel:Hide()
end

local lminipanel = CreateFrame('Frame', 'LeftMiniPanel', Minimap)
lminipanel:Point('TOPLEFT', Minimap, 'BOTTOMLEFT', -E.Border, (E.PixelMode and 0 or -3))
lminipanel:Point('BOTTOMRIGHT', Minimap, 'BOTTOM', -E.Spacing, -((E.PixelMode and 0 or 3) + PANEL_HEIGHT))
lminipanel:SetTemplate('Default', true)

local rminipanel = CreateFrame('Frame', 'RightMiniPanel', Minimap)
rminipanel:Point('TOPRIGHT', Minimap, 'BOTTOMRIGHT', E.Border, (E.PixelMode and 0 or -3))
rminipanel:Point('BOTTOMLEFT', lminipanel, 'BOTTOMRIGHT', (E.PixelMode and -1 or 1), 0)
rminipanel:SetTemplate('Default', true)
	
local configtoggle = CreateFrame('Button', 'ElvConfigToggle', Minimap)
configtoggle:RegisterForClicks('AnyUp')
configtoggle:Point('TOPLEFT', rminipanel, 'TOPRIGHT', (E.PixelMode and -1 or 1), 0)
configtoggle:Point('BOTTOMLEFT', rminipanel, 'BOTTOMRIGHT', (E.PixelMode and -1 or 1), 0)
configtoggle:Width( ( E.MiniMapSize - 9 ) / 6 + (E.PixelMode and 3 or 4) )
configtoggle:SetTemplate('Default', true)
configtoggle:FontString(nil, C['datatext'].font, C['datatext'].fontsize, C['datatext'].fontoutline)
configtoggle.text:SetText('C')
configtoggle.text:SetPoint('CENTER')
configtoggle.text:SetJustifyH('CENTER')
configtoggle:SetScript('OnClick', function(self, btn)
	if btn == 'LeftButton' then
		if not IsAddOnLoaded('ElvUI_Config') then return end
		local ElvuiConfig = LibStub('AceAddon-3.0'):GetAddon('ElvuiConfig')
		if not ElvuiConfig then return end
		ElvuiConfig:ShowConfig()
	else
		if InCombatLockdown() then return end
		
		E.ToggleMovers()
		E.ToggleElements()
		
		if ElvUF or oUF then
			E.MoveUF()
		end
	end
end)

configtoggle:SetScript('OnEnter', function(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT', 0, -4)
	GameTooltip:ClearLines()
	GameTooltip:AddDoubleLine(L.chat_left_click, L.layout_toggle_configuration, 1, 1, 1)
	GameTooltip:AddDoubleLine(L.chat_right_click, L.layout_toggle_movers, 1, 1, 1)
	GameTooltip:Show()
end)

configtoggle:SetScript('OnLeave', function(self)
	GameTooltip:Hide()
end)