--[[
	ClassTimers

	Configuration functions
	id - spell id
	castByAnyone - show if aura wasn't created by player, set true to show if its by anyone
	color - bar color (nil for default color)
	unitType - 0 all, 1 friendly, 2 enemy
	castSpellId - fill only if you want to see line on bar that indicates if its safe to start casting spell and not clip the last tick, also note that this can be different from aura id 

	Example: CreateSpellEntry( spellID , castByAnyone, color, unitType, castSpellId), 
]]--
local E, C, L, DB = unpack(select(2, ...)) -- Import Functions/Constants, Config, Locales

CreateSpellEntry = function( id, castByAnyone, color, unitType, castSpellId )
	return { enabled = true, id = id, castByAnyone = castByAnyone, color = color, unitType = unitType or 0, castSpellId = castSpellId };
end

--Config starts here, do not edit anything above this point!!

-- Trinket filter - mostly for trinket procs, delete or wrap into comment block --[[  ]] if you dont want to track those
TRINKET_FILTER = {
		CreateSpellEntry( 75477 ), -- Scaly Nimbleness  [Petrified Twilight Scale] 271
		CreateSpellEntry( 75480 ), -- Scaly Nimbleness  [Petrified Twilight Scale] 285
		CreateSpellEntry( 71432 ), -- Tiny Abom in a jar (Mote of Anger)
		CreateSpellEntry( 73422 ), --Chaos Bane
		CreateSpellEntry( 71905 ), --Soul Fragment
		CreateSpellEntry( 67671 ), -- Fury(Banner of Victory)
		CreateSpellEntry( 54758 ), -- Hyperspeed Acceleration (Hyperspeed Accelerators)
		CreateSpellEntry( 55637 ), -- Lightweave
		CreateSpellEntry( 71635 ), -- Aegis of Dalaran 264
		CreateSpellEntry( 71638 ), -- Aegis of Dalaran 272
		CreateSpellEntry( 71586 ), -- Hardened Skin	
		CreateSpellEntry( 71187 ), -- Libram of Three Truths
		CreateSpellEntry( 2825, true ), --Heroism
		CreateSpellEntry( 32182, true ), -- Bloodlust
		CreateSpellEntry( 26297 ), -- Berserking (troll racial)
		CreateSpellEntry( 33702 ), CreateSpellEntry( 33697 ), CreateSpellEntry( 20572 ), -- Blood Fury (orc racial)
		CreateSpellEntry( 57933, true ), -- Tricks of Trade (15% dmg buff)
};

--[[ Configuration functions - DO NOT TOUCH
	id - spell id
	castByAnyone - show if aura wasn't created by player, set true to show if its by anyone
	color - bar color (nil for default color)
	unitType - 0 all, 1 friendly, 2 enemy
	castSpellId - fill only if you want to see line on bar that indicates if its safe to start casting spell and not clip the last tick, also note that this can be different from aura id 

	Example: CreateSpellEntry( spellID , castByAnyone, color, unitType, castSpellId), 
]]--

CLASS_FILTERS = {
	DEATHKNIGHT = { 
		target = { 
			CreateSpellEntry( 55095 ), -- Frost Fever
			CreateSpellEntry( 55078 ), -- Blood Plague
		},
		player = { 
			CreateSpellEntry( 59052 ), -- Freezing Fog
			CreateSpellEntry( 51124 ), -- Killing Machine  
			CreateSpellEntry( 49016 ), -- Hysteria
			CreateSpellEntry( 49222 ), -- Bone Shield
			CreateSpellEntry( 57623 ), -- Horn of Winter
		},
		procs = {
			CreateSpellEntry( 53365 ), -- Unholy Strength	
			CreateSpellEntry( 71227 ), -- Sigil of the Hanged Man				
		}
	},
	DRUID = { 
		target = { 
			CreateSpellEntry( 53251 ), -- Wild Growth
			CreateSpellEntry( 48441 ), -- Rejuvenation
			CreateSpellEntry( 48443, false, nil, nil, 48443 ), -- Regrowth
			CreateSpellEntry( 48451 ), -- Lifebloom
			CreateSpellEntry( 48468 ), -- Insect Swarm
			CreateSpellEntry( 48463 ), -- Moonfire
			CreateSpellEntry( 53308 ), -- Entangling Roots
			CreateSpellEntry( 33786 ), -- Cyclone
			CreateSpellEntry( 18658 ), -- Hibernate
			CreateSpellEntry( 26995 ), -- Soothe Animal
			CreateSpellEntry( 50259 ), -- Feral Charge (Cat) - daze
			CreateSpellEntry( 45334 ), -- Feral Charge (Bear) - immobilize
			CreateSpellEntry( 58181 ), -- Infected Wounds
			CreateSpellEntry( 6795 ), -- Growl
			CreateSpellEntry( 5209 ), -- Challenging Roar
			CreateSpellEntry( 48560 ), -- Demoralizing Roar
			CreateSpellEntry( 48568 ), -- Lacerate
			CreateSpellEntry( 8983 ), -- Bash   
			CreateSpellEntry( 49802 ), -- Maim
			CreateSpellEntry( 48574 ), -- Rake
			CreateSpellEntry( 49800 ), -- Rip
			CreateSpellEntry( 48564, true ), -- Mangle (Bear)
			CreateSpellEntry( 48566, true ), -- Mangle (Cat)
			CreateSpellEntry( 49804 ), -- Pounce bleed
			CreateSpellEntry( 49803 ), -- Pounce stun
			CreateSpellEntry( 16857, true ), -- Faerie Fire (Feral)
			CreateSpellEntry( 770, true ), -- Farie Fire
			CreateSpellEntry( 73787, true, nil, 2 ), -- Necrotic Plague
			CreateSpellEntry( 73786, true, nil, 2 ), -- Necrotic Plague
			CreateSpellEntry( 73785, true, nil, 2 ), -- Necrotic Plague
			CreateSpellEntry( 70338, true, nil, 2 ), -- Necrotic Plague
		},
		player = { 
			CreateSpellEntry( 53201 ), -- Starfall
			CreateSpellEntry( 29166 ), -- Innervate
			CreateSpellEntry( 22812 ), -- Barkskin
			CreateSpellEntry( 5215 ), -- Prowl 
			CreateSpellEntry( 53312 ), -- Nature's Grasp
			CreateSpellEntry( 5229 ), -- Enrage
			CreateSpellEntry( 52610 ), -- Savage Roar
			CreateSpellEntry( 50213 ), -- Tiger's Fury
			CreateSpellEntry( 33357 ), -- Dash
			CreateSpellEntry( 22842 ), -- Frenzied Regeneration
			CreateSpellEntry( 50334 ), -- Berserk
			CreateSpellEntry( 61336 ), -- Survival Instincts
		},
		procs = {
			CreateSpellEntry( 16870 ), -- Clearcasting			
			CreateSpellEntry( 48518 ), -- Eclipse starfire
			CreateSpellEntry( 48517 ), -- Eclipse wrath
			CreateSpellEntry( 69369 ), -- Predator's Swiftness
			CreateSpellEntry( 71175 ), -- Idol of the Crying Moon
		}
	},
	HUNTER = { 
		target = {
			CreateSpellEntry( 49050 ), -- Aimed Shot
			CreateSpellEntry( 49001 ), -- Serpent Sting
			CreateSpellEntry( 52604 ), -- Scorpid Sting
			CreateSpellEntry( 67993 ), -- Viper Sting
			CreateSpellEntry( 53238 ), -- Piercing Shots
			CreateSpellEntry( 63672 ), -- Black Arrow
		},
		player = {
			CreateSpellEntry( 34074 ), -- Aspect of the Viper
		},
		procs = {
			CreateSpellEntry( 6150 ), -- Quick Shots
			CreateSpellEntry( 56453 ), -- Lock and Load
			CreateSpellEntry( 70728 ), -- Exploit Weakness (2pc t10)
			CreateSpellEntry( 71007 ), -- Stinger (4pc t10)
		},
	},
	MAGE = {
		target = { 
			CreateSpellEntry( 55360 ), -- Living Bomb
		},
		player = {
			CreateSpellEntry( 36032 ), -- Arcane Blast
			CreateSpellEntry( 43020 ), -- Mana Shield
			CreateSpellEntry( 43039 ), -- Ice Barrier
			CreateSpellEntry( 43012 ), -- Frost Ward
			CreateSpellEntry( 43010 ), -- Fire Ward
			CreateSpellEntry( 12472 ), -- Icy Veins
			CreateSpellEntry( 12042 ), -- Arcane Power
			CreateSpellEntry( 48108 ), -- Hot Streak
		},
		procs = {
			CreateSpellEntry( 44544 ), -- Fingers of Frost	
			CreateSpellEntry( 44401 ), -- Missile Barrage Proc		
		},
	},
	PALADIN = { 
		target = {
			CreateSpellEntry( 31803 ), -- Holy Vengeance (Aliance)
			CreateSpellEntry( 53742 ), -- Blood Corruption (Horde)
			--CreateSpellEntry( 61840 ), -- Righteous Vengeance
			CreateSpellEntry( 20066 ), -- Repentance
			CreateSpellEntry( 53563 ), -- Beacon of Light
			CreateSpellEntry( 10308 ), -- Hammer of Justice
			CreateSpellEntry( 20185 ), -- Judgement of Light
			CreateSpellEntry( 20186 ), -- Judgement of Wisdom
			CreateSpellEntry( 20184 ), -- Judgement of Justice
			CreateSpellEntry( 53601 ), -- Sacred Shield
		},
		player = {
			CreateSpellEntry( 642 ), -- Divine Shield
			CreateSpellEntry( 498 ), -- Divine Protection
			CreateSpellEntry( 31884 ), -- Avenging Wrath
			CreateSpellEntry( 53601, true), -- Sacred Shield
			CreateSpellEntry( 54428 ), -- Divine Plea
			CreateSpellEntry( 48952 ), -- Holy Shield
			CreateSpellEntry( 70940, true), -- Divine Guardian 
			CreateSpellEntry( 64205 ), -- Divine Sacrafice
			--CreateSpellEntry( 25771 ), -- Forbearance
		},
		procs = {
			CreateSpellEntry( 59578 ), -- The Art of War			
		},
	},
	PRIEST = { 
		target = { 
			CreateSpellEntry( 48066 ), -- Power Word: Shield
			CreateSpellEntry( 6788, true, nil, 1 ), -- Weakened Soul
			CreateSpellEntry( 48068 ), -- Renew
			CreateSpellEntry( 48111 ), -- Prayer of Mending
			CreateSpellEntry( 552 ), -- Abolish Disease
			CreateSpellEntry( 33206 ), -- Pain Suppression
			CreateSpellEntry( 48160, false, nil, nil, 48160 ), -- Vampiric Touch
			CreateSpellEntry( 48125 ), -- Shadow Word: Pain
			CreateSpellEntry( 48300 ), -- Devouring Plague
			CreateSpellEntry( 47788 ), -- Guardian Spirit
		},
		player = {
			CreateSpellEntry( 10060 ), -- Power Infusion
			CreateSpellEntry( 48168 ), -- Inner Fire
			CreateSpellEntry( 47585 ), -- Dispersion
		},
		procs = {
			CreateSpellEntry( 63734 ), -- Serendipity
			CreateSpellEntry( 33151 ), -- Surge of Light
			CreateSpellEntry( 15258 ), -- Shadow Weaving
		},
	},
	ROGUE = { 
		target = { 
			CreateSpellEntry( 1833 ), -- Cheap Shot
			CreateSpellEntry( 408 ), CreateSpellEntry( 8643 ), -- Kidney Shot      
			CreateSpellEntry( 1776 ), -- Gouge   
			CreateSpellEntry( 2094 ), -- Blind
			CreateSpellEntry( 8647 ), -- Expose Armor
			CreateSpellEntry( 51722 ), -- Dismantle
			CreateSpellEntry( 57970 ), -- Deadly Poison
			CreateSpellEntry( 57975 ), -- Wound Posion
			CreateSpellEntry( 3409 ),  -- Crippling Poison      
			CreateSpellEntry( 5760 ), -- Mind-Numbling Poison
			CreateSpellEntry( 51724 ), -- Sap			
			CreateSpellEntry( 48672 ), -- Rupture
			CreateSpellEntry( 48676 ), -- Garrote
		},
		player = { 
			CreateSpellEntry( 57993 ), -- Envenom
			CreateSpellEntry( 6774 ), -- Slice and Dice			
			CreateSpellEntry( 63848 ), -- Hunger for Blood
			CreateSpellEntry( 57934 ), -- Tricks of Trade
			CreateSpellEntry( 5277 ), -- Evasion Rank 1
			CreateSpellEntry( 26669 ), -- Evasion Rank 2
		},
		procs = {
			
		},
	},
	SHAMAN = {
		target = { 
			CreateSpellEntry( 49284 ), -- Earth Shield
			CreateSpellEntry( 49233 ), -- Flame Shock
			CreateSpellEntry( 49236 ), -- Frost Shock
		},
		player = { 
			CreateSpellEntry( 49281 ), -- Lightning Shield
			CreateSpellEntry( 57960 ), -- Water Shield
			CreateSpellEntry( 30823 ), -- Shamanistic Rage
		},
		procs = {
			CreateSpellEntry( 53817 ), -- Maelstrom Weapon				
		},
	},
	WARLOCK = { 
		target = {
			CreateSpellEntry( 59164, false, nil, nil, 59164 ), -- Haunt
			CreateSpellEntry( 32391 ), -- Shadow Embrace 
			CreateSpellEntry( 47813 ), -- Corruption
			CreateSpellEntry( 47843, false, nil, nil, 47843 ), -- Unstable Affliction
			CreateSpellEntry( 47867 ), -- Curse of Doom
			CreateSpellEntry( 47864 ), -- Curse of Agony
			CreateSpellEntry( 47865 ), -- Curse of the Elements 
			CreateSpellEntry( 17962 ), -- Conflagration
			CreateSpellEntry( 47811, false, nil, nil, 47811 ), -- Immolate
			CreateSpellEntry( 47836, false, nil, nil, 47836 ), -- Seed of Corruption
		},
		player = {            
		},
		procs = {
			CreateSpellEntry( 54277 ), -- Backdraft
			CreateSpellEntry( 64371 ), -- Eradication
			CreateSpellEntry( 71165 ), -- Molten Core
			CreateSpellEntry( 63167 ), -- Decimation
			CreateSpellEntry( 63321 ), -- Life Tap Glyph            
		},
	},
	WARRIOR = { 
		target = {
			CreateSpellEntry( 47465 ), -- Rend
			CreateSpellEntry( 47486 ), -- Mortal Strike
			CreateSpellEntry( 47437 ), -- Demoralizing Shout
			CreateSpellEntry( 64382 ), -- Shattering Throw
			CreateSpellEntry( 58567 ), -- Sunder Armor
		},
		player = { 
			CreateSpellEntry( 47440 ), -- Commanding Shout
			CreateSpellEntry( 47436 ), -- Battle Shout
			CreateSpellEntry( 55694 ), -- Enraged Regeneration
			CreateSpellEntry( 23920 ), -- Spell Reflection
			CreateSpellEntry( 871 ), -- Shield Wall
			CreateSpellEntry( 1719 ), -- Recklessness
			CreateSpellEntry( 20230 ), -- Retaliation
			CreateSpellEntry( 46916 ), -- Slam!
		},
		procs = {
			
		},
	},
};