﻿local E, C, L, DB = unpack(select(2, ...))

function GetColor( r, b, g, a )	
	return { r = r, b = b, g = g, a = a }
end

DB["media"] = {
	-- Font
	["font"] = "ElvUI Font",
	["dmgfont"] = "ElvUI Combat",
	-- Textures
	["normTex"] = "ElvUI Gloss",
	["glossTex"] = "ElvUI Gloss",
	["glowTex"] = "ElvUI GlowBorder",
	["blank"] = "ElvUI Blank",
	["raidicons"] = [[Interface\AddOns\ElvUI\media\textures\raidicons.blp]],
	--Colors
	["bordercolor"] = GetColor( .1, .1, .1 ),
	["backdropcolor"] = GetColor( .1, .1, .1 ),
	["backdropfadecolor"] = GetColor( .054, .054, .054, .8 ),
	["valuecolor"] = {r = 23/255,g = 132/255,b = 209/255}, -- color for values of datatexts
}

DB["general"] = {
	["autoscale"] = true,
	["uiscale"] = 0.78,
	["multisampleprotect"] = true,
	["fontscale"] = 12,
	["resolutionoverride"] = "NONE",
	["upperpanel"] = true,
	["lowerpanel"] = true,
	["loginmessage"] = true,
	['pixelPerfect'] = false,
}

DB["skin"] = {
	["enable"] = true,
		['Achievement_Popup'] = true,
		['AchievementUI'] = true,
		['Arena'] = true,
		['ArenaRegistrar'] = true,
		['AuctionhouseUI'] = true,
		['Character'] = true,
		['Friends'] = true,
		['Gossip']= true,
		['LFD'] = true,
		['MacroUI'] = true,
		['Mail'] = true,
		['Merchant'] = true,
		['Misc'] = true,
		['PvP'] = true,
		['Quest'] = true,
		['SpellBook'] = true,
		['TalentUI'] = true,
		['Taxi'] = true,
		['TradeSkillUI'] = true,
	['Ace3'] = true,
	['DBM'] = true,
	['Omen'] = true,
	['Recount'] = true,
	['Skada'] = true,
	["embedright"] = "Recount",
}

DB["unitframes"] = {
	["enable"] = true,
		-- General
		["font"] = "ElvUI Font",
		["fontsize"] = 12,
		['fontoutline'] = 'OUTLINE',
		["lowThreshold"] = 20,
		["targetpowerplayeronly"] = true,
		["showfocustarget"] = false,
		["pettarget"] = true,
		["showtotalhpmp"] = false,
		["showsmooth"] = true,
		["charportrait"] = false,
		["charportraithealth"] = false,
		["classcolor"] = false,
		["classcolorpower"] = false,
		["classcolorbackdrop"] = false,
		["healthcolor"] = { r = .1, g = .1, b = .1 },
		["healthcolorbyvalue"] = true,
		["healthbackdrop"] = false,
		["healthbackdropcolor"] = { r = .07,g = .07,b = .07 },
		["combatfeedback"] = false,
		["debuffhighlight"] = true,
		["classbar"] = true,
		["combat"] = false,
		["unitname"] = true,
		["namefontsize"] = 12,
		["mini_powerbar"] = false,
		["mini_classbar"] = true,
		["powerbar_offset"] = 0,
		["showboss"] = true,
		["arena"] = true,
		["displayaggro"] = true,
		["powerbar_height"] = 10,
		["classbar_height"] = 10,
		-- Frame Size
		["playtarwidth"] = 220,
		["playtarheight"] = 55,
		["smallwidth"] = 120,
		["smallheight"] = 40,
		["arenabosswidth"] = 200,
		["arenabossheight"] = 45,
		["assisttankwidth"] = 120,
		["assisttankheight"] = 27,
		["portaitheight"] = 55,
		["portaitwidth"] = 55,
		-- Auras
		["auratimer"] = true,
		["auratextscale"] = 11,
		["playerbuffs"] = false,
		["playerdebuffs"] = true,
		["targetbuffs"] = true,
		["targetdebuffs"] = true,
		["arenabuffs"] = true,
		["bossbuffs"] = true,
		["arenadebuffs"] = true,
		["bossdebuffs"] = true,
		["playershowonlydebuffs"] = true,
		["playerdebuffsonly"] = true,
		["totdebuffs"] = true,
		["focusdebuffs"] = true,
		["playeraurasperrow"] = 8,
		["targetaurasperrow"] = 8,
		["smallaurasperrow"] = 5,
		["playernumbuffrows"] = 1,
		["playernumdebuffrows"] = 1,	
		["targetnumbuffrows"] = 1,
		["targetnumdebuffrows"] = 1,
		
		["unitcastbar"] = true,
		["cblatency"] = false,
		["cbicons"] = true,
		["cbticks"] = true,
		["castermode"] = true,
		["castplayerwidth"] = 220,
		["castplayerheight"] = 20,
		["casttargetwidth"] = 220,
		["casttargetheight"] = 20,
		["castfocuswidth"] = 275,
		["castfocusheight"] = 20,
		["castbarcolor"] = GetColor(.1, .1, .1),
		["nointerruptcolor"] = {r = 0.78, g = 0.25, b = 0.25},
		
		["POWER_MANA"] = {r = 0.31, g = 0.45, b = 0.63},
		["POWER_RAGE"] = {r = 0.78, g = 0.25, b = 0.25},
		["POWER_FOCUS"] = {r = 0.71, g = 0.43, b = 0.27},
		["POWER_ENERGY"] = {r = 0.65, g = 0.63, b = 0.35},
		["POWER_RUNICPOWER"] = {r = 0, g = 0.82, b = 1},
}

DB["raidframes"] = {
	["enable"] = true,
		["fontsize"] = 12,
		["scale"] = 1,
		["showrange"] = true,
		["raidalphaoor"] = 0.3,
		['showsolo'] = false,
		["showplayerinparty"] = true,
		["healthdeficit"] = false,
		["griddps"] = false,
		["raidunitbuffwatch"] = false,
		["buffindicatorsize"] = 6,
		["buffindicatorcoloricons"] = true,
		["debuffs"] = true,
		["displayaggro"] = true,
		["mini_powerbar"] = true,
		["powerbar_offset"] = 5,
}

DB["classtimer"] = {
	["enable"] = true,
		['font'] = "ElvUI Font",
		['fontsize'] = 12,
		['fontoutline'] = 'OUTLINE',
		["bar_height"] = 17,
		["bar_spacing"] = 5,
		["icon_position"] = 2,
		["layout"] = 4,
		["showspark"] = true,
		["cast_suparator"] = true,
		["classcolor"] = false,
		["buffcolor"] = DB["media"].bordercolor,
		["debuffcolor"] = {r = 0.78, g = 0.25, b = 0.25},
		["proccolor"] = {r = 0.84, g = 0.75, b = 0.65},
}

DB["actionbar"] = {
	["enable"] = true,                     -- enable elvui action bars
		['font'] = 'ElvUI Font',
		['fontsize'] = 12,
		['fontoutline'] = 'OUTLINE',
		["hotkey"] = true,                     -- enable hotkey display because it was a lot requested
		["showgrid"] = true,                   -- show grid on empty button
		["macrotext"] = true,					--show macro text on actionbuttons
		["verticalstance"] = false,				--make stance bar vertical
	["microbar"] = true,					--enable microbar display
		["mousemicro"] = false,					--enable microbar display
	["enablecd"] = true,
		["treshold"] = 3,                      -- show decimal under X seconds and text turn red
		["expiringcolor"] = { r = 1, g = 0, b = 0 },		--color of expiring seconds turns to 
		["secondscolor"] = { r = 1, g = 1, b = 0 },			--seconds color
		["minutescolor"] = { r = 1, g = 1, b = 1 },			-- minutes color
		["hourscolor"] = { r = 0.4, g = 1, b = 1 },			-- hours color
		["dayscolor"] = { r = 0.4, g = 0.4, b = 1 },		-- days color	
	["bar1enable"] = true,
		["bar1btnmax"] = 12,
		["bar1btnsize"] = 34,
		["bar1btnrows"] = 1,
		["bar1xspacing"] = 2,
		["bar1yspacing"] = 2,
	["bar2enable"] = true,
		["bar2btnmax"] = 12,
		["bar2btnsize"] = 34,
		["bar2btnrows"] = 1,
		["bar2xspacing"] = 2,
		["bar2yspacing"] = 2,
	["bar3enable"] = true,
		["bar3btnmax"] = 12,
		["bar3btnsize"] = 34,
		["bar3btnrows"] = 12,
		["bar3xspacing"] = 2,
		["bar3yspacing"] = 2,
	["bar4enable"] = true,
		["bar4btnmax"] = 12,
		["bar4btnsize"] = 34,
		["bar4btnrows"] = 12,
		["bar4xspacing"] = 2,
		["bar4yspacing"] = 2,
	["bar5enable"] = true,
		["bar5btnmax"] = 12,
		["bar5btnsize"] = 34,
		["bar5btnrows"] = 1,
		["bar5xspacing"] = 2,
		["bar5yspacing"] = 2,
	["hideshapeshift"] = false,
		["shiftbarbtnsize"] = 34,
		["shiftbarspacing"] = 2,
	["petbarenable"] = true,
		["petbarbtnsize"] = 34,
		["petbarbtnrows"] = 1,
		["petbarspacing"] = 2,
	
	["vehiclebarsize"] = 34,
	["vehiclebarspacing"] = 2,
}

DB["nameplate"] = {
	["enable"] = true,
		['font'] = 'ElvUI Font',
		['fontsize'] = 12,
		['fontoutline'] = 'OUTLINE',
		["showhealth"] = false,
		["enhancethreat"] = true,
		["combat"] = false,
		["goodcolor"] = {r = 75/255,  g = 175/255, b = 76/255},
		["badcolor"] = {r = 0.78, g = 0.25, b = 0.25},
		["transitioncolor"] = {r = 218/255, g = 197/255, b = 92/255},
		["trackauras"] = false,
		["trackccauras"] = true,
}

DB["datatext"] = {
	['font'] = 'ElvUI Font',
	['fontsize'] = 12,
	['fontoutline'] = 'OUTLINE',
	["stat1"] = 1,
	['Durability'] = 2,
	["stat2"] = 3,
	['System'] = 4,
	['Time'] = 5,
	['Gold'] = 6,
	["guild"] = 7,
	["friends"] = 8,
	['BattleGround'] = true,
	["time24"] = true,
	["localtime"] = true,
	["classcolor"] = false,
}

DB["chat"] = {
	["enable"] = true,
		['font'] = 'ElvUI Font',
		['fontsize'] = 12,
		['fontoutline'] = 'OUTLINE',
		["whispersound"] = true,
		["whisper"] = "ElvUI Aska",
		["showbackdrop"] = true,
		["chatwidth"] = 380,
		["chatheight"] = 180,
		["sticky"] = true,
		["bubbles"] = true,
		['chatbar'] = true,
		["panelBackdropNameLeft"] = "",
		["panelBackdropNameRight"] = "",
}

DB["tooltip"] = {
	["enable"] = true,
		["hidecombat"] = true,
		["hidecombatraid"] = true,
		["hidebuttons"] = false,
		["hideuf"] = false,
		["cursor"] = false,
		["colorreaction"] = false,
		["itemid"] = true,
		["whotargetting"] = true,
}

DB["others"] = {
	["errorenable"] = true,
	["autoacceptinv"] = true,
	["enablebag"] = true,
	['afkcamera'] = true,
	['alertcombat'] = true,

	["lootframe"] = true,
	["rolllootframe"] = true,
	["sellgrays"] = true,
	["autorepair"] = true,
	
	["raidbuffreminder"] = true,	
	["announceinterrupt"] = "PARTY",
	["showthreat"] = true,
	["minimapauras"] = true,
	["rowbuffs"] = 14,
}