local E, C, L, DB = unpack( select( 2, ... ) )

if not C['unitframes']['enable'] == true and not C['raidframes']['enable'] == true then return end

-- CAST BAR
function E.ConstructCastBar( self, direction )
	local castbar = CreateFrame( 'StatusBar', nil, self )
	castbar:SetStatusBarTexture( C['media']['normTex'] )
	castbar.CustomDelayText = E.CustomCastDelayText
	castbar.PostCastStart = E.PostCastStart
	castbar.PostChannelStart = E.PostCastStart		
	castbar.PostCastInterruptible = E.PostCastInterruptible
	castbar.PostCastNotInterruptible = E.PostCastNotInterruptible
	castbar:CreateBackdrop( 'Default' )
	
	castbar:FontString( 'Time', C['unitframes']['font'], C['unitframes']['fontsize'], C['unitframes']['fontoutline'] )
	castbar.Time:SetShadowColor( 0, 0, 0, 0 )	
	castbar.Time:Point( 'RIGHT', castbar, 'RIGHT', -4, 0 )
	castbar.Time:SetTextColor( 0.84, 0.75, 0.65 )
	castbar.Time:SetJustifyH( 'RIGHT' )
	castbar.CustomTimeText = E.CustomCastTimeText
	
	castbar:FontString( 'Text', C['unitframes']['font'], C['unitframes']['fontsize'], C['unitframes']['fontoutline'] )
	castbar.Text:SetPoint( 'LEFT', castbar, 'LEFT', 4, 0 )
	castbar.Text:SetTextColor( 0.84, 0.75, 0.65 )
	
	castbar.Spark = castbar:CreateTexture( nil, 'OVERLAY' )
	castbar.Spark:SetBlendMode( 'ADD' )
	castbar.Spark:SetVertexColor( 1, 1, 1 )
	
	if C['unitframes']['cblatency'] == true and self.unit == 'player' then
		castbar.SafeZone = castbar:CreateTexture( nil, 'OVERLAY' )
		castbar.SafeZone:SetTexture( C['media']['normTex'] )
		castbar.SafeZone:SetVertexColor( 0.69, 0.31, 0.31, 0.75 )
	end	
	
	castbar.bg = castbar:CreateTexture( nil, 'BORDER' )
	castbar.bg:Hide()
	
	local button = CreateFrame( 'Frame', nil, castbar )
	button:SetTemplate( 'Default' )
	
	if direction == 'LEFT' then
		button:Point( 'RIGHT', castbar, 'LEFT', E.PixelMode and 0 or -3, 0 )
	else
		button:Point( 'LEFT', castbar, 'RIGHT', E.PixelMode and 0 or 3, 0 )
	end

	local icon = button:CreateTexture( nil, 'ARTWORK' )
	icon:SetInside()
	icon:SetTexCoord( unpack( E.TexCoords ) )
	icon.bg = button
	
	castbar.ButtonIcon = icon

	return castbar
end

function E.SpawnMenu( self )
	local unit = self.unit:gsub( '(.)', string.upper, 1 )
	if self.unit == 'targettarget' then return end
	if _G[unit..'FrameDropDown'] then
		ToggleDropDownMenu( 1, nil, _G[unit..'FrameDropDown'], 'cursor' )
	elseif ( self.unit:match( 'party' ) ) then
		ToggleDropDownMenu(1, nil, _G['PartyMemberFrame'..self.id..'DropDown'], 'cursor' )
	else
		FriendsDropDown.unit = self.unit
		FriendsDropDown.id = self.id
		FriendsDropDown.initialize = RaidFrameDropDown_Initialize
		ToggleDropDownMenu( 1, nil, FriendsDropDown, 'cursor' )
	end
end

local frameshown = true
local unitlist = {}
local function FadeFramesInOut(fade)
	for frames, unitlist in pairs(unitlist) do
		if not UnitExists(_G[unitlist].unit) then return end
		if fade == true then
			UIFrameFadeIn(_G[unitlist], 0.15)
		else
			UIFrameFadeOut(_G[unitlist], 0.15)
		end
	end
end

E.Fader = function(self, arg1, arg2)	
	if arg1 == "UNIT_HEALTH" and self.unit ~= arg2 then return end
	
	local unit = self.unit
	if arg2 == true then self = self:GetParent() end
	if not unitlist[tostring(self:GetName())] then tinsert(unitlist, tostring(self:GetName())) end
	
	local cur = UnitHealth("player")
	local max = UnitHealthMax("player")
	
	if (UnitCastingInfo("player") or UnitChannelInfo("player")) and frameshown ~= true then
		FadeFramesInOut(true)
		frameshown = true	
	elseif cur ~= max and frameshown ~= true then
		FadeFramesInOut(true)
		frameshown = true	
	elseif (UnitExists("target") or UnitExists("focus")) and frameshown ~= true then
		FadeFramesInOut(true)
		frameshown = true	
	elseif arg1 == true and frameshown ~= true then
		FadeFramesInOut(true)
		frameshown = true
	else
		if InCombatLockdown() and frameshown ~= true then
			FadeFramesInOut(true)
			frameshown = true	
		elseif not UnitExists("target") and not InCombatLockdown() and not UnitExists("focus") and (cur == max) and not (UnitCastingInfo("player") or UnitChannelInfo("player")) then
			FadeFramesInOut(false)
			frameshown = false
		end
	end
end

E.AuraFilter = function(icons, unit, icon, name, rank, texture, count, dtype, duration, timeLeft, caster, isStealable, shouldConsolidate, spellID)	
	local header = icon:GetParent():GetParent():GetParent():GetName()
	local inInstance, instanceType = IsInInstance()
	icon.owner = caster
	icon.isStealable = isStealable
	
	if (unit and unit:find("arena%d")) then --Arena frames
		if E.DebuffWhiteList[name] then
			return true
		elseif E.ArenaBuffWhiteList[name] then
			return true
		else
			return false
		end	
	elseif unit == "target" or (unit and unit:find("boss%d")) then --Target/Boss Only
		if C["unitframes"].playerdebuffsonly == true then
			-- Show all debuffs on friendly targets
			if UnitIsFriend("player", "target") then return true end
			
			local isPlayer
			
			if(caster == 'player' or caster == 'vehicle') then
				isPlayer = true
			else
				isPlayer = false
			end

			if isPlayer then
				return true
			elseif E.DebuffWhiteList[name] or (inInstance and ((instanceType == "pvp" or instanceType == "arena") and E.TargetPVPOnly[name])) then
				return true
			else
				return false
			end
		else
			return true
		end
	else --Everything else
		if unit ~= "player" and unit ~= "targettarget" and unit ~= "focus" and inInstance and (instanceType == "pvp" or instanceType == "arena") then
			if E.DebuffWhiteList[name] or E.TargetPVPOnly[name] then
				return true
			else
				return false
			end
		else
			if E.DebuffBlacklist[name] then
				return false
			else
				return true
			end
		end
	end
end

E.PostNamePosition = function(self)
	self.Name:ClearAllPoints()
	if (self.Power.value:GetText() and UnitIsPlayer("target") and C["unitframes"].targetpowerplayeronly == true) or (self.Power.value:GetText() and C["unitframes"].targetpowerplayeronly == false) then
		self.Power.value:SetAlpha(1)
		self.Name:SetPoint("CENTER", self.Health, "CENTER")
	else
		self.Power.value:SetAlpha(0)
		self.Name:SetPoint("LEFT", self.Health, "LEFT", 4, 0)
	end
end

local delay = 0
E.UpdateManaLevel = function(self, elapsed)
	delay = delay + elapsed
	if self.unit ~= "player" or delay < 0.2 or UnitIsDeadOrGhost("player") or UnitPowerType("player") ~= 0 then return end
	delay = 0

	local percMana = UnitMana("player") / UnitManaMax("player") * 100

	if percMana <= 20 then
		self.ManaLevel:SetText("|cffaf5050"..L.unitframes_ouf_lowmana.."|r")
		E.Flash(self.ManaLevel, 0.3)
	else
		self.ManaLevel:SetText()
		E.StopFlash(self.ManaLevel)
	end
end

E.MLAnchorUpdate = function(self)
	if self.Leader:IsShown() then
		self.MasterLooter:Point("TOPRIGHT", -18, 9)
	else
		self.MasterLooter:Point("TOPRIGHT", -4, 9)
	end
end

E.CustomCastTimeText = function(self, duration)
	self.Time:SetText(("%.1f / %.1f"):format(self.channeling and duration or self.max - duration, self.max))
end

E.CustomCastDelayText = function(self, duration)
	self.Time:SetText(("%.1f |cffaf5050%s %.1f|r"):format(self.channeling and duration or self.max - duration, self.channeling and "- " or "+", self.delay))
end

local FormatTime = function(s, reverse)
	local day, hour, minute, second = 86400, 3600, 60, 1
	if s >= day then
		return format("%dd", ceil(s / hour))
	elseif s >= hour then
		return format("%dh", ceil(s / hour))
	elseif s >= minute then
		return format("%dm", ceil(s / minute))
	elseif s >= minute / 12 then
		return floor(s)
	end
	
	if reverse and reverse == true and s >= second then
		return floor(s)
	else	
		return format("%.1f", s)
	end
end

local abs = math.abs --faster
local CreateAuraTimer = function(self, elapsed)	
	if self.timeLeft then
		self.elapsed = (self.elapsed or 0) + elapsed
		if self.elapsed >= 0.1 then
			if not self.first then
				self.timeLeft = self.timeLeft - self.elapsed
			else
				self.timeLeft = self.timeLeft - GetTime()
				self.first = false
			end
			if self.timeLeft > 0 then
				local time = FormatTime(self.timeLeft)
				if self.reverse then time = FormatTime(abs(self.timeLeft - self.duration), true) end
				self.text:SetText(time)
				if self.timeLeft <= 5 then
					self.text:SetTextColor(0.99, 0.31, 0.31)
				else
					self.text:SetTextColor(1, 1, 1)
				end
			else
				self.text:Hide()
				self:SetScript("OnUpdate", nil)
			end
			if not self.debuff == true then
				local r, g, b = self:GetParent():GetParent().Health.backdrop:GetBackdropBorderColor()
				self:SetBackdropBorderColor(r, g, b)
			end
			self.elapsed = 0
		end
	end
end

function E.PvPUpdate(self, elapsed)
	if(self.elapsed and self.elapsed > 0.2) then
		local unit = self.unit
		local time = GetPVPTimer()

		local min = format("%01.f", floor((time/1000)/60))
		local sec = format("%02.f", floor((time/1000) - min *60)) 
		if(self.PvP) then
			if(UnitIsPVPFreeForAll(unit)) then
				if time ~= 301000 and time ~= -1 then
					self.PvP:SetText(PVP.." ".."("..min..":"..sec..")")
				else
					self.PvP:SetText(PVP)
				end
			elseif UnitIsPVP(unit) then
				if time ~= 301000 and time ~= -1 then
					self.PvP:SetText(PVP.." ".."("..min..":"..sec..")")
				else
					self.PvP:SetText(PVP)
				end
			else
				self.PvP:SetText("")
			end
		end
		self.elapsed = 0
	else
		self.elapsed = (self.elapsed or 0) + elapsed
	end
end

function E.PostCreateAura(element, button)
	local unit = button:GetParent():GetParent().unit
	local header = button:GetParent():GetParent():GetParent():GetName()
	
	if unit == "focus" or unit == "targettarget" or header == "ElvuiHealParty" then
		button:FontString(nil, C['unitframes'].font, C["unitframes"].auratextscale, C["unitframes"].fontoutline)
	else
		button:FontString(nil, C['unitframes'].font, C["unitframes"].auratextscale, C["unitframes"].fontoutline)
	end
	
	button:SetTemplate("Default")
	button.text:SetPoint("CENTER", E.Scale(0), E.mult)
	
	button.cd.noOCC = true		 	-- hide OmniCC CDs
	button.cd.noCooldownCount = true	-- hide CDC CDs
	
	button.cd:SetReverse()
	button.icon:SetInside()
	button.icon:SetTexCoord(0.08, 0.92, 0.08, 0.92)
	button.icon:SetDrawLayer('ARTWORK')
	
	button.count:Point("BOTTOMRIGHT", E.mult, 1.5)
	button.count:SetJustifyH("RIGHT")
	button.count:SetFont(C['unitframes'].font, C["unitframes"].auratextscale*0.8, "THINOUTLINE")

	button.overlayFrame = CreateFrame("frame", nil, button, nil)
	button.cd:SetFrameLevel(button:GetFrameLevel() + 1)
	button.cd:ClearAllPoints()
	button.cd:SetInside()
	button.overlayFrame:SetFrameLevel(button.cd:GetFrameLevel() + 2)	   
	button.overlay:SetParent(button.overlayFrame)
	button.count:SetParent(button.overlayFrame)
	button.text:SetParent(button.overlayFrame)
	
	local highlight = button:CreateTexture(nil, "HIGHLIGHT")
	highlight:SetTexture(1,1,1,0.45)
	highlight:SetAllPoints(button.icon)	
end

function E.PostUpdateAura(icons, unit, icon, index, offset, filter, isDebuff, duration, timeLeft)
	local name, _, _, _, dtype, duration, expirationTime, unitCaster, _, _, spellID = UnitAura(unit, index, icon.filter)
	
	if(icon.debuff) then
		if(not UnitIsFriend("player", unit) and icon.owner ~= "player" and icon.owner ~= "vehicle") and (not E.DebuffWhiteList[name]) then
			icon:SetBackdropBorderColor(unpack(C["media"].bordercolor))
			icon.icon:SetDesaturated(true)
		else
			local color = DebuffTypeColor[dtype] or DebuffTypeColor.none
			if (name == "Unstable Affliction" or name == "Vampiric Touch") and E.myclass ~= "WARLOCK" then
				icon:SetBackdropBorderColor(0.05, 0.85, 0.94)
			else
				icon:SetBackdropBorderColor(color.r * 0.6, color.g * 0.6, color.b * 0.6)
			end
			icon.icon:SetDesaturated(false)
		end
	else
		if (icon.isStealable or ((E.myclass == "PRIEST" or E.myclass == "SHAMAN" or E.myclass == "MAGE") and dtype == "Magic")) and not UnitIsFriend("player", unit) then
			icon:SetBackdropBorderColor(237/255, 234/255, 142/255)
		else
			icon:SetBackdropBorderColor(unpack(C["media"].bordercolor))		
		end
	end
	
	if duration and duration > 0 then
		if C["unitframes"].auratimer == true then
			icon.text:Show()
		else
			icon.text:Hide()
		end
	else
		icon.text:Hide()
	end
	
	icon.duration = duration
	icon.timeLeft = expirationTime
	icon.first = true
	
	
	if E.ReverseTimer and E.ReverseTimer[spellID] then 
		icon.reverse = true 
	else
		icon.reverse = false
	end

	icon:SetScript("OnUpdate", CreateAuraTimer)
end

--Credit Monolit
local ticks = {}
local function SetCastTicks(self, num)
	if num and num > 0 then
		local d = self:GetWidth() / num
		for i = 1, num do
			if not ticks[i] then
				ticks[i] = self:CreateTexture(nil, 'OVERLAY')
				ticks[i]:SetTexture(C["media"].blank)
				ticks[i]:SetVertexColor(0, 0, 0)
				ticks[i]:SetWidth(2)
				ticks[i]:SetHeight(self:GetHeight())
			end
			ticks[i]:ClearAllPoints()
			ticks[i]:SetPoint("CENTER", self, "LEFT", d * i, 0)
			ticks[i]:Show()
		end
	else
		for _, tick in pairs(ticks) do
			tick:Hide()
		end
	end
end

function E.PostCastInterruptible(self, unit)
	if unit == "vehicle" then unit = "player" end
	if unit ~= "player" then
		if UnitCanAttack("player", unit) then
			self:SetStatusBarColor(unpack(C["unitframes"].nointerruptcolor))
		else
			self:SetStatusBarColor(unpack(C["unitframes"].castbarcolor))	
		end		
	end
end

function E.PostCastNotInterruptible(self, unit)
	self:SetStatusBarColor(unpack(C["unitframes"].castbarcolor))
end

E.PostCastStart = function(self, unit, name, rank, castid)
	if unit == "vehicle" then unit = "player" end
	self.Text:SetText(string.sub(name, 0, math.floor((((32/245) * self:GetWidth()) / C["unitframes"].fontsize) * 12)))
	
	if C["unitframes"].cbticks == true and unit == "player" then
		if E.ChannelTicks[name] then
			SetCastTicks(self, E.ChannelTicks[name])
		else
			for _, tick in pairs(ticks) do
				tick:Hide()
			end		
		end
	end
	
	if self.interrupt and unit ~= "player" then
		if UnitCanAttack("player", unit) then
			self:SetStatusBarColor(unpack(C["unitframes"].nointerruptcolor))
		else
			self:SetStatusBarColor(unpack(C["unitframes"].castbarcolor))	
		end
	else
		self:SetStatusBarColor(unpack(C["unitframes"].castbarcolor))
	end
end

E.ReputationPositionUpdate = function(self)
	if not self:GetName() then self = self:GetParent() end
	if not self.Reputation or not MinimapMover then return end
	self.Reputation:ClearAllPoints()
	
	local point, _, _, _, _ = MinimapMover:GetPoint()
	
	if point:match("BOTTOM") then
		if self.Experience and self.Experience:IsShown() then
			self.Reputation:Point("BOTTOMLEFT", self.Experience, "TOPLEFT", 0, 5)
		elseif self.Experience and self.Experience:IsShown() then
			self.Reputation:Point("TOPLEFT", self.Experience, "BOTTOMLEFT", 0, -5)
		else
			self.Reputation:Point("BOTTOMLEFT", LeftMiniPanel, "TOPLEFT", 2, 3)
		end
	else
		if self.Experience and self.Experience:IsShown() then
			self.Reputation:Point("TOPLEFT", self.Experience, "BOTTOMLEFT", 0, -5)
		elseif self.Experience and self.Experience:IsShown() then
			self.Reputation:Point("BOTTOMLEFT", self.Experience, "TOPLEFT", 0, 5)
		else
			self.Reputation:Point("TOPLEFT", LeftMiniPanel, "BOTTOMLEFT", 2, -3)
		end		
	end
end

E.PortraitUpdate = function(self, unit) 
	if C["unitframes"].charportraithealth == true then
		self:SetAlpha(0) self:SetAlpha(.15) 
	end
	
	if self:GetModel() and self:GetModel().find and self:GetModel():find("worgenmale") then
		self:SetCamera(1)
	end	
end	

E.HidePortrait = function(self, event)
	if self.unit == "target" then
		if not UnitExists(self.unit) or not UnitIsConnected(self.unit) or not UnitIsVisible(self.unit) then
			self.PFramet:SetAlpha(0)
		else
			self.PFramet:SetAlpha(1)
		end
	end
end

E.ComboDisplay = function(self, event, unit)
	if(unit == 'pet') then return end
	
	local cpoints = self.CPoints
	local cp
	if (UnitHasVehicleUI("player") or UnitHasVehicleUI("vehicle")) then
		cp = GetComboPoints('vehicle', 'target')
	else
		cp = GetComboPoints('player', 'target')
	end

	for i=1, MAX_COMBO_POINTS do
		if(i <= cp) then
			cpoints[i]:SetAlpha(1)
		else
			cpoints[i]:SetAlpha(0.15)
		end
	end
	
	if cpoints[1]:GetAlpha() == 1 then
		cpoints:Show()
	else
		cpoints:Hide()
	end
end

E.RestingIconUpdate = function (self)
	if IsResting() then
		self.Resting:Show()
	else
		self.Resting:Hide()
	end
end

function E.UpdateThreat(self, event, unit)
	if (self.unit ~= unit) or not unit then return end
	
	local threat = UnitThreatSituation(unit)
	if threat and threat > 1 then
		local r, g, b = GetThreatStatusColor(threat)			
		if self.shadow then
			self.shadow:SetBackdropBorderColor(r, g, b)
		elseif self.Health.backdrop then
			self.Health.backdrop:SetBackdropBorderColor(r, g, b)
			
			if self.Power and self.Power.backdrop then
				self.Power.backdrop:SetBackdropBorderColor(r, g, b)
			end
		end
	else		
		if self.shadow then
			self.shadow:SetBackdropBorderColor(0, 0, 0, 0)
		elseif self.Health.backdrop then
			self.Health.backdrop:SetTemplate("Default")
			
			if self.Power and self.Power.backdrop then
				self.Power.backdrop:SetTemplate("Default")
			end
		end
	end 
end

--------------------------------------------------------------------------------------------
-- THE AURAWATCH FUNCTION ITSELF. HERE BE DRAGONS!
--------------------------------------------------------------------------------------------

E.countOffsets = {
	TOPLEFT = {6, 1},
	TOPRIGHT = {-6, 1},
	BOTTOMLEFT = {6, 1},
	BOTTOMRIGHT = {-6, 1},
	LEFT = {6, 1},
	RIGHT = {-6, 1},
	TOP = {0, 0},
	BOTTOM = {0, 0},
}

function E.CreateAuraWatchIcon(self, icon)
	if (icon.cd) then
		if C["raidframes"].buffindicatorcoloricons == true then
			icon.cd:SetReverse()
		end
	end 	
end

function E.createAuraWatch(self, unit)
	local auras = CreateFrame("Frame", nil, self)
	auras:SetPoint("TOPLEFT", self.Health, 2, -2)
	auras:SetPoint("BOTTOMRIGHT", self.Health, -2, 2)
	auras.presentAlpha = 1
	auras.missingAlpha = 0
	auras.icons = {}
	auras.PostCreateIcon = E.CreateAuraWatchIcon

	if (not C["unitframes"].auratimer) then
		auras.hideCooldown = true
	end

	local buffs = {}

	if IsAddOnLoaded("ElvUI") then
		if (E.DPSBuffIDs[E.myclass]) then
			for key, value in pairs(E.DPSBuffIDs[E.myclass]) do
				if value["enabled"] == true then
					tinsert(buffs, value)
				end
			end
		end
	end
	
	if (buffs) then
		for key, spell in pairs(buffs) do
			local icon = CreateFrame("Frame", nil, auras)
			icon.spellID = spell["id"]
			icon.anyUnit = spell["anyUnit"]
			icon.onlyShowMissing = spell["onlyShowMissing"]
			if spell["onlyShowMissing"] then
				icon.presentAlpha = 0
				icon.missingAlpha = 1
			else
				icon.presentAlpha = 1
				icon.missingAlpha = 0				
			end
			icon:SetWidth(E.Scale(C["raidframes"].buffindicatorsize))
			icon:SetHeight(E.Scale(C["raidframes"].buffindicatorsize))
			icon:SetPoint(spell["point"], 0, 0)
			
			if C["raidframes"].buffindicatorcoloricons == true then
				local tex = icon:CreateTexture(nil, "OVERLAY")
				tex:SetAllPoints(icon)
				tex:SetTexture(C["media"].blank)
				if (spell["color"]) then
					local color = spell["color"]
					tex:SetVertexColor(color.r, color.g, color.b)
				else
					tex:SetVertexColor(0.8, 0.8, 0.8)
				end
				icon.icon = tex
			else
				local _, _, image = GetSpellInfo(icon.spellID)
				local tex = icon:CreateTexture(nil, 'ARTWORK')
				tex:SetAllPoints(icon)
				tex:SetTexCoord(.18, .82, .18, .82)
				tex:SetTexture(image)
				icon.icon = tex
			end
			
			local border = icon:CreateTexture(nil, "BACKGROUND")
			border:SetInside()
			border:SetTexture(C["media"].blank)
			border:SetVertexColor(0, 0, 0)

			local count = icon:CreateFontString(nil, "OVERLAY")
			count:SetFont(C['unitframes'].font, C["raidframes"].buffindicatorsize + 3, "THINOUTLINE")
			count:SetPoint("CENTER", unpack(E.countOffsets[spell["point"]]))
			icon.count = count

			auras.icons[spell["id"]] = icon
		end
	end

	self.AuraWatch = auras
end