local E, C, L, DB = unpack( select( 2, ... ) )

function E.ConstructPowerBar( self, bg, text )
	local power = CreateFrame( 'StatusBar', nil, self )
	power:SetStatusBarTexture( C['media']['normTex'] )
	power.frequentUpdates = true
	power:SetFrameStrata( 'LOW' )
	power.PostUpdate = E.PostUpdatePower
	
	if ( C['unitframes']['showsmooth'] == true ) then
		power.Smooth = true
	end	
	
	if ( bg ) then
		power.bg = power:CreateTexture( nil, 'BORDER' )
		power.bg:SetAllPoints()
		power.bg:SetTexture( C['media']['blank'] )
		power.bg.multiplier = 0.25
	end
	
	if ( text ) then
		power:FontString( 'value', C['unitframes']['font'], C['unitframes']['fontsize'], C['unitframes']['fontoutline'] )
		power.value:SetShadowColor( 0, 0, 0, 0 )			
		power.value:SetParent( self )
	end
	
	if ( C['unitframes']['classcolorpower'] == true ) then
		power.colorClass = true
		power.colorReaction = true
	else
		power.colorPower = true
	end
	
	power.colorDisconnected = true
	power.colorTapping = false
	
	power:CreateBackdrop( 'Default' )

	return power
end

E.PostUpdatePower = function( power, unit, min, max )
	local self = power:GetParent()
	local pType, pToken, altR, altG, altB = UnitPowerType( unit )
	local color = E.oUF_colors.power[pToken]
	
	if ( C['general']['classcolortheme'] == true ) then
		power.backdrop:SetBackdropBorderColor( power:GetParent().Health.backdrop:GetBackdropBorderColor() )
	end
	
	if not power.value then return end		

	if ( color ) then
		power.value:SetTextColor( color[1], color[2], color[3] )
	else
		power.value:SetTextColor( altR, altG, altB, 1 )
	end	
		
	if min == 0 then 
		power.value:SetText() 
	else
		if ( not UnitIsPlayer( unit ) and not UnitPlayerControlled( unit ) or not UnitIsConnected( unit ) ) and not ( unit and unit:find( 'boss%d' ) ) then
			power.value:SetText()
		elseif UnitIsDead( unit ) or UnitIsGhost( unit ) then
			power.value:SetText()
		else
			if min ~= max then
				if pType == 0 then
					if unit == 'target' then
						if C['unitframes']['showtotalhpmp'] == true then
							power.value:SetFormattedText( '%s |cffD7BEA5|||r %s', E.ShortValue( max - ( max - min ) ), E.ShortValue( max ) )
						else
							power.value:SetFormattedText( '%d%% |cffD7BEA5-|r %s', floor( min / max * 100 ), E.ShortValue( max - ( max - min ) ) )
						end
					elseif unit == 'player' and self:GetAttribute( 'normalUnit' ) == 'pet' or unit == 'pet' then
						if C['unitframes']['showtotalhpmp'] == true then
							power.value:SetFormattedText( '%s |cffD7BEA5|||r %s', E.ShortValue( max - ( max - min ) ), E.ShortValue( max ) )
						else
							power.value:SetFormattedText( '%d%%', floor( min / max * 100 ) )
						end
					elseif ( unit and unit:find( 'arena%d' ) ) then
						power.value:SetText( E.ShortValue( min ) )
					elseif ( unit and unit:find( 'boss%d' ) ) then
						power.value:SetFormattedText('%d%%', floor( min / max * 100 ) )					
					else
						if C['unitframes']['showtotalhpmp'] == true then
							power.value:SetFormattedText( '%s |cffD7BEA5|||r %s', E.ShortValue( max - ( max - min ) ), E.ShortValue( max ) )
						else
							power.value:SetFormattedText( '%d%% |cffD7BEA5-|r %s', floor( min / max * 100 ), E.ShortValue( max - ( max - min ) ) )
						end
					end
				else
					power.value:SetText( max - ( max - min ) )
				end
			else
				if ( unit == 'pet' ) or ( unit == 'target' ) or ( unit and unit:find( 'arena%d' ) ) then
					power.value:SetText( E.ShortValue( min ) )
				else
					power.value:SetText( E.ShortValue( min ) )
				end
			end
		end
	end
	
	if ( self.Name and unit == 'target' ) then
		E.PostNamePosition(self)
	end
end