local E, C, L, DB = unpack( select( 2, ... ) )

if C['others']['raidbuffreminder'] ~= true then return end

local flaskbuffs = E.BuffReminderRaidBuffs['Flask']
local battleelixirbuffs = E.BuffReminderRaidBuffs['BattleElixir']
local guardianelixirbuffs = E.BuffReminderRaidBuffs['GuardianElixir']
local foodbuffs = E.BuffReminderRaidBuffs['Food']	
local battleelixired	
local guardianelixired	

local function SetCasterOnlyBuffs()
	Spell3Buff = { 20217, 25898, }
	Spell4Buff = { 48469, 72588, }
	Spell5Buff = { 42995, 43002, 61316, }
	Spell6Buff = { 48936, 48938, 58777, }
end

local function SetBuffs()
	Spell3Buff = { 20217, 25898, }
	Spell4Buff = { 48469, 72588, }
	Spell5Buff = { 48161,48162, }
	Spell6Buff = { 20911, 25899, 48932, 48934, 47436, }
end

local function CheckElixir( unit )
	if ( battleelixirbuffs and battleelixirbuffs[1] ) then
		for i, battleelixirbuffs in pairs( battleelixirbuffs ) do
			local spellname = select(1, GetSpellInfo(battleelixirbuffs))
			if UnitAura( 'player', spellname ) then
				FlaskFrame.t:SetTexture( select( 3, GetSpellInfo( battleelixirbuffs ) ) )
				battleelixired = true
				break
			else
				battleelixired = false
			end
		end
	end
	
	if ( guardianelixirbuffs and guardianelixirbuffs[1] ) then
		for i, guardianelixirbuffs in pairs( guardianelixirbuffs ) do
			local spellname = select( 1, GetSpellInfo( guardianelixirbuffs ) )
			if UnitAura( 'player', spellname ) then
				guardianelixired = true
				if not battleelixired then
					FlaskFrame.t:SetTexture( select( 3, GetSpellInfo( guardianelixirbuffs ) ) )
				end
				break
			else
				guardianelixired = false
			end
		end
	end	
	
	if guardianelixired == true and battleelixired == true then
		FlaskFrame:SetAlpha( 0.2 )
		return
	else
		FlaskFrame:SetAlpha( 1 )
	end
end

RaidReminderShown = true
local function OnAuraChange( self, event, arg1, unit )
	if ( event == 'UNIT_AURA' and arg1 ~= 'player' ) then 
		return
	end
	
	if E.Role == 'Caster' then 
		SetCasterOnlyBuffs() 
	else
		SetBuffs()
	end
	
	if ( flaskbuffs and flaskbuffs[1] ) then
		FlaskFrame.t:SetTexture( select( 3, GetSpellInfo( flaskbuffs[1] ) ) )
		for i, flaskbuffs in pairs( flaskbuffs ) do
			local spellname = select( 1, GetSpellInfo( flaskbuffs ) )
			if UnitAura( 'player', spellname ) then
				FlaskFrame.t:SetTexture( select( 3, GetSpellInfo( flaskbuffs ) ) )
				FlaskFrame:SetAlpha( 0.2 )
				break
			else
				CheckElixir()
			end
		end
	end
	
	if ( foodbuffs and foodbuffs[1] ) then
		FoodFrame.t:SetTexture( select( 3, GetSpellInfo( foodbuffs[1] ) ) )
		for i, foodbuffs in pairs(foodbuffs) do
			local spellname = select( 1, GetSpellInfo( foodbuffs ) )
			if UnitAura( 'player', spellname ) then
				FoodFrame:SetAlpha( 0.2 )
				FoodFrame.t:SetTexture( select( 3, GetSpellInfo( foodbuffs ) ) )
				break
			else
				FoodFrame:SetAlpha( 1 )
			end
		end
	end
	
	for i, Spell3Buff in pairs( Spell3Buff ) do
		local spellname = select( 1, GetSpellInfo( Spell3Buff ) )
		if UnitAura( 'player', spellname ) then
			Spell3Frame:SetAlpha( 0.2 )
			Spell3Frame.t:SetTexture( select( 3, GetSpellInfo( Spell3Buff ) ) )
			break
		else
			Spell3Frame:SetAlpha( 1 )
			Spell3Frame.t:SetTexture( select( 3, GetSpellInfo( Spell3Buff ) ) )
		end
	end
	
	for i, Spell4Buff in pairs( Spell4Buff ) do
		local spellname = select( 1, GetSpellInfo( Spell4Buff ) )
		if UnitAura( 'player', spellname ) then
			Spell4Frame:SetAlpha( 0.2 )
			Spell4Frame.t:SetTexture( select( 3, GetSpellInfo( Spell4Buff ) ) )
			break
		else
			Spell4Frame:SetAlpha( 1 )
			Spell4Frame.t:SetTexture( select( 3, GetSpellInfo( Spell4Buff ) ) )
		end
	end
	
	for i, Spell5Buff in pairs( Spell5Buff ) do
		local spellname = select( 1, GetSpellInfo( Spell5Buff ) )
		if UnitAura( 'player', spellname ) then
			Spell5Frame:SetAlpha( 0.2 )
			Spell5Frame.t:SetTexture( select( 3, GetSpellInfo( Spell5Buff ) ) )
			break
		else
			Spell5Frame:SetAlpha( 1 )
			Spell5Frame.t:SetTexture( select( 3, GetSpellInfo( Spell5Buff ) ) )
		end
	end	

	for i, Spell6Buff in pairs( Spell6Buff ) do
		local spellname = select( 1, GetSpellInfo( Spell6Buff ) )
		if UnitAura( 'player', spellname ) then
			Spell6Frame:SetAlpha( 0.2 )
			Spell6Frame.t:SetTexture(select(3, GetSpellInfo( Spell6Buff ) ) )
			break
		else
			Spell6Frame:SetAlpha( 1 )
			Spell6Frame.t:SetTexture( select( 3, GetSpellInfo( Spell6Buff ) ) )
		end
	end	
end

local bsize = ( ( E.MiniMapSize - 9 ) / 6 + (E.PixelMode and 3 or 4) )

local raidbuff_reminder = CreateFrame( 'Frame', 'RaidBuffReminder', Minimap )
raidbuff_reminder:SetTemplate( 'Default' )
raidbuff_reminder:Width( bsize )
raidbuff_reminder:Point( 'TOPLEFT', Minimap.backdrop, 'TOPRIGHT', ( E.PixelMode and -1 or 1 ), 0 )
raidbuff_reminder:Point( 'BOTTOMLEFT', Minimap.backdrop, 'BOTTOMRIGHT', ( E.PixelMode and -1 or 1 ), 0 )
raidbuff_reminder:RegisterEvent( 'ACTIVE_TALENT_GROUP_CHANGED' )
raidbuff_reminder:RegisterEvent( 'UNIT_INVENTORY_CHANGED' )
raidbuff_reminder:RegisterEvent( 'UNIT_AURA' )
raidbuff_reminder:RegisterEvent( 'PLAYER_REGEN_ENABLED' )
raidbuff_reminder:RegisterEvent( 'PLAYER_REGEN_DISABLED' )
raidbuff_reminder:RegisterEvent( 'PLAYER_ENTERING_WORLD' )
raidbuff_reminder:RegisterEvent( 'UPDATE_BONUS_ACTIONBAR' )
raidbuff_reminder:RegisterEvent( 'CHARACTER_POINTS_CHANGED' )
raidbuff_reminder:RegisterEvent( 'ZONE_CHANGED_NEW_AREA' )
raidbuff_reminder:SetScript( 'OnEvent', OnAuraChange )

local function CreateButton( name, relativeTo, firstbutton )
	local button = CreateFrame( 'Frame', name, RaidBuffReminder )
	button:SetTemplate( 'Default' )
	button:Size( bsize - ( E.PixelMode and 1 or 4 ) )
	if firstbutton == true then
		button:Point("TOP", relativeTo, "TOP", 0, -( E.PixelMode and 0 or 2 ) )
	else
		button:Point("TOP", relativeTo, "BOTTOM", 0, ( E.PixelMode and 1 or -1 ) )
	end
	button:SetFrameLevel( RaidBuffReminder:GetFrameLevel() + 2 )
	
	button.t = button:CreateTexture( name..'.t', 'OVERLAY' )
	button.t:SetTexCoord(unpack(E.TexCoords))
	button.t:SetInside()
	button.t:SetTexture( 'Interface\\Icons\\INV_Misc_QuestionMark' )
end

do
	CreateButton( 'FlaskFrame', RaidBuffReminder, true )
	CreateButton( 'FoodFrame', FlaskFrame, false )
	CreateButton( 'Spell3Frame', FoodFrame, false )
	CreateButton( 'Spell4Frame', Spell3Frame, false )
	CreateButton( 'Spell5Frame', Spell4Frame, false )
	CreateButton( 'Spell6Frame', Spell5Frame, false )
end