local E, C, L, DB = unpack(select(2, ...))

if not C["datatext"].stat1 or C["datatext"].stat1 == 0 then return end

local Stat = CreateFrame("Frame")
Stat:EnableMouse(true)
Stat:SetFrameStrata("MEDIUM")
Stat:SetFrameLevel(3)

local Text  = LeftChatDataPanel:CreateFontString(nil, "OVERLAY")
Text:SetFont(C["datatext"].font, C["datatext"].fontsize, C["datatext"].fontoutline)
E.PP(C["datatext"].stat1, Text)

local format = string.format
local targetlv, playerlv
local basemisschance, leveldifference, dodge, parry, block
local chanceString = "%.2f%%"
local modifierString = string.join("", "%d (+", chanceString, ")")
local manaRegenString = "%d / %d"
local displayNumberString = string.join("", "%s", E.ValColor, "%d|r")
local displayFloatString = string.join("", "%s", E.ValColor, "%.2f%%|r")
local spellpwr, avoidance, pwr
local haste, hasteBonus

local function UpdateTank(self)
	targetlv, playerlv = UnitLevel("target"), UnitLevel("player")

	if targetlv == -1 then
		basemisschance = (5 - (3*.2))
		leveldifference = 3
	elseif targetlv > playerlv then
		basemisschance = (5 - ((targetlv - playerlv)*.2))
		leveldifference = (targetlv - playerlv)
	elseif targetlv < playerlv and targetlv > 0 then
		basemisschance = (5 + ((playerlv - targetlv)*.2))
		leveldifference = (targetlv - playerlv)
	else
		basemisschance = 5
		leveldifference = 0
	end
	
	if select(2, UnitRace("player")) == "NightElf" then basemisschance = basemisschance + 2 end
	
	if leveldifference >= 0 then
		dodge = (GetDodgeChance()-leveldifference*.2)
		parry = (GetParryChance()-leveldifference*.2)
		block = (GetBlockChance()-leveldifference*.2)
	else
		dodge = (GetDodgeChance()+abs(leveldifference*.2))
		parry = (GetParryChance()+abs(leveldifference*.2))
		block = (GetBlockChance()+abs(leveldifference*.2))
	end
	
	if dodge <= 0 then dodge = 0 end
	if parry <= 0 then parry = 0 end
	if block <= 0 then block = 0 end
	
	if E.myclass == "DRUID" then
		parry = 0
		block = 0
	elseif E.myclass == "DEATHKNIGHT" then
		block = 0
	end
	avoidance = (dodge+parry+block+basemisschance)
	
	Text:SetFormattedText(displayFloatString, L.datatext_playeravd, avoidance)

	self:SetAllPoints(Text)
end

local function UpdateCaster(self)
	if GetSpellBonusHealing() > GetSpellBonusDamage(7) then
		spellpwr = GetSpellBonusHealing()
	else
		spellpwr = GetSpellBonusDamage(7)
	end
	
	Text:SetFormattedText(displayNumberString, L.datatext_playersp, spellpwr)

	self:SetAllPoints(Text)
end

local function UpdateMelee(self)
	local base, posBuff, negBuff = UnitAttackPower("player");
	local effective = base + posBuff + negBuff;
	local Rbase, RposBuff, RnegBuff = UnitRangedAttackPower("player");
	local Reffective = Rbase + RposBuff + RnegBuff;
		
	if E.myclass == "HUNTER" then
		pwr = Reffective
	else
		pwr = effective
	end
	
	Text:SetFormattedText(displayNumberString, L.datatext_playerap, pwr)      

	self:SetAllPoints(Text)
end

local int = 5	
local function Update(self, t)
	int = int - t
	if int > 0 then return end
	if E.Role == "Tank" then 
		UpdateTank(self)
	elseif E.Role == "Caster" then
		UpdateCaster(self)
	elseif E.Role == "Melee" then
		UpdateMelee(self)
	end
	int = 2
end

Stat:SetScript("OnUpdate", Update)
Update(Stat, 6)