local E, C, L, DB = unpack(select(2, ...))

if C['datatext']['Gold'] and C['datatext']['Gold'] > 0 then
	local Stat = CreateFrame('Frame')
	Stat:EnableMouse(true)
	Stat:SetFrameStrata('MEDIUM')
	Stat:SetFrameLevel(3)

	local Text = Stat:CreateFontString(nil, 'OVERLAY')
	Text:SetFont(C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'])
	E.PP(C['datatext']['Gold'], Text)

	local Profit	= 0
	local Spent		= 0
	local OldMoney	= 0
	local myPlayerRealm = GetCVar('realmName');

	local function formatMoney(money)
		local gold = floor(math.abs(money) / 10000)
		local silver = mod(floor(math.abs(money) / 100), 100)
		local copper = mod(floor(math.abs(money)), 100)
		if gold ~= 0 then
			return format('%s'..L.goldabbrev..' %s'..L.silverabbrev..' %s'..L.copperabbrev, gold, silver, copper)
		elseif silver ~= 0 then
			return format('%s'..L.silverabbrev..' %s'..L.copperabbrev, silver, copper)
		else
			return format('%s'..L.copperabbrev, copper)
		end
	end

	local function FormatTooltipMoney(money)
		local gold, silver, copper = abs(money / 10000), abs(mod(money / 100, 100)), abs(mod(money, 100))
		local cash = ''
		cash = format('%d'..L.goldabbrev..' %d'..L.silverabbrev..' %d'..L.copperabbrev, gold, silver, copper)	
		return cash
	end
	
	local function OnEvent(self, event)
		if event == 'PLAYER_ENTERING_WORLD' then
			OldMoney = GetMoney()
		end
		
		local NewMoney	= GetMoney()
		local Change = NewMoney-OldMoney
		
		if OldMoney>NewMoney then
			Spent = Spent - Change
		else
			Profit = Profit + Change
		end
		
		Text:SetText(formatMoney(NewMoney))
		self:SetAllPoints(Text)

		local myPlayerName  = UnitName('player');				
		if (ElvuiData == nil) then ElvuiData = {}; end
		if (ElvuiData.Gold == nil) then ElvuiData.Gold = {}; end
		if (ElvuiData.Gold[myPlayerRealm]==nil) then ElvuiData.Gold[myPlayerRealm]={}; end
		ElvuiData.Gold[myPlayerRealm][myPlayerName] = GetMoney();
			
		OldMoney = NewMoney
	end

	Stat:RegisterEvent('PLAYER_MONEY')
	Stat:RegisterEvent('SEND_MAIL_MONEY_CHANGED')
	Stat:RegisterEvent('SEND_MAIL_COD_CHANGED')
	Stat:RegisterEvent('PLAYER_TRADE_MONEY')
	Stat:RegisterEvent('TRADE_MONEY_CHANGED')
	Stat:RegisterEvent('PLAYER_ENTERING_WORLD')
	Stat:SetScript('OnMouseDown', function() OpenAllBags() end)
	Stat:SetScript('OnEvent', OnEvent)
	Stat:SetScript('OnEnter', function(self)
		if not InCombatLockdown() then
			local anchor, panel, xoff, yoff = E.DataTextTooltipAnchor(Text)
			GameTooltip:SetOwner(panel, anchor, xoff, yoff)
			GameTooltip:ClearLines()
			GameTooltip:AddLine(L.datatext_session)
			GameTooltip:AddDoubleLine(L.datatext_earned, formatMoney(Profit), 1, 1, 1, 1, 1, 1)
			GameTooltip:AddDoubleLine(L.datatext_spent, formatMoney(Spent), 1, 1, 1, 1, 1, 1)
			if Profit < Spent then
				GameTooltip:AddDoubleLine(L.datatext_deficit, formatMoney(Profit-Spent), 1, 0, 0, 1, 1, 1)
			elseif (Profit-Spent)>0 then
				GameTooltip:AddDoubleLine(L.datatext_profit, formatMoney(Profit-Spent), 0, 1, 0, 1, 1, 1)
			end
			GameTooltip:AddLine' '
		
			local totalGold = 0				
			GameTooltip:AddLine(L.datatext_character)			
			local thisRealmList = ElvuiData.Gold[myPlayerRealm];
			for k,v in pairs(thisRealmList) do
				GameTooltip:AddDoubleLine(k, FormatTooltipMoney(v), 1, 1, 1, 1, 1, 1)
				totalGold=totalGold+v;
			end 
			GameTooltip:AddLine' '
			GameTooltip:AddLine(L.datatext_server)
			GameTooltip:AddDoubleLine(L.datatext_totalgold, FormatTooltipMoney(totalGold), 1, 1, 1, 1, 1, 1)

			for i = 1, MAX_WATCHED_TOKENS do
				local name, count, extraCurrencyType, icon, itemID = GetBackpackCurrencyInfo(i)
				if name and i == 1 then
					GameTooltip:AddLine(' ')
					GameTooltip:AddLine(CURRENCY)
				end
				if name and count then GameTooltip:AddDoubleLine(name, count, 1, 1, 1) end
			end
			GameTooltip:Show()
		end
	end)
	Stat:SetScript('OnLeave', function() GameTooltip:Hide() end)

	local function RESETGOLD()		
		local myPlayerRealm = GetCVar('realmName');
		local myPlayerName  = UnitName('player');
		
		ElvuiData.Gold = {}
		ElvuiData.Gold[myPlayerRealm]={}
		ElvuiData.Gold[myPlayerRealm][myPlayerName] = GetMoney();	
	end
	SLASH_RESETGOLD1 = '/resetgold'
	SlashCmdList['RESETGOLD'] = RESETGOLD
end