local E, C, L, DB = unpack(select(2, ...))

if C['actionbar']['enable'] ~= true or C['actionbar']['microbar'] ~= true then return end

local microbuttons = {'CharacterMicroButton', 'SpellbookMicroButton', 'TalentMicroButton', 'AchievementMicroButton', 'QuestLogMicroButton', 'SocialsMicroButton', 'PVPMicroButton', 'LFDMicroButton', 'MainMenuMicroButton', 'HelpMicroButton'}

local f = CreateFrame('Frame', 'MicroParent', E.UIParent)
MicroParent.shown = false
if C['actionbar']['mousemicro'] == true then f:SetAlpha(0) end

local function CheckFade(self, elapsed)
	local mouseactive
	for i, button in pairs(microbuttons) do
		local b = _G[button]
		if b.mouseover == true then
			mouseactive = true
			if GameTooltip:IsShown() then
				GameTooltip:Hide()
			end
		end
	end
	
	if C['actionbar']['mousemicro'] ~= true then return end
	
	if MicroPlaceHolder.mouseover == true then
		mouseactive = true
		if GameTooltip:IsShown() then
			GameTooltip:Hide()
		end
	end
	
	if mouseactive == true then
		if MicroParent.shown ~= true then
			UIFrameFadeIn(MicroParent, 0.2)
			MicroParent.shown = true
		end
	else
		if MicroParent.shown == true then
			UIFrameFadeOut(MicroParent, 0.2)
			MicroParent.shown = false
		end
	end
end
f:SetScript('OnUpdate', CheckFade)

for i, button in pairs(microbuttons) do
	local m = _G[button]
	local pushed = m:GetPushedTexture()
	local normal = m:GetNormalTexture()
	local disabled = m:GetDisabledTexture()
	
	m:SetParent(MicroParent)
	m.SetParent = E.dummy

	m:SetHighlightTexture('')
	m.SetHighlightTexture = E.dummy

	local f = CreateFrame('Frame', nil, m)
	f:SetFrameLevel(1)
	f:SetFrameStrata('BACKGROUND')
	f:Point('BOTTOMLEFT', m, 'BOTTOMLEFT', 2, 0)
	f:Point('TOPRIGHT', m, 'TOPRIGHT', -2, -28)
	f:SetTemplate('Default', true)
	m.frame = f
	
	pushed:SetTexCoord(0.17, 0.87, 0.5, 0.908)
	pushed:ClearAllPoints()
	pushed:SetInside(m.frame)
	
	normal:SetTexCoord(0.17, 0.87, 0.5, 0.908)
	normal:ClearAllPoints()
	normal:SetInside(m.frame)
	
	if disabled then
		disabled:SetTexCoord(0.17, 0.87, 0.5, 0.908)
		disabled:ClearAllPoints()
		disabled:SetInside(m.frame)
	end
	
	m.mouseover = false
	m:HookScript('OnEnter', function(self) 
		self.frame:SetBackdropBorderColor(unpack(C['media']['valuecolor'])) 
		self.mouseover = true 
	end)
	m:HookScript('OnLeave', function(self) 
		self.frame:SetBackdropBorderColor(unpack(C['media']['bordercolor'])) 
		self.mouseover = false 
	end)
end

local x = CreateFrame('Frame', 'MicroPlaceHolder', MicroParent)
x:Point('TOPLEFT', CharacterMicroButton.frame, 'TOPLEFT')
x:Point('BOTTOMRIGHT', HelpMicroButton.frame, 'BOTTOMRIGHT')
x:EnableMouse(true)
x.mouseover = false
x:SetScript('OnEnter', function(self) self.mouseover = true end)
x:SetScript('OnLeave', function(self) self.mouseover = false end)

do
	MicroButtonPortrait:ClearAllPoints()
	MicroButtonPortrait:SetInside(CharacterMicroButton.frame)	
end

MicroParent:Point('TOPLEFT', E.UIParent, 'TOPLEFT', 2, -2)
MicroParent:Width(252)
MicroParent:Height(CharacterMicroButton:GetHeight() - 28)

CharacterMicroButton:ClearAllPoints()
CharacterMicroButton:SetPoint('BOTTOMLEFT', MicroParent, 'BOTTOMLEFT', 0,  0)
CharacterMicroButton.SetPoint = E.dummy
CharacterMicroButton.ClearAllPoints = E.dummy

E.CreateMover(MicroParent, 'MicroMover', L.actionbar_micromenu)