﻿local E, C, L, DB = unpack(select(2, ...))

if not C['actionbar']['enable'] == true or not C['actionbar']['petbarenable'] == true then return end

local bar = CreateFrame('Frame', 'ElvuiPetBar', E.UIParent, 'SecureHandlerStateTemplate')
local cols = ceil(10 / C['actionbar']['petbarbtnrows'])
if cols < 1 then cols = 1; end
if 10 < C['actionbar']['petbarbtnrows'] then
	C['actionbar']['petbarbtnrows'] = 10
end

bar:Size((C['actionbar']['petbarbtnsize'] + C['actionbar']['petbarspacing']) * cols, (C['actionbar']['petbarbtnsize'] + C['actionbar']['petbarspacing']) * C['actionbar']['petbarbtnrows'])
bar:ClearAllPoints()
bar:Point('BOTTOM', E.UIParent, 'BOTTOM', 0, 110)
E.CreateMover(bar, 'PetBarMover', L.actionbar_barpet, true)

function E.PositionBarPet(self)
	local b
	for i = 1, 10 do
		b = _G['PetActionButton'..i]
		local b2 = _G['PetActionButton'..i-1]
		b:SetSize(C['actionbar']['petbarbtnsize'], C['actionbar']['petbarbtnsize'])
		b:SetParent(ElvuiPetBar)
		b:ClearAllPoints()
		local row = math.floor(10 / C['actionbar']['petbarbtnrows'])
		local b3 = _G['PetActionButton'..i-row]
		local pre = i - 1

		if i <= 10 then
			if i == 1 then
				b:Point('TOPLEFT', bar, 'TOPLEFT')
			elseif pre % row == 0 and pre + row <= 10 then
				b:Point('TOP', b3, 'BOTTOM', 0, -C['actionbar']['petbarspacing'])
			elseif pre % row == 0 and pre + row > 10 then
				b:Hide()
			else
				b:Point('LEFT', b2, 'RIGHT', C['actionbar']['petbarspacing'], -0)
			end
		else
			b:Hide()
		end
		
		b:Show()
		self:SetAttribute('addchild', b)
	end
end
	
bar:RegisterEvent('PLAYER_LOGIN')
bar:RegisterEvent('PLAYER_CONTROL_LOST')
bar:RegisterEvent('PLAYER_CONTROL_GAINED')
bar:RegisterEvent('PLAYER_ENTERING_WORLD')
bar:RegisterEvent('PLAYER_FARSIGHT_FOCUS_CHANGED')
bar:RegisterEvent('PET_BAR_UPDATE')
bar:RegisterEvent('PET_BAR_UPDATE_USABLE')
bar:RegisterEvent('PET_BAR_UPDATE_COOLDOWN')
bar:RegisterEvent('PET_BAR_HIDE')
bar:RegisterEvent('UNIT_PET')
bar:RegisterEvent('UNIT_FLAGS')
bar:RegisterEvent('UNIT_AURA')
bar:SetScript('OnEvent', function(self, event, ...)
	if event == 'PLAYER_LOGIN' then	
		PetActionBarFrame.showgrid = 1
		
		E.PositionBarPet(self)
		RegisterStateDriver(self, 'visibility', '[pet,novehicleui,nobonusbar:5] show; hide')
		hooksecurefunc('PetActionBar_Update', E.ElvuiPetBarUpdate)
	elseif event == 'PET_BAR_UPDATE' or event == 'UNIT_PET' and arg1 == 'player' 
	or event == 'PLAYER_CONTROL_LOST' or event == 'PLAYER_CONTROL_GAINED' or event == 'PLAYER_FARSIGHT_FOCUS_CHANGED' or event == 'UNIT_FLAGS'
	or arg1 == 'pet' and (event == 'UNIT_AURA') then
		E.ElvuiPetBarUpdate()
	elseif event == 'PET_BAR_UPDATE_COOLDOWN' then
		PetActionBar_UpdateCooldowns()
	else
		E.StylePet()
	end
end)