﻿local E, C, L, DB = unpack(select(2, ...))

if not C['actionbar']['enable'] == true or not C['actionbar']['bar1enable'] == true then return end

local bar = CreateFrame('Frame', 'ElvuiMainMenuBar', E.UIParent, 'SecureHandlerStateTemplate')
local cols = ceil(C['actionbar']['bar1btnmax'] / C['actionbar']['bar1btnrows'])
if cols < 1 then cols = 1; end
if C['actionbar']['bar1btnmax'] < C['actionbar']['bar1btnrows'] then
	C['actionbar']['bar1btnrows'] = C['actionbar']['bar1btnmax'];
end

bar:SetSize((C['actionbar']['bar1btnsize'] + C['actionbar']['bar1xspacing']) * cols, (C['actionbar']['bar1btnsize'] + C['actionbar']['bar1yspacing']) * C['actionbar']['bar1btnrows'])
bar:SetParent(E.UIParent)
bar:ClearAllPoints()
bar:Point('BOTTOM', E.UIParent, 'BOTTOM', 0, 2)
E.CreateMover(bar, 'ActionBar1Mover', L.actionbar_bar1, true)

local Page = {
	['DRUID'] = '[bonusbar:1,nostealth] 7; [bonusbar:1,stealth] 8; [bonusbar:2] 8; [bonusbar:3] 9; [bonusbar:4] 10;',
	['WARRIOR'] = '[bonusbar:1] 7; [bonusbar:2] 8; [bonusbar:3] 9;',
	['PRIEST'] = '[bonusbar:1] 7;',
	['ROGUE'] = '[bonusbar:1] 7; [form:3] 7;',
	['DEFAULT'] = '[bonusbar:5] 11; [bar:2] 2; [bar:3] 3; [bar:4] 4; [bar:5] 5; [bar:6] 6;',
}

local function GetBar()
	local condition = Page['DEFAULT']
	local class = E.myclass
	local page = Page[class]
	if page then
		condition = condition..' '..page
	end
	condition = condition..' 1'
	return condition
end

if C['actionbar']['bar1enable'] then
	bar:SetScale(1);
	bar:SetAlpha(1);
else
	bar:SetScale(0.000001);
	bar:SetAlpha(0);
end

function E.PositionMainBar()	
	local b
	for i = 1, 12 do
		b = _G['ActionButton'..i]
		local b2 = _G['ActionButton'..i-1]
		b:Size(C['actionbar']['bar1btnsize'], C['actionbar']['bar1btnsize'])
		b:SetParent(ElvuiMainMenuBar)
		b:ClearAllPoints()
		local row = math.floor(C['actionbar']['bar1btnmax'] / C['actionbar']['bar1btnrows'])
		local b3 = _G['ActionButton'..i-row]
		local pre = i - 1
			
		if i <= C['actionbar'].bar1btnmax then
			if i == 1 then
				b:Point('TOPLEFT', bar, 'TOPLEFT')
			elseif pre % row == 0 and pre + row <= C['actionbar']['bar1btnmax'] then
				b:Point('TOP', b3, 'BOTTOM', 0, -C['actionbar']['bar1yspacing'])
			elseif pre % row == 0 and pre + row > C['actionbar']['bar1btnmax'] then
				b:Hide()
			else
				b:Point('LEFT', b2, 'RIGHT', C['actionbar']['bar1xspacing'], 0)
			end
		else
			b:Hide()
		end
	end
end

bar:RegisterEvent('PLAYER_LOGIN')
bar:RegisterEvent('KNOWN_CURRENCY_TYPES_UPDATE')
bar:RegisterEvent('CURRENCY_DISPLAY_UPDATE')
bar:RegisterEvent('BAG_UPDATE')
bar:RegisterEvent('ACTIVE_TALENT_GROUP_CHANGED')
bar:SetScript('OnEvent', function(self, event, ...)
	if event == 'PLAYER_LOGIN' then
		local button
		for i = 1, NUM_ACTIONBAR_BUTTONS do
			button = _G['ActionButton'..i]
			self:SetFrameRef('ActionButton'..i, button)
			button.SetAlpha = E.dummy
		end	

		self:Execute([[
			buttons = table.new()
			for i = 1, 12 do
				table.insert(buttons, self:GetFrameRef('ActionButton'..i))
			end
		]])

		self:SetAttribute('_onstate-page', [[ 
			for i, button in ipairs(buttons) do
				button:SetAttribute('actionpage', tonumber(newstate))
			end
		]])

		self:SetAttribute('_onstate-vehicleupdate', [[		
			if newstate == 's2' then
				self:GetParent():Hide()
			else
				self:GetParent():Show()
			end	
		]])
		
		RegisterStateDriver(self, 'page', GetBar())
		RegisterStateDriver(self, 'vehicleupdate', '[vehicleui] hide;show')
	elseif event == 'ACTIVE_TALENT_GROUP_CHANGED' then
		LoadAddOn('Blizzard_GlyphUI')
	else
		MainMenuBar_OnEvent(self, event, ...)
	end
end)