local E, C, L, DB = unpack(select(2, ...))
if C['skin']['enable'] ~= true or C['skin']['TalentUI'] ~= true then return end

local function LoadSkin()
	local TalentUIStrip = {'PlayerTalentFrame', 'PlayerTalentFrameStatusFrame', 'PlayerTalentFrameScrollFrame', 'PlayerTalentFramePointsBar', 'PlayerTalentFramePreviewBar', 'PlayerTalentFramePreviewBarFiller'}
	for _, object in pairs(TalentUIStrip) do
		_G[object]:StripTextures()
	end
	
	local TalentUIKill = {'PlayerTalentFramePortrait'}
	for _, texture in pairs(TalentUIKill) do
		_G[texture]:Kill()
	end

	local TalentUIButtons = {'PlayerTalentFrameActivateButton','PlayerTalentFrameLearnButton','PlayerTalentFrameResetButton'}
	for i = 1, #TalentUIButtons do
		_G[TalentUIButtons[i]]:StripTextures()
		E.SkinButton(_G[TalentUIButtons[i]])
	end

	for i=1, MAX_TALENT_TABS do
		local tab = _G['PlayerSpecTab'..i]
		if tab then
			local a = tab:GetRegions()
			a:Hide()
			tab:StripTextures()
			tab:GetNormalTexture():SetTexCoord(unpack(E.TexCoords))
			
			tab:GetNormalTexture():ClearAllPoints()
			tab:GetNormalTexture():SetInside()

			tab:CreateBackdrop('Default')
			tab.backdrop:SetAllPoints()
			tab:StyleButton(true)
		end
	end

	for i=1, 4 do
		E.SkinTab(_G['PlayerTalentFrameTab'..i])
	end

	for i=1, MAX_NUM_TALENTS do
		button = _G['PlayerTalentFrameTalent'..i]
		icon = _G['PlayerTalentFrameTalent'..i..'IconTexture']
		if ( button ) then
			button:StripTextures()
			button:SetTemplate('Default', true)
			button:StyleButton()
			
			icon:SetTexCoord(unpack(E.TexCoords))
			icon:ClearAllPoints()
			icon:SetInside()
		end
	end
	
	PlayerTalentFrame:CreateBackdrop('Transparent')
	PlayerTalentFrame.backdrop:Point('TOPLEFT', 10, -12)
	PlayerTalentFrame.backdrop:Point('BOTTOMRIGHT', -33, 76)
	
	E.SkinCloseButton(PlayerTalentFrameCloseButton)
	E.SkinScrollBar(PlayerTalentFrameScrollFrameScrollBar)
end

E.SkinFuncs['Blizzard_TalentUI'] = LoadSkin