local E, C, L, DB = unpack(select(2, ...))
if C['skin'].enable ~= true or C['skin']['Mail'] ~= true then return end

local function LoadSkin()
	local AllMailFrameStripTextures = {'MailFrame', 'InboxFrame', 'SendMailFrame', 'SendMailScrollFrame', 'OpenMailFrame', 'OpenMailScrollFrame'}
	for i = 1, #AllMailFrameStripTextures do
		_G[AllMailFrameStripTextures[i]]:StripTextures(true)
	end

	local AllMailFrameScrollbars = {'SendMailScrollFrameScrollBar', 'OpenMailScrollFrameScrollBar'}
	for i = 1, #AllMailFrameScrollbars do
		E.SkinScrollBar(_G[AllMailFrameScrollbars[i]])
	end

	local AllMailFrameInputs = {'SendMailNameEditBox', 'SendMailSubjectEditBox', 'SendMailMoneyGold', 'SendMailMoneySilver', 'SendMailMoneyCopper'}
	for i = 1, #AllMailFrameInputs do
		E.SkinEditBox(_G[AllMailFrameInputs[i]])
	end

	for i = 1, 2 do
		E.SkinTab(_G['MailFrameTab'..i])
	end

	local AllMailFrameButtons = {'SendMailMailButton', 'SendMailCancelButton', 'OpenMailReplyButton', 'OpenMailDeleteButton', 'OpenMailCancelButton', 'OpenMailReportSpamButton'}
	for i = 1, #AllMailFrameButtons do
		E.SkinButton(_G[AllMailFrameButtons[i]])
	end

	OpenMailLetterButton:StripTextures()
	OpenMailLetterButton:SetTemplate('Default', true)
	OpenMailLetterButton:StyleButton()
	OpenMailLetterButtonIconTexture:SetTexCoord(unpack(E.TexCoords))					
	OpenMailLetterButtonIconTexture:ClearAllPoints()
	OpenMailLetterButtonIconTexture:SetInside()
	
	OpenMailMoneyButton:StripTextures()
	OpenMailMoneyButton:SetTemplate('Default', true)
	OpenMailMoneyButton:StyleButton()
	OpenMailMoneyButtonIconTexture:SetTexCoord(unpack(E.TexCoords))					
	OpenMailMoneyButtonIconTexture:ClearAllPoints()
	OpenMailMoneyButtonIconTexture:SetInside()
	
	for i = 1, INBOXITEMS_TO_DISPLAY do
		local bg = _G['MailItem'..i]
		bg:StripTextures()
		bg:SetTemplate('Default')
		
		local bu = _G['MailItem'..i..'Button']
		bu:StripTextures()
		bu:SetTemplate('Default', true)
		bu:StyleButton()

		local ic = _G['MailItem'..i..'Button'..'Icon']
		ic:SetTexCoord(unpack(E.TexCoords))
		ic:ClearAllPoints()
		ic:SetInside()
	end

	local function MailFrameSkin()
		for i = 1, ATTACHMENTS_MAX_SEND do				
			local b = _G['SendMailAttachment'..i]
			if not b.skinned then
				b:StripTextures()
				b:SetTemplate('Default', true)
				b:StyleButton()
				b.skinned = true
			end
			local t = b:GetNormalTexture()
			if t then
				t:SetTexCoord(unpack(E.TexCoords))
				t:ClearAllPoints()
				t:SetInside()
			end
		end
	end
	hooksecurefunc('SendMailFrame_Update', MailFrameSkin)

	for i = 1, ATTACHMENTS_MAX_RECEIVE do
		local bu = _G['OpenMailAttachmentButton'..i]
		bu:StripTextures()
		bu:SetTemplate('Default', true)
		bu:StyleButton()
		
		local ic = _G['OpenMailAttachmentButton'..i..'IconTexture']
		ic:SetTexCoord(unpack(E.TexCoords))
		ic:ClearAllPoints()
		ic:SetInside()
	end

	OpenMailBodyText:SetTextColor(1, 1, 1)
	for _, v in pairs{'ItemLabel', 'Purchaser', 'BuyMode', 'SalePrice', 'Deposit', 'HouseCut', 'AmountReceived', 'NotYetSent', 'MoneyDelay'} do
		_G['OpenMailInvoice'..v]:SetTextColor(1, 1, 1)
	end
	
	MailFrame:CreateBackdrop('Transparent')
	MailFrame.backdrop:Point('TOPLEFT', 16, -12)
	MailFrame.backdrop:Point('BOTTOMRIGHT', -34, 74)
	E.SkinCloseButton(InboxCloseButton)
	
	OpenMailFrame:CreateBackdrop('Transparent')
	OpenMailFrame.backdrop:Point('TOPLEFT', 12, -12)
	OpenMailFrame.backdrop:Point('BOTTOMRIGHT', -34, 74)
	E.SkinCloseButton(OpenMailCloseButton)
	
	E.SkinNextPrevButton(InboxPrevPageButton)
	E.SkinNextPrevButton(InboxNextPageButton)
end

tinsert(E.SkinFuncs['ElvUI'], LoadSkin)