local E, C, L, DB = unpack(select(2, ...))
if C['skin'].enable ~= true or C['skin']['Friends'] ~= true then return end

local function LoadSkin()
	local AllFriendsFrameStripTextures = {'FriendsFrame', 'FriendsListFrame', 'FriendsTabHeader', 'WhoFrame', 'WhoListScrollFrame', 'GuildFrame', 'GuildListScrollFrame', 'GuildFrameLFGFrame', 'GuildInfoFrame', 'GuildInfoTextBackground', 'GuildEventLogFrame', 'GuildEventFrame', 'GuildMemberDetailFrame', 'GuildMemberNoteBackground', 'GuildMemberOfficerNoteBackground', 'GuildControlPopupFrame', 'ChannelFrame', 'ChannelFrameVerticalBar', 'ChannelRosterScrollFrame', 'ChannelFrameDaughterFrame', 'ChannelFrameDaughterFrameChannelName', 'RaidFrame', 'RaidInfoFrame', 'RaidInfoInstanceLabel', 'RaidInfoIDLabel'}
	for i = 1, #AllFriendsFrameStripTextures do
		_G[AllFriendsFrameStripTextures[i]]:StripTextures(true)
	end

	local AllFriendsFrameDropDowns = {'FriendsFrameStatusDropDown', 'WhoFrameDropDown', 'GuildControlPopupFrameDropDown'}
	for i = 1, #AllFriendsFrameDropDowns do
		E.SkinDropDownBox(_G[AllFriendsFrameDropDowns[i]])
	end

	local AllFriendsFrameScrollbars = {'FriendsFrameFriendsScrollFrameScrollBar', 'WhoListScrollFrameScrollBar', 'GuildListScrollFrameScrollBar', 'GuildEventLogScrollFrameScrollBar', 'GuildInfoFrameScrollFrameScrollBar', 'ChannelRosterScrollFrameScrollBar', 'RaidInfoScrollFrameScrollBar'}
	for i = 1, #AllFriendsFrameScrollbars do
		E.SkinScrollBar(_G[AllFriendsFrameScrollbars[i]])
	end

	local AllFriendsFrameInputs = {'GuildControlPopupFrameEditBox', 'GuildControlWithdrawGoldEditBox', 'GuildControlWithdrawItemsEditBox'}
	for i = 1, #AllFriendsFrameInputs do
		E.SkinEditBox(_G[AllFriendsFrameInputs[i]])
	end

	local AllFriendsFrameCheckBoxes = {'GuildFrameLFGButton'}
	for i = 1, #AllFriendsFrameCheckBoxes do
		E.SkinCheckBox(_G[AllFriendsFrameCheckBoxes[i]])
	end

	for i = 1, 2 do
		_G["FriendsTabHeaderTab"..i]:StripTextures()
	end
	for i = 1, 5 do
		E.SkinTab(_G["FriendsFrameTab"..i])
	end
	for i = 1, 4 do
		_G["WhoFrameColumnHeader"..i]:StripTextures()
		_G["GuildFrameColumnHeader"..i]:StripTextures()
		_G["GuildFrameGuildStatusColumnHeader"..i]:StripTextures()
	end

	local AllFriendsFrameButtons = {'FriendsFrameAddFriendButton', 'FriendsFrameSendMessageButton', 'FriendsFrameIgnorePlayerButton', 'FriendsFrameUnsquelchButton', 'WhoFrameWhoButton', 'WhoFrameAddFriendButton', 'WhoFrameGroupInviteButton', 'GuildFrameGuildInformationButton', 'GuildFrameAddMemberButton', 'GuildFrameControlButton', 'GuildMemberRemoveButton', 'GuildMemberGroupInviteButton', 'GuildInfoGuildEventButton', 'GuildInfoSaveButton', 'GuildInfoCancelButton', 'GuildEventLogCancelButton', 'GuildControlPopupAcceptButton', 'GuildControlPopupFrameCancelButton', 'ChannelFrameNewButton', 'ChannelFrameDaughterFrameOkayButton', 'ChannelFrameDaughterFrameCancelButton', 'RaidFrameConvertToRaidButton', 'RaidFrameRaidInfoButton', 'RaidInfoExtendButton', 'RaidInfoCancelButton', 'RaidFrameNotInRaidRaidBrowserButton'}
	for i = 1, #AllFriendsFrameButtons do
		E.SkinButton(_G[AllFriendsFrameButtons[i]])
	end

	FriendsFrame:CreateBackdrop('Transparent')
	FriendsFrame.backdrop:Point('TOPLEFT', 10, -12)
	FriendsFrame.backdrop:Point('BOTTOMRIGHT', -31, 76)
	E.SkinCloseButton(FriendsFrameCloseButton)
	FriendsFrameStatusDropDown:ClearAllPoints()
	FriendsFrameStatusDropDown:SetPoint("TOPLEFT", FriendsFrame, "TOPLEFT", 10, -28)
	
	for i = 1, FRIENDS_TO_DISPLAY do
		local FriendsFrameFriendsScrollFrameButtons = _G["FriendsFrameFriendsScrollFrameButton"..i]
		FriendsFrameFriendsScrollFrameButtons.background:Hide()
		FriendsFrameFriendsScrollFrameButtons:SetHighlightTexture(C['media']['blank'])
		FriendsFrameFriendsScrollFrameButtons:GetHighlightTexture():SetVertexColor(.24, .56, 1, .2)
	end
	E.SkinNextPrevButton(GuildFrameGuildListToggleButton)
	
	GuildInfoFrame:CreateBackdrop('Transparent')
	GuildInfoFrame:SetPoint("TOPLEFT", GuildFrame, "TOPRIGHT", -30, -14)
	E.SkinCloseButton(GuildInfoCloseButton)
	
	GuildEventLogFrame:CreateBackdrop('Transparent')
	GuildEventLogFrame:SetPoint("TOPLEFT", GuildFrame, "TOPRIGHT", -30, -14)
	E.SkinCloseButton(GuildEventLogCloseButton)
	
	GuildMemberDetailFrame:CreateBackdrop('Transparent')
	GuildMemberDetailFrame:SetPoint("TOPLEFT", GuildFrame, "TOPRIGHT", -30, -14)
	E.SkinCloseButton(GuildMemberDetailCloseButton)
	
	GuildControlPopupFrame:CreateBackdrop('Transparent')
	GuildControlPopupFrame.backdrop:Point('TOPLEFT', 3, -6)
	GuildControlPopupFrame.backdrop:Point('BOTTOMRIGHT', -28, 27)
	GuildControlPopupFrame:SetPoint("TOPLEFT", GuildFrame, "TOPRIGHT", -22, -6)
	
	for i = 1, MAX_DISPLAY_CHANNEL_BUTTONS do
		_G["ChannelButton"..i]:StripTextures()
		_G["ChannelButton"..i]:StyleButton()
	end
	
	ChannelFrameDaughterFrame:CreateBackdrop('Transparent')
	ChannelFrameDaughterFrame.backdrop:Point('TOPLEFT', 5, -6)
	ChannelFrameDaughterFrame.backdrop:Point('BOTTOMRIGHT', -5, 0)

	E.SkinCloseButton(ChannelFrameDaughterFrameDetailCloseButton)
	ChannelFrameDaughterFrameChannelName:StripTextures()
	ChannelFrameDaughterFrameChannelName:CreateBackdrop('Transparent')
	ChannelFrameDaughterFrameChannelPassword:StripTextures()
	ChannelFrameDaughterFrameChannelPassword:CreateBackdrop('Transparent')
	
	RaidInfoFrame:CreateBackdrop('Transparent')
	E.SkinCloseButton(RaidInfoCloseButton)
end

tinsert(E.SkinFuncs['ElvUI'], LoadSkin)