﻿local E, C, L, DB = unpack( select( 2, ... ) )

local BunnyUIChat = CreateFrame( 'Frame', 'BunnyUIChat' )
local _G = _G
local origs = {}
local type = type
local CreatedFrames = 0

local tabTexs = {
	'',
	'Selected',
	'Highlight'
}

local AddMessage = function( self, text, ... )
	if( type( text ) == 'string' ) then
		text = text:gsub( '|h%[(%d+)%. .-%]|h', '|h[%1]|h' )
	end
	return origs[self]( self, text, ... )
end

FriendsMicroButton:Kill()
ChatFrameMenuButton:Kill()

local function SetChatStyle( frame )
	if frame.styled then return end
	
	frame.IgnoreFixDimensions = true;

	local id = frame:GetID()
	local chat = frame:GetName()
	local tab = _G[chat..'Tab']
	local editbox = _G[chat..'EditBox']
	
	for _, texName in pairs(tabTexs) do
		_G[tab:GetName()..texName..'Left']:Kill()
		_G[tab:GetName()..texName..'Middle']:Kill()
		_G[tab:GetName()..texName..'Right']:Kill()	
	end
	
	tab:SetAlpha(1)
	tab.SetAlpha = UIFrameFadeRemoveFrame	
	
	_G[chat..'TabText']:SetTextColor( unpack( C['media']['valuecolor'] ) )
	_G[chat..'TabText']:SetFont( C['chat']['font'], C['chat']['fontsize'], C['chat']['fontoutline'] )
	_G[chat..'TabText'].OldSetTextColor = _G[chat..'TabText'].SetTextColor 
	_G[chat..'TabText'].SetTextColor = E.dummy
	
	frame:SetClampRectInsets( 0,0,0,0 )
	frame:SetClampedToScreen( false )
	if frame:IsMovable() then
		frame:SetUserPlaced( true )
	end
	frame:StripTextures( true )
	_G[chat..'ButtonFrame']:Kill()
	
	local a, b, c = select( 6, editbox:GetRegions() ); a:Kill(); b:Kill(); c:Kill()
	_G[format( editbox:GetName()..'FocusLeft', id )]:Kill()
	_G[format( editbox:GetName()..'FocusMid', id )]:Kill()
	_G[format( editbox:GetName()..'FocusRight', id )]:Kill()	
	editbox:SetTemplate( 'Default', true )
	editbox:SetAltArrowKeyMode( false) 
	editbox:HookScript( 'OnEditFocusGained', function( self ) self:Show(); if not LeftChatPanel:IsShown() then LeftChatPanel.editboxforced = true; LeftChatToggleButton:GetScript( 'OnEnter' )( LeftChatToggleButton ) end end )
	editbox:HookScript( 'OnEditFocusLost', function( self ) if LeftChatPanel.editboxforced then LeftChatPanel.editboxforced = nil; if LeftChatPanel:IsShown() then LeftChatToggleButton:GetScript( 'OnLeave' )( LeftChatToggleButton ) end end self:Hide() end )	
	editbox:SetAllPoints( LeftChatDataPanel )
	
	hooksecurefunc( 'ChatEdit_UpdateHeader', function()
		local type = editbox:GetAttribute( 'chatType' )
		if ( type == 'CHANNEL' ) then
			local id = GetChannelName( editbox:GetAttribute( 'channelTarget' ) )
			if id == 0 then
				editbox:SetBackdropBorderColor( unpack( C['media']['bordercolor'] ) )
			else
				editbox:SetBackdropBorderColor( ChatTypeInfo[type..id].r,ChatTypeInfo[type..id].g,ChatTypeInfo[type..id].b )
			end
		else
			editbox:SetBackdropBorderColor( ChatTypeInfo[type].r,ChatTypeInfo[type].g,ChatTypeInfo[type].b )
		end
	end )
	
	for j = 1, #CHAT_FRAME_TEXTURES do
		_G[chat..CHAT_FRAME_TEXTURES[j]]:SetTexture(nil)
	end

	if _G[chat] == _G['ChatFrame2'] then
		FCF_SetWindowName(_G[chat], 'Журнал')
	end

	if _G[chat] ~= _G['ChatFrame2'] then
		origs[_G[chat]] = _G[chat].AddMessage
		_G[chat].AddMessage = AddMessage
	else
		CombatLogQuickButtonFrame_Custom:StripTextures()
		CombatLogQuickButtonFrame_CustomProgressBar:ClearAllPoints()
		CombatLogQuickButtonFrame_CustomProgressBar:SetPoint( 'TOPLEFT', CombatLogQuickButtonFrame_Custom, 2, -2 )
		CombatLogQuickButtonFrame_CustomProgressBar:SetPoint( 'BOTTOMRIGHT', CombatLogQuickButtonFrame_Custom, -2, 2 )
		CombatLogQuickButtonFrame_CustomProgressBar:SetStatusBarTexture( C['media']['normTex'] )
	end
	
	CreatedFrames = id
	frame.styled = true
	E.ChatCopyButtons(id)
end

local function SetupChat( self )	
	for i = 1, NUM_CHAT_WINDOWS do
		local frame = _G[format( 'ChatFrame%s', i )]
		SetChatStyle( frame )
		FCFTab_UpdateAlpha( frame )
	end
	
	local var
	if C['chat']['sticky'] == true then
		var = 1
	else
		var = 0
	end

	ChatTypeInfo.WHISPER.sticky = var
	ChatTypeInfo.BN_WHISPER.sticky = var
	ChatTypeInfo.OFFICER.sticky = var
	ChatTypeInfo.RAID_WARNING.sticky = var
	ChatTypeInfo.CHANNEL.sticky = var
end

local insidetab = false
local function SetupChatFont( self )
	for i = 1, NUM_CHAT_WINDOWS do
		local chat = _G[format( 'ChatFrame%s', i )]
		local tab = _G[format( 'ChatFrame%sTab', i )]
		local id = chat:GetID()
		local name = FCF_GetChatWindowInfo( id )
		local point = GetChatWindowSavedPosition( id )
		local button = _G[format( 'ButtonCF%d', i )]
		local _, _, _, _, _, _, _, _, docked, _ = GetChatWindowInfo( id )
		
		chat:SetFrameStrata( 'LOW' )
		
		local _, fontSize = FCF_GetChatWindowInfo( id )
		
		if fontSize < 12 then		
			FCF_SetChatWindowFontSize( nil, chat, 12 )
		else
			FCF_SetChatWindowFontSize( nil, chat, fontSize )
		end
		
		tab:HookScript( 'OnEnter', function() insidetab = true end )
		tab:HookScript( 'OnLeave', function() insidetab = false end )	
	end
end
hooksecurefunc( 'FCF_OpenNewWindow', SetupChatFont )
hooksecurefunc( 'FCF_DockFrame', SetupChatFont )

BunnyUIChat:RegisterEvent( 'ADDON_LOADED' )
BunnyUIChat:RegisterEvent( 'PLAYER_ENTERING_WORLD' )
BunnyUIChat:SetScript( 'OnEvent', function( self, event, ... )
	local addon = ...
	if event == 'ADDON_LOADED' then
		if addon == 'Blizzard_CombatLog' then
			self:UnregisterEvent( 'ADDON_LOADED' )
			SetupChat( self )
		end
	elseif event == 'PLAYER_ENTERING_WORLD' then
		self:UnregisterEvent( 'PLAYER_ENTERING_WORLD' )
		SetupChatFont( self )
		GeneralDockManager:SetParent( LeftChatPanel )
	end
end)

BunnyUIChat:SetScript( 'OnUpdate', function( self, elapsed )
	if ( InCombatLockdown() and not override and self.initialMove ) or ( IsMouseButtonDown( 'LeftButton' ) and not override ) then return end

	RightChatPanel:Size( C['chat']['chatwidth'], C['chat']['chatheight'] )
	LeftChatPanel:Size( C['chat']['chatwidth'], C['chat']['chatheight'] )
		
	local chat, chatbg, tab, id, point, button, isDocked, chatFound
	for _, frameName in pairs( CHAT_FRAMES ) do
		chat = _G[frameName]
		id = chat:GetID()
		point = GetChatWindowSavedPosition(id)
		
		if point == 'BOTTOMRIGHT' and chat:IsShown() then
			chatFound = true
			break
		end
	end	

	if chatFound then
		self.RightChatWindowID = id
	else
		self.RightChatWindowID = nil
	end

	for i=1, CreatedFrames do
		local BASE_OFFSET = 60
		if E.PixelMode then
			BASE_OFFSET = BASE_OFFSET - 3
		end	
		chat = _G[format( 'ChatFrame%d', i )]
		chatbg = format( 'ChatFrame%dBackground', i )
		button = _G[format( 'ButtonCF%d', i )]
		id = chat:GetID()
		tab = _G[format( 'ChatFrame%sTab', i )]
		point = GetChatWindowSavedPosition( id )
		_, _, _, _, _, _, _, _, isDocked, _ = GetChatWindowInfo( id )		
		
		if id > NUM_CHAT_WINDOWS then
			if point == nil then
				point = select( 1, chat:GetPoint() )
			end
			if select( 2, tab:GetPoint() ):GetName() ~= bg then
				isDocked = true
			else
				isDocked = false
			end	
		end	
		
		if not chat.isInitialized then return end
			
		if point == 'BOTTOMRIGHT' and chat:IsShown() and not ( id > NUM_CHAT_WINDOWS ) and id == self.RightChatWindowID then
			if id ~= 2 then
				chat:ClearAllPoints()
				chat:SetPoint( 'BOTTOMLEFT', RightChatDataPanel, 'TOPLEFT', 1, 3 )
				chat:SetSize( C['chat']['chatwidth'] - 11, C['chat']['chatheight'] - BASE_OFFSET )
			else
				chat:ClearAllPoints()
				chat:SetPoint('BOTTOMLEFT', RightChatDataPanel, 'TOPLEFT', 1, 3 )
				chat:SetSize( C['chat']['chatwidth'] - 11, C['chat']['chatheight'] - BASE_OFFSET - CombatLogQuickButtonFrame_Custom:GetHeight() )			
			end
			FCF_SavePositionAndDimensions( chat )			
			
			tab:SetParent( RightChatPanel )
			chat:SetParent( tab )
			
		elseif not isDocked and chat:IsShown() then
			tab:SetParent( E.UIParent )
			chat:SetParent( E.UIParent )
		else
			if id ~= 2 and not ( id > NUM_CHAT_WINDOWS ) then
				chat:ClearAllPoints()
				chat:Point( 'BOTTOMLEFT', LeftChatToggleButton, 'TOPLEFT', 1, 3 )
				chat:SetSize( C['chat']['chatwidth'] - 11, C['chat']['chatheight'] - BASE_OFFSET )
				FCF_SavePositionAndDimensions( chat )		
			end
			chat:SetParent( LeftChatPanel )
			tab:SetParent( GeneralDockManager )
		end
	end
	
	self.initialMove = true;
end)

local lines = {}
local frame = nil
local editBox = nil
local isf = nil

local sizes = {
	":14:14",
	":16:16",
	":12:20",
	":14",
}

local function CreatCopyFrame()
	frame = CreateFrame( 'Frame', 'CopyFrame', E.UIParent )
	frame:SetTemplate( 'Transparent' )
	frame:SetHeight( 200 )
	frame:SetScale( 1 )
	frame:SetPoint('BOTTOMLEFT', ElvuiActionBarBackground, 'BOTTOMLEFT', 0, 0)
	frame:SetPoint('BOTTOMRIGHT', ElvuiActionBarBackground, 'BOTTOMRIGHT', 0, 0)
	frame:Hide()
	frame:EnableMouse( true )
	frame:SetFrameStrata( 'DIALOG' )

	local scrollArea = CreateFrame( 'ScrollFrame', 'CopyScroll', frame, 'UIPanelScrollFrameTemplate' )
	scrollArea:SetPoint( 'TOPLEFT', frame, 'TOPLEFT', 8, -30 )
	scrollArea:SetPoint( 'BOTTOMRIGHT', frame, 'BOTTOMRIGHT', -30, 8 )
	
	E.SkinScrollBar( CopyScrollScrollBar )

	editBox = CreateFrame( 'EditBox', 'CopyBox', frame )
	editBox:SetMultiLine( true )
	editBox:SetMaxLetters( 99999 )
	editBox:EnableMouse( true )
	editBox:SetAutoFocus( false )
	editBox:SetFontObject( ChatFontNormal )
	editBox:SetWidth( scrollArea:GetWidth() )
	editBox:SetHeight( 200 )
	editBox:SetScript( 'OnEscapePressed', function()
		frame:Hide()
	end)
	
	editBox:SetScript( 'OnTextSet', function( self )
		local text = self:GetText()
		
		for _, size in pairs( sizes ) do
			if string.find( text, size ) then
				self:SetText( string.gsub( text, size, ':12:12' ) )
			end		
		end
	end)

	scrollArea:SetScrollChild( editBox )

	local close = CreateFrame( 'Button', 'CopyCloseButton', frame, 'UIPanelCloseButton' )
	close:SetPoint( 'TOPRIGHT', frame, 'TOPRIGHT' )
	close:EnableMouse(true)
	close:SetScript( 'OnMouseUp', function()
		frame:Hide()
	end)
	
	E.SkinCloseButton( close )
	
	isf = true
end

local function GetLines( ... )
	local ct = 1
	for i = select( '#', ... ), 1, -1 do
		local region = select( i, ... )
		if region:GetObjectType() == 'FontString' then
			lines[ct] = tostring( region:GetText() )
			ct = ct + 1
		end
	end
	return ct - 1
end

local function Copy( cf )
	local _, size = cf:GetFont()
	FCF_SetChatWindowFontSize( cf, cf, 0.01 )
	local lineCt = GetLines( cf:GetRegions() )
	local text = table.concat( lines, "\n", 1, lineCt )
	FCF_SetChatWindowFontSize( cf, cf, size )
	if not isf then CreatCopyFrame() end
	if frame:IsShown() then frame:Hide() return end
	frame:Show()
	editBox:SetText( text )
end

function E.ChatCopyButtons( id )
	local cf = _G[format( 'ChatFrame%d',  id )]
	local tab = _G[format( 'ChatFrame%dTab', id )]
	local name = FCF_GetChatWindowInfo( id )
	local point = GetChatWindowSavedPosition( id )
	local _, fontSize = FCF_GetChatWindowInfo( id )
	local _, _, _, _, _, _, _, _, docked, _ = GetChatWindowInfo( id )
	local button = _G[format( 'ButtonCF%d', id )]
	
	if not button then
		local button = CreateFrame( 'Button', format( 'ButtonCF%d', id ), cf )
		button:SetHeight( 22 )
		button:SetWidth( 20 )
		button:SetAlpha( 0 )
		button:SetPoint( 'TOPRIGHT', 0, 0 )
		button:SetTemplate( 'Default', true )
		
		local buttontex = button:CreateTexture( nil, 'OVERLAY' )
		buttontex:SetPoint( 'TOPLEFT', button, 'TOPLEFT', 2, -2 )
		buttontex:SetPoint( 'BOTTOMRIGHT', button, 'BOTTOMRIGHT', -2, 2 )
		buttontex:SetTexture( [[Interface\AddOns\ElvUI\media\textures\copy.tga]] )
		
		if id == 1 then
			button:SetScript( 'OnMouseUp', function( self, btn )
				if btn == 'RightButton' then
					ToggleFrame( ChatMenu )
				else
					Copy( cf )
				end
			end)
		else
			button:SetScript( 'OnMouseUp', function( self, btn )
				Copy( cf )
			end)		
		end
		
		button:SetScript( 'OnEnter', function() 
			button:SetAlpha( 1 ) 
		end)
		button:SetScript( 'OnLeave', function() button:SetAlpha( 0 ) end )
	end
end

local ScrollLines = 3
function FloatingChatFrame_OnMouseScroll( self, delta )
	if delta < 0 then
		if IsShiftKeyDown() then
			self:ScrollToBottom()
		else
			for i = 1, ScrollLines do
				self:ScrollDown()
			end
		end
	elseif delta > 0 then
		if IsShiftKeyDown() then
			self:ScrollToTop()
		else
			for i = 1, ScrollLines do
				self:ScrollUp()
			end
		end
	end
end

if C['chat']['whisper'] then
	local SoundSys = CreateFrame( 'Frame' )
	SoundSys:RegisterEvent( 'CHAT_MSG_WHISPER' )
	SoundSys:RegisterEvent( 'CHAT_MSG_BN_WHISPER' )
	SoundSys:HookScript( 'OnEvent', function( self, event, ... )
		if event == 'CHAT_MSG_WHISPER' or 'CHAT_MSG_BN_WHISPER' then
			PlaySoundFile( C['chat']['whisper'] )
		end
	end)
end