﻿local E, C, L, DB = unpack(select(2, ...))

StaticPopupDialogs["DISABLE_UI"] = {
	text = L.popup_disableui,
	button1 = ACCEPT,
	button2 = CANCEL,
	OnAccept = DisableElvui,
	timeout = 0,
	whileDead = 1,
	preferredIndex = 3
}

StaticPopupDialogs["RELOAD_UI"] = {
	text = L.popup_reloadui,
	button1 = ACCEPT,
	button2 = CANCEL,
	OnAccept = function() ReloadUI() end,
	timeout = 0,
	whileDead = 1,
	preferredIndex = 3
}

StaticPopupDialogs["RESET_UF"] = {
	text = L.popup_resetuf,
	button1 = YES,
	button2 = NO,
	OnAccept = function() E.ResetUF() ReloadUI() end,
	timeout = 0,
	whileDead = 1,
	preferredIndex = 3
}

StaticPopupDialogs["BUY_BANK_SLOT"] = {
	text = CONFIRM_BUY_BANK_SLOT,
	button1 = YES,
	button2 = NO,
	OnAccept = function(self)
		PurchaseSlot()
	end,
	OnShow = function(self)
		MoneyFrame_Update(self.moneyFrame, GetBankSlotCost())
	end,
	hasMoneyFrame = 1,
	timeout = 0,
	hideOnEscape = 1,
	preferredIndex = 3
}

StaticPopupDialogs["CANNOT_BUY_BANK_SLOT"] = {
	text = L.bags_noslots,
	button1 = ACCEPT,
	timeout = 0,
	whileDead = 1,	
	preferredIndex = 3
}

StaticPopupDialogs["NO_BANK_BAGS"] = {
	text = L.bags_need_purchase,
	button1 = ACCEPT,
	timeout = 0,
	whileDead = 1,	
	preferredIndex = 3
}

StaticPopupDialogs['APRIL_FOOLS'] = {
	text = 'Ваши настройки были оптимизированы для лучшей производительности.',
	button1 = ACCEPT,
	OnAccept = function() 
		FoolsDay = true
		ReloadUI()
	end,
	timeout = 0,
	whileDead = 1,	
}