local E, C, L, DB = unpack(select(2, ...))

E.dummy = function() return end
E.myname, _ = UnitName("player")
E.myrealm = GetRealmName()
_, E.myclass = UnitClass("player")
E.version = GetAddOnMetadata("ElvUI", "Version")
E.patch = GetBuildInfo()
E.level = UnitLevel("player")
E.IsElvsEdit = true
E.resolution = GetCVar('gxResolution')
E.screenheight = tonumber(string.match(E.resolution, "%d+x(%d+)"))
E.screenwidth = tonumber(string.match(E.resolution, "(%d+)x+%d"))
E.UIParent = CreateFrame('Frame', 'ElvUIParent', UIParent)
E.UIParent:SetFrameLevel(E.UIParent:GetFrameLevel())
E.UIParent:SetFrameStrata(E.UIParent:GetFrameStrata())
E.UIParent:SetPoint('CENTER', UIParent, 'CENTER')
E.UIParent:SetSize(UIParent:GetSize())
-- Tables
E["frames"] = {};
E.TexCoords = {.08, .92, .08, .92}
E.Spacing = 1;
E.Border = 2;
E.PixelMode = false;

if C.general.pixelPerfect then
	E.Border = 1;
	E.Spacing = 0;
	E.PixelMode = true;
end

BINDING_HEADER_ELVUI = GetAddOnMetadata("ElvUI", "Title")

E.HiddenFrame = CreateFrame('Frame')
E.HiddenFrame:Hide()
local RollUpdater = CreateFrame("Frame")
local function CheckRoll(self, event, unit)
	if event == "UNIT_AURA" and unit ~= "player" then return end
	if (E.myclass == "PALADIN" and UnitBuff("player", GetSpellInfo(25780))) and GetCombatRatingBonus(CR_DEFENSE_SKILL) > 100 or 
	(E.myclass == "WARRIOR" and GetBonusBarOffset() == 2) or 
	(E.myclass == "DEATHKNIGHT" and UnitBuff("player", GetSpellInfo(48263))) or
	(E.myclass == "DRUID" and GetBonusBarOffset() == 3) then
		E.Role = "Tank"
	else
		local playerint = select(2, UnitStat("player", 4))
		local playeragi	= select(2, UnitStat("player", 2))
		local base, posBuff, negBuff = UnitAttackPower("player");
		local playerap = base + posBuff + negBuff;

		if ((playerap > playerint) or (playeragi > playerint)) and not (UnitBuff("player", GetSpellInfo(24858)) or UnitBuff("player", GetSpellInfo(65139))) then
			E.Role = "Melee"
		else
			E.Role = "Caster"
		end
	end
	
	if event == "PLAYER_ENTERING_WORLD" then
		if E.myclass ~= "WARRIOR" and  E.myclass ~= "DRUID" then
			RollUpdater:UnregisterEvent("UPDATE_BONUS_ACTIONBAR")	
		end
		RollUpdater:UnregisterEvent("PLAYER_ENTERING_WORLD")
	end
end	
RollUpdater:RegisterEvent("PLAYER_ENTERING_WORLD")
RollUpdater:RegisterEvent("UNIT_AURA")
RollUpdater:RegisterEvent("UPDATE_BONUS_ACTIONBAR")
RollUpdater:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
RollUpdater:RegisterEvent("CHARACTER_POINTS_CHANGED")
RollUpdater:RegisterEvent("UNIT_INVENTORY_CHANGED")
RollUpdater:SetScript("OnEvent", CheckRoll)
CheckRoll()