EPF = {};
EPF.Funcs = {};

function EPF.Funcs.Initialize()
	-- Register Events
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("PLAYER_LEVEL_UP");
	
	-- Default Variables
	EPF.Vars = {};
	EPF.Vars.Version = 1.3;
	EPF.Vars.Mode = 1;
	EPF.Vars.DK = 1;
	EPF.Vars.Faction = 0;
	EPF.Vars.Debug = 1;
	EPF.Vars.Loaded = false;
	
	-- Slash Commands
	SLASH_EPF1 = "/epf";
	SLASH_EPF2 = "/eliteplayerframe";
	
	-- Tables
	EPF.Tables = {};
	-- Slash Command Options
	EPF.Tables.Commands = {
		[-1] = {
			["ID"] = -1,
			["Name"] = "null",
		},
		[0] = {
			["ID"] = 0,
			["Name"] = "help",
		},
		[1] = {
			["ID"] = 1,
			["Name"] = "mode",
		},
		[2] = {
			["ID"] = 2,
			["Name"] = "dk",
		},
		[3] = {
			["ID"] = 3,
			["Name"] = "faction",
		},
		[4] = {
			["ID"] = 4,
			["Name"] = "info",
		},
		[5] = {
			["ID"] = 5,
			["Name"] = "debug",
		},
		[6] = {
			["ID"] = 6,
			["Name"] = "reset",
		},
		[7] = {
			["ID"] = 7,
			["Name"] = "update",
		},
	};
	-- Debug Levels
	EPF.Tables.DebugLevels = {
		[0] = {
			["ID"] = 0,
			["Name"] = "Errors",
			["Prefix"] = "Error",
			["Color"] = "FFFF3333",
		},
		[1] = {
			["ID"] = 1,
			["Name"] = "Notices",
			["Prefix"] = "Notice",
			["Color"] = "FF33FF33",
		},
		[2] = {
			["ID"] = 2,
			["Name"] = "Warnings",
			["Prefix"] = "Warning",
			["Color"] = "FF33FF33",
		},
		[3] = {
			["ID"] = 3,
			["Name"] = "Debug Events",
			["Prefix"] = "Debug Event",
			["Color"] = "FF33FF33",
		},
	};
	-- Modes
	EPF.Tables.Modes = {
		[0] = {
			["ID"] = 0,
			["Name"] = "Off",
			["Color"] = "FFFF3333",
		},
		[1] = {
			["ID"] = 1,
			["Name"] = "Auto",
			["Color"] = "FF33FF33",
		},
		[2] = {
			["ID"] = 2,
			["Name"] = "Rare",
			["Color"] = "FF999999",
		},
		[3] = {
			["ID"] = 3,
			["Name"] = "Rare-Elite",
			["Color"] = "FFFFDD99",
		},
		[4] = {
			["ID"] = 4,
			["Name"] = "Elite",
			["Color"] = "FFFFDD33",
		},
		[5] = {
			["ID"] = 5,
			["Name"] = "Death Knight - Alliance",
			["Color"] = "FF33FFFF",
		},
		[6] = {
			["ID"] = 6,
			["Name"] = "Death Knight - Horde",
			["Color"] = "FFFF66FF",
		},
	};
	-- Death Knight Frames
	EPF.Tables.DKFrames = {
		[0] = {
			["ID"] = 0,
			["Name"] = "Off",
			["Color"] = "FFFF3333",
		},
		[1] = {
			["ID"] = 1,
			["Name"] = "On",
			["Color"] = "FF33FF33",
		},
	};
	-- Genders
	EPF.Tables.Genders = {
		[1] = {
			["ID"] = 1,
			["Name"] = "Unknown",
			["Color"] = "FF999999",
		},
		[2] = {
			["ID"] = 2,
			["Name"] = "Male",
			["Color"] = "FF3366FF",
		},
		[3] = {
			["ID"] = 3,
			["Name"] = "Female",
			["Color"] = "FFFF3366",
		},
	};
	-- Factions
	EPF.Tables.Factions = {
		[0] = {
			["ID"] = 0,
			["Name"] = "Auto",
			["Color"] = "FF33FF33",
		},
		[1] = {
			["ID"] = 1,
			["Name"] = "Alliance",
			["Color"] = "FF3366FF",
		},
		[2] = {
			["ID"] = 2,
			["Name"] = "Horde",
			["Color"] = "FFFF3333",
		},
	};
	-- Expansions
	EPF.Tables.Expansions = {
		[0] = {
			["ID"] = 0,
			["Name"] = "Base",
			["Color"] = "FFFFDD33",
			["Cap"] = 60,
		},
		[1] = {
			["ID"] = 1,
			["Name"] = "The Burning Crusade",
			["Color"] = "FF33FF33",
			["Cap"] = 70,
		},
		[2] = {
			["ID"] = 2,
			["Name"] = "Wrath of the Lich King",
			["Color"] = "FF3399FF",
			["Cap"] = 80,
		},
		[3] = {
			["ID"] = 3,
			["Name"] = "Cataclysm",
			["Color"] = "FFFF6666",
			["Cap"] = 85,
		},
	};
	-- Level Cap Steps
	EPF.Tables.Caps = {
		["Ranges"] = {
			[0] = 0,
			[1] = 2,
		},
		["Bases"] = {
			[0] = 60,
			[1] = 80,
		},
		["Steps"] = {
			[0] = 10,
			[1] = 5,
		},
	};
end

-- [ Event hanlder ] --
function EPF.Funcs.Event(frame, event, ...)
	if (event == "VARIABLES_LOADED") then
		EPF.Funcs.Loaded();
		EPF.Funcs.Msg(tostring(event),3);
	elseif (event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_LEVEL_UP") then
		if (not EPF.Vars.Loaded) then
			EPF.Funcs.Loaded();
			EPF.Funcs.Msg("Display update was called before loading.",2);
		end
		EPF.Funcs.Msg(tostring(event),3);
		EPF.Funcs.Display.Update(true);
	end
end

-- [ Loaded handler ] --
function EPF.Funcs.Loaded()
	-- Check settings
	if (EPF_Vars == nil) then
		EPF_Vars = {};
		-- New character, load default settings
		for k,v in pairs(EPF.Vars) do
			EPF_Vars[k] = v;
		end
		EPF.Funcs.Msg("New character. Loaded default settings.",1);
	elseif (EPF_Vars.Version < EPF.Vars.Version) then
		-- New version, update settings
		for k,v in pairs(EPF.Vars) do
			if (EPF_Vars[k] == nil) then
				EPF_Vars[k] = v;
			end
		end
		EPF_Vars.Version = EPF.Vars.Version;
		EPF.Funcs.Msg("Updated settings for version "..tostring(EPF_Vars.Version)..".",1);
	else
		-- Double check settings, use defaults if error
		for k,v in pairs(EPF.Vars) do
			if (EPF_Vars[k] == nil) then
				EPF_Vars[k] = v;
				EPF.Funcs.Msg("Missing variable "..tostring(k)..". Using default setting.",2);
			end
		end
	end
	
	-- Set info
	EPF.Vars.Addon = {};
	EPF.Funcs.Info.Addon();
	EPF.Vars.Game = {};
	EPF.Funcs.Info.Game();
	EPF.Vars.Player = {};
	EPF.Funcs.Info.Player();
	
	EPF.Vars.Loaded = true;
	EPF.Funcs.Msg("Loaded!",3);
end

-- [ Addon Reset ] --
function EPF.Funcs.Reset()
	-- Wipe vars and apply defaults
	EPF.Vars.Loaded = false;
	wipe(EPF_Vars);
	for k,v in pairs(EPF.Vars) do
		EPF_Vars[k] = v;
	end
	
	-- Reset info
	EPF.Vars.Addon = {};
	EPF.Funcs.Info.Addon();
	EPF.Vars.Game = {};
	EPF.Funcs.Info.Game();
	EPF.Vars.Player = {};
	EPF.Funcs.Info.Player();
	EPF.Vars.Loaded = true;
	
	-- Update display
	EPF.Funcs.Display.Update(true);
	
	EPF.Funcs.Msg("Reloaded default settings.",3);
end

-- [ Message writing function ] --
function EPF.Funcs.Msg(msg,dbg,custom)
	-- Check debugging level
	if (custom) then
		SendChatMessage("[EPF]: "..tostring(msg).."",custom.type,custom.lang,custom.to);
	else
		if (DEFAULT_CHAT_FRAME and ((dbg == nil) or (EPF_Vars.Debug >= dbg))) then
			if (dbg ~= nil) then
				msg = tostring(EPF.Tables.DebugLevels[dbg].Prefix)..": "..msg;
			end
			DEFAULT_CHAT_FRAME:AddMessage("[|cFFFFDD33EPF|r]: "..tostring(msg).."");
		end
	end
end

-- [ Slash Command Hanlders ] --
EPF.Funcs.SlashCmd = {};
function EPF.Funcs.SlashCmd.null(string, ...)
	if ((string) and (string ~= "")) then
		-- Split the string into a table of arguments
		local args = EPF.Funcs.SplitString(string);
		-- Get handler based on first argument given
		local cmd = EPF.Funcs.SlashCmd[tostring(args[1])];
		if (type(cmd) == "function") then
			-- If the handler exists, call it
			cmd(args);
		else
			-- Invalid command, present help message.
			EPF.Funcs.Msg(string.." is not a valid command.",0);
			EPF.Funcs.SlashCmd.help(args);
		end
	else
		-- Top level command presenting help
		EPF.Funcs.SlashCmd.help();
	end
end

SlashCmdList["EPF"] = EPF.Funcs.SlashCmd.null;
EPF.Funcs.SlashHelp = {};
function EPF.Funcs.SlashCmd.help(args)
	local cmd;
	if (args and args[2] ~= nil) then
		cmd = EPF.Funcs.SlashHelp[tostring(args[2])];
		if (type(cmd) == "function") then
			cmd();
		else
			EPF.Funcs.Msg(tostring(args[2]).." is an invalid argument for /epf help",0);
		end
	else
		EPF.Funcs.Msg("Help: |cFF999999"..SLASH_EPF1..", "..SLASH_EPF2.."|r");
		for n,f in EPF.Funcs.SortedPairs(EPF.Funcs.SlashCmd,EPF.Funcs.CompareSlashCmd.Asc) do
			if (n ~= "null" or n ~= "help") then
				cmd = EPF.Funcs.SlashHelp[n]
				if (type(cmd) == "function") then
					if ((n ~= "update" and n ~= "reset") or EPF_Vars.Debug > 0) then
						cmd();
					end
				end
			end
		end
	end
end
function EPF.Funcs.SlashHelp.info()
	local msg;
	EPF.Funcs.Msg("Help: info [addon|game|player] - Presents information about the chosen option.");
end
function EPF.Funcs.SlashCmd.info(args)
	if (args[2] == "addon") then
		EPF.Funcs.Msg("Info - Addon: "..tostring(EPF.Vars.Addon.Title).." v"..tostring(EPF.Vars.Addon.Version).." by "..tostring(EPF.Vars.Addon.Author)..".");
		EPF.Funcs.Msg("Info - Addon: "..tostring(EPF.Vars.Addon.Description));
		EPF.Funcs.Msg("Info - Addon: "..tostring(EPF.Vars.Addon.Email).." - "..tostring(EPF.Vars.Addon.URL).."");
	elseif (args[2] == "game") then
		local n = EPF.Funcs.Format(EPF.Vars.Game.Name,EPF.Tables.Expansions[EPF.Vars.Game.ID]);
		local e = EPF.Funcs.Format(EPF.Vars.Game.Expansion,EPF.Tables.Expansions[EPF.Vars.Game.ID]);
		local v = EPF.Vars.Game.Version.."."..EPF.Vars.Game.Build
		EPF.Funcs.Msg("Info - Game: "..tostring(n).." ("..tostring(e)..")");
		EPF.Funcs.Msg("Info - Game: "..tostring(v).." ("..tostring(EPF.Vars.Game.Interface)..")");
		EPF.Funcs.Msg("Info - Game: Capped @ Level "..tostring(EPF.Vars.Game.Level));
	elseif (args[2] == "player") then
		EPF.Funcs.Msg("Info - Player: "..tostring(EPF.Vars.Player.Name).." - Level "..tostring(EPF.Vars.Player.Level));
		EPF.Funcs.Msg("Info - Player: "..tostring(EPF.Funcs.Format(EPF.Tables.Genders[EPF.Vars.Player.Gender].Name,EPF.Tables.Genders[EPF.Vars.Player.Gender])).." "..tostring(EPF.Vars.Player.Race).." "..tostring(EPF.Vars.Player.Class));
		EPF.Funcs.Msg("Info - Player: "..tostring(EPF.Funcs.Format(EPF.Tables.Factions[EPF.Vars.Player.Faction].Name,EPF.Tables.Factions[EPF.Vars.Player.Faction])));
	elseif (args[2] == "help" or args[3] == "help") then
		EPF.Funcs.SlashHelp.info();
	elseif (args[2] == nil) then
		EPF.Funcs.SlashCmd.info({nil,"addon"});
		EPF.Funcs.Msg("---");
		EPF.Funcs.SlashCmd.info({nil,"game"});
		EPF.Funcs.Msg("---");
		EPF.Funcs.SlashCmd.info({nil,"player"});
	else
		EPF.Funcs.Msg(tostring(args[2]).." is an invalid argument for /epf info",0);
		EPF.Funcs.SlashHelp.info();
	end
end
function EPF.Funcs.SlashHelp.mode()
	local msg = "mode [0-6] - Display mode (";
	local msg2;
	for k,v in EPF.Funcs.SortedPairs(EPF.Tables.Modes) do
		if (msg2 == nil) then
			msg2 = tostring(EPF.Funcs.Format(EPF.Tables.Modes[k].Name,EPF.Tables.Modes[k]));
		else
			msg2 = msg2..", "..tostring(EPF.Funcs.Format(EPF.Tables.Modes[k].Name,EPF.Tables.Modes[k]));
		end
	end
	EPF.Funcs.Msg("Help: "..msg..msg2..").");
end
function EPF.Funcs.SlashCmd.mode(args)
	local status;
	if (args[2] ~= nil) then
		if (args[2] == "help") then
			EPF.Funcs.SlashHelp.mode();
		elseif (tonumber(args[2]) == nil or (tonumber(args[2]) > 6 or tonumber(args[2]) < 0)) then
			EPF.Funcs.Msg(tostring(args[2]).." is an invalid argument for /epf mode",0);
			EPF.Funcs.SlashHelp.mode();
		else
			-- Set to given mode in second argument
			EPF_Vars.Mode = tonumber(args[2]);
			EPF.Funcs.Display.Update(true);
			EPF.Funcs.Msg("Mode: "..tostring(EPF.Funcs.Format(EPF_Vars.Mode,EPF.Tables.Modes[EPF_Vars.Mode])).." ("..tostring(EPF.Funcs.Format(EPF.Tables.Modes[EPF_Vars.Mode].Name,EPF.Tables.Modes[EPF_Vars.Mode]))..")");
		end
	else
		EPF.Funcs.Msg("Mode: "..tostring(EPF.Funcs.Format(EPF_Vars.Mode,EPF.Tables.Modes[EPF_Vars.Mode])).." ("..tostring(EPF.Funcs.Format(EPF.Tables.Modes[EPF_Vars.Mode].Name,EPF.Tables.Modes[EPF_Vars.Mode]))..")");
	end
end
function EPF.Funcs.SlashHelp.dk()
	local msg = "dk [0-1] - Setting for Death Knight frames in auto mode (";
	local msg2;
	for k,v in EPF.Funcs.SortedPairs(EPF.Tables.DKFrames) do
		if (msg2 == nil) then
			msg2 = tostring(EPF.Funcs.Format(EPF.Tables.DKFrames[k].Name,EPF.Tables.DKFrames[k]));
		else
			msg2 = msg2..", "..tostring(EPF.Funcs.Format(EPF.Tables.DKFrames[k].Name,EPF.Tables.DKFrames[k]));
		end
	end
	EPF.Funcs.Msg("Help: "..msg..msg2..").");
end
function EPF.Funcs.SlashCmd.dk(args)
	local val
	local status;
	if (args[2] ~= nil) then
		if (args[2] == "help") then
			EPF.Funcs.SlashHelp.dk();
		elseif (tonumber(args[2]) == nil or (tonumber(args[2]) > 1 or tonumber(args[2]) < 0)) then
			EPF.Funcs.Msg(tostring(args[2]).." is an invalid argument for /epf dk",0);
			EPF.Funcs.SlashHelp.dk();
		else
			-- Set to given dk frames mode in second argument
			EPF_Vars.DK = tonumber(args[2]);
			EPF.Funcs.Display.Update(true);
			EPF.Funcs.Msg("Death Knight Frames: "..tostring(EPF.Funcs.Format(EPF_Vars.DK,EPF.Tables.DKFrames[EPF_Vars.DK])).." ("..tostring(EPF.Funcs.Format(EPF.Tables.DKFrames[EPF_Vars.DK].Name,EPF.Tables.DKFrames[EPF_Vars.DK]))..")");
		end
	else
		EPF.Funcs.Msg("Death Knight Frames: "..tostring(EPF.Funcs.Format(EPF_Vars.DK,EPF.Tables.DKFrames[EPF_Vars.DK])).." ("..tostring(EPF.Funcs.Format(EPF.Tables.DKFrames[EPF_Vars.DK].Name,EPF.Tables.DKFrames[EPF_Vars.DK]))..")");
	end
end
function EPF.Funcs.SlashHelp.faction()
	local msg = "faction [0-2] - Faction control for Death Knight frames (";
	local msg2;
	for k,v in EPF.Funcs.SortedPairs(EPF.Tables.Factions) do
		if (msg2 == nil) then
			msg2 = tostring(EPF.Funcs.Format(EPF.Tables.Factions[k].Name,EPF.Tables.Factions[k]));
		else
			msg2 = msg2..", "..tostring(EPF.Funcs.Format(EPF.Tables.Factions[k].Name,EPF.Tables.Factions[k]));
		end
	end
	EPF.Funcs.Msg("Help: "..msg..msg2..").");
end
function EPF.Funcs.SlashCmd.faction(args)
	local val
	local status;
	if (args[2] ~= nil) then
		if (args[2] == "help") then
			EPF.Funcs.SlashHelp.faction();
		elseif (tonumber(args[2]) == nil or (tonumber(args[2]) > 2 or tonumber(args[2]) < 0)) then
			EPF.Funcs.Msg(tostring(args[2]).." is an invalid argument for /epf faction",0);
			EPF.Funcs.SlashHelp.faction();
		else
			-- Set to given faction mode in second argument
			EPF_Vars.Faction = tonumber(args[2]);
			EPF.Funcs.Display.Update(true);
			EPF.Funcs.Msg("Faction: "..tostring(EPF.Funcs.Format(EPF_Vars.Faction,EPF.Tables.Factions[EPF_Vars.Faction])).." ("..tostring(EPF.Funcs.Format(EPF.Tables.Factions[EPF_Vars.Faction].Name,EPF.Tables.Factions[EPF_Vars.Faction]))..")");
		end
	else
		EPF.Funcs.Msg("Faction: "..tostring(EPF.Funcs.Format(EPF_Vars.Faction,EPF.Tables.Factions[EPF_Vars.Faction])).." ("..tostring(EPF.Funcs.Format(EPF.Tables.Factions[EPF_Vars.Faction].Name,EPF.Tables.Factions[EPF_Vars.Faction]))..")");
	end
end
function EPF.Funcs.SlashHelp.debug()
	local msg = "debug [0-3] - Debug output control (";
	local msg2
	for k,v in EPF.Funcs.SortedPairs(EPF.Tables.DebugLevels) do
		if (msg2 == nil) then
			msg2 = tostring(EPF.Funcs.Format(EPF.Tables.DebugLevels[k].Name,EPF.Tables.DebugLevels[k]));
		else
			msg2 = msg2..", "..tostring(EPF.Funcs.Format(EPF.Tables.DebugLevels[k].Name,EPF.Tables.DebugLevels[k]));
		end
	end
	EPF.Funcs.Msg("Help: "..msg..msg2..").");
end
function EPF.Funcs.SlashCmd.debug(args)
	local val
	local status;
	if (args[2] ~= nil) then
		if (args[2] == "help") then
			EPF.Funcs.SlashHelp.debug();
		elseif (tonumber(args[2]) == nil or (tonumber(args[2]) > 3 or tonumber(args[2]) < 0)) then
			EPF_Vars.Debug = 0;
			EPF.Funcs.Msg(tostring(args[2]).." is an invalid argument for /epf debug",0);
			EPF.Funcs.SlashHelp.debug();
		else
			-- Set to given debug level in second argument
			EPF_Vars.Debug = tonumber(args[2]);
			EPF.Funcs.Msg("Debug: "..tostring(EPF.Funcs.Format(EPF_Vars.Debug,EPF.Tables.DebugLevels[EPF_Vars.Debug])).." ("..tostring(EPF.Funcs.Format(EPF.Tables.DebugLevels[EPF_Vars.Debug].Name,EPF.Tables.DebugLevels[EPF_Vars.Debug]))..")");
		end
	else
		EPF.Funcs.Msg("Debug: "..tostring(EPF.Funcs.Format(EPF_Vars.Debug,EPF.Tables.DebugLevels[EPF_Vars.Debug])).." ("..tostring(EPF.Funcs.Format(EPF.Tables.DebugLevels[EPF_Vars.Debug].Name,EPF.Tables.DebugLevels[EPF_Vars.Debug]))..")");
	end
end
function EPF.Funcs.SlashHelp.update()
	EPF.Funcs.Msg("Help: update - Manually updates the PlayerFrame.");
end
function EPF.Funcs.SlashCmd.update(args)
	if (args[2] == "help") then
		EPF.Funcs.SlashHelp.update();
	else
		EPF.Funcs.Display.Update(true);
	end
end
function EPF.Funcs.SlashHelp.reset()
	EPF.Funcs.Msg("Help: reset - Resets addon to defaults.");
end
function EPF.Funcs.SlashCmd.reset(args)
	if (args[2] == "help") then
		EPF.Funcs.SlashHelp.reset();
	else
		EPF.Funcs.Reset();
	end
end

-- [ Informational Functions ] --
EPF.Funcs.Info = {};
function EPF.Funcs.Info.Game()
	EPF.Vars.Game.Version, EPF.Vars.Game.Build, EPF.Vars.Game.BuildDate, EPF.Vars.Game.Interface = GetBuildInfo();
	EPF.Vars.Game.ID = tonumber(string.sub(EPF.Vars.Game.Version, 0, string.find(EPF.Vars.Game.Version, "%.")-1))-1;
	EPF.Vars.Game.Expansion = "1."..EPF.Vars.Game.ID;
	if (EPF.Tables.Expansions[EPF.Vars.Game.ID]) then
		EPF.Vars.Game.Name = EPF.Tables.Expansions[EPF.Vars.Game.ID].Name;
		EPF.Vars.Game.Color = EPF.Tables.Expansions[EPF.Vars.Game.ID].Color;
		EPF.Vars.Game.Level = EPF.Tables.Expansions[EPF.Vars.Game.ID].Cap;
	else
		EPF.Vars.Game.Name = "Unknown";
		for k,v in pairs(EPF.Tables.Caps.Ranges) do
			if (EPF.Vars.Game.ID > v) then
				EPF.Funcs.Msg("Level cap match for "..v.." on step group "..k..".",3);
				EPF.Vars.Game.Level = EPF.Tables.Caps.Bases[k] + (EPF.Tables.Caps.Steps[k] * (EPF.Vars.Game.ID - v));
			else
				EPF.Funcs.Msg("No level cap matches for "..v.." on step group "..k..".",3);
				break;
			end
		end
		
	end
	EPF.Funcs.Msg("Game information updated.",3);
	return EPF.Vars.Game;
end
function EPF.Funcs.Info.Player()
	EPF.Vars.Player.Name = UnitName("player");
	EPF.Vars.Player.Level = UnitLevel("player");
	EPF.Vars.Player.Gender = UnitSex("player");
	EPF.Vars.Player.Race = UnitRace("player");
	EPF.Vars.Player.Class = UnitClass("player");
	EPF.Vars.Player.Faction = EPF.RevLookup(EPF.Tables.Factions,"Name",UnitFactionGroup("player"));
	EPF.Funcs.Msg("Player information updated.",3);
	return EPF.Vars.Player;
end
function EPF.Funcs.Info.Addon()
	EPF.Vars.Addon.ShortName = "EPF";
	EPF.Vars.Addon.Name, EPF.Vars.Addon.Title, EPF.Vars.Addon.Description = GetAddOnInfo("ElitePlayerFrame_Enhanced");
	EPF.Vars.Addon.Version = GetAddOnMetadata(EPF.Vars.Addon.Name, "Version");
	EPF.Vars.Addon.Author = GetAddOnMetadata(EPF.Vars.Addon.Name, "Author");
	EPF.Vars.Addon.URL = GetAddOnMetadata(EPF.Vars.Addon.Name, "X-Website");
	EPF.Vars.Addon.Email = GetAddOnMetadata(EPF.Vars.Addon.Name, "X-eMail");
	EPF.Funcs.Msg("Addon information updated.",3);
	return EPF.Vars.Addon;
end

-- [ Formatting Function ] --
function EPF.Funcs.Format(s,t)
	if (t) then
		local col = t.Color;
		s = "|c"..tostring(col)..tostring(s).."|r";
		return s;
	else
		return s;
	end
end

-- [ Display Functions ] --
EPF.Funcs.Display = {};
function EPF.Funcs.Display.Update(force)
	if (EPF.Vars.Player.Level ~= UnitLevel("player") or EPF.Tables.Factions[EPF.Vars.Player.Faction].Name ~= UnitFactionGroup("player") or EPF.Vars.Player.Class ~= UnitClass("player") or force) then
		EPF.Funcs.Info.Player();
		if (EPF_Vars.Mode == 6 or (EPF_Vars.Mode == 1 and ((EPF.Vars.Player.Faction == 2 and EPF_Vars.Faction == 0) or EPF_Vars.Faction == 2) and EPF.Vars.Player.Class == "Death Knight" and EPF_Vars.DK == 1)) then
			PlayerFrameTexture:SetTexture("Interface\\AddOns\\ElitePlayerFrame_Enhanced\\Textures\\UI-PlayerFrame-Deathknight-Horde.tga");
			PlayerFrameTexture:ClearAllPoints();
			PlayerFrameTexture:SetPoint("TOPLEFT", "PlayerFrame", 12, 13);
			PlayerFrameTexture:SetTexCoord(0, 1, 0, 1);
			EPF.Funcs.Msg("Displaying "..tostring(EPF.Funcs.Format(EPF.Tables.Modes[6].Name,EPF.Tables.Modes[6])).." frame.",3);
		elseif (EPF_Vars.Mode == 5 or (EPF_Vars.Mode == 1 and ((EPF.Vars.Faction == 1 and EPF_Vars.Faction == 0) or EPF_Vars.Faction == 1) and EPF.Vars.Player.Class == "Death Knight" and EPF_Vars.DK == 1)) then
			PlayerFrameTexture:SetTexture("Interface\\AddOns\\ElitePlayerFrame_Enhanced\\Textures\\UI-PlayerFrame-Deathknight-Alliance.tga");
			PlayerFrameTexture:ClearAllPoints();
			PlayerFrameTexture:SetPoint("TOPLEFT", "PlayerFrame", 10, 7);
			PlayerFrameTexture:SetTexCoord(0, 1, 0, 1);
			EPF.Funcs.Msg("Displaying "..tostring(EPF.Funcs.Format(EPF.Tables.Modes[5].Name,EPF.Tables.Modes[5])).." frame.",3);
		elseif (EPF_Vars.Mode == 4 or (EPF.Vars.Player.Level == EPF.Vars.Game.Level and EPF_Vars.Mode == 1)) then
			PlayerFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-Elite.blp");
			PlayerFrameTexture:ClearAllPoints();
			PlayerFrameTexture:SetPoint("TOPLEFT", "PlayerFrame", 0, 0);
			PlayerFrameTexture:SetTexCoord(1, 0, 0, 1);
			EPF.Funcs.Msg("Displaying "..tostring(EPF.Funcs.Format(EPF.Tables.Modes[4].Name,EPF.Tables.Modes[4])).." frame.",3);
		elseif (EPF_Vars.Mode == 3 or (EPF.Vars.Player.Level >= EPF.Tables.Caps.Bases[0] and EPF_Vars.Mode == 1)) then
			PlayerFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-Rare-Elite.blp");
			PlayerFrameTexture:ClearAllPoints();
			PlayerFrameTexture:SetPoint("TOPLEFT", "PlayerFrame", 0, 0);
			PlayerFrameTexture:SetTexCoord(1, 0, 0, 1);
			EPF.Funcs.Msg("Displaying "..tostring(EPF.Funcs.Format(EPF.Tables.Modes[3].Name,EPF.Tables.Modes[3])).." frame.",3);
		elseif (EPF_Vars.Mode == 2 or (EPF.Vars.Player.Level >= 10 and EPF_Vars.Mode == 1)) then
			PlayerFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-Rare.blp");
			PlayerFrameTexture:ClearAllPoints();
			PlayerFrameTexture:SetPoint("TOPLEFT", "PlayerFrame", 0, 0);
			PlayerFrameTexture:SetTexCoord(1, 0, 0, 1);
			EPF.Funcs.Msg("Displaying "..tostring(EPF.Funcs.Format(EPF.Tables.Modes[2].Name,EPF.Tables.Modes[2])).." frame.",3);
		else
			PlayerFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame.blp");
			PlayerFrameTexture:ClearAllPoints();
			PlayerFrameTexture:SetPoint("TOPLEFT", "PlayerFrame", 0, 0);
			PlayerFrameTexture:SetTexCoord(1, 0, 0, 1);
			EPF.Funcs.Msg("Displaying "..tostring(EPF.Funcs.Format("Standard",EPF.Tables.Modes[1])).." frame.",3);
		end
	else
		EPF.Funcs.Msg("Player info has not changed since last display update.",3);
	end
	if (PlayerFrame:IsClampedToScreen() == false or force) then
		PlayerFrame:SetClampedToScreen(true);
	else
	end
end

-- [ Misc. Functions ] --
-- [ String Splitting Function ] -- Credit to Mikk
function EPF.Funcs.SplitString(s)
	local tt = {};
	local i = 0;
	while(true) do
		local word;
		_, i, word = strfind(s, "^ *([^%s]+) *", i+1);
		if(not word) then
			return tt;
		end
		tinsert(tt,word);
	end
end
-- [ Reverse Lookup Function ] --
function EPF.RevLookup(t,i,x)
	for k,v in pairs(t) do
		if (v[i] == x) then
			return k;
		end
	end
end
-- [ Sort Pairing Function ] --
function EPF.Funcs.SortedPairs(t,c)
	local tt = {};
	if (not c) then
		c = EPF.Funcs.Compare.Asc;
	elseif (type(c) ~= "function") then
		if (c == 1) then
			c = EPF.Funcs.Compare.Desc;
		else
			c = EPF.Funcs.Compare.Asc;
		end
	end
	for k in pairs(t) do
		tinsert(tt,k);
	end
	sort(tt,c);
	local i = 0
	local f = function ()
		i = i + 1;
		if tt[i] == nil then
			return nil;
		else
			EPF.Funcs.Msg("Pair "..tostring(i).." ["..tostring(tt[i]).."]",3);
			return tt[i], t[tt[i]];
		end
	end
	return f;
end
-- [ Sort Comparison Functions ] --
EPF.Funcs.Compare = {};
function EPF.Funcs.Compare.Null(a,b,d)
	local dir;
	local result;
	local ctype = "Unknown";
	if (type(a) ~= type(b)) then
		if ((tonumber(a) ~= nil) and (tonumber(b) ~= nil)) then
			a = tonumber(a);
			b = tonumber(b);
			ctype = "number";
		elseif ((type(a) == "string") or (type(b) == "string")) then
			a = tostring(a);
			b = tostring(b);
			ctype = "string";
		end
	else
		ctype = type(a);
	end
	if (d == 1) then
		result = a > b;
		dir = "Descending";
	else
		result = a < b;
		dir = "Ascending";
	end
	EPF.Funcs.Msg("Comparing "..tostring(a).." to "..tostring(b).." as "..tostring(ctype).." ("..tostring(dir)..") - Result is "..tostring(result)..".",3);
	if (d == 1) then
		return a > b;
	else
		return a < b;
	end
end
function EPF.Funcs.Compare.Asc(a,b)
	return EPF.Funcs.Compare.Null(a,b,0);
end
function EPF.Funcs.Compare.Desc(a,b)
	return EPF.Funcs.Compare.Null(a,b,1);
end
EPF.Funcs.CompareSlashCmd = {};
function EPF.Funcs.CompareSlashCmd.Null(a,b,d)
	local result;
	local ctype = "number";
	a2 = EPF.RevLookup(EPF.Tables.Commands,"Name",a);
	b2 = EPF.RevLookup(EPF.Tables.Commands,"Name",b);
	if (d == 1) then
		result = a2 > b2;
		dir = "Descending";
	else
		result = a2 < b2;
		dir = "Ascending";
	end
	EPF.Funcs.Msg("Comparing slash command "..tostring(a2).."("..tostring(a)..") to "..tostring(b2).."("..tostring(b)..") as "..tostring(ctype).." ("..tostring(dir)..") - Result is "..tostring(result)..".",3);
	if (d == 1) then
		return a2 > b2;
	else
		return a2 < b2;
	end
end
function EPF.Funcs.CompareSlashCmd.Asc(a,b)
	return EPF.Funcs.CompareSlashCmd.Null(a,b,0);
end
function EPF.Funcs.CompareSlashCmd.Desc(a,b)
	return EPF.Funcs.CompareSlashCmd.Null(a,b,1);
end
