if select(6, GetAddOnInfo("Cartographer3_" .. (debugstack():match("[a%.][p%.][h%.]er3\\(.-)\\") or ""))) ~= "MISSING" then return end

local Cartographer3 = _G.Cartographer3
if not Cartographer3 then
	error("Cartographer3_InstancePOIs requires Cartographer3")
end

Cartographer3.L("InstancePOIs", "enUS", function() return {
} end)

local B = LibStub("LibBabble-Boss-3.0", true)
if not B then
	LoadAddOn("LibBabble-Boss-3.0")
	B = LibStub("LibBabble-Boss-3.0", true)
	if not B then
		error("Cartographer3_InstancePOIs requires LibBabble-Boss-3.0")
	end
end
local BB = B:GetLookupTable()
local BBB = B:GetBaseLookupTable()

local L = Cartographer3.L("InstancePOIs")

local Cartographer3_InstancePOIs = Cartographer3.NewModule("InstancePOIs", L["Instance POIs"], L["Module which adds default POIs to instance maps"], {
	notes = {}
})

Cartographer3.AddPOIType("InstancePOI", L["Instance POI"], function()
	local poi = CreateFrame("Frame", nil, UIParent)
	local texture = poi:CreateTexture(nil, "ARTWORK")
	texture:SetAllPoints()
	texture:SetTexture([[Interface\TargetingFrame\UI-RaidTargetingIcon_8]])
	return poi
end, 1, true)

local Cartographer3_Utils = Cartographer3.Utils

local db
local noteDB

local KINDS = {
	entrance = UnitPopupButtons.RAID_TARGET_1, -- Star
	boss = UnitPopupButtons.RAID_TARGET_8, -- Skull
	friend = UnitPopupButtons.RAID_TARGET_6, -- Square
	other = UnitPopupButtons.RAID_TARGET_2, -- Circle
}

local Cartographer3_InstancePOIs_Localization = _G.Cartographer3_InstancePOIs_Localization
_G.Cartographer3_InstancePOIs_Localization = nil
local convertBlock

if Cartographer3_InstancePOIs_Localization then

	local lvlPattern = "^Lvl ([%d%?]+) (.*)$" -- Lvl 54 Dragon
	local lvlElitePattern = "^Lvl ([%d%?]+) Elite (.*)$" -- Lvl 54 Elite Dragon
	
	local function simpleTryConvert(s)
		if BBB[s] then
			return BB[s]
		elseif Cartographer3_InstancePOIs_Localization[s] then
			return Cartographer3_InstancePOIs_Localization[s]
		end
		return nil
	end
	local function tryConvert(s)
		local new = simpleTryConvert(s)
		if new then
			return new
		end
	
		local lvl, name = s:match(lvlElitePattern)
		if lvl then
			name = simpleTryConvert(name) or name
			return Cartographer3_InstancePOIs_Localization["Lvl %s Elite %s"]:format(lvl, name)
		end
	
		local lvl, name = s:match(lvlPattern)
		if lvl then
			name = simpleTryConvert(name) or name
			return Cartographer3_InstancePOIs_Localization["Lvl %s %s"]:format(lvl, name)
		end
		return s
	end
	local tmp = {}
	local function f(...)
		for i = 1, select('#', ...) do
			tmp[i] = tryConvert((select(i, ...)))
		end
		local s = table.concat(tmp, "\n")
		for i = 1, #tmp do
			tmp[i] = nil
		end
		return s
	end
	function convertBlock(text)
		return f(("\n"):split(text))
	end
end

local data_x = {}
local data_y = {}
local data_kind = {}
local data_name = {}
local data_info = {}

function Cartographer3_InstancePOIs.OnInitialize()
	db = Cartographer3.db.InstancePOIs
	Cartographer3_InstancePOIs_Localization = nil
	convertBlock = nil
end

function Cartographer3_InstancePOIs.Add(zone, x, y, kind, name, info)
	if type(zone) ~= "string" then
		error(("Bad argument #1 to `Add'. Expected %q, got %q"):format("string", type(zone)), 2)
	elseif type(x) ~= "number" then
		error(("Bad argument #2 to `Add'. Expected %q, got %q"):format("number", type(x)), 2)
	elseif x < 0 or x >= 1 then
		error(("Bad argument #2 to `Add'. Expected [0, 1), got %s"):format("number", x), 2)
	elseif type(y) ~= "number" then
		error(("Bad argument #3 to `Add'. Expected %q, got %q"):format("number", type(y)), 2)
	elseif y < 0 or y >= 1 then
		error(("Bad argument #3 to `Add'. Expected [0, 1), got %s"):format("number", y), 2)
	elseif type(kind) ~= "string" then
		error(("Bad argument #4 to `Add'. Expected %q, got %q"):format("string", type(kind)), 2)
	elseif not KINDS[kind] then
		local t = {}
		for k in pairs(KINDS) do
			t[#t+1] = ("%q"):format(k)
		end
		error(("Bad argument #4 to `Add'. Expected in (%s), got %q"):format((", "):join(unpack(t)), kind), 2)
	elseif type(name) ~= "string" then
		error(("Bad argument #5 to `Add'. Expected %q, got %q"):format("string", type(name)), 2)
	elseif info ~= nil and type(info) ~= "string" then
		error(("Bad argument #6 to `Add'. Expected %q or %q, got %q"):format("string", "nil", type(info)), 2)
	end
	
	if not data_x[zone] then
		data_x[zone] = {}
		data_y[zone] = {}
		data_kind[zone] = {}
		data_name[zone] = {}
		data_info[zone] = {}
	end
	local data_x__zone = data_x[zone]
	local data_y__zone = data_y[zone]
	local data_kind__zone = data_kind[zone]
	local data_name__zone = data_name[zone]
	local data_info__zone = data_info[zone]
	
	if convertBlock then
		if name then
			name = convertBlock(name)
		end
		if info then
			info = convertBlock(info)
		end
	end
	
	local id = #data_x__zone + 1
	data_x__zone[id] = x
	data_y__zone[id] = y
	data_kind__zone[id] = kind
	data_name__zone[id] = name
	data_info__zone[id] = info
end

local pois = {}
local pool = {}
local numPOIs = 0

local function poi_AddDataToFullTooltip(self)
	GameTooltip:SetText(self.name)
	if self.info then
		GameTooltip:AddLine(self.info, nil, nil, nil, true)
	end
end

local function poi_AddDataToTooltipLine(self)
	local text = self.name
	if self.info then
		text = text .. " - " .. (self.info:gsub("\n", " - "))
	end
	GameTooltip:AddLine(text)
end

local function Clear(poi)
	pois[poi] = nil
	poi:Hide()
	pool[poi] = true
	poi.name = nil
	poi.kind = nil
	poi.info = nil
end

local function Draw(id)
	local zone = Cartographer3.Data.currentMapTexture
	if not data_x[zone] or not data_x[zone][id] then
		return
	end
	local x = data_x[zone][id]
	local y = data_y[zone][id]
	
	local ux, uy = Cartographer3_Utils.ConvertZoneCoordinateToUniverseCoordinate(zone, x, y)
	if not ux then
		return
	end
	
	local poi = next(pool)
	if poi then
		pool[poi] = nil
		poi:Show()
	else
		numPOIs = numPOIs + 1
		poi = CreateFrame("Button", "Cartographer3_InstancePOIs_POI" .. numPOIs, Cartographer3.Data.mapView)
		local texture = poi:CreateTexture(nil--[[poi:GetName() .. "_Texture"]], "ARTWORK")
		poi.texture = texture
		texture:SetAllPoints(poi)
		poi.AddDataToFullTooltip = poi_AddDataToFullTooltip
		poi.AddDataToTooltipLine = poi_AddDataToTooltipLine
		poi:SetWidth(1)
		poi:SetHeight(1)
		Cartographer3.AddPOI(poi, "InstancePOI")
	end
	pois[poi] = true
	local kind = data_kind[zone][id]
	local iconData = KINDS[kind]
	poi.texture:SetTexture(iconData.icon)
	if iconData.tCoordLeft then
		poi.texture:SetTexCoord(iconData.tCoordLeft, iconData.tCoordRight, iconData.tCoordTop, iconData.tCoordBottom)
	else
		poi.texture:SetTexCoord(0, 1, 0, 1)
	end
	poi.name = data_name[zone][id]
	poi.info = data_info[zone][id]
	poi.kind = kind
	poi:SetPoint("CENTER", ux, uy)
end

function Cartographer3_InstancePOIs.ClearMap()
	for poi in pairs(pois) do
		Clear(poi)
	end
end

function Cartographer3_InstancePOIs.RefreshMap()
	if not Cartographer3_InstancePOIs.IsEnabled() then
		return
	end
	Cartographer3_InstancePOIs.ClearMap()
	
	local zone = Cartographer3.Data.currentMapTexture
	
	local data_x__zone = data_x[zone]
	if not data_x__zone then
		return
	end
	
	for id = 1, #data_x__zone do
		Draw(id)
	end
end
Cartographer3_Utils.AddEventListener("WORLD_MAP_UPDATE", function()
	if db then
		Cartographer3_InstancePOIs.RefreshMap()
	end
end)
