if select(6, GetAddOnInfo("Cartographer3_" .. (debugstack():match("[a%.][p%.][h%.]er3\\(.-)\\") or ""))) ~= "MISSING" then return end

local Cartographer3 = _G.Cartographer3
if not Cartographer3 then
	error("Cartographer3_Notes requires Cartographer3")
end

Cartographer3.L("Notes", "enUS", function() return {
} end)

local L = Cartographer3.L("Notes")

local Cartographer3_Notes = Cartographer3.NewModule("Notes", L["Notes"], L["Module which allows you to put notes on the map"], {
	notes = {}
})

local WotLK = not not ToggleAchievementFrame

Cartographer3.AddPOIType("Note", L["Note"], function()
	local poi = CreateFrame("Frame", nil, UIParent)
	local texture = poi:CreateTexture(nil, "ARTWORK")
	texture:SetAllPoints()
	texture:SetTexture([[Interface\TargetingFrame\UI-RaidTargetingIcon_1]])
	return poi
end, 1, true)

local Cartographer3_Utils = Cartographer3.Utils

local db
local noteDB

function Cartographer3_Notes.OnInitialize()
	db = Cartographer3.db.Notes
	noteDB = db.notes
	Cartographer3_Notes.RefreshMap()
end

local icons = {
	["Star"] = UnitPopupButtons.RAID_TARGET_1,
	["Circle"] = UnitPopupButtons.RAID_TARGET_2,
	["Diamond"] = UnitPopupButtons.RAID_TARGET_3,
	["Triangle"] = UnitPopupButtons.RAID_TARGET_4,
	["Moon"] = UnitPopupButtons.RAID_TARGET_5,
	["Square"] = UnitPopupButtons.RAID_TARGET_6,
	["Cross"] = UnitPopupButtons.RAID_TARGET_7,
	["Skull"] = UnitPopupButtons.RAID_TARGET_8,
}

local function CoordToID(x, y)
	if x < 0 then
		x = 0
	elseif x >= 0.9999 then
		x = 0.9999
	end
	if y < 0 then
		y = 0
	elseif y >= 0.9999 then
		y = 0.9999
	end
	return math.floor(x * 10000 + 0.5)*10000 + math.floor(y * 10000 + 0.5)
end

local function IDToCoord(id)
	return math.floor(id / 10000) / 10000, (id % 10000) / 10000
end

local pois = {}
local pool = {}
local numPOIs = 0

local function poi_AddDataToFullTooltip(self)
	GameTooltip:SetText(self.name)
	if self.description then
		GameTooltip:AddLine(self.description, nil, nil, nil, true)
	end
end

local function poi_AddDataToTooltipLine(self)
	local text = self.name
	if self.description then
		text = text .. " - " .. self.description
	end
	GameTooltip:AddLine(text)
end

local function Clear(poi)
	local id = poi.id
	pois[id] = nil
	poi:Hide()
	pool[poi] = true
	poi.id = nil
	poi.name = nil
	poi.description = nil
end

local function Draw(id, noteData)
	local oldPOI = pois[id]
	if oldPOI then
		Clear(oldPOI)
	end
	local x, y = IDToCoord(id)
	local zone = Cartographer3.Data.currentMapTexture

	local ux, uy = Cartographer3_Utils.ConvertZoneCoordinateToUniverseCoordinate(zone, x, y)
	if not ux then
		return
	end

	local poi = next(pool)
	if poi then
		pool[poi] = nil
		poi:Show()
	else
		numPOIs = numPOIs + 1
		poi = CreateFrame("Button", "Cartographer3_Notes_POI" .. numPOIs, Cartographer3.Data.mapView)
		local texture = poi:CreateTexture(nil--[[poi:GetName() .. "_Texture"]], "ARTWORK")
		poi.texture = texture
		texture:SetAllPoints(poi)
		poi.AddDataToFullTooltip = poi_AddDataToFullTooltip
		poi.AddDataToTooltipLine = poi_AddDataToTooltipLine
		poi:SetWidth(1)
		poi:SetHeight(1)
		Cartographer3.AddPOI(poi, "Note")
	end
	pois[id] = poi
	poi.id = id
	local icon, name, description
	if type(noteData) == "table" then
		icon = noteData[1]
		name = noteData[2]
		description = noteData[3]
	else
		icon = noteData
	end
	local iconData = icons[icon]
	poi.texture:SetTexture(iconData.icon)
	if iconData.tCoordLeft then
		poi.texture:SetTexCoord(iconData.tCoordLeft, iconData.tCoordRight, iconData.tCoordTop, iconData.tCoordBottom)
	else
		poi.texture:SetTexCoord(0, 1, 0, 1)
	end
	poi.name = name
	if not name or name == "" then
		poi.name = iconData.text
	end
	if description and description ~= "" then
		poi.description = description
	else
		poi.description = nil
	end
	poi:SetPoint("CENTER", ux, uy)
end

function Cartographer3_Notes.ClearMap()
	for id, poi in pairs(pois) do
		Clear(poi)
	end
end

function Cartographer3_Notes.RefreshMap()
	if not Cartographer3_Notes.IsEnabled() then
		return
	end
	Cartographer3_Notes.ClearMap()

	local zone = Cartographer3.Data.currentMapTexture

	local noteDB_zone = noteDB[zone]
	if not noteDB_zone then
		return
	end

	for id, noteData in pairs(noteDB_zone) do
		Draw(id, noteData)
	end
end
Cartographer3_Utils.AddEventListener("WORLD_MAP_UPDATE", function()
	if db then
		Cartographer3_Notes.RefreshMap()
	end
end)

function Cartographer3_Notes.RefreshNote(zone, x, y)
	if not Cartographer3_Notes.IsEnabled() then
		return
	end
	if Cartographer3.Data.currentMapTexture ~= zone then
		return
	end

	local id = CoordToID(x, y)
	local poi = pois[id]
	if poi then
		Clear(poi)
	end

	local noteDB_zone = noteDB[zone]
	if not noteDB_zone then
		return
	end

	local noteDB_zone_id = noteDB_zone[id]
	if not noteDB_zone_id then
		return
	end

	Draw(id, noteDB_zone_id)
end

function Cartographer3_Notes.AddNote(zone, x, y, icon, name, description)
	local noteDB_zone = noteDB[zone]
	if not noteDB_zone then
		noteDB_zone = {}
		noteDB[zone] = noteDB_zone
	end

	local id = CoordToID(x, y)

	if name then
		name = name:trim()
		if name == "" then
			name = nil
		end
	end
	if description then
		description = description:trim()
		if description == "" then
			description = nil
		end
	end

	noteDB_zone[id] = { icon, name, description }

	Cartographer3_Notes.RefreshNote(zone, x, y)
end

function Cartographer3_Notes.RemoveNote(zone, x, y)
	local noteDB_zone = noteDB[zone]
	if noteDB_zone then
		local id = CoordToID(x, y)
		if noteDB_zone[id] then
			noteDB_zone[id] = nil
			if not next(noteDB_zone) then
				noteDB[zone] = nil
			end
			Cartographer3_Notes.RefreshNote(zone, x, y)
		end
	end
end

local getFrame
do
	local frame
	function getFrame(...)
		frame = CreateFrame("Frame", "Cartographer3_Notes_Popup", UIParent)
		frame:SetWidth(350)
		frame:SetHeight(210)
		frame:SetPoint("CENTER", UIParent, "CENTER")
		frame:SetBackdrop {
			bgFile = [=[Interface\DialogFrame\UI-DialogBox-Background]=],
			edgeFile = [=[Interface\DialogFrame\UI-DialogBox-Border]=],
			tile = true,
			tileSize = 32,
			edgeSize = 32,
			insets = {
				left = 11,
				right = 12,
				top = 12,
				bottom = 11,
			}
		}
		frame:SetBackdropColor(0, 0, 0, 1)
		frame:EnableMouse(true)
		frame:SetToplevel(true)
		frame:SetClampedToScreen(true)
		frame:SetMovable(true)
		frame:SetFrameStrata("FULLSCREEN")

		local titleFrame = CreateFrame("Frame", nil, frame)
		titleFrame:SetWidth(150)
		titleFrame:SetHeight(34.56)
		titleFrame:SetPoint("TOP", 0, 12)
		titleFrame:EnableMouse(true)
		titleFrame:RegisterForDrag("LeftButton")
		titleFrame:SetScript("OnDragStart", function(this)
			frame:StartMoving()
		end)
		titleFrame:SetScript("OnDragStop", function(this)
			frame:StopMovingOrSizing()
		end)

		local titleTex = titleFrame:CreateTexture(nil, "ARTWORK")
		titleTex:SetTexture([=[Interface\DialogFrame\UI-DialogBox-Header]=])
		titleTex:SetAllPoints()
		titleTex:SetTexCoord(0.235, 0.76, 0.04, 0.58)

		local title = titleFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal")
		title:SetPoint("CENTER")
		title:SetText(L["Add note"])

		local nameLabel = frame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall")
		nameLabel:SetPoint("TOPLEFT", 25, -28)
		nameLabel:SetText(L["Name"])

		local function style(f)
			local left = f:CreateTexture(nil, "BACKGROUND")
			left:SetTexture(0.4, 0.4, 0.4)
			left:SetWidth(1)
			left:SetPoint("TOPLEFT")
			left:SetPoint("BOTTOMLEFT")
			local top = f:CreateTexture(nil, "BACKGROUND")
			top:SetTexture(0.4, 0.4, 0.4)
			top:SetHeight(1)
			top:SetPoint("TOPLEFT")
			top:SetPoint("TOPRIGHT")
			local right = f:CreateTexture(nil, "BACKGROUND")
			right:SetTexture(0.8, 0.8, 0.8)
			right:SetWidth(1)
			right:SetPoint("TOPRIGHT")
			right:SetPoint("BOTTOMRIGHT")
			local bottom = f:CreateTexture(nil, "BACKGROUND")
			bottom:SetTexture(0.8, 0.8, 0.8)
			bottom:SetHeight(1)
			bottom:SetPoint("BOTTOMLEFT")
			bottom:SetPoint("BOTTOMRIGHT")
			local bg = f:CreateTexture(nil, "BACKGROUND")
			bg:SetTexture(0, 0, 0, 0.5)
			bg:SetPoint("TOPLEFT", 1, -1)
			bg:SetPoint("BOTTOMRIGHT", -1, 1)
		end

		local nameEditBox = CreateFrame("EditBox", frame:GetName() .. "_NameEditBox", frame)
		nameEditBox:SetPoint("TOP", nameLabel, "BOTTOM")
		nameEditBox:SetPoint("LEFT", frame, "LEFT", 24, 0)
		nameEditBox:SetPoint("RIGHT", frame, "RIGHT", -24, 0)
		nameEditBox:SetHeight(24)
		nameEditBox:SetMaxLetters(120)
		nameEditBox:SetAutoFocus(false)
		nameEditBox:SetFontObject("ChatFontNormal")
		nameEditBox:SetScript("OnEscapePressed", function(this)
			this:ClearFocus()
		end)
		nameEditBox:SetScript("OnEditFocusLost", function(this)
			this:HighlightText(0, 0)
		end)
		nameEditBox:SetScript("OnEditFocusGained", function(this)
			this:HighlightText()
		end)
		nameEditBox:SetScript("OnTextChanged", function(this)
			if frame.noteData then
				local text = this:GetText():trim()
				if text == "" then
					text = nil
				end
				if type(frame.noteData) ~= "table" then
					if text then
						local noteData = { frame.noteData }
						frame.noteData = noteData
						noteDB[frame.zone][frame.id] = noteData
					end
				elseif not text and not frame.noteData[3] then
					local noteData = frame.noteData[1]
					frame.noteData = noteData
					noteDB[frame.zone][frame.id] = noteData
				else
					frame.noteData[2] = text
				end
				Cartographer3_Notes.RefreshNote(frame.zone, frame.x, frame.y)
			end
		end)
		style(nameEditBox)

		local descriptionLabel = frame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall")
		descriptionLabel:SetPoint("LEFT", 25, 0)
		descriptionLabel:SetPoint("TOP", nameEditBox, "BOTTOM", 0, -5)
		descriptionLabel:SetText(L["Description"])

		local descriptionScrollFrame = CreateFrame("ScrollFrame", frame:GetName() .. "_DescriptionScrollFrame", frame)
		descriptionScrollFrame:SetPoint("TOP", descriptionLabel, "BOTTOM")
		descriptionScrollFrame:SetPoint("LEFT", frame, "LEFT", 24, 0)
		descriptionScrollFrame:SetPoint("RIGHT", frame, "RIGHT", -24, 0)
		descriptionScrollFrame:SetHeight(42)
		style(descriptionScrollFrame)

		local descriptionEditBox = CreateFrame("EditBox", frame:GetName() .. "_DescriptionEditBox", descriptionScrollFrame)
		descriptionEditBox:SetAutoFocus(false)
		descriptionEditBox:SetMultiLine(true)
		descriptionEditBox:SetWidth(nameEditBox:GetWidth())
		descriptionEditBox:SetScript("OnEscapePressed", nameEditBox:GetScript("OnEscapePressed"))
		descriptionEditBox:SetScript("OnEditFocusLost", nameEditBox:GetScript("OnEditFocusLost"))
		descriptionEditBox:SetScript("OnEditFocusGained", nameEditBox:GetScript("OnEditFocusGained"))
		descriptionEditBox:SetFontObject(nameEditBox:GetFontObject())
		descriptionScrollFrame:SetScrollChild(descriptionEditBox)
		local fs = UIParent:CreateFontString(nil, "ARTWORK")
		descriptionEditBox:SetScript("OnTextChanged", function(this)
			fs:SetFontObject(this:GetFontObject())
			fs:SetWidth(this:GetParent():GetWidth())
			fs:SetText(this:GetText())
			local height = fs:GetHeight() + 6
			if height < 42 then
				height = 42
			end
			this:GetParent():SetHeight(height)
			frame:SetHeight(height + 150)

			if frame.noteData then
				local text = this:GetText():trim()
				if text == "" then
					text = nil
				end
				if type(frame.noteData) ~= "table" then
					if text then
						local noteData = { frame.noteData }
						frame.noteData = noteData
						noteDB[frame.zone][frame.id] = noteData
					end
				elseif not text and not frame.noteData[2] then
					local noteData = frame.noteData[1]
					frame.noteData = noteData
					noteDB[frame.zone][frame.id] = noteData
				else
					frame.noteData[3] = text
				end
				Cartographer3_Notes.RefreshNote(frame.zone, frame.x, frame.y)
			end
		end)

		local iconDropDown = CreateFrame("Frame", frame:GetName() .. "_IconDropDown", frame, "UIDropDownMenuTemplate")
		iconDropDown:SetPoint("TOPLEFT", descriptionScrollFrame, "BOTTOMLEFT", -20, -4)
		iconDropDown.value = "Star"
		iconDropDown.text = _G[iconDropDown:GetName() .. "Text"]
		local texture = iconDropDown:CreateTexture(nil, "OVERLAY")
		texture:SetPoint("LEFT", iconDropDown, "LEFT", 24, 2)
		texture:SetWidth(14)
		texture:SetHeight(14)
		local function func(k)
			local iconData = icons[k]
			iconDropDown.value = k
			iconDropDown.text:SetText(iconData.text)
			if iconData.color then
				iconDropDown.text:SetTextColor(iconData.color.r, iconData.color.g, iconData.color.b)
			else
				iconDropDown.text:SetTextColor(1, 1, 1)
			end
			texture:SetTexture(iconData.icon)
			if iconData.tCoordLeft then
				texture:SetTexCoord(iconData.tCoordLeft, iconData.tCoordRight, iconData.tCoordTop, iconData.tCoordBottom)
			else
				texture:SetTexCoord(1, 1, 1, 1)
			end
			if frame.noteData then
				if type(frame.noteData) == "table" then
					frame.noteData[1] = k
				else
					frame.noteData = k
					noteDB[frame.zone][frame.id] = k
				end
				Cartographer3_Notes.RefreshNote(frame.zone, frame.x, frame.y)
			end
		end
		local function icon_sort(alpha, bravo)
			local alpha_data, bravo_data = icons[alpha], icons[bravo]

			return alpha_data.text < bravo_data.text
		end
		local tmp = {}
		UIDropDownMenu_Initialize(iconDropDown, function()
			for k in pairs(icons) do
				tmp[#tmp+1] = k
			end
			table.sort(tmp, icon_sort)
			for i, k in ipairs(tmp) do
				tmp[i] = nil
				local v = icons[k]
				local info = UIDropDownMenu_CreateInfo()
				info.text = v.text
				info.value = k
				info.icon = v.icon
				info.tCoordLeft = v.tCoordLeft
				info.tCoordRight = v.tCoordRight
				info.tCoordTop = v.tCoordTop
				info.tCoordBottom = v.tCoordBottom
				info.textR = v.color and v.color.r
				info.textG = v.color and v.color.g
				info.textB = v.color and v.color.b
				info.checked = k == iconDropDown.value
				info.func = func
				info.arg1 = k
				UIDropDownMenu_AddButton(info)
			end
		end)
		if WotLK then
			UIDropDownMenu_SetWidth(iconDropDown, 100)
		else
			UIDropDownMenu_SetWidth(100, iconDropDown)
		end
		func("Star")

		local cancelButton = CreateFrame("Button", frame:GetName() .. "_CancelButton", frame, "OptionsButtonTemplate")
		cancelButton:SetWidth(96)
		cancelButton:SetHeight(22)
		cancelButton:SetText(CANCEL)
		cancelButton:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT", -16, 16)
		cancelButton:SetScript("OnClick", function(this)
			if frame.oldNoteData_icon then
				if not frame.oldNoteData_name and not frame.oldNoteData_description then
					frame.noteData = frame.oldNoteData_icon
					noteDB[frame.zone][frame.id] = frame.oldNoteData_icon
				else
					if type(frame.noteData) ~= "table" then
						frame.noteData = {}
						noteDB[frame.zone][frame.id] = frame.noteData
					end
					frame.noteData[1] = frame.oldNoteData_icon
					frame.noteData[2] = frame.oldNoteData_name
					frame.noteData[3] = frame.oldNoteData_description
				end
			else
				local noteDB_zone = noteDB[frame.zone]
				if noteDB_zone then
					noteDB_zone[frame.id] = nil
					if not next(noteDB_zone) then
						noteDB[frame.zone] = nil
					end
				end
			end
			Cartographer3_Notes.RefreshNote(frame.zone, frame.x, frame.y)
			frame:Hide()
		end)

		local okayButton = CreateFrame("Button", frame:GetName() .. "_OkayButton", frame, "OptionsButtonTemplate")
		okayButton:SetWidth(96)
		okayButton:SetHeight(22)
		okayButton:SetText(OKAY)
		okayButton:SetPoint("RIGHT", cancelButton, "LEFT")
		okayButton:SetScript("OnClick", function(this)
			frame:Hide()
		end)

		frame:SetScript("OnMouseDown", function(this, button)
			if button == "LeftButton" and MouseIsOver(descriptionScrollFrame) then
				descriptionEditBox:SetFocus()
			end
		end)

		frame:SetScript("OnHide", function(this)
			frame.noteData = nil
		end)

		nameEditBox:SetScript("OnTabPressed", function(this)
			descriptionEditBox:SetFocus()
		end)

		descriptionEditBox:SetScript("OnTabPressed", function(this)
			this:ClearFocus()
		end)

		function getFrame(zone, x, y)
			nameEditBox:SetFocus()
			local noteDB_zone = noteDB[zone]
			local noteData
			local id = CoordToID(x, y)
			frame.zone = zone
			frame.x = x
			frame.y = y
			frame.id = id
			if noteDB_zone then
				noteData = noteDB_zone[id]
			else
				noteDB_zone = {}
				noteDB[zone] = noteDB_zone
			end
			if not noteData then
				title:SetText(L["Add Note"])
				nameEditBox:SetText('')
				descriptionEditBox:SetText('')
				noteData = iconDropDown.value
				noteDB_zone[id] = noteData
				Cartographer3_Notes.RefreshNote(zone, x, y)
				frame.oldNoteData_icon = nil
				frame.oldNoteData_name = nil
				frame.oldNoteData_description = nil
			else
				title:SetText(L["Edit Note"])
				local icon, name, description
				if type(noteData) == "table" then
					icon, name, description = noteData[1], noteData[2], noteData[3]
				else
					icon = noteData
				end
				func(icon)
				nameEditBox:SetText(name or '')
				descriptionEditBox:SetText(description or '')
				frame.oldNoteData_icon = icon
				frame.oldNoteData_name = name
				frame.oldNoteData_description = description
			end
			frame.noteData = noteData
			frame:Show()
			return frame
		end
		return getFrame(...)
	end
end

function Cartographer3_Notes.ShowAddNoteFrame(zone, x, y)
	getFrame(zone, x, y)
end

function Cartographer3_Notes.Enable()
	Cartographer3_Notes.RefreshMap()
end

function Cartographer3_Notes.Disable()
	Cartographer3_Notes.ClearMap()
end

do
	local zoneTexture, zoneX, zoneY
	local function addNoteHere()
		Cartographer3_Notes.ShowAddNoteFrame(zoneTexture, zoneX, zoneY)
	end
	local function editNote(poi)
		if not poi.id then
			return
		end
		local x, y = IDToCoord(poi.id)
		if x then
			Cartographer3_Notes.ShowAddNoteFrame(zoneTexture, x, y)
		end
	end
	local function removeNote(poi)
		if not poi.id then
			return
		end
		local x, y = IDToCoord(poi.id)
		if x then
			getFrame(zoneTexture, x, y):Hide()
			Cartographer3_Notes.RemoveNote(zoneTexture, x, y)
		end
	end
	Cartographer3.AddRightClickMenuHandler(function(data, level, value, needSeparator)
		if level == 1 then
			if needSeparator then
				local info = UIDropDownMenu_CreateInfo()
				info.text = " "
				info.isTitle = true
				UIDropDownMenu_AddButton(info, level)
			end
			local info = UIDropDownMenu_CreateInfo()
			info.text = L["Add note here"]
			info.func = addNoteHere
			zoneTexture, zoneX, zoneY = data.zoneTexture, data.zoneX, data.zoneY
			UIDropDownMenu_AddButton(info, level)

			local first = true
			for i, poi in ipairs(data.pois) do
				if poi.poiType == "Note" then
					if first then
						first = false
						local info = UIDropDownMenu_CreateInfo()
						info.text = " "
						info.isTitle = true
						UIDropDownMenu_AddButton(info, level)
					end
					local info = UIDropDownMenu_CreateInfo()
					info.text = L["Edit note '%s'"]:format(poi.name)
					info.func = editNote
					info.arg1 = poi
					UIDropDownMenu_AddButton(info, level)

					local info = UIDropDownMenu_CreateInfo()
					info.text = L["Remove note '%s'"]:format(poi.name)
					info.func = removeNote
					info.arg1 = poi
					UIDropDownMenu_AddButton(info, level)
				end
			end
			return true
		end
	end)
end

for i, v in ipairs { "/note", "/addnote" } do
	_G["SLASH_CARTOGRAPHERTHREE_NOTES" .. i] = v
end

local function printUsage()
	DEFAULT_CHAT_FRAME:AddMessage(L["|cffffff7fCartographer3 - Notes |r/note |cffffff7fUsage:|r"])
	DEFAULT_CHAT_FRAME:AddMessage(L["|cffffff7f/way <x> <y> [name]|r - Set waypoint to x, y with name"])
	DEFAULT_CHAT_FRAME:AddMessage(L["|cffffff7f/way <zone> <x> <y> [name]|r - Set waypoint to x, y in zone with name"])
end

local zoneList
local possibleMatches = {}
_G.hash_SlashCmdList.CARTOGRAPHERTHREE_NOTES = nil
_G.SlashCmdList.CARTOGRAPHERTHREE_NOTES = function(text)
	if not Cartographer3_Notes.IsEnabled() then
		DEFAULT_CHAT_FRAME:AddMessage(L["|cffffff7fCartographer3 - Notes|r is currently disabled."])
		return
	end
	local tokens = { (", "):split(text) }

	for i = #tokens, 1, -1 do
		local v = tokens[i]
		if v:trim() == "" then
			table.remove(tokens, i)
		end
	end

	if not tokens[1] then
		tokens[1] = ""
	end

	local first = tokens[1]:lower()

	if first ~= "" then
		local num = 0
		for i, v in ipairs(tokens) do
			if tonumber(v) then
				num = i - 1
				break
			end
		end

		local zone = nil
		if num > 0 then
			zone = table.concat(tokens, " ", 1, num)
		end

		local x, y = tokens[num + 1], tokens[num + 2]

		local name = table.concat(tokens, " ", num + 3)
		if name == "" then
			name = nil
		end

		local texture
		if zone then
			if not zoneList then
				zoneList = {}
				for texture, zoneData in pairs(Cartographer3.Data.ZONE_DATA) do
					zoneList[zoneData.localizedName:lower():gsub("[%L]", "")] = texture
				end
			end
			local lowerZone = zone:lower():gsub("[%L]", "")
			for name, texture in pairs(zoneList) do
				if name:match(lowerZone) then
					possibleMatches[#possibleMatches+1] = texture
				end
			end
			if #possibleMatches > 1 then
				local names = {}
				for i, texture in ipairs(possibleMatches) do
					names[#names+1] = Cartographer3.Data.ZONE_DATA[texture].localizedName
				end
				table.sort(names)

				DEFAULT_CHAT_FRAME:AddMessage(L["Found multiple matches for zone '%s': %s"]:format(zone, table.concat(names, ", ")))
				for i = 1, #possibleMatches do
					possibleMatches[i] = nil
				end
				return
			end
			texture = possibleMatches[1]
			possibleMatches[1] = nil

			if not texture then
				DEFAULT_CHAT_FRAME:AddMessage(L["No match was found for zone '%s'"]:format(zone))
				return
			end
		end

		x, y = tonumber(x), tonumber(y)
		if not x or not y then
			printUsage()
			return
		end

		x, y = x / 100, y / 100

		if not texture then
			texture = GetMapInfo()
		end

		local icon = "Star"
		if name then
			local name_lower = name:lower()
			for k, v in pairs(icons) do
				if v.text:lower() == name_lower or k:lower() == name then
					icon = k
					name = nil
					break
				end
			end
		end
		Cartographer3_Notes.AddNote(texture, x, y, icon, name)
	else
		printUsage()
	end
end
if WotLK then
	local oldHandler = _G.SlashCmdList.CARTOGRAPHERTHREE_NOTES
	function _G.SlashCmdList.CARTOGRAPHERTHREE_NOTES(chatFrame, text)
		oldHandler(text)
	end
end
