--[[

	AtlasQuest, a World of Warcraft addon.
	Email me at mystery8@gmail.com

	This file is part of AtlasQuest.

	AtlasQuest is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	AtlasQuest is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with AtlasQuest; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


This file is for storing quest IDs and Levels.

The Quest IDs are stored in the old/current variable format:

Inst[INST #]Quest[QUEST #]_QuestID
Inst1Quest1_QuestID

The Quest Levels are stored in the new format:
AQ_[Quest ID]_Level
AQ_214_Level


Although the quest levels are already stored in the localization files, I
cannot be 100% certain they are all up to date. Storing them here as well
for the purpose of quest links helps with that.


- Thandrenn

--]]

----------------------------------------------
---------------- DUNGEONS --------------------
----------------------------------------------




--------------- INST1 - Deadmines (VC) ---------------

Inst1Quest1_QuestID = "27756"
Inst1Quest2_QuestID = "27758"
Inst1Quest3_QuestID = "27781"
Inst1Quest4_QuestID = "27785"
Inst1Quest5_QuestID = "27790"

Inst1Quest1_HORDE_QuestID = "27842"
Inst1Quest2_HORDE_QuestID = "27844"
Inst1Quest3_HORDE_QuestID = "27847"
Inst1Quest4_HORDE_QuestID = "27848"
Inst1Quest5_HORDE_QuestID = "27850"


AQ_27756_Level = "16"
AQ_27758_Level = "16"
AQ_27781_Level = "16"
AQ_27785_Level = "16"
AQ_27790_Level = "17"
AQ_27842_Level = "16"
AQ_27844_Level = "16"
AQ_27847_Level = "16"
AQ_27848_Level = "16"
AQ_27850_Level = "17"



--------------- INST2 - Wailing Caverns (WC) ---------------

Inst2Quest1_QuestID = "26872"
Inst2Quest2_QuestID = "26873"
Inst2Quest3_QuestID = "26870"

Inst2Quest1_HORDE_QuestID = "26878"
Inst2Quest2_HORDE_QuestID = "26872"
Inst2Quest3_HORDE_QuestID = "26873"
Inst2Quest4_HORDE_QuestID = "26870"


AQ_26878_Level = "16"
AQ_26872_Level = "18"
AQ_26873_Level = "18"
AQ_26870_Level = "21"



--------------- INST3 - Ragefire Chasm (RFC) ---------------

Inst3Quest1_QuestID = "30997"
Inst3Quest2_QuestID = "30995"
Inst3Quest3_QuestID = "30998"
Inst3Quest4_QuestID = "30996"

Inst3Quest1_HORDE_QuestID = "31037"
Inst3Quest2_HORDE_QuestID = "30982"
Inst3Quest3_HORDE_QuestID = "30984"
Inst3Quest4_HORDE_QuestID = "30969"
Inst3Quest5_HORDE_QuestID = "30983"


AQ_30997_Level = "15"
AQ_30995_Level = "15"
AQ_30998_Level = "15"
AQ_30996_Level = "15"
AQ_31037_Level = "15"
AQ_30982_Level = "15"
AQ_30984_Level = "15"
AQ_30969_Level = "15"
AQ_30983_Level = "15"



--------------- INST4 - Uldaman (Ulda) ---------------

Inst4Quest1_QuestID = "27672"
Inst4Quest2_QuestID = "27677"
Inst4Quest3_QuestID = "27673"
Inst4Quest4_QuestID = "27676"
Inst4Quest5_QuestID = "2278"
Inst4Quest6_QuestID = "2280"

Inst4Quest1_HORDE_QuestID = "27679"
Inst4Quest2_HORDE_QuestID = "27680"
Inst4Quest3_HORDE_QuestID = "27682"
Inst4Quest4_HORDE_QuestID = "27681"
Inst4Quest5_HORDE_QuestID = "2278"
Inst4Quest6_HORDE_QuestID = "2280"


AQ_27672_Level = "39"
AQ_27677_Level = "40"
AQ_27673_Level = "39"
AQ_27676_Level = "39"
AQ_2278_Level = "40"
AQ_2280_Level = "40"
AQ_27679_Level = "39"
AQ_27680_Level = "40"
AQ_27682_Level = "39"
AQ_27681_Level = "39"



--------------- INST5 - Blackrock Depths (BRD) ---------------

Inst5Quest1_QuestID = "27565"
Inst5Quest2_QuestID = "27567"
Inst5Quest3_QuestID = "27603"
Inst5Quest4_QuestID = "27568"
Inst5Quest5_QuestID = "27569"
Inst5Quest6_QuestID = "27571"
Inst5Quest7_QuestID = "27573"
Inst5Quest8_QuestID = "27578"
Inst5Quest9_QuestID = "27596"
Inst5Quest10_QuestID = "28393"
Inst5Quest11_QuestID = "28401"
Inst5Quest12_QuestID = "28399"
Inst5Quest13_QuestID = "28343"
Inst5Quest14_QuestID = "28406"
Inst5Quest15_QuestID = "28394"
Inst5Quest16_QuestID = "28398"
Inst5Quest17_QuestID = "28328"
Inst5Quest18_QuestID = "28405"
Inst5Quest19_QuestID = "7848"
Inst5Quest20_QuestID = "4083"
Inst5Quest21_QuestID = "12491"

Inst5Quest1_HORDE_QuestID = "27579"
Inst5Quest2_HORDE_QuestID = "27581"
Inst5Quest3_HORDE_QuestID = "27603"
Inst5Quest4_HORDE_QuestID = "27582"
Inst5Quest5_HORDE_QuestID = "27585"
Inst5Quest6_HORDE_QuestID = "27589"
Inst5Quest7_HORDE_QuestID = "27591"
Inst5Quest8_HORDE_QuestID = "27593"
Inst5Quest9_HORDE_QuestID = "27596"
Inst5Quest10_HORDE_QuestID = "28457"
Inst5Quest11_HORDE_QuestID = "28465"
Inst5Quest12_HORDE_QuestID = "28459"
Inst5Quest13_HORDE_QuestID = "28343"
Inst5Quest14_HORDE_QuestID = "28463"
Inst5Quest15_HORDE_QuestID = "28461"
Inst5Quest16_HORDE_QuestID = "28458"
Inst5Quest17_HORDE_QuestID = "28474"
Inst5Quest18_HORDE_QuestID = "28473"
Inst5Quest19_HORDE_QuestID = "28466"
Inst5Quest20_HORDE_QuestID = "7848"
Inst5Quest21_HORDE_QuestID = "4083"
Inst5Quest22_HORDE_QuestID = "12492"


AQ_27565_Level = "52"
AQ_27567_Level = "55"
AQ_27603_Level = "52"
AQ_27568_Level = "54"
AQ_27569_Level = "55"
AQ_27571_Level = "56"
AQ_27573_Level = "57"
AQ_27578_Level = "58"
AQ_27596_Level = "55"
AQ_28393_Level = "50"
AQ_28401_Level = "50"
AQ_28399_Level = "50"
AQ_28343_Level = "50"
AQ_28406_Level = "50"
AQ_28394_Level = "50"
AQ_28398_Level = "50"
AQ_28328_Level = "50"
AQ_28405_Level = "50"
AQ_7848_Level = "60"
AQ_4083_Level = "55"
AQ_12491_Level = "90"
AQ_27579_Level = "52"
AQ_27581_Level = "55"
AQ_27582_Level = "54"
AQ_27585_Level = "55"
AQ_27589_Level = "56"
AQ_27591_Level = "57"
AQ_27593_Level = "58"
AQ_28457_Level = "50"
AQ_28465_Level = "50"
AQ_28459_Level = "50"
AQ_28463_Level = "50"
AQ_28461_Level = "50"
AQ_28458_Level = "50"
AQ_28474_Level = "50"
AQ_28473_Level = "50"
AQ_28466_Level = "50"
AQ_12492_Level = "90"



--------------- INST6 - Blackwing Lair (BWL) ---------------

Inst6Quest1_QuestID = "8730"

Inst6Quest1_HORDE_QuestID = "8730"


AQ_8730_Level = "60"



--------------- INST7 - Blackfathom Deeps (BFD) ---------------

Inst7Quest1_QuestID = "34672"

Inst7Quest1_HORDE_QuestID = "34673"


AQ_34672_Level = "25"
AQ_34673_Level = "25"



--------------- INST8 - Lower Blackrock Spire (LBRS) ---------------

Inst8Quest1_QuestID = "27470"
Inst8Quest2_QuestID = "27471"
Inst8Quest3_QuestID = "27469"
Inst8Quest4_QuestID = "27440"

Inst8Quest1_HORDE_QuestID = "27470"
Inst8Quest2_HORDE_QuestID = "27469"
Inst8Quest3_HORDE_QuestID = "27440"


AQ_27470_Level = "58"
AQ_27471_Level = "58"
AQ_27469_Level = "58"
AQ_27440_Level = "59"



--------------- INST10 - Dire Maul East (DM) ---------------

Inst10Quest1_QuestID = "27129"
Inst10Quest2_QuestID = "27107"
Inst10Quest3_QuestID = "27108"
Inst10Quest4_QuestID = "27105"
Inst10Quest5_QuestID = "27104"
Inst10Quest6_QuestID = "27103"

Inst10Quest1_HORDE_QuestID = "27130"
Inst10Quest2_HORDE_QuestID = "27107"
Inst10Quest3_HORDE_QuestID = "27108"
Inst10Quest4_HORDE_QuestID = "27105"
Inst10Quest5_HORDE_QuestID = "27104"
Inst10Quest6_HORDE_QuestID = "27103"


AQ_27129_Level = "40"
AQ_27107_Level = "40"
AQ_27108_Level = "40"
AQ_27105_Level = "40"
AQ_27104_Level = "41"
AQ_27103_Level = "41"
AQ_27130_Level = "40"



--------------- INST11 - Dire Maul North (DM) ---------------

Inst11Quest1_QuestID = "27133"
Inst11Quest2_QuestID = "27125"
Inst11Quest3_QuestID = "27118"
Inst11Quest4_QuestID = "27119"
Inst11Quest5_QuestID = "27124"
Inst11Quest6_QuestID = "27114"

Inst11Quest1_HORDE_QuestID = "27134"
Inst11Quest2_HORDE_QuestID = "27128"
Inst11Quest3_HORDE_QuestID = "27118"
Inst11Quest4_HORDE_QuestID = "27119"
Inst11Quest5_HORDE_QuestID = "27124"
Inst11Quest6_HORDE_QuestID = "27114"


AQ_27133_Level = "46"
AQ_27125_Level = "47"
AQ_27118_Level = "46"
AQ_27119_Level = "46"
AQ_27124_Level = "47"
AQ_27114_Level = "46"
AQ_27134_Level = "46"
AQ_27128_Level = "47"



--------------- INST12 - Dire Maul West (DM) ---------------

Inst12Quest1_QuestID = "27131"
Inst12Quest2_QuestID = "27112"
Inst12Quest3_QuestID = "27113"
Inst12Quest4_QuestID = "27109"
Inst12Quest5_QuestID = "27110"
Inst12Quest6_QuestID = "27111"
Inst12Quest7_QuestID = "7506"
Inst12Quest8_QuestID = "7503"
Inst12Quest9_QuestID = "7500"
Inst12Quest10_QuestID = "7501"
Inst12Quest11_QuestID = "7504"
Inst12Quest12_QuestID = "7498"
Inst12Quest13_QuestID = "7505"
Inst12Quest14_QuestID = "7502"
Inst12Quest15_QuestID = "7499"

Inst12Quest1_HORDE_QuestID = "27132"
Inst12Quest2_HORDE_QuestID = "27112"
Inst12Quest3_HORDE_QuestID = "27113"
Inst12Quest4_HORDE_QuestID = "27109"
Inst12Quest5_HORDE_QuestID = "27110"
Inst12Quest6_HORDE_QuestID = "27111"
Inst12Quest7_HORDE_QuestID = "7506"
Inst12Quest8_HORDE_QuestID = "7503"
Inst12Quest9_HORDE_QuestID = "7500"
Inst12Quest10_HORDE_QuestID = "7501"
Inst12Quest11_HORDE_QuestID = "7504"
Inst12Quest12_HORDE_QuestID = "7498"
Inst12Quest13_HORDE_QuestID = "7505"
Inst12Quest14_HORDE_QuestID = "7502"
Inst12Quest15_HORDE_QuestID = "7499"

AQ_27131_Level = "42"
AQ_27112_Level = "43"
AQ_27113_Level = "43"
AQ_27109_Level = "43"
AQ_27110_Level = "44"
AQ_27111_Level = "44"
AQ_27132_Level = "42"
AQ_7506_Level = "60"
AQ_7503_Level = "60"
AQ_7500_Level = "60"
AQ_7501_Level = "60"
AQ_7504_Level = "60"
AQ_7498_Level = "60"
AQ_7505_Level = "60"
AQ_7502_Level = "60"
AQ_7499_Level = "60"



--------------- INST13 - Maraudon (Mara) ---------------

Inst13Quest1_QuestID = "27697"
Inst13Quest2_QuestID = "27698"
Inst13Quest3_QuestID = "27692"

Inst13Quest1_HORDE_QuestID = "27697"
Inst13Quest2_HORDE_QuestID = "27698"
Inst13Quest3_HORDE_QuestID = "27692"


AQ_27697_Level = "34"
AQ_27698_Level = "36"
AQ_27692_Level = "39"



--------------- INST14 - Molten Core (MC) ---------------

Inst14Quest1_QuestID = "7786"
Inst14Quest2_QuestID = "7604"

Inst14Quest1_HORDE_QuestID = "7786"
Inst14Quest2_HORDE_QuestID = "7604"


AQ_7786_Level = "60"
AQ_7604_Level = "60"



--------------- INST16 - Onyxia's Lair (Ony) ---------------

Inst16Quest1_QuestID = "24428"

Inst16Quest1_HORDE_QuestID = "24429"


AQ_24428_Level = "80"
AQ_24429_Level = "80"



--------------- INST17 - Razorfen Downs (RFD) ---------------

Inst17Quest1_QuestID = "27063"
Inst17Quest2_QuestID = "33513"
Inst17Quest3_QuestID = "33514"

Inst17Quest1_HORDE_QuestID = "27062"
Inst17Quest2_HORDE_QuestID = "33513"
Inst17Quest3_HORDE_QuestID = "33514"


AQ_27063_Level = "43"
AQ_33513_Level = "44"
AQ_33514_Level = "46"
AQ_27062_Level = "43"



--------------- INST18 - Razorfen Kraul (RFK) ---------------

Inst18Quest1_QuestID = "26908"
Inst18Quest2_QuestID = "26907"
Inst18Quest3_QuestID = "26901"
Inst18Quest4_QuestID = "26906"
Inst18Quest5_QuestID = "26905"

Inst18Quest1_HORDE_QuestID = "26908"
Inst18Quest2_HORDE_QuestID = "26907"
Inst18Quest3_HORDE_QuestID = "26901"
Inst18Quest4_HORDE_QuestID = "26906"
Inst18Quest5_HORDE_QuestID = "26905"


AQ_26908_Level = "33"
AQ_26907_Level = "35"
AQ_26901_Level = "35"
AQ_26906_Level = "35"
AQ_26905_Level = "35"



--------------- INST58 - Scarlet Monastery ---------------

Inst58Quest1_QuestID = "31513"
Inst58Quest2_QuestID = "31515"
Inst58Quest3_QuestID = "31514"
Inst58Quest4_QuestID = "31516"

Inst58Quest1_HORDE_QuestID = "31513"
Inst58Quest2_HORDE_QuestID = "31515"
Inst58Quest3_HORDE_QuestID = "31514"
Inst58Quest4_HORDE_QuestID = "31516"


AQ_31513_Level = "34"
AQ_31515_Level = "90"
AQ_31514_Level = "34"
AQ_31516_Level = "90"



--------------- INST59 - Scarlet Halls ---------------

Inst59Quest1_QuestID = "31513"
Inst59Quest2_QuestID = "31515"
Inst59Quest3_QuestID = "31514"
Inst59Quest4_QuestID = "31516"

Inst59Quest1_HORDE_QuestID = "31513"
Inst59Quest2_HORDE_QuestID = "31515"
Inst59Quest3_HORDE_QuestID = "31514"
Inst59Quest4_HORDE_QuestID = "31516"


AQ_31513_Level = "34"
AQ_31515_Level = "90"
AQ_31514_Level = "34"
AQ_31516_Level = "90"



--------------- INST20 - Scholomance (Scholo) ---------------

Inst20Quest1_QuestID = "31440"
Inst20Quest2_QuestID = "31442"
Inst20Quest3_QuestID = "31447"
Inst20Quest4_QuestID = "31448"
Inst20Quest5_QuestID = "28756"

Inst20Quest1_HORDE_QuestID = "31440"
Inst20Quest2_HORDE_QuestID = "31442"
Inst20Quest3_HORDE_QuestID = "31447"
Inst20Quest4_HORDE_QuestID = "31448"
Inst20Quest5_HORDE_QuestID = "28756"


AQ_31440_Level = "43"
AQ_31442_Level = "90"
AQ_31447_Level = "43"
AQ_31448_Level = "90"
AQ_28756_Level = "42"



--------------- INST21 - Shadowfang Keep (SFK) ---------------

Inst21Quest1_QuestID = "27917"
Inst21Quest2_QuestID = "27920"
Inst21Quest3_QuestID = "27921"
Inst21Quest4_QuestID = "27968"
Inst21Quest5_QuestID = "27356"
Inst21Quest6_QuestID = "27344"
Inst21Quest7_QuestID = "27354"
Inst21Quest8_QuestID = "27343"
Inst21Quest9_QuestID = "27361"
Inst21Quest10_QuestID = "27362"
Inst21Quest11_QuestID = "27363"
Inst21Quest12_QuestID = "27351"
Inst21Quest13_QuestID = "27353"
Inst21Quest14_QuestID = "27355"
Inst21Quest15_QuestID = "27337"
Inst21Quest16_QuestID = "24745"

Inst21Quest1_HORDE_QuestID = "27974"
Inst21Quest2_HORDE_QuestID = "27988"
Inst21Quest3_HORDE_QuestID = "27996"
Inst21Quest4_HORDE_QuestID = "27998"
Inst21Quest5_HORDE_QuestID = "27404"
Inst21Quest6_HORDE_QuestID = "27395"
Inst21Quest7_HORDE_QuestID = "27400"
Inst21Quest8_HORDE_QuestID = "27403"
Inst21Quest9_HORDE_QuestID = "27434"
Inst21Quest10_HORDE_QuestID = "27441"
Inst21Quest11_HORDE_QuestID = "27436"
Inst21Quest12_HORDE_QuestID = "27435"
Inst21Quest13_HORDE_QuestID = "27439"
Inst21Quest14_HORDE_QuestID = "27437"
Inst21Quest15_HORDE_QuestID = "27396"
Inst21Quest16_HORDE_QuestID = "27397"
Inst21Quest17_HORDE_QuestID = "27402"
Inst21Quest18_HORDE_QuestID = "27365"
Inst21Quest19_HORDE_QuestID = "14483"


AQ_27917_Level = "18"
AQ_27920_Level = "19"
AQ_27921_Level = "20"
AQ_27968_Level = "21"
AQ_27356_Level = "20"
AQ_27344_Level = "20"
AQ_27354_Level = "20"
AQ_27343_Level = "20"
AQ_27361_Level = "20"
AQ_27362_Level = "20"
AQ_27363_Level = "20"
AQ_27351_Level = "20"
AQ_27353_Level = "20"
AQ_27355_Level = "20"
AQ_27337_Level = "20"
AQ_24745_Level = "90"
AQ_27974_Level = "18"
AQ_27988_Level = "19"
AQ_27996_Level = "20"
AQ_27998_Level = "21"
AQ_27404_Level = "20"
AQ_27395_Level = "20"
AQ_27400_Level = "20"
AQ_27403_Level = "20"
AQ_27434_Level = "20"
AQ_27441_Level = "20"
AQ_27436_Level = "20"
AQ_27435_Level = "20"
AQ_27439_Level = "20"
AQ_27437_Level = "20"
AQ_27396_Level = "20"
AQ_27397_Level = "20"
AQ_27402_Level = "20"
AQ_27365_Level = "20"
AQ_14483_Level = "90"



--------------- INST22 - Stratholme - Crusaders' Square (Strat) ---------------

Inst22Quest1_QuestID = "27422"
Inst22Quest2_QuestID = "27352"
Inst22Quest3_QuestID = "27192"
Inst22Quest4_QuestID = "28755"
Inst22Quest5_QuestID = "27305"
Inst22Quest6_QuestID = "27223"
Inst22Quest7_QuestID = "27185"
Inst22Quest8_QuestID = "27208"

Inst22Quest1_HORDE_QuestID = "27422"
Inst22Quest2_HORDE_QuestID = "27352"
Inst22Quest3_HORDE_QuestID = "27192"
Inst22Quest4_HORDE_QuestID = "28755"
Inst22Quest5_HORDE_QuestID = "27305"
Inst22Quest6_HORDE_QuestID = "27223"
Inst22Quest7_HORDE_QuestID = "27185"
Inst22Quest8_HORDE_QuestID = "27208"


AQ_27422_Level = "45"
AQ_27352_Level = "50"
AQ_27192_Level = "46"
AQ_28755_Level = "46"
AQ_27305_Level = "46"
AQ_27223_Level = "47"
AQ_27185_Level = "46"
AQ_27208_Level = "47"



--------------- INST28 - Stratholme - The Gauntlet (Strat) ---------------

Inst28Quest1_QuestID = "27230"
Inst28Quest2_QuestID = "27359"
Inst28Quest3_QuestID = "27228"
Inst28Quest4_QuestID = "27227"

Inst28Quest1_HORDE_QuestID = "27230"
Inst28Quest2_HORDE_QuestID = "27359"
Inst28Quest3_HORDE_QuestID = "27228"
Inst28Quest4_HORDE_QuestID = "27227"


AQ_27230_Level = "50"
AQ_27359_Level = "50"
AQ_27228_Level = "50"
AQ_27227_Level = "51"



--------------- INST23 - The Ruins of Ahn'Qiraj (AQ20) ---------------

Inst23Quest1_QuestID = "8791"

Inst23Quest1_HORDE_QuestID = "8791"


AQ_8791_Level = "60"



--------------- INST24 - The Stockade (Stocks) ---------------

Inst24Quest1_QuestID = "27733"
Inst24Quest2_QuestID = "27737"
Inst24Quest3_QuestID = "27739"


AQ_27733_Level = "23"
AQ_27737_Level = "24"
AQ_27739_Level = "25"



--------------- INST25 - Sunken Temple (ST) ---------------

Inst25Quest1_QuestID = "27915"
Inst25Quest2_QuestID = "27633"
Inst25Quest3_QuestID = "27604"
Inst25Quest4_QuestID = "27605"

Inst25Quest1_HORDE_QuestID = "27915"
Inst25Quest2_HORDE_QuestID = "27633"
Inst25Quest3_HORDE_QuestID = "27604"
Inst25Quest4_HORDE_QuestID = "27605"


AQ_27915_Level = "54"
AQ_27633_Level = "54"
AQ_27604_Level = "54"
AQ_27605_Level = "54"



--------------- INST26 - The Temple of Ahn'Qiraj (AQ40) ---------------

Inst26Quest1_QuestID = "8801"
Inst26Quest2_QuestID = "8802"
Inst26Quest3_QuestID = "8784"
Inst26Quest4_QuestID = "8579"

Inst26Quest1_HORDE_QuestID = "8801"
Inst26Quest2_HORDE_QuestID = "8802"
Inst26Quest3_HORDE_QuestID = "8784"
Inst26Quest4_HORDE_QuestID = "8579"


AQ_8801_Level = "60"
AQ_8802_Level = "60"
AQ_8784_Level = "60"
AQ_8579_Level = "60"



--------------- INST27 - Zul'Farrak (ZF) ---------------

Inst27Quest1_QuestID = "25556"
Inst27Quest2_QuestID = "27068"
Inst27Quest3_QuestID = "27076"
Inst27Quest4_QuestID = "27071"
Inst27Quest5_QuestID = "27070"

Inst27Quest1_HORDE_QuestID = "25556"
Inst27Quest2_HORDE_QuestID = "27068"
Inst27Quest3_HORDE_QuestID = "27076"
Inst27Quest4_HORDE_QuestID = "27071"
Inst27Quest5_HORDE_QuestID = "27070"


AQ_25556_Level = "47"
AQ_27068_Level = "49"
AQ_27076_Level = "48"
AQ_27071_Level = "48"
AQ_27070_Level = "48"



--------------- INST29 - Gnomeregan (Gnomer) ---------------

Inst29Quest1_QuestID = "26943"
Inst29Quest2_QuestID = "26944"
Inst29Quest3_QuestID = "26939"
Inst29Quest4_QuestID = "26941"
Inst29Quest5_QuestID = "26942"
Inst29Quest6_QuestID = "2945"
Inst29Quest7_QuestID = "2947"
Inst29Quest8_QuestID = "2951"

Inst29Quest1_HORDE_QuestID = "2945"
Inst29Quest2_HORDE_QuestID = "2949"
Inst29Quest3_HORDE_QuestID = "2951"


AQ_26943_Level = "26"
AQ_26944_Level = "26"
AQ_26939_Level = "27"
AQ_26941_Level = "28"
AQ_26942_Level = "29"
AQ_2945_Level = "34"
AQ_2949_Level = "34"
AQ_2951_Level = "30"
AQ_2947_Level = "34"



--------------- INST37 - HFC: Ramparts (Ramp) ---------------

Inst37Quest1_QuestID = "29543"
Inst37Quest2_QuestID = "29594"
Inst37Quest3_QuestID = "29529"
Inst37Quest4_QuestID = "29528"
Inst37Quest5_QuestID = "11354"

Inst37Quest1_HORDE_QuestID = "29542"
Inst37Quest2_HORDE_QuestID = "29593"
Inst37Quest3_HORDE_QuestID = "29530"
Inst37Quest4_HORDE_QuestID = "29527"
Inst37Quest5_HORDE_QuestID = "11354"


AQ_29543_Level = "62"
AQ_29594_Level = "62"
AQ_29529_Level = "62"
AQ_29528_Level = "62"
AQ_11354_Level = "70"
AQ_29542_Level = "62"
AQ_29593_Level = "62"
AQ_29530_Level = "62"
AQ_29527_Level = "62"



--------------- INST38 - HFC: Blood Furnace (BF) ---------------

Inst38Quest1_QuestID = "29538"
Inst38Quest2_QuestID = "29539"
Inst38Quest3_QuestID = "29540"
Inst38Quest4_QuestID = "11362"

Inst38Quest1_HORDE_QuestID = "29535"
Inst38Quest2_HORDE_QuestID = "29536"
Inst38Quest3_HORDE_QuestID = "29537"
Inst38Quest4_HORDE_QuestID = "11362"


AQ_29538_Level = "63"
AQ_29539_Level = "63"
AQ_29540_Level = "63"
AQ_11362_Level = "70"
AQ_29535_Level = "63"
AQ_29536_Level = "63"
AQ_29537_Level = "63"


--------------- INST39 - HFC: Shattered Halls (SH) ---------------

Inst39Quest1_QuestID = "29689"
Inst39Quest2_QuestID = "29649"
Inst39Quest3_QuestID = "29654"
Inst39Quest4_QuestID = "29656"
Inst39Quest5_QuestID = "10884"
Inst39Quest6_QuestID = "10670"
Inst39Quest7_QuestID = "9637"
Inst39Quest8_QuestID = "11363"
Inst39Quest9_QuestID = "11364"
Inst39Quest10_QuestID = "29652"

Inst39Quest1_HORDE_QuestID = "29688"
Inst39Quest2_HORDE_QuestID = "29650"
Inst39Quest3_HORDE_QuestID = "29653"
Inst39Quest4_HORDE_QuestID = "29655"
Inst39Quest5_HORDE_QuestID = "10884"
Inst39Quest6_HORDE_QuestID = "10670"
Inst39Quest7_HORDE_QuestID = "9637"
Inst39Quest8_HORDE_QuestID = "11363"
Inst39Quest9_HORDE_QuestID = "11364"
Inst39Quest10_HORDE_QuestID = "29651"


AQ_29689_Level = "70"
AQ_29649_Level = "70"
AQ_29654_Level = "70"
AQ_29656_Level = "70"
AQ_10884_Level = "70"
AQ_10670_Level = "70"
AQ_9637_Level = "70"
AQ_11363_Level = "70"
AQ_11364_Level = "70"
AQ_29652_Level = "70"
AQ_29688_Level = "70"
AQ_29650_Level = "70"
AQ_29653_Level = "70"
AQ_29655_Level = "70"
AQ_29651_Level = "70"



--------------- INST40 - HFC: Magtheridon's Lair ---------------

Inst40Quest1_QuestID = "10888"
Inst40Quest2_QuestID = "11002" --**

Inst40Quest1_HORDE_QuestID = "10888"
Inst40Quest2_HORDE_QuestID = "11003"


AQ_10888_Level = "70"
AQ_11002_Level = "70"
AQ_11003_Level = "70"



--------------- INST41 - CR: The Slave Pens (SP) ---------------

Inst41Quest1_QuestID = "29566"
Inst41Quest2_QuestID = "29563"
Inst41Quest3_QuestID = "29564"
Inst41Quest4_QuestID = "29565"
Inst41Quest5_QuestID = "11368"
Inst41Quest6_QuestID = "13431"
Inst41Quest7_QuestID = "11972"

Inst41Quest1_HORDE_QuestID = "29566"
Inst41Quest2_HORDE_QuestID = "29563"
Inst41Quest3_HORDE_QuestID = "29564"
Inst41Quest4_HORDE_QuestID = "29565"
Inst41Quest5_HORDE_QuestID = "11368"
Inst41Quest6_HORDE_QuestID = "13431"
Inst41Quest7_HORDE_QuestID = "11972"


AQ_29566_Level = "65"
AQ_29563_Level = "65"
AQ_29564_Level = "65"
AQ_29565_Level = "65"
AQ_11368_Level = "70"
AQ_13431_Level = "70"
AQ_11972_Level = "90"



--------------- INST42 - CR: The Steamvault (SV) ---------------

Inst42Quest1_QuestID = "29616"
Inst42Quest2_QuestID = "29613"
Inst42Quest3_QuestID = "29614"
Inst42Quest4_QuestID = "29615"
Inst42Quest5_QuestID = "10885"
Inst42Quest6_QuestID = "10667"
Inst42Quest7_QuestID = "9832"
Inst42Quest8_QuestID = "11371"
Inst42Quest9_QuestID = "11370"

Inst42Quest1_HORDE_QuestID = "29616"
Inst42Quest2_HORDE_QuestID = "29613"
Inst42Quest3_HORDE_QuestID = "29614"
Inst42Quest4_HORDE_QuestID = "29615"
Inst42Quest5_HORDE_QuestID = "10885"
Inst42Quest6_HORDE_QuestID = "10667"
Inst42Quest7_HORDE_QuestID = "9832"
Inst42Quest8_HORDE_QuestID = "11371"
Inst42Quest9_HORDE_QuestID = "11370"


AQ_29616_Level = "69"
AQ_29613_Level = "70"
AQ_29614_Level = "70"
AQ_29615_Level = "70"
AQ_10885_Level = "70"
AQ_10667_Level = "70"
AQ_9832_Level = "70"
AQ_11371_Level = "70"
AQ_11370_Level = "70"



--------------- INST43 - CR: The Underbog (UB) ---------------

Inst43Quest1_QuestID = "29571"
Inst43Quest2_QuestID = "29570"
Inst43Quest3_QuestID = "29568"
Inst43Quest4_QuestID = "29567"
Inst43Quest5_QuestID = "29691"
Inst43Quest6_QuestID = "29692"
Inst43Quest7_QuestID = "11369"

Inst43Quest1_HORDE_QuestID = "29571"
Inst43Quest2_HORDE_QuestID = "29570"
Inst43Quest3_HORDE_QuestID = "29568"
Inst43Quest4_HORDE_QuestID = "29567"
Inst43Quest5_HORDE_QuestID = "29691"
Inst43Quest6_HORDE_QuestID = "29692"
Inst43Quest7_HORDE_QuestID = "11369"


AQ_29571_Level = "65"
AQ_29570_Level = "65"
AQ_29568_Level = "65"
AQ_29567_Level = "65"
AQ_29691_Level = "65"
AQ_29692_Level = "65"
AQ_11369_Level = "70"



--------------- INST44 - Auchindoun: Auchenai Crypts (AC) ---------------

Inst44Quest1_QuestID = "29595"
Inst44Quest2_QuestID = "29596"
Inst44Quest3_QuestID = "29590"
Inst44Quest4_QuestID = "29591"
Inst44Quest5_QuestID = "11374"

Inst44Quest1_HORDE_QuestID = "29595"
Inst44Quest2_HORDE_QuestID = "29596"
Inst44Quest3_HORDE_QuestID = "29590"
Inst44Quest4_HORDE_QuestID = "29591"
Inst44Quest5_HORDE_QuestID = "11374"
Inst44Quest6_HORDE_QuestID = "10167"
Inst44Quest7_HORDE_QuestID = "10168"

AQ_29595_Level = "67"
AQ_29596_Level = "67"
AQ_29590_Level = "67"
AQ_29591_Level = "67"
AQ_11374_Level = "70"
AQ_10167_Level = "68"
AQ_10168_Level = "68"



--------------- INST45 - Auchindoun: Mana Tombs (MT) ---------------

Inst45Quest1_QuestID = "29583"
Inst45Quest2_QuestID = "29574"
Inst45Quest3_QuestID = "29573"
Inst45Quest4_QuestID = "29575"
Inst45Quest5_QuestID = "10977"
Inst45Quest6_QuestID = "11373"

Inst45Quest1_HORDE_QuestID = "29582"
Inst45Quest2_HORDE_QuestID = "29574"
Inst45Quest3_HORDE_QuestID = "29573"
Inst45Quest4_HORDE_QuestID = "29575"
Inst45Quest5_HORDE_QuestID = "10977"
Inst45Quest6_HORDE_QuestID = "11373"


AQ_29583_Level = "66"
AQ_29574_Level = "66"
AQ_29573_Level = "66"
AQ_29575_Level = "66"
AQ_10977_Level = "70"
AQ_11373_Level = "70"
AQ_29582_Level = "66"



--------------- INST46 - Auchindoun: Sethekk Halls (Seth) ---------------

Inst46Quest1_QuestID = "10180"
Inst46Quest2_QuestID = "29605"
Inst46Quest3_QuestID = "29607"
Inst46Quest4_QuestID = "29606"
Inst46Quest5_QuestID = "9637"
Inst46Quest6_QuestID = "11372"

Inst46Quest1_HORDE_QuestID = "10180"
Inst46Quest2_HORDE_QuestID = "29605"
Inst46Quest3_HORDE_QuestID = "29607"
Inst46Quest4_HORDE_QuestID = "29606"
Inst46Quest5_HORDE_QuestID = "9637"
Inst46Quest6_HORDE_QuestID = "11372"


AQ_10180_Level = "69"
AQ_29605_Level = "69"
AQ_29607_Level = "69"
AQ_29606_Level = "69"
--AQ_9637_Level = "70"  -- Already used for HFC: Shattered Halls. Left here just for the note.
AQ_11372_Level = "70"



--------------- INST47 - Auchindoun: Shadow Labyrinth (SLabs) ---------------

Inst46Quest1_QuestID = "29642"
Inst46Quest2_QuestID = "29640"
Inst46Quest3_QuestID = "29641"
Inst46Quest4_QuestID = "29645"
Inst46Quest5_QuestID = "10649"
Inst46Quest6_QuestID = "29643"
Inst46Quest7_QuestID = "29644"
Inst46Quest8_QuestID = "10666"
Inst46Quest9_QuestID = "9831"
Inst46Quest10_QuestID = "10885"
Inst46Quest11_QuestID = "11376"
Inst46Quest12_QuestID = "11375"

Inst46Quest1_HORDE_QuestID = "29642"
Inst46Quest2_HORDE_QuestID = "29640"
Inst46Quest3_HORDE_QuestID = "29641"
Inst46Quest4_HORDE_QuestID = "29645"
Inst46Quest5_HORDE_QuestID = "10649"
Inst46Quest6_HORDE_QuestID = "29643"
Inst46Quest7_HORDE_QuestID = "29644"
Inst46Quest8_HORDE_QuestID = "10666"
Inst46Quest9_HORDE_QuestID = "9831"
Inst46Quest10_HORDE_QuestID = "10885"
Inst46Quest11_HORDE_QuestID = "11376"
Inst46Quest12_HORDE_QuestID = "11375"


AQ_29642_Level = "70"
AQ_29640_Level = "70"
AQ_29641_Level = "70"
AQ_29645_Level = "70"
AQ_10649_Level = "70"
AQ_29643_Level = "70"
AQ_29644_Level = "70"
AQ_10666_Level = "69"
AQ_9831_Level = "70"
AQ_10885_Level = "70"
AQ_11376_Level = "70"
AQ_11375_Level = "70"



--------------- INST48 - CR: Serpentshrine Cavern (SSC) ---------------

Inst48Quest1_QuestID = "10445"
Inst48Quest2_QuestID = "10944"

Inst48Quest1_HORDE_QuestID = "10445"
Inst48Quest2_HORDE_QuestID = "10944"


AQ_10445_Level = "70"
AQ_10944_Level = "70"



--------------- INST49 - CoT: Black Morass (BM) ---------------

Inst49Quest1_QuestID = "10296"
Inst49Quest2_QuestID = "10297"
Inst49Quest3_QuestID = "9836"
Inst49Quest4_QuestID = "11382"
Inst49Quest5_QuestID = "11383"

Inst49Quest1_HORDE_QuestID = "10296"
Inst49Quest2_HORDE_QuestID = "10297"
Inst49Quest3_HORDE_QuestID = "9836"
Inst49Quest4_HORDE_QuestID = "11382"
Inst49Quest5_HORDE_QuestID = "11383"


AQ_10296_Level = "70"
AQ_10297_Level = "70"
AQ_9836_Level = "70"
AQ_11382_Level = "70"
AQ_11383_Level = "70"



--------------- INST50 - CoT: Battle of Mount Hyjal ---------------

Inst50Quest1_QuestID = "10947"

Inst50Quest1_HORDE_QuestID = "10947"


AQ_10947_Level = "70"



--------------- INST51 - CoT: Old Hillsbrad ---------------

Inst51Quest1_QuestID = "10282"
Inst51Quest2_QuestID = "29598"
Inst51Quest3_QuestID = "29599"
Inst51Quest4_QuestID = "11378"
Inst51Quest5_QuestID = "12513"

Inst51Quest1_HORDE_QuestID = "10282"
Inst51Quest2_HORDE_QuestID = "29598"
Inst51Quest3_HORDE_QuestID = "29599"
Inst51Quest4_HORDE_QuestID = "11378"
Inst51Quest5_HORDE_QuestID = "12513"


AQ_10282_Level = "68"
AQ_29598_Level = "68"
AQ_29599_Level = "68"
AQ_11378_Level = "70"
AQ_12513_Level = "68"



--------------- INST52 - Gruul's Lair (GL) ---------------

Inst52Quest1_QuestID = "13431"

Inst52Quest1_HORDE_QuestID = "13431"


--AQ_13431_Level = "70"  -- Already used for CR: Slave Pens. Left here just for the note.



--------------- INST53 - Karazhan (Kara) ---------------

Inst53Quest1_QuestID = "9840"
Inst53Quest2_QuestID = "9843"
Inst53Quest3_QuestID = "9844"
Inst53Quest4_QuestID = "9860"
Inst53Quest5_QuestID = "9630"
Inst53Quest6_QuestID = "9638"
Inst53Quest7_QuestID = "9639"
Inst53Quest8_QuestID = "9640"
Inst53Quest9_QuestID = "9645"
Inst53Quest10_QuestID = "9680"
Inst53Quest11_QuestID = "9631"
Inst53Quest12_QuestID = "9637"
Inst53Quest13_QuestID = "9644"
Inst53Quest14_QuestID = "13431"

Inst53Quest1_HORDE_QuestID = "9840"
Inst53Quest2_HORDE_QuestID = "9843"
Inst53Quest3_HORDE_QuestID = "9844"
Inst53Quest4_HORDE_QuestID = "9860"
Inst53Quest5_HORDE_QuestID = "9630"
Inst53Quest6_HORDE_QuestID = "9638"
Inst53Quest7_HORDE_QuestID = "9639"
Inst53Quest8_HORDE_QuestID = "9640"
Inst53Quest9_HORDE_QuestID = "9645"
Inst53Quest10_HORDE_QuestID = "9680"
Inst53Quest11_HORDE_QuestID = "9631"
Inst53Quest12_HORDE_QuestID = "9637"
Inst53Quest13_HORDE_QuestID = "9644"
Inst53Quest14_HORDE_QuestID = "13431"


AQ_9840_Level = "70"
AQ_9843_Level = "70"
AQ_9844_Level = "70"
AQ_9860_Level = "70"
AQ_9630_Level = "70"
AQ_9638_Level = "70"
AQ_9639_Level = "70"
AQ_9640_Level = "70"
AQ_9645_Level = "70"
AQ_9680_Level = "70"
AQ_9631_Level = "70"
AQ_9637_Level = "70"
AQ_9644_Level = "70"
--AQ_13431_Level = "70"  -- Already used for CR: Slave Pens. Left here just for the note.



--------------- INST54 - TK: Arcatraz (Arc) ---------------

Inst54Quest1_QuestID = "29674"
Inst54Quest2_QuestID = "29675"
Inst54Quest3_QuestID = "29681"
Inst54Quest4_QuestID = "10705"
Inst54Quest5_QuestID = "10886"
Inst54Quest6_QuestID = "9832"
Inst54Quest7_QuestID = "11388"
Inst54Quest8_QuestID = "11389"


Inst54Quest1_HORDE_QuestID = "29674"
Inst54Quest2_HORDE_QuestID = "29675"
Inst54Quest3_HORDE_QuestID = "29681"
Inst54Quest4_HORDE_QuestID = "10705"
Inst54Quest5_HORDE_QuestID = "10886"
Inst54Quest6_HORDE_QuestID = "9832"
Inst54Quest7_HORDE_QuestID = "11388"
Inst54Quest8_HORDE_QuestID = "11389"

AQ_29674_Level = "70"
AQ_29675_Level = "70"
AQ_29681_Level = "70"
AQ_10705_Level = "70"
AQ_10886_Level = "70"
--AQ_9832_Level = "70"  -- Already used for CR: The Steamvault. Left here just for the note.
AQ_11388_Level = "70"
AQ_11389_Level = "70"



--------------- INST55 - TK: Botanica (Bot) ---------------

Inst55Quest1_QuestID = "29660"
Inst55Quest2_QuestID = "29667"
Inst55Quest3_QuestID = "29669"
Inst55Quest4_QuestID = "10704"
Inst55Quest5_QuestID = "10257"
Inst55Quest6_QuestID = "11384"
Inst55Quest7_QuestID = "11385"

Inst55Quest1_HORDE_QuestID = "29660"
Inst55Quest2_HORDE_QuestID = "29667"
Inst55Quest3_HORDE_QuestID = "29669"
Inst55Quest4_HORDE_QuestID = "10704"
Inst55Quest5_HORDE_QuestID = "10257"
Inst55Quest6_HORDE_QuestID = "11384"
Inst55Quest7_HORDE_QuestID = "11385"

AQ_29660_Level = "70"
AQ_29667_Level = "70"
AQ_29669_Level = "70"
AQ_10704_Level = "70"
AQ_10257_Level = "70"
AQ_11384_Level = "70"
AQ_11385_Level = "70"



--------------- INST56 - TK: Mechanar (Mech) ---------------

Inst56Quest1_QuestID = "29659"
Inst56Quest2_QuestID = "29657"
Inst56Quest3_QuestID = "29658"
Inst56Quest4_QuestID = "10704"
Inst56Quest5_QuestID = "10665"
Inst56Quest6_QuestID = "11386"
Inst56Quest7_QuestID = "11387"

Inst56Quest1_HORDE_QuestID = "29659"
Inst56Quest2_HORDE_QuestID = "29657"
Inst56Quest3_HORDE_QuestID = "29658"
Inst56Quest4_HORDE_QuestID = "10704"
Inst56Quest5_HORDE_QuestID = "10665"
Inst56Quest6_HORDE_QuestID = "11386"
Inst56Quest7_HORDE_QuestID = "11387"


AQ_29659_Level = "70"
AQ_29657_Level = "70"
AQ_29658_Level = "70"
--AQ_10704_Level = "70"  -- Already used for TK: Botanica. Left here just for the note.
AQ_10665_Level = "69"
AQ_11386_Level = "70"
AQ_11387_Level = "70"



--------------- INST61 - TK: The Eye ---------------

Inst61Quest1_QuestID = "10946"
Inst61Quest2_QuestID = "11007"
Inst61Quest3_QuestID = "10445"

Inst61Quest1_HORDE_QuestID = "10946"
Inst61Quest2_HORDE_QuestID = "11007"
Inst61Quest3_HORDE_QuestID = "10445"


AQ_10946_Level = "70"
AQ_11007_Level = "70"
AQ_10445_Level = "70"



--------------- INST62 - Black Temple (BT) ---------------

Inst62Quest1_QuestID = "10958"
Inst62Quest2_QuestID = "10957"
Inst62Quest3_QuestID = "10959"

Inst62Quest1_HORDE_QuestID = "10958"
Inst62Quest2_HORDE_QuestID = "10957"
Inst62Quest3_HORDE_QuestID = "10959"


AQ_10958_Level = "70"
AQ_10957_Level = "70"
AQ_10959_Level = "70"



--------------- INST63 - Zul'Aman (ZA) ---------------

Inst63Quest1_QuestID = "29180"
Inst63Quest2_QuestID = "29184"
Inst63Quest3_QuestID = "29186"
Inst63Quest4_QuestID = "29217"
Inst63Quest5_QuestID = "29186"

Inst63Quest1_HORDE_QuestID = "29180"
Inst63Quest2_HORDE_QuestID = "29184"
Inst63Quest3_HORDE_QuestID = "29186"
Inst63Quest4_HORDE_QuestID = "29217"
Inst63Quest5_HORDE_QuestID = "29186"


AQ_29180_Level = "85"
AQ_29184_Level = "85"
AQ_29186_Level = "85"
AQ_29217_Level = "85"
AQ_29186_Level = "85"



--------------- INST67 - Magisters' Terrace (MgT) ---------------

Inst67Quest1_QuestID = "29682"
Inst67Quest2_QuestID = "29684"
Inst67Quest3_QuestID = "11490"
Inst67Quest4_QuestID = "29685"
Inst67Quest5_QuestID = "29686"
Inst67Quest6_QuestID = "29687"
Inst67Quest7_QuestID = "11500"
Inst67Quest8_QuestID = "11499"

Inst67Quest1_HORDE_QuestID = "29682"
Inst67Quest2_HORDE_QuestID = "29684"
Inst67Quest3_HORDE_QuestID = "11490"
Inst67Quest4_HORDE_QuestID = "29685"
Inst67Quest5_HORDE_QuestID = "29686"
Inst67Quest6_HORDE_QuestID = "29687"
Inst67Quest7_HORDE_QuestID = "11500"
Inst67Quest8_HORDE_QuestID = "11499"


AQ_29682_Level = "70"
AQ_29684_Level = "70"
AQ_11490_Level = "70"
AQ_29685_Level = "70"
AQ_29686_Level = "70"
AQ_29687_Level = "70"
AQ_11500_Level = "70"
AQ_11499_Level = "70"



--------------- INST68 - Sunwell Plateau ---------------

Inst68Quest1_QuestID = "24553"

Inst68Quest1_HORDE_QuestID = "24564"


AQ_24553_Level = "80"
AQ_24564_Level = "80"



--------------- INST69 - Caverns of Time: The Culling of Stratholme ---------------

Inst69Quest1_QuestID = "13149"
Inst69Quest2_QuestID = "13151"

Inst69Quest1_HORDE_QuestID = "13149"
Inst69Quest2_HORDE_QuestID = "13151"


AQ_13149_Level = "80"
AQ_13151_Level = "80"



--------------- INST70 - Utgarde Keep: Utgarde Keep ---------------

Inst70Quest1_QuestID = "29763"
Inst70Quest2_QuestID = "29764"
Inst70Quest3_QuestID = "29803"

Inst70Quest1_HORDE_QuestID = "11262"
Inst70Quest2_HORDE_QuestID = "13206"
Inst70Quest3_HORDE_QuestID = "30112"


AQ_29763_Level = "71"
AQ_29764_Level = "71"
AQ_29803_Level = "71"
AQ_11262_Level = "71"
AQ_13206_Level = "71"
AQ_30112_Level = "71"



--------------- INST71 - Utgarde Keep: Utgarde Pinnacle ---------------

Inst71Quest1_QuestID = "13131"
Inst71Quest2_QuestID = "13132"
Inst71Quest3_QuestID = "29864"

Inst71Quest1_HORDE_QuestID = "13131"
Inst71Quest2_HORDE_QuestID = "13132"
Inst71Quest3_HORDE_QuestID = "29864"


AQ_13131_Level = "80"
AQ_13132_Level = "80"
AQ_29864_Level = "80"



--------------- INST72 - The Nexus: The Nexus ---------------

Inst72Quest1_QuestID = "13094"
Inst72Quest2_QuestID = "11905"
Inst72Quest3_QuestID = "11911"
Inst72Quest4_QuestID = "11973"

Inst72Quest1_HORDE_QuestID = "13095"
Inst72Quest2_HORDE_QuestID = "11905"
Inst72Quest3_HORDE_QuestID = "11911"
Inst72Quest4_HORDE_QuestID = "11973"


AQ_13094_Level = "71"
AQ_11905_Level = "71"
AQ_11911_Level = "71"
AQ_11973_Level = "71"
AQ_13095_Level = "71"



--------------- INST73 - The Nexus: The Oculus ---------------

Inst73Quest1_QuestID = "13124"
Inst73Quest2_QuestID = "13126"
Inst73Quest3_QuestID = "13127"
Inst73Quest4_QuestID = "13128"

Inst73Quest1_HORDE_QuestID = "13124"
Inst73Quest2_HORDE_QuestID = "13126"
Inst73Quest3_HORDE_QuestID = "13127"
Inst73Quest4_HORDE_QuestID = "13128"


AQ_13124_Level = "80"
AQ_13126_Level = "80"
AQ_13127_Level = "80"
AQ_13128_Level = "80"



--------------- INST74 - The Nexus: The Eye of Eternity ---------------

Inst74Quest1_QuestID = "13384"
Inst74Quest2_QuestID = "13385"
Inst74Quest3_QuestID = "24584"

Inst74Quest1_HORDE_QuestID = "13384"
Inst74Quest2_HORDE_QuestID = "13385"
Inst74Quest3_HORDE_QuestID = "24584"


AQ_13384_Level = "80"
AQ_13385_Level = "80"
AQ_24584_Level = "80"



--------------- INST75 - Azjol-Nerub ---------------

Inst75Quest1_QuestID = "29811"
Inst75Quest2_QuestID = "29808"
Inst75Quest3_QuestID = "29807"

Inst75Quest1_HORDE_QuestID = "29811"
Inst75Quest2_HORDE_QuestID = "29808"
Inst75Quest3_HORDE_QuestID = "29807"


AQ_29811_Level = "74"
AQ_29808_Level = "74"
AQ_29807_Level = "74"



--------------- INST76 - Ahn'kahet: The Old Kingdom ---------------

Inst76Quest1_QuestID = "29825"
Inst76Quest2_QuestID = "29826"
Inst76Quest3_QuestID = "13187"

Inst76Quest1_HORDE_QuestID = "29825"
Inst76Quest2_HORDE_QuestID = "29826"
Inst76Quest3_HORDE_QuestID = "13187"


AQ_29825_Level = "76"
AQ_29826_Level = "76"
AQ_13187_Level = "76"



--------------- INST77 - Ulduar: Halls of Stone ---------------

Inst77Quest1_QuestID = "29850"
Inst77Quest1_QuestID = "29848"
Inst77Quest1_QuestID = "13207"

Inst77Quest1_HORDE_QuestID = "29850"
Inst77Quest1_HORDE_QuestID = "29848"
Inst77Quest1_HORDE_QuestID = "13207"


AQ_29850_Level = "78"
AQ_29848_Level = "78"
AQ_13207_Level = "78"



--------------- INST78 - Ulduar: Halls of Lightning ---------------

Inst78Quest1_QuestID = "29863"
Inst78Quest2_QuestID = "29861"
Inst78Quest3_QuestID = "29862"
Inst78Quest4_QuestID = "29860"

Inst78Quest1_HORDE_QuestID = "29863"
Inst78Quest2_HORDE_QuestID = "29861"
Inst78Quest3_HORDE_QuestID = "29862"
Inst78Quest4_HORDE_QuestID = "29860"


AQ_29863_Level = "80"
AQ_29861_Level = "80"
AQ_29862_Level = "80"
AQ_29860_Level = "80"



--------------- INST79 - The Obsidian Sanctum ---------------

Inst79Quest1_QuestID = "24579"

Inst79Quest1_HORDE_QuestID = "24579"


AQ_24579_Level = "80"



--------------- INST80 - Drak'Tharon Keep ---------------

Inst80Quest1_QuestID = "12037"
Inst80Quest2_QuestID = "13129"
Inst80Quest3_QuestID = "29828"
Inst80Quest4_QuestID = "30120"

Inst80Quest1_HORDE_QuestID = "12037"
Inst80Quest2_HORDE_QuestID = "13129"
Inst80Quest3_HORDE_QuestID = "29828"
Inst80Quest4_HORDE_QuestID = "30120"


AQ_12037_Level = "74"
AQ_13129_Level = "74"
AQ_29828_Level = "74"
AQ_30120_Level = "75"



--------------- INST81 - Gundrak ---------------

Inst81Quest1_QuestID = "29836"
Inst81Quest2_QuestID = "29833"
Inst81Quest3_QuestID = "29844"
Inst81Quest4_QuestID = "29834"
Inst81Quest5_QuestID = "29839"

Inst81Quest1_HORDE_QuestID = "29836"
Inst81Quest2_HORDE_QuestID = "29833"
Inst81Quest3_HORDE_QuestID = "29844"
Inst81Quest4_HORDE_QuestID = "29834"
Inst81Quest5_HORDE_QuestID = "29839"


AQ_29836_Level = "78"
AQ_29833_Level = "78"
AQ_29844_Level = "78"
AQ_29834_Level = "78"
AQ_29839_Level = "78"



--------------- INST82 - The Violet Hold ---------------

Inst82Quest1_QuestID = "29829"
Inst82Quest2_QuestID = "29830"


Inst82Quest1_HORDE_QuestID = "29829"
Inst82Quest2_HORDE_QuestID = "29830"


AQ_29829_Level = "77"
AQ_29830_Level = "77"



--------------- INST84 - Naxxramas (Naxx) ---------------

Inst84Quest1_QuestID = "13372"
Inst84Quest2_QuestID = "13375"
Inst84Quest3_QuestID = "24580"
Inst84Quest4_QuestID = "24582"
Inst84Quest5_QuestID = "24581"
Inst84Quest6_QuestID = "24583"

Inst84Quest1_HORDE_QuestID = "13372"
Inst84Quest2_HORDE_QuestID = "13375"
Inst84Quest3_HORDE_QuestID = "24580"
Inst84Quest4_HORDE_QuestID = "24582"
Inst84Quest5_HORDE_QuestID = "24581"
Inst84Quest6_HORDE_QuestID = "24583"


AQ_13372_Level = "80"
AQ_13375_Level = "80"
AQ_24580_Level = "80"
AQ_24582_Level = "80"
AQ_24581_Level = "80"
AQ_24583_Level = "80"



--------------- INST85 - Vault of Archavon ---------------



--------------- INST86 - Ulduar ---------------

Inst86Quest1_QuestID = "13604"
Inst86Quest2_QuestID = "13607"
Inst86Quest3_QuestID = "13609"
Inst86Quest4_QuestID = "13610"
Inst86Quest5_QuestID = "13606"
Inst86Quest6_QuestID = "13611"
Inst86Quest7_QuestID = "13614"
Inst86Quest8_QuestID = "13631"
Inst86Quest9_QuestID = "13817"
Inst86Quest10_QuestID = "13816"
Inst86Quest11_QuestID = "13822"
Inst86Quest12_QuestID = "13823"
Inst86Quest13_QuestID = "13821"
Inst86Quest14_QuestID = "13824"
Inst86Quest15_QuestID = "13818"
Inst86Quest16_QuestID = "13819"
Inst86Quest17_QuestID = "24585"
Inst86Quest18_QuestID = "24587"
Inst86Quest19_QuestID = "24586"
Inst86Quest20_QuestID = "24588"

Inst86Quest1_HORDE_QuestID = "13604"
Inst86Quest2_HORDE_QuestID = "13607"
Inst86Quest3_HORDE_QuestID = "13609"
Inst86Quest4_HORDE_QuestID = "13610"
Inst86Quest5_HORDE_QuestID = "13606"
Inst86Quest6_HORDE_QuestID = "13611"
Inst86Quest7_HORDE_QuestID = "13614"
Inst86Quest8_HORDE_QuestID = "13631"
Inst86Quest9_HORDE_QuestID = "13817"
Inst86Quest10_HORDE_QuestID = "13816"
Inst86Quest11_HORDE_QuestID = "13822"
Inst86Quest12_HORDE_QuestID = "13823"
Inst86Quest13_HORDE_QuestID = "13821"
Inst86Quest14_HORDE_QuestID = "13824"
Inst86Quest15_HORDE_QuestID = "13818"
Inst86Quest16_HORDE_QuestID = "13819"
Inst86Quest17_HORDE_QuestID = "24585"
Inst86Quest18_HORDE_QuestID = "24587"
Inst86Quest19_HORDE_QuestID = "24586"
Inst86Quest20_HORDE_QuestID = "24588"


AQ_13604_Level = "80"
AQ_13607_Level = "80"
AQ_13609_Level = "80"
AQ_13610_Level = "80"
AQ_13606_Level = "80"
AQ_13611_Level = "80"
AQ_13614_Level = "80"
AQ_13631_Level = "80"
AQ_13817_Level = "80"
AQ_13816_Level = "80"
AQ_13822_Level = "80"
AQ_13823_Level = "80"
AQ_13821_Level = "80"
AQ_13824_Level = "80"
AQ_13818_Level = "80"
AQ_13819_Level = "80"
AQ_24585_Level = "80"
AQ_24587_Level = "80"
AQ_24586_Level = "80"
AQ_24588_Level = "80"



--------------- INST87 - Trial of the Champion ---------------

Inst87Quest1_QuestID = "29851"

Inst87Quest1_HORDE_QuestID = "29851"


AQ_29851_Level = "78"



--------------- INST88 - Trial of the Crusader ---------------

Inst88Quest1_QuestID = "24589"

Inst88Quest1_HORDE_QuestID = "24589"

AQ_24589_Level = "80"



--------------- INST90 - Forge of Souls (FoS)  ---------------

Inst90Quest1_QuestID = "24510"
Inst90Quest2_QuestID = "24499"
Inst90Quest3_QuestID = "24476"

Inst90Quest1_HORDE_QuestID = "24506"
Inst90Quest2_HORDE_QuestID = "24511"
Inst90Quest3_HORDE_QuestID = "24560"


AQ_24510_Level = "80"
AQ_24499_Level = "80"
AQ_24476_Level = "80"
AQ_24506_Level = "80"
AQ_24511_Level = "80"
AQ_24560_Level = "80"



--------------- INST91 - Pit of Saron (PoS)  ---------------

Inst91Quest1_QuestID = "24683"
Inst91Quest2_QuestID = "24498"
Inst91Quest3_QuestID = "24710"
Inst91Quest4_QuestID = "24461"

Inst91Quest1_HORDE_QuestID = "24682"
Inst91Quest2_HORDE_QuestID = "24507"
Inst91Quest3_HORDE_QuestID = "24712"
Inst91Quest4_HORDE_QuestID = "24559"


AQ_24683_Level = "80"
AQ_24498_Level = "80"
AQ_24710_Level = "80"
AQ_24461_Level = "80"
AQ_24682_Level = "80"
AQ_24507_Level = "80"
AQ_24712_Level = "80"
AQ_24559_Level = "80"



--------------- INST92 - Halls of Reflection (HoR)  ---------------

Inst92Quest1_QuestID = "24711"
Inst92Quest2_QuestID = "24500"
Inst92Quest3_QuestID = "24480"

Inst92Quest1_HORDE_QuestID = "24713"
Inst92Quest2_HORDE_QuestID = "24802"
Inst92Quest3_HORDE_QuestID = "24561"


AQ_24711_Level = "80"
AQ_24500_Level = "80"
AQ_24480_Level = "80"
AQ_24713_Level = "80"
AQ_24802_Level = "80"
AQ_24561_Level = "80"



--------------- INST93 - Icecrown Citadel (ICC)  ---------------

Inst93Quest1_QuestID = "24590"
Inst93Quest2_QuestID = "24545"
Inst93Quest3_QuestID = "24743"
Inst93Quest4_QuestID = "24547"
Inst93Quest5_QuestID = "24749"
Inst93Quest6_QuestID = "24756"
Inst93Quest7_QuestID = "24757"
Inst93Quest8_QuestID = "24548"
Inst93Quest9_QuestID = "24549"
Inst93Quest10_QuestID = "24748"

Inst93Quest1_HORDE_QuestID = "24590"
Inst93Quest2_HORDE_QuestID = "24545"
Inst93Quest3_HORDE_QuestID = "24743"
Inst93Quest4_HORDE_QuestID = "24547"
Inst93Quest5_HORDE_QuestID = "24749"
Inst93Quest6_HORDE_QuestID = "24756"
Inst93Quest7_HORDE_QuestID = "24757"
Inst93Quest8_HORDE_QuestID = "24548"
Inst93Quest9_HORDE_QuestID = "24549"
Inst93Quest10_HORDE_QuestID = "24748"

AQ_24590_Level = "80"
AQ_24545_Level = "80"
AQ_24743_Level = "80"
AQ_24547_Level = "80"
AQ_24749_Level = "80"
AQ_24756_Level = "80"
AQ_24757_Level = "80"
AQ_24548_Level = "80"
AQ_24549_Level = "80"
AQ_24748_Level = "80"



--------------- INST94 - Ruby Sanctum (RS)  ---------------

Inst94Quest1_QuestID = "26012"
Inst94Quest2_QuestID = "26013"
Inst94Quest3_QuestID = "26034"

Inst94Quest1_HORDE_QuestID = "26012"
Inst94Quest2_HORDE_QuestID = "26013"
Inst94Quest3_HORDE_QuestID = "26034"

AQ_26012_Level = "80"
AQ_26013_Level = "80"
AQ_26034_Level = "80"



--------------- INST95 - Blackrock Caverns ---------------

Inst95Quest1_QuestID = "28732"
Inst95Quest2_QuestID = "28735"
Inst95Quest3_QuestID = "28737"
Inst95Quest4_QuestID = "28738"
Inst95Quest5_QuestID = "28740"
Inst95Quest6_QuestID = "28741"

Inst95Quest1_HORDE_QuestID = "28732"
Inst95Quest2_HORDE_QuestID = "28735"
Inst95Quest3_HORDE_QuestID = "28737"
Inst95Quest4_HORDE_QuestID = "28738"
Inst95Quest5_HORDE_QuestID = "28740"
Inst95Quest6_HORDE_QuestID = "28741"


AQ_28732_Level = "82"
AQ_28735_Level = "82"
AQ_28737_Level = "82"
AQ_28738_Level = "82"
AQ_28740_Level = "82"
AQ_28741_Level = "82"



--------------- INST96 - Throne of the Tides ---------------

Inst96Quest1_QuestID = "28834"
Inst96Quest2_QuestID = "28836"

Inst96Quest1_HORDE_QuestID = "28833"
Inst96Quest2_HORDE_QuestID = "28843"


AQ_28834_Level = "82"
AQ_28836_Level = "82"
AQ_28833_Level = "82"
AQ_28843_Level = "82"



--------------- INST97 - The Stonecore ---------------

Inst97Quest1_QuestID = "28866"
Inst97Quest2_QuestID = "28815"
Inst97Quest3_QuestID = "28814"
Inst97Quest4_QuestID = "28824"

Inst97Quest1_HORDE_QuestID = "28866"
Inst97Quest2_HORDE_QuestID = "28815"
Inst97Quest3_HORDE_QuestID = "28814"
Inst97Quest4_HORDE_QuestID = "28824"


AQ_28866_Level = "83"
AQ_28815_Level = "84"
AQ_28814_Level = "84"
AQ_28824_Level = "84"



--------------- INST98 - The Vortex Pinnacle ---------------

Inst98Quest1_QuestID = "28845"
Inst98Quest2_QuestID = "28760"
Inst98Quest3_QuestID = "28779"

Inst98Quest1_HORDE_QuestID = "28845"
Inst98Quest2_HORDE_QuestID = "28760"
Inst98Quest3_HORDE_QuestID = "28779"


AQ_28845_Level = "84"
AQ_28760_Level = "84"
AQ_28779_Level = "84"



--------------- INST99 - Grim Batol ---------------

Inst99Quest1_QuestID = "28852"
Inst99Quest2_QuestID = "28853"
Inst99Quest3_QuestID = "28854"

Inst99Quest1_HORDE_QuestID = "28852"
Inst99Quest2_HORDE_QuestID = "28853"
Inst99Quest3_HORDE_QuestID = "28854"


AQ_28852_Level = "85"
AQ_28853_Level = "85"
AQ_28854_Level = "85"



--------------- INST100 - Halls of Origination ---------------

Inst100Quest1_QuestID = "28654"
Inst100Quest2_QuestID = "28746"
Inst100Quest3_QuestID = "28753"

Inst100Quest1_HORDE_QuestID = "28654"
Inst100Quest2_HORDE_QuestID = "28746"
Inst100Quest3_HORDE_QuestID = "28753"

AQ_28654_Level = "83"
AQ_28746_Level = "83"
AQ_28753_Level = "83"



--------------- INST101 - Lost City of the Tol'vir ---------------

Inst101Quest1_QuestID = "28870"
Inst101Quest2_QuestID = "28781"
Inst101Quest3_QuestID = "28783"

Inst101Quest1_HORDE_QuestID = "28870"
Inst101Quest2_HORDE_QuestID = "28781"
Inst101Quest3_HORDE_QuestID = "28783"


AQ_28870_Level = "83"
AQ_28781_Level = "85"
AQ_28783_Level = "85"



--------------- INST102 - Blackwing Descent ---------------



--------------- INST103 - The Bastion of Twilight ---------------



--------------- INST104 - Throne of the Four Winds ---------------



--------------- INST105 - Baradin Hold ---------------



--------------- INST108 - Zul'Gurub (ZG) ---------------

Inst108Quest1_QuestID = "29172"
Inst108Quest2_QuestID = "29174"
Inst108Quest3_QuestID = "29242"
Inst108Quest4_QuestID = "29173"
Inst108Quest5_QuestID = "29153"
Inst108Quest6_QuestID = "29241"

Inst108Quest1_HORDE_QuestID = "29172"
Inst108Quest2_HORDE_QuestID = "29174"
Inst108Quest3_HORDE_QuestID = "29242"
Inst108Quest4_HORDE_QuestID = "29173"
Inst108Quest5_HORDE_QuestID = "29251"
Inst108Quest6_HORDE_QuestID = "29241"


AQ_29172_Level = "85"
AQ_29174_Level = "85"
AQ_29242_Level = "85"
AQ_29173_Level = "85"
AQ_29153_Level = "85"
AQ_29241_Level = "85"
AQ_29251_Level = "85"



--------------- INST109 - Firelands ---------------

Inst109Quest1_QuestID = "29453"
Inst109Quest2_QuestID = "29135"
Inst109Quest3_QuestID = "29234"
Inst109Quest4_QuestID = "29270"
Inst109Quest5_QuestID = "29307"

Inst109Quest1_HORDE_QuestID = "29452"
Inst109Quest2_HORDE_QuestID = "29135"
Inst109Quest3_HORDE_QuestID = "29234"
Inst109Quest4_HORDE_QuestID = "29270"
Inst109Quest5_HORDE_QuestID = "29307"


AQ_29453_Level = "85"
AQ_29135_Level = "85"
AQ_29234_Level = "85"
AQ_29270_Level = "85"
AQ_29307_Level = "85"
AQ_29452_Level = "85"



--------------- INST110 - End Time ---------------

Inst110Quest1_QuestID = "30095"
Inst110Quest2_QuestID = "30096"
Inst110Quest3_QuestID = "30097"

Inst110Quest1_HORDE_QuestID = "30094"
Inst110Quest2_HORDE_QuestID = "30096"
Inst110Quest3_HORDE_QuestID = "30097"


AQ_30095_Level = "85"
AQ_30096_Level = "85"
AQ_30097_Level = "85"



--------------- INST111 - Well of Eternity ---------------

Inst111Quest1_QuestID = "30098"
Inst111Quest2_QuestID = "30099"
Inst111Quest3_QuestID = "30100"
Inst111Quest4_QuestID = "30101"
Inst111Quest5_QuestID = "30104"

Inst111Quest1_HORDE_QuestID = "30098"
Inst111Quest2_HORDE_QuestID = "30099"
Inst111Quest3_HORDE_QuestID = "30100"
Inst111Quest4_HORDE_QuestID = "30101"
Inst111Quest5_HORDE_QuestID = "30104"


AQ_30098_Level = "85"
AQ_30099_Level = "85"
AQ_30100_Level = "85"
AQ_30101_Level = "85"
AQ_30104_Level = "85"



--------------- INST112 - Hour of Twilight ---------------

Inst112Quest1_QuestID = "30102"
Inst112Quest2_QuestID = "30103"
Inst112Quest3_QuestID = "30105"

Inst112Quest1_HORDE_QuestID = "30102"
Inst112Quest2_HORDE_QuestID = "30103"
Inst112Quest3_HORDE_QuestID = "30105"


AQ_30102_Level = "85"
AQ_30103_Level = "85"
AQ_30105_Level = "85"



--------------- INST113 - Dragon Soul ---------------

Inst113Quest1_QuestID = "29801"
Inst113Quest2_QuestID = "30107"
Inst113Quest3_QuestID = "30116"
Inst113Quest4_QuestID = "30118"

Inst113Quest1_HORDE_QuestID = "29801"
Inst113Quest2_HORDE_QuestID = "30107"
Inst113Quest3_HORDE_QuestID = "30116"
Inst113Quest4_HORDE_QuestID = "30118"


AQ_29801_Level = "85"
AQ_30107_Level = "85"
AQ_30116_Level = "85"
AQ_30118_Level = "85"



--------------- INST114 - Mogu'Shan Palace ---------------

Inst114Quest1_QuestID = "31357"
Inst114Quest2_QuestID = "31360"

Inst114Quest1_HORDE_QuestID = "31357"
Inst114Quest2_HORDE_QuestID = "31360"


AQ_31357_Level = "89"
AQ_31360_Level = "89"



--------------- INST115 - Shado-Pan Monastery ---------------

Inst115Quest1_QuestID = "31031"
Inst115Quest2_QuestID = "30757"
Inst115Quest3_QuestID = "31342"

Inst115Quest1_HORDE_QuestID = "31031"
Inst115Quest2_HORDE_QuestID = "30757"
Inst115Quest3_HORDE_QuestID = "31342"


AQ_31031_Level = "88"
AQ_30757_Level = "89"
AQ_31342_Level = "89"



--------------- INST116 - Stormstout Brewery ---------------

Inst116Quest1_QuestID = "30085"
Inst116Quest2_QuestID = "31327"
Inst116Quest3_QuestID = "31324"
Inst116Quest4_QuestID = "33024"

Inst116Quest1_HORDE_QuestID = "30085"
Inst116Quest2_HORDE_QuestID = "31327"
Inst116Quest3_HORDE_QuestID = "31324"
Inst116Quest4_HORDE_QuestID = "33024"


AQ_30085_Level = "87"
AQ_31327_Level = "87"
AQ_31324_Level = "87"
AQ_33024_Level = "90"



--------------- INST117 - Temple of the Jade Serpent ---------------

Inst117Quest1_QuestID = "31355"
Inst117Quest2_QuestID = "31356"
Inst117Quest3_QuestID = "33020"
Inst117Quest4_QuestID = "33107"

Inst117Quest1_HORDE_QuestID = "31355"
Inst117Quest2_HORDE_QuestID = "31356"
Inst117Quest3_HORDE_QuestID = "33020"
Inst117Quest4_HORDE_QuestID = "33107"


AQ_31355_Level = "87"
AQ_31356_Level = "87"
AQ_33020_Level = "90"
AQ_33107_Level = "90"



--------------- INST118 - Gate of the Setting Sun ---------------

Inst118Quest1_QuestID = "31363"
Inst118Quest2_QuestID = "31364"

Inst118Quest1_HORDE_QuestID = "31363"
Inst118Quest2_HORDE_QuestID = "31364"


AQ_31363_Level = "90"
AQ_31364_Level = "90"



--------------- INST119 - Siege of Niuzao Temple ---------------

Inst119Quest1_QuestID = "31365"
Inst119Quest2_QuestID = "31366"

Inst119Quest1_HORDE_QuestID = "31365"
Inst119Quest2_HORDE_QuestID = "31366"


AQ_31365_Level = "90"
AQ_31366_Level = "90"



--------------- INST120 - Mogu'shan Vaults ---------------



--------------- INST121 - Terrace of Endless Spring ---------------



--------------- INST122 - Heart of Fear ---------------



--------------- INST138 - Throne of Thunder ---------------

Inst138Quest1_QuestID = "32599"
Inst138Quest2_QuestID = "32715"
Inst138Quest3_QuestID = "32714"
Inst138Quest4_QuestID = "32713"
Inst138Quest5_QuestID = "32716"
Inst138Quest6_QuestID = "32711"
Inst138Quest7_QuestID = "32710"
Inst138Quest8_QuestID = "32712"

Inst138Quest1_HORDE_QuestID = "32589"
Inst138Quest2_HORDE_QuestID = "32715"
Inst138Quest3_HORDE_QuestID = "32714"
Inst138Quest4_HORDE_QuestID = "32713"
Inst138Quest5_HORDE_QuestID = "32716"
Inst138Quest6_HORDE_QuestID = "32711"
Inst138Quest7_HORDE_QuestID = "32710"
Inst138Quest8_HORDE_QuestID = "32712"


AQ_32599_Level = "90"
AQ_32589_Level = "90"
AQ_32715_Level = "90"
AQ_32714_Level = "90"
AQ_32713_Level = "90"
AQ_32716_Level = "90"
AQ_32711_Level = "90"
AQ_32710_Level = "90"
AQ_32712_Level = "90"



--------------- INST145 - Siege of Orgrimmar ---------------

Inst145Quest1_QuestID = "33147"
Inst145Quest2_QuestID = "33138"
Inst145Quest3_QuestID = "33337"
Inst145Quest4_QuestID = "33375"
Inst145Quest5_QuestID = "33376"
Inst145Quest6_QuestID = "33377"

Inst145Quest1_HORDE_QuestID = "33147"
Inst145Quest2_HORDE_QuestID = "33138"
Inst145Quest3_HORDE_QuestID = "33337"
Inst145Quest4_HORDE_QuestID = "33375"
Inst145Quest5_HORDE_QuestID = "33376"
Inst145Quest6_HORDE_QuestID = "33377"


AQ_33147_Level = "90"
AQ_33138_Level = "90"
AQ_33337_Level = "90"
AQ_33375_Level = "90"
AQ_33376_Level = "90"
AQ_33377_Level = "90"



--------------- INST146 - Auchindoun ---------------

Inst146Quest1_QuestID = "37146"
Inst146Quest2_QuestID = "37156"
Inst146Quest3_QuestID = "37232"
Inst146Quest4_QuestID = "37154"
Inst146Quest5_QuestID = "37233"
Inst146Quest6_QuestID = "35993"
Inst146Quest7_QuestID = "37271"

Inst146Quest1_HORDE_QuestID = "37146"
Inst146Quest2_HORDE_QuestID = "37156"
Inst146Quest3_HORDE_QuestID = "37232"
Inst146Quest4_HORDE_QuestID = "37154"
Inst146Quest5_HORDE_QuestID = "37233"
Inst146Quest6_HORDE_QuestID = "35993"
Inst146Quest7_HORDE_QuestID = "37259"


AQ_37146_Level = "96"
AQ_37156_Level = "100"
AQ_37232_Level = "100"
AQ_37154_Level = "100"
AQ_37233_Level = "100"
AQ_35993_Level = "100"
AQ_37271_Level = "100"
AQ_37259_Level = "100"



--------------- INST147 - Skyreach ---------------

Inst147Quest1_QuestID = "36316"
Inst147Quest2_QuestID = "36157"
Inst147Quest3_QuestID = "37147"
Inst147Quest4_QuestID = "37159"
Inst147Quest5_QuestID = "37158"
Inst147Quest6_QuestID = "37234"
Inst147Quest7_QuestID = "37235"
Inst147Quest8_QuestID = "37277"

Inst147Quest1_HORDE_QuestID = "36316"
Inst147Quest2_HORDE_QuestID = "36157"
Inst147Quest3_HORDE_QuestID = "37147"
Inst147Quest4_HORDE_QuestID = "37159"
Inst147Quest5_HORDE_QuestID = "37158"
Inst147Quest6_HORDE_QuestID = "37234"
Inst147Quest7_HORDE_QuestID = "37235"
Inst147Quest8_HORDE_QuestID = "37264"


AQ_36316_Level = "97"
AQ_36157_Level = "100"
AQ_37147_Level = "99"
AQ_37159_Level = "100"
AQ_37158_Level = "100"
AQ_37234_Level = "100"
AQ_37235_Level = "100"
AQ_37277_Level = "100"
AQ_37264_Level = "100"



--------------- INST148 - Bloodmaul Slag Mines ---------------

Inst148Quest1_QuestID = "37142"
Inst148Quest2_QuestID = "37152"
Inst148Quest3_QuestID = "37228"
Inst148Quest4_QuestID = "37153"
Inst148Quest5_QuestID = "37229"
Inst148Quest6_QuestID = "35990"
Inst148Quest7_QuestID = "37272"

Inst148Quest1_HORDE_QuestID = "37142"
Inst148Quest2_HORDE_QuestID = "37152"
Inst148Quest3_HORDE_QuestID = "37228"
Inst148Quest4_HORDE_QuestID = "37153"
Inst148Quest5_HORDE_QuestID = "37229"
Inst148Quest6_HORDE_QuestID = "35990"
Inst148Quest7_HORDE_QuestID = "37260"


AQ_37142_Level = "92"
AQ_37152_Level = "100"
AQ_37228_Level = "100"
AQ_37153_Level = "100"
AQ_37229_Level = "100"
AQ_35990_Level = "100"
AQ_37272_Level = "100"
AQ_37260_Level = "100"



--------------- INST149 - Iron Docks ---------------

Inst149Quest1_QuestID = "37145"
Inst149Quest2_QuestID = "37157"
Inst149Quest3_QuestID = "37230"
Inst149Quest4_QuestID = "37155"
Inst149Quest5_QuestID = "37231"
Inst149Quest6_QuestID = "37274"

Inst149Quest1_HORDE_QuestID = "37145"
Inst149Quest2_HORDE_QuestID = "37157"
Inst149Quest3_HORDE_QuestID = "37230"
Inst149Quest4_HORDE_QuestID = "37155"
Inst149Quest5_HORDE_QuestID = "37231"
Inst149Quest6_HORDE_QuestID = "37262"


AQ_37145_Level = "94"
AQ_37157_Level = "100"
AQ_37230_Level = "100"
AQ_37155_Level = "100"
AQ_37231_Level = "100"
AQ_37274_Level = "100"
AQ_37262_Level = "100"



--------------- INST150 - The Everbloom ---------------

Inst150Quest1_QuestID = "37150"
Inst150Quest2_QuestID = "37227"
Inst150Quest3_QuestID = "37166"
Inst150Quest4_QuestID = "37241"
Inst150Quest5_QuestID = "37165"
Inst150Quest6_QuestID = "37240"
Inst150Quest7_QuestID = "36813"
Inst150Quest8_QuestID = "35992"
Inst150Quest9_QuestID = "37278"

Inst150Quest1_HORDE_QuestID = "37150"
Inst150Quest2_HORDE_QuestID = "37227"
Inst150Quest3_HORDE_QuestID = "37166"
Inst150Quest4_HORDE_QuestID = "37241"
Inst150Quest5_HORDE_QuestID = "37165"
Inst150Quest6_HORDE_QuestID = "37240"
Inst150Quest7_HORDE_QuestID = "36813"
Inst150Quest8_HORDE_QuestID = "35992"
Inst150Quest9_HORDE_QuestID = "37265"


AQ_37150_Level = "100"
AQ_37227_Level = "100"
AQ_37166_Level = "100"
AQ_37241_Level = "100"
AQ_37165_Level = "100"
AQ_37240_Level = "100"
AQ_36813_Level = "100"
AQ_35992_Level = "100"
AQ_37278_Level = "100"
AQ_37265_Level = "100"



--------------- INST151 - Grimrail Depot ---------------

Inst151Quest1_QuestID = "37160"
Inst151Quest2_QuestID = "37243"
Inst151Quest3_QuestID = "37167"
Inst151Quest4_QuestID = "37242"
Inst151Quest5_QuestID = "37151"
Inst151Quest6_QuestID = "37209"
Inst151Quest7_QuestID = "35991"
Inst151Quest8_QuestID = "37273"

Inst151Quest1_HORDE_QuestID = "37160"
Inst151Quest2_HORDE_QuestID = "37243"
Inst151Quest3_HORDE_QuestID = "37167"
Inst151Quest4_HORDE_QuestID = "37242"
Inst151Quest5_HORDE_QuestID = "37151"
Inst151Quest6_HORDE_QuestID = "37209"
Inst151Quest7_HORDE_QuestID = "35991"
Inst151Quest8_HORDE_QuestID = "37261"


AQ_37160_Level = "100"
AQ_37243_Level = "100"
AQ_37167_Level = "100"
AQ_37242_Level = "100"
AQ_37151_Level = "100"
AQ_37209_Level = "100"
AQ_35991_Level = "100"
AQ_37273_Level = "100"
AQ_37261_Level = "100"



--------------- INST152 - Shadowmoon Burial Grounds ---------------

Inst152Quest1_QuestID = "37149"
Inst152Quest2_QuestID = "37245"
Inst152Quest3_QuestID = "37163"
Inst152Quest4_QuestID = "37238"
Inst152Quest5_QuestID = "37164"
Inst152Quest6_QuestID = "37239"
Inst152Quest7_QuestID = "37275"

Inst152Quest1_HORDE_QuestID = "37149"
Inst152Quest2_HORDE_QuestID = "37245"
Inst152Quest3_HORDE_QuestID = "37163"
Inst152Quest4_HORDE_QuestID = "37238"
Inst152Quest5_HORDE_QuestID = "37164"
Inst152Quest6_HORDE_QuestID = "37239"
Inst152Quest7_HORDE_QuestID = "37263"


AQ_37149_Level = "100"
AQ_37245_Level = "100"
AQ_37163_Level = "100"
AQ_37238_Level = "100"
AQ_37164_Level = "100"
AQ_37239_Level = "100"
AQ_37275_Level = "100"
AQ_37263_Level = "100"



--------------- INST153 - Upper Blackrock Spire ---------------

Inst153Quest1_QuestID = "37148"
Inst153Quest2_QuestID = "37244"
Inst153Quest3_QuestID = "37161"
Inst153Quest4_QuestID = "37236"
Inst153Quest5_QuestID = "37162"
Inst153Quest6_QuestID = "37237"
Inst153Quest7_QuestID = "37179"
Inst153Quest8_QuestID = "37279"

Inst153Quest1_HORDE_QuestID = "37148"
Inst153Quest2_HORDE_QuestID = "37244"
Inst153Quest3_HORDE_QuestID = "37161"
Inst153Quest4_HORDE_QuestID = "37236"
Inst153Quest5_HORDE_QuestID = "37162"
Inst153Quest6_HORDE_QuestID = "37237"
Inst153Quest7_HORDE_QuestID = "37179"
Inst153Quest8_HORDE_QuestID = "37266"


AQ_37148_Level = "100"
AQ_37244_Level = "100"
AQ_37161_Level = "100"
AQ_37236_Level = "100"
AQ_37162_Level = "100"
AQ_37237_Level = "100"
AQ_37179_Level = "100"
AQ_37279_Level = "100"
AQ_37266_Level = "100"



--------------- INST154 - Highmaul ---------------

Inst154Quest1_QuestID = "35997"
Inst154Quest2_QuestID = "35998"

Inst154Quest1_HORDE_QuestID = "35997"
Inst154Quest2_HORDE_QuestID = "35998"


AQ_35997_Level = "100"
AQ_35998_Level = "100"



--------------- INST155 - Blackrock Foundry ---------------




---------------------------------------------------
------------------ SCENARIOS ----------------------
---------------------------------------------------


--------------- INST125 - A Brewing Storm ---------------

Inst125Quest1_QuestID = "30567"

Inst125Quest1_HORDE_QuestID = "30567"


AQ_30567_Level = "90"



--------------- INST126 - Arena of Annihilation ---------------

Inst126Quest1_QuestID = "31207"

Inst126Quest1_HORDE_QuestID = "31207"


AQ_31207_Level = "90"



--------------- INST127 - Brewmoon Festival ---------------

Inst127Quest1_QuestID = "31611"

Inst127Quest1_HORDE_QuestID = "31611"


AQ_31611_Level = "90"



--------------- INST128 - Crypt of Forgotten Kings ---------------


--------------- INST129 - Greenstone Village ---------------

Inst129Quest1_QuestID = "31613"

Inst129Quest1_HORDE_QuestID = "31613"


AQ_31613_Level = "90"



--------------- INST130 - Theramore's Fall ---------------


--------------- INST131 - Unga Ingoo ---------------

Inst131Quest1_QuestID = "31658"

Inst131Quest1_HORDE_QuestID = "31658"


AQ_31658_Level = "90"



--------------- INST132 - Assault on Zanvess ---------------


--------------- INST133 - Peak of Serenity ---------------


--------------- INST134 - Lion's Landing ---------------


--------------- INST135 - Domination Point ---------------


--------------- INST136 - A Little Patience ---------------

Inst136Quest1_QuestID = "32248"


AQ_32248_Level = "90"



--------------- INST137 - Dagger in the Dark ---------------

Inst137Quest1_HORDE_QuestID = "32251"


AQ_32251_Level = "90"



--------------- INST139 - Blood in the Snow ---------------


--------------- INST140 - Battle on the High Seas ---------------


--------------- INST141 - Dark Heart of Pandaria ---------------


--------------- INST142 - The Secrets of Ragefire ---------------


--------------- INST144 - Troves of the Thunder King ---------------




---------------------------------------------------
---------------- BATTLEGROUNDS --------------------
---------------------------------------------------



--------------- INST33 - Alterac Valley (AV) ---------------

Inst33Quest1_QuestID = "7162"
Inst33Quest2_QuestID = "7141"
Inst33Quest3_QuestID = "7121"
Inst33Quest4_QuestID = "6982"
Inst33Quest5_QuestID = "5892"
Inst33Quest6_QuestID = "7223"
Inst33Quest7_QuestID = "7122"
Inst33Quest8_QuestID = "7102"
Inst33Quest9_QuestID = "7081"
Inst33Quest10_QuestID = "7027"
Inst33Quest11_QuestID = "7026"
Inst33Quest12_QuestID = "7386"
Inst33Quest13_QuestID = "6881"
Inst33Quest14_QuestID = "6942"
Inst33Quest15_QuestID = "6941"
Inst33Quest16_QuestID = "6943"

Inst33Quest1_HORDE_QuestID = "7161"
Inst33Quest2_HORDE_QuestID = "7142"
Inst33Quest3_HORDE_QuestID = "7123"
Inst33Quest4_HORDE_QuestID = "5893"
Inst33Quest5_HORDE_QuestID = "6985"
Inst33Quest6_HORDE_QuestID = "7224"
Inst33Quest7_HORDE_QuestID = "7124"
Inst33Quest8_HORDE_QuestID = "7101"
Inst33Quest9_HORDE_QuestID = "7082"
Inst33Quest10_HORDE_QuestID = "7001"
Inst33Quest11_HORDE_QuestID = "7002"
Inst33Quest12_HORDE_QuestID = "7385"
Inst33Quest13_HORDE_QuestID = "6801"
Inst33Quest14_HORDE_QuestID = "6825"
Inst33Quest15_HORDE_QuestID = "6826"
Inst33Quest16_HORDE_QuestID = "6827"


AQ_7162_Level = "-1"
AQ_7141_Level = "-1"
AQ_7121_Level = "-1"
AQ_6982_Level = "-1"
AQ_5892_Level = "-1"
AQ_7223_Level = "-1"
AQ_7122_Level = "-1"
AQ_7102_Level = "-1"
AQ_7081_Level = "-1"
AQ_7027_Level = "-1"
AQ_7026_Level = "-1"
AQ_7386_Level = "-1"
AQ_6881_Level = "-1"
AQ_6942_Level = "-1"
AQ_6941_Level = "-1"
AQ_6943_Level = "-1"
AQ_7161_Level = "-1"
AQ_7142_Level = "-1"
AQ_7123_Level = "-1"
AQ_5893_Level = "-1"
AQ_6985_Level = "-1"
AQ_7224_Level = "-1"
AQ_7124_Level = "-1"
AQ_7101_Level = "-1"
AQ_7082_Level = "-1"
AQ_7001_Level = "-1"
AQ_7002_Level = "-1"
AQ_7385_Level = "-1"
AQ_6801_Level = "-1"
AQ_6825_Level = "-1"
AQ_6826_Level = "-1"
AQ_6827_Level = "-1"



--------------- INST34 - Arathi Basin (AB) ---------------

Inst34Quest1_QuestID = "8105"
Inst34Quest2_QuestID = "8114"
Inst34Quest3_QuestID = "8115"

Inst34Quest1_HORDE_QuestID = "8120"
Inst34Quest2_HORDE_QuestID = "8121"
Inst34Quest3_HORDE_QuestID = "8122"


AQ_8105_Level = "55"
AQ_8114_Level = "60"
AQ_8115_Level = "60"
AQ_8120_Level = "55"
AQ_8121_Level = "60"
AQ_8122_Level = "60"



--------------- INST35 - Warsong Gulch (WSG) ---------------



--------------- INST60 - Eye of the Storm ---------------



--------------- INST83 - Strand of the Ancients (SotA)  ---------------



--------------- INST89 - Isle of Conquest (IoC)  ---------------



--------------- INST106 - Battle for Gilneas ---------------



--------------- INST107 - Twin Peaks ---------------



--------------- INST123 - Silvershard Mines ---------------



--------------- INST124 - Temple of Kotmogu ---------------



--------------- INST143 - Deepwind Gorge ---------------




---------------------------------------------------
---------------- OUTDOOR RAIDS --------------------
---------------------------------------------------



--------------- INST64 - Doom Lord Kazzak ---------------



--------------- INST65 - Doomwalker ---------------



--------------- INST66 - Skettis ---------------

Inst66Quest1_QuestID = "11098"
Inst66Quest2_QuestID = "11008"
Inst66Quest3_QuestID = "11085"
Inst66Quest4_QuestID = "11093"
Inst66Quest5_QuestID = "11004"
Inst66Quest6_QuestID = "11005"
Inst66Quest7_QuestID = "11021"
Inst66Quest8_QuestID = "11024"
Inst66Quest9_QuestID = "11028"
Inst66Quest10_QuestID = "11056"
Inst66Quest11_QuestID = "11029"
Inst66Quest12_QuestID = "11885"
Inst66Quest13_QuestID = "11073"

Inst66Quest1_HORDE_QuestID = "11098"
Inst66Quest2_HORDE_QuestID = "11008"
Inst66Quest3_HORDE_QuestID = "11085"
Inst66Quest4_HORDE_QuestID = "11093"
Inst66Quest5_HORDE_QuestID = "11004"
Inst66Quest6_HORDE_QuestID = "11005"
Inst66Quest7_HORDE_QuestID = "11021"
Inst66Quest8_HORDE_QuestID = "11024"
Inst66Quest9_HORDE_QuestID = "11028"
Inst66Quest10_HORDE_QuestID = "11056"
Inst66Quest11_HORDE_QuestID = "11029"
Inst66Quest12_HORDE_QuestID = "11885"
Inst66Quest13_HORDE_QuestID = "11073"


AQ_11098_Level = "70"
AQ_11008_Level = "70"
AQ_11085_Level = "70"
AQ_11093_Level = "70"
AQ_11004_Level = "70"
AQ_11005_Level = "70"
AQ_11021_Level = "70"
AQ_11024_Level = "70"
AQ_11028_Level = "70"
AQ_11056_Level = "70"
AQ_11029_Level = "70"
AQ_11885_Level = "70"
AQ_11073_Level = "70"

