﻿local addonName = ...
local addon = _G[addonName]

local L = LibStub("AceLocale-3.0"):GetLocale(addonName)
local BB = LibStub("LibBabble-Boss-3.0"):GetLookupTable()
local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BI = LibStub("LibBabble-Inventory-3.0"):GetLookupTable()

local WHITE		= "|cFFFFFFFF"
local GREEN		= "|cFF00FF00"

-- Simplified loot table containing item ID's only, based on AtlasLoot v5.09.00
local lootTable = {
			
	-- to do: HardModeArena & HardModeArena2 from sets_en.lua
	-- to do : wotlk crafts
	-- to do : pvp non set 80, line 3000 in wotlk.lua of AL 5.04
	-- tier 8

	-- ** Miscellaneous **
	[L["Bash'ir Landing"]] = {	
		[L["Skyguard Raid"]] = { 32596, 32600, 32599, 32597, 32634, 32637, 32635, 32636, 32639, 32638, 
								32641, 32640, 32759, 32630, 32631, 32627, 32625, 32629, 32628, 32626, 32624 },
		[L["Stasis Chambers"]] = { 32522, 31577, 31569, 31553, 31561},
	},
	[L["Skettis"]] = {	
		[L["Darkscreecher Akkarai"]] = {	32529, 32715, 31558, 31555, 31566, 31563, 31574, 31571, 31582, 31579, 32514 },
		[L["Karrog"]] = {	32533, 32717, 31558, 31555, 31566, 31563, 31574, 31571, 31582, 31579, 32514 },
		[L["Gezzarak the Huntress"]] = { 32531, 32716, 31558, 31555, 31566, 31563, 31574, 31571, 31582, 31579, 32514 },
		[L["Vakkiz the Windrager"]] = {	32532, 32718, 31558, 31555, 31566, 31563, 31574, 31571, 31582, 31579, 32514 },
		[L["Terokk"]] = { 32540, 32541, 31556, 31564, 31572, 31580, 32535, 32534, 32782, 32536, 32537 }
	},
	[L["Ethereum Prison"]] = {	
		[L["Armbreaker Huffaz"]] = { 31943, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Fel Tinkerer Zortan"]] = { 31573, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Forgosh"]] = { 31940, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Gul'bor"]] = { 31940, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Malevus the Mad"]] = { 31581, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Porfus the Gem Gorger"]] = { 31557, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Wrathbringer Laz-tarash"]] = { 32520, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 }
	},
	[L["Abyssal Council"] .. " (" .. BZ["Silithus"] .. ")"] = {	
		[L["Crimson Templar (Fire)"]] = { 20657, 20655, 20656	},
		[L["Azure Templar (Water)"]] = { 20654, 20652, 20653 },
		[L["Hoary Templar (Wind)"]] = { 20658, 20659, 20660 },
		[L["Earthen Templar (Earth)"]] = { 20661, 20662, 20663 },
		[L["The Duke of Cinders (Fire)"]] = { 20665, 20666, 20514, 20664, 21989 },
		[L["The Duke of Fathoms (Water)"]] = { 20668, 20669, 20514, 20667 },
		[L["The Duke of Zephyrs (Wind)"]] = { 20674, 20675, 20514, 20673 },
		[L["The Duke of Shards (Earth)"]] = { 20671, 20672, 20514, 20670 },
		[BB["Prince Skaldrenox"] .. " (Fire)"] = { 20682, 20515, 20681, 20680	},
		[BB["Lord Skwol"] .. " (Water)"] = {	20685, 20515, 20684, 20683 },
		[BB["High Marshal Whirlaxis"] .. " (Wind)"] = { 20691, 20515, 20690, 20689 },
		[BB["Baron Kazum"] .. " (Earth)"] = { 20688, 20515, 20686, 20687 }
	},
	[L["Elemental Invasion"]] = {	
		[BB["Baron Charr"] .. " (" .. BZ["Un'Goro Crater"] .. ")"] = {	18671, 19268, 18672 },
		[BB["Princess Tempestria"] .. " (" .. BZ["Winterspring"] .. ")"] = { 18678, 19268, 21548, 18679 },
		[BB["Avalanchion"] .. " (" .. BZ["Azshara"] .. ")"] = { 18673, 19268, 18674 },
		[BB["The Windreaver"] .. " (" .. BZ["Silithus"] .. ")"] = { 18676, 19268, 21548, 18677 }
	},
	[L["Gurubashi Arena"]] = {	
		[L["Booty Run"]] = { 18709, 18710, 18711, 18712, 18706, 19024 }
	},
	[L["Fishing Extravaganza"]] = {	
		[L["First Prize"]] = { 19970, 19979	},
		[L["Rare Fish"]] = { 19805, 19803, 19806, 19808 },
		[L["Rare Fish Rewards"]] = { 19972, 19969, 19971 }
	},
	[L["Children's Week"]] = {	
		[BZ["Azeroth"]] = { 23007, 23015, 23002, 23022 },
		[BZ["Outland"]] = { 32616, 32622, 32617	}
	},
	[L["Love is in the air"]] = {	
		[L["Gift of Adoration"]] = { 34480, 22279, 22235, 22200, 22261, 22218, 21813, 34258 },
		[L["Box of Chocolates"]] = { 22237, 22238, 22236, 22239 },
		[L["Quest rewards"]] = { 22276, 22278, 22280, 22277, 22281, 22282	}
	},
	[L["Hallow's End"]] = {	
		[L["Various Locations"]] = { 33117, 20400, 18633, 18632, 18635, 20557 },
		[L["Treat Bag"]] = {	20410, 20409, 20399, 20398, 20397, 20413, 20411, 20414, 20389, 20388, 
									20390, 20561, 20391, 20566, 20564, 20570, 20572, 20568, 20573, 20562, 
									20392, 20565, 20563, 20569, 20571, 20567, 20574 },
		[L["Headless Horseman"]] = { 33808, 34075, 34073, 34074, 33292, 33154, 34068, 33226, 33182, 33184, 
									33176, 33183, 33189 }
	},
	[L["Feast of Winter Veil"]] = {	
		[L["Various Locations"]] = { 21525, 21524, 17712, 17202, 34191, 21212, 21519 },
		[L["Smokywood Pastures Vendor"]] = { 34262, 34319, 34261, 34413, 17201, 17200, 17344, 17406, 17407, 17408, 
								34410, 17404, 17405, 34412, 17196, 17403, 17402, 17194, 17303, 17304, 17307 },
		[L["Gaily Wrapped Present"]] = { 21301, 21308, 21305, 21309	},
		[L["Festive Gift"]] = {	21328 },
		[L["Winter Veil Gift"]] = { 34425 },
		[L["Gently Shaken Gift"]] = {	21235, 21241 },
		[L["Ticking Present"]] = {	21325, 21213, 17706, 17725, 17720, 17722, 17709, 17724 },
		[L["Carefully Wrapped Present"]] = { 21254 },
		[L["Smokywood Pastures Extra-Special Gift"]] = { 21215 }
	},
	[L["Noblegarden"]] = {	
		[L["Brightly Colored Egg"]] = { 19028, 6833, 6835, 7807, 7808, 7806 }
	},	
	[L["Harvest Festival"]] = {	
		[L["Quest rewards"]] = { 19697, 20009, 20010 },
		[L["Food"]] = { 19994, 19995, 19996, 19997 }
	},
	[L["Scourge Invasion"]] = {	
		[L["Miscellaneous"]] = { 23123, 23122, 22999, 23194, 23195, 23196	},
		[L["Cloth Set"]] = {	23085, 23091, 23084 },
		[L["Leather Set"]] = { 23089, 23093, 23081 },
		[L["Mail Set"]] = { 23088, 23092, 23082 },
		[L["Plate Set"]] = {	23087, 23090, 23078 },
		[L["Balzaphon"]] = {	23126, 23125, 23124 },
		[L["Lord Blackwood"]] = { 23156, 23132, 23139 },
		[L["Revanchion"]] = { 23127, 23129, 23128	},
		[L["Scorn"]] = { 23170, 23169, 23168 },
		[L["Sever"]] = { 23173, 23171 },
		[L["Lady Falther'ess"]] = { 23178, 23177 }
	},
	[L["Lunar Festival"]] = {	
		[L["Miscellaneous"]] = { 21540, 21157, 21538, 21539, 21541, 21544, 21543, 21537, 21713, 21100 },
		[L["Fireworks Pack"]] = { 21558, 21559, 21557, 21561, 21562, 21589, 21590, 21592, 21593, 21595 },
		[L["Lucky Red Envelope"]] = { 21744, 21745 },
		[BI["Engineering"]] = { 21738, 21724, 21725, 21726, 21727, 21728, 21729, 21737, 21730, 21731, 
									21732, 21733, 21734, 21735 },
		[BI["Tailoring"]] = { 21722, 21723 }
	},
	[L["Midsummer Fire Festival"]] = {	
		[L["Miscellaneous"]] = { 34686, 23379, 23083, 23247, 23246, 23435, 23327, 23326, 
									23211, 34684, 23323, 23324, 34685, 34683 },
		[L["Lord Ahune"]] = { 35494, 35495, 35496, 35497, 35498, 35514, 35723, 34955, 35279, 35280 },
		[L["Lord Ahune"] .. L[" (Heroic)"]] = { 35507, 35509, 35508, 35511, 35498, 34955, 35723, 35279, 35280, 35497, 
									35496, 35494, 35495, 35514 }
	},
	[L["Shartuul"]] = {	
		[L["Blade Edge Mountains"]] = { 32941, 32676, 32675, 32677, 32678, 32672, 32673, 32674, 32670, 32671, 
									32679, 32942, 32655, 32656, 32665, 32664, 32658, 32659, 32660, 32663, 
									32661, 32662 }
	},
	[L["Brewfest"]] = {	
		[L["Miscellaneous"]] = { 33927, 33047, 33968, 33864, 33967, 33969, 33862, 33863, 33868, 33966, 
									33978, 33977, 33976, 32912, 34140, 32233, 33455, 34063, 34064, 33023, 
									33024, 33025, 33026, 33043, 33929 },
		[L["Barleybrew Brewery"]] = { 33030, 33028, 33029 },
		[L["Thunderbrew Brewery"]] = { 33031, 33032, 33033	},
		[L["Gordok Brewery"]] = { 33034, 33036, 33035 },
		["Coren Direbrew"] = { 37127, 38289, 38290, 38288, 38287, 37597 },
		[L["Drohn's Distillery"]] = { 34017, 34018, 34019 },
		[L["T'chali's Voodoo Brewery"]] = { 34020, 34021, 34022 }
	},
	
	-- ** Sets & PVP ***
	[BZ["Alterac Valley"]] = {	
		[L["Miscellaneous"].." (" .. FACTION_ALLIANCE .. ")"] = { 19045, 19032 },
		[L["Miscellaneous"].." (" .. FACTION_HORDE .. ")"] = {	19046, 19031 },
		[L["Miscellaneous"]] = { 19316, 17348, 17349, 19301, 19307, 19317, 17351, 17352, 19318	},
		[L["Superior Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = { 19086, 19084, 19094, 19093, 19092, 19091, 19098, 19097, 19100, 19104, 
										19102, 19320, 19319 },
		[L["Superior Rewards"].." (" .. FACTION_HORDE .. ")"] = {	19085, 19083, 19090, 19089, 19088, 19087, 19096, 19095, 19099, 19103, 
										19101, 19320, 19319 },
		[L["Epic Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = { 19030 },
		[L["Epic Rewards"].." (" .. FACTION_HORDE .. ")"] = { 19029 },
		[L["Epic Rewards"]] = {	19325, 19312, 19308, 19309, 19324, 19321, 21563, 19315, 19311, 19310, 19323 }
	},
	[BZ["Arathi Basin"]] = {
		[L["Miscellaneous"].." (" .. FACTION_ALLIANCE .. ")"] = {	17349, 17352, 20225, 20227, 20226, 20243, 20237, 20244 },
		[L["Miscellaneous"].." (" .. FACTION_HORDE .. ")"] = {	17349, 17352, 20222, 20224, 20223, 20234, 20232, 20235 },
		[format(L["Lv %s Rewards"], "20-29").." (" .. FACTION_ALLIANCE .. ")"] = {	20099, 20096, 20117, 20105, 20120, 20090, 20114, 20102, 20123, 20093, 
										20108, 20126, 20111, 20129, 21119 },
		[format(L["Lv %s Rewards"], "20-29").." (" .. FACTION_HORDE .. ")"] = {	20164, 20162, 20191, 20172, 20152, 20197, 20188, 20169, 20201, 20157, 
										20178, 20207, 20182, 20210, 21120 },
		[format(L["Lv %s Rewards"], "30-39").." (" .. FACTION_ALLIANCE .. ")"] = {	20098, 20095, 20116, 20104, 20113, 20101, 21118 }, 
		[format(L["Lv %s Rewards"], "30-39").." (" .. FACTION_HORDE .. ")"] = {	20166, 20161, 20192, 20173, 20187, 20168, 21116 },
		[format(L["Lv %s Rewards"], "40-49").." (" .. FACTION_ALLIANCE .. ")"] = {	20097, 20094, 20115, 20103, 20112, 20100, 20089, 20088, 20119, 20118, 
										20092, 20091, 20122, 20121, 20107, 20106, 20125, 20124, 20110, 20109, 
										20128, 20127, 21117 }, 
		[format(L["Lv %s Rewards"], "40-49").." (" .. FACTION_HORDE .. ")"] = {	20165, 20160, 20193, 20174, 20189, 20170, 20153, 20151, 20198, 20196, 
										20156, 20155, 20200, 20202, 20180, 20179, 20206, 20205, 20183, 20185, 
										20209, 20211, 21115 },
		[format(L["Lv %s Rewards"], "50-59").." (" .. FACTION_ALLIANCE .. ")"] = {	20047, 20054, 20045, 20046, 20052, 20053, 20043, 20050, 20042, 20041, 
										20049, 20048, 20071 }, 
		[format(L["Lv %s Rewards"], "50-59").." (" .. FACTION_HORDE .. ")"] = {	20163, 20159, 20190, 20171, 20186, 20167, 20150, 20195, 20154, 20199, 
										20204, 20208, 20072 },
		[format(L["Lv %s Rewards"], "60").." (" .. FACTION_ALLIANCE .. ")"] = {	20073, 20061, 20059, 20060, 20055, 20056, 20058, 20057, 20070, 20069 }, 
		[format(L["Lv %s Rewards"], "60").." (" .. FACTION_HORDE .. ")"] = {	20068, 20176, 20194, 20175, 20158, 20203, 20212, 20214, 20220 },
		[L["PVP Cloth Set"].." (" .. FACTION_ALLIANCE .. ")"] = { 20061, 20047, 20054	},
		[L["PVP Cloth Set"].." (" .. FACTION_HORDE .. ")"] = { 20176, 20163, 20159 },
		[L["PVP Leather Sets"].." (" .. FACTION_ALLIANCE .. ")"] = { 20059, 20045, 20052, 20060, 20046, 20053 },
		[L["PVP Leather Sets"].." (" .. FACTION_HORDE .. ")"] = { 20194, 20190, 20186, 20175, 20171, 20167 },
		[L["PVP Mail Sets"].." (" .. FACTION_ALLIANCE .. ")"] = { 20055, 20043, 20050, 20056, 20044, 20051 },
		[L["PVP Mail Sets"].." (" .. FACTION_HORDE .. ")"] = { 20158, 20150, 20154, 20203, 20195, 20199 },
		[L["PVP Plate Sets"].." (" .. FACTION_ALLIANCE .. ")"] = { 20057, 20041, 20048, 20058, 20042, 20049 },
		[L["PVP Plate Sets"].." (" .. FACTION_HORDE .. ")"] = { 20212, 20204, 20208 }
	},
	[BZ["Warsong Gulch"]] = {	
		[L["Miscellaneous"].." (" .. FACTION_ALLIANCE .. ")"] = {	19506 },
		[L["Miscellaneous"].." (" .. FACTION_HORDE .. ")"] = {	19505 },
		[L["Miscellaneous"]] = { 17348, 17349, 19060, 19062, 19067, 17351, 17352, 19061, 19066, 19068 },
		[format(L["Lv %s Rewards"], "10-19").." (" .. FACTION_ALLIANCE .. ")"] = {	20428, 20444, 20431, 20439, 20443, 20440, 20434, 20438 },
		[format(L["Lv %s Rewards"], "10-19").." (" .. FACTION_HORDE .. ")"] = {	20427, 20442, 20426, 20429, 20441, 20430, 20425, 20437 },
		[format(L["Lv %s Rewards"], "20-29").." (" .. FACTION_ALLIANCE .. ")"] = {	19533, 19541, 19525, 19517, 21568, 21566, 19549, 19557, 19573, 19565 },
		[format(L["Lv %s Rewards"], "20-29").." (" .. FACTION_HORDE .. ")"] = {	19529, 19537, 19521, 19513, 21568, 21566, 19545, 19553, 19569, 19561 },
		[format(L["Lv %s Rewards"], "30-39").." (" .. FACTION_ALLIANCE .. ")"] = {	19532, 19540, 19524, 19515, 19548, 19556, 19572, 19564 }, 
		[format(L["Lv %s Rewards"], "30-39").." (" .. FACTION_HORDE .. ")"] = {	19528, 19536, 19520, 19512, 19544, 19552, 19568, 19560 },
		[format(L["Lv %s Rewards"], "40-49").." (" .. FACTION_ALLIANCE .. ")"] = {	19597, 19590, 19584, 19581, 19531, 19539, 19523, 19516, 21567, 21565, 
													19547, 19555, 19571, 19563 }, 
		[format(L["Lv %s Rewards"], "40-49").." (" .. FACTION_HORDE .. ")"] = {	19597, 19590, 19584, 19581, 19527, 19535, 19519, 19511, 21567, 21565, 
													19543, 19551, 19567, 19559 },
		[format(L["Lv %s Rewards"], "50-59").." (" .. FACTION_ALLIANCE .. ")"] = {	19596, 19589, 19583, 19580, 19530, 19538, 19522, 19514, 19546, 19554, 19570, 19562 }, 
		[format(L["Lv %s Rewards"], "50-59").." (" .. FACTION_HORDE .. ")"] = {	19596, 19589, 19583, 19580, 19526, 19534, 19518, 19510, 19542, 19550, 
													19566, 19558 },
		[format(L["Lv %s Rewards"], "60").." (" .. FACTION_ALLIANCE .. ")"] = {	19595, 22752, 19587, 22749, 22750, 19582, 22748, 30497, 19578, 22753, 22672 }, 
		[format(L["Lv %s Rewards"], "60").." (" .. FACTION_HORDE .. ")"] = {	19595, 22747, 19587, 22740, 22741, 19582, 22673, 22676, 19578, 30498, 22651 }
	},
	[L["World PVP"]] = {	
		[L["Hellfire Fortifications"]] = { 27833, 27786, 28360, 27830, 27785, 27777, 24520, 24579, 24522, 24581 },
		[L["Twin Spire Ruins"]] = { 27990, 27984, 27922, 27929, 27939, 27983, 27920, 27927, 27930	},
		[L["Spirit Towers (Terrokar)"]] = { 28553, 28557, 28759, 28574, 28575, 28577, 28560, 28761, 32947, 28555, 
								28556, 28760, 28561, 28576, 28758, 28559, 32948	},
		[L["Halaa (Nagrand)"]] = {	28915, 27679, 27649, 27648, 27650, 27647, 27652, 27654, 27653, 24208, 
								29228, 27680, 27638, 27645, 27637, 27646, 27643, 27644, 27639, 33783, 
								32071, 30611, 30615, 30598, 30597, 30599, 30612, 30571, 30570, 30568 }
	},

	[format(L["Arena Season %d"], 1)] = {	
		[L["Druid Set"]] = { 28127, 28129, 28130, 28126, 28128, 28137, 28139, 28140, 28136, 28138,
								31376, 31378, 31379, 31375, 31377 },
		[L["Hunter Set"]] = { 28331, 28333, 28334, 28335, 28332 },
		[L["Mage Set"]] = { 25855, 25854, 25856, 25857, 25858 },
		[L["Paladin Set"]] = { 27704, 27706, 27702, 27703, 27705, 27881, 27883, 27879, 27880, 27882, 
								31616, 31619, 31613, 31614, 31618 },
		[L["Priest Set"]] = { 27708, 27710, 27711, 27707, 27709, 31410, 31412, 31413, 31409, 31411 },
		[L["Rogue Set"]] = {	25830, 25832, 25831, 25834, 25833 },
		[L["Shaman Set"]] = { 25998, 25999, 25997, 26000, 26001,27471, 27473, 27469, 27470, 27472, 
								31400, 31407, 31396, 31397, 31406 },
		[L["Warlock Set"]] = { 24553, 24554, 24552, 24556, 24555, 30187, 30186, 30200, 30188, 30201 },
		[L["Warrior Set"]] = { 24545, 24546, 24544, 24549, 24547 },
		[L["Weapons"]] = { 28313, 28314, 28297, 28312, 28310, 28295, 28307, 24550, 28308, 28309, 
								28298, 32450, 32451, 28305, 28302, 28299, 28476, 28300, 24557, 28358, 
								28319, 28294, 28320, 28346, 32452, 33945, 33942, 28355, 33936, 28356, 
								33948, 33939, 33951, 28357 }
	},
	[format(L["Arena Season %d"], 2)] = {	
		[L["Druid Set"]] = { 31968, 31971, 31972, 31967, 31969, 32057, 32059, 32060, 32056, 32058, 
								31988, 31990, 31991, 31987, 31989 },
		[L["Hunter Set"]] = { 31962, 31964, 31960, 31961, 31963 },
		[L["Mage Set"]] = { 32048, 32047, 32050, 32049, 32051 },
		[L["Paladin Set"]] = { 31997, 31996, 31992, 31993, 31995, 32041, 32043, 32039, 32040, 32042, 
								32022, 32024, 32020, 32021, 32023 },
		[L["Priest Set"]] = { 32035, 32037, 32038, 32034, 32036, 32016, 32018, 32019, 32015, 32017 },
		[L["Rogue Set"]] = {	31999, 32001, 32002, 31998, 32000 },
		[L["Shaman Set"]] = { 32006, 32008, 32004, 32005, 32007, 32011, 32013, 32009, 32010, 32012, 
								32031, 32033, 32029, 32030, 32032 },
		[L["Warlock Set"]] = { 31974, 31976, 31977, 31973, 31975, 31980, 31979, 31982, 31981, 31983 },
		[L["Warrior Set"]] = { 30488, 30490, 30486, 30487, 30489 },
		[L["Weapons"]] = { 32028, 32003, 32053, 32044, 32046, 32052, 32027, 31984, 31965, 31985, 
								31966, 32963, 32964, 32026, 31958, 31959, 32014, 32025, 32055, 33313, 
								33309, 32045, 32054, 31986, 32962, 31978, 32961, 33946, 33943, 33076, 
								33937, 33077, 33949, 33940, 33952, 33078 }
	},
	[format(L["Arena Season %d"], 3)] = {	
		[L["Druid Set"]] = { 33672, 33674, 33675, 33671, 33673, 33768, 33770, 33771, 33767, 33769, 
								33691, 33693, 33694, 33690, 33692 },
		[L["Hunter Set"]] = { 33666, 33668, 33664, 33665, 33667 },
		[L["Mage Set"]] = { 33758, 33757, 33760, 33759, 33761 },
		[L["Paladin Set"]] = { 33697, 33699, 33695, 33696, 33698, 33751, 33753, 33749, 33750, 33752, 
								33724, 33726, 33722, 33723, 33725 },
		[L["Priest Set"]] = { 33745, 33747, 33748, 33744, 33746, 33718, 33720, 33721, 33717, 33719  },
		[L["Rogue Set"]] = {	33701, 33703, 33704, 33700, 33702 },
		[L["Shaman Set"]] = { 33708, 33710, 33706, 33707, 33709, 33713, 33715, 33711, 33712, 33714, 
								33740, 33742, 33738, 33739, 33741 },
		[L["Warlock Set"]] = { 33677, 33679, 33680, 33676, 33678, 33683, 33682, 33685, 33684, 33686 },
		[L["Warrior Set"]] = { 33730, 33732, 33728, 33729, 33731 },
		[L["Weapons"]] = { 33737, 33705, 34016, 33763, 33754, 33801, 33756, 33762, 33734, 33688, 
								33669, 34015, 33689, 33670, 34014, 33687, 33743, 33733, 33662, 33663, 
								33727, 34540, 33716, 33766, 33661, 33735, 33755, 33765, 34529, 33006, 
								34530, 34059, 34066, 33764, 33681, 34033, 33736, 33947, 33944, 33841, 
								33938, 33842, 33950, 33941, 33953, 33843 }
	},
	[format(L["Arena Season %d"], 4)] = {
		[L["Druid Set"]] = { 34999, 35001, 35002, 34998, 35000, 35112, 35114, 35115, 35111, 35113, 
								35023, 35025, 35026, 35022, 35024 },
		[L["Hunter Set"]] = { 34992, 34994, 34990, 34991, 34993 },
		[L["Mage Set"]] = { 35097, 35096, 35099, 35098, 35100 },
		[L["Paladin Set"]] = { 35029, 35031, 35027, 5028, 35030, 35090, 35092, 35088, 35089, 35091, 
								35061, 35063, 35059, 35060, 35062 },
		[L["Priest Set"]] = { 35084, 35086, 35087, 35083, 35085, 35054, 35056, 35057, 35053, 35055 },
		[L["Rogue Set"]] = {	35033, 35035, 35036, 35032, 35034 },
		[L["Shaman Set"]] = { 35044, 35046, 35042, 35043, 35045, 35050, 35052, 35048, 35049, 35051, 
								35079, 35081, 35077, 35078, 35080 },
		[L["Warlock Set"]] = { 35004, 35006, 35007, 35003, 35005, 35010, 35009, 35012, 35011, 35013 },
		[L["Warrior Set"]] = { 35068, 35070, 35066, 35067, 35069 },
		[L["Weapons"]] = { 35076, 35038, 35037, 35102, 37739, 35093, 35058, 35095, 35101, 35072, 
								35015, 34996, 34995, 35017, 34997, 35110, 35014, 35082, 37740, 35071, 
								34988, 34989, 35064, 34987, 35103, 35109, 34986, 35073, 35094, 35108, 
								35047, 35018, 35075, 34985, 35065, 35107, 35008, 35016, 35074, 35019, 
								35020, 35021, 35039, 35040, 35041, 35104, 35105, 35106 }
	},
	[format(L["Arena Season %d"], 5)] = {
		[L["Death Knight"]] = { 
			40817, 40857, 40779, 40799, 40837, 40820, 40860, 40781, 40803, 40841, 40824, 40863, 40784, 40806, 40845
		},
		[L["Druid Set"]] = { 
			41324, 41278, 41313, 41290, 41301, 41325, 41279, 41314, 41291, 41302, 41326, 41280, 41315, 41292, 41303, 	-- balance
			41675, 41712, 41658, 41770, 41664, 41676, 41713, 41659, 41771, 41665, 41677, 41714, 41660, 41772, 41666,		-- feral
			41269, 41271, 41272, 41268, 41270, 41319, 41273, 41308, 41284, 41296, 41320, 41274, 41309, 41286, 41297		-- resto
		},
		[L["Hunter Set"]] = { 
			41154, 41214, 41084, 41140, 41202, 41155, 41215, 41085, 41141, 41203, 41156, 41216, 41086, 41142, 41204
		},
		[L["Mage Set"]] = { 
			41943, 41962, 41949, 41968, 41956, 41944, 41963, 41950, 41969, 41957, 41945, 41964, 41951, 41970, 41958
		},
		[L["Paladin Set"]] = { 
			40818, 40858, 40780, 40798, 40838, 40821, 40861, 40782, 40802, 40842, 40825, 40864, 40785, 40805, 40846,		-- retrib
			40930, 40960, 40898, 40918, 40936, 40931, 40961, 40904, 40925, 40937, 40932, 40962, 40905, 40926, 40938		-- holy
		},
		[L["Priest Set"]] = { 
			41912, 41930, 41918, 41937, 41924, 41913, 41931, 41919, 41938, 41925, 41914, 41933, 41920, 41939, 41926,		-- shadow
			41848, 41850, 41851, 41847, 41849, 41852, 41867, 41857, 41872, 41862, 41853, 41868, 41858, 41873, 41863,		-- holy
		},
		[L["Rogue Set"]] = {	
			41644, 41646, 41647, 41643, 41645, 41670, 41681, 41648, 41765, 41653, 41671, 41682, 41649, 41766, 41654
		},
		[L["Shaman Set"]] = { 
			41016, 41041, 40987, 41004, 41030, 41017, 41042, 40989, 41005, 41031, 41018, 41043, 40991, 41006, 41032,		-- elem
			41148, 41208, 41078, 41134, 41160, 41149, 41209, 41079, 41135, 41162, 41150, 41210, 41080, 41136, 41198,		-- enh
			41010, 41024, 40986, 40998, 41023, 41011, 41036, 40988, 40999, 41025, 41012, 41037, 40990, 41000, 41026		-- resto
		},
		[L["Warlock Set"]] = { 
			41990, 42008, 41996, 42014, 42002, 41991, 42009, 42001, 42015, 42003, 41992, 42010, 41997, 42016, 42004
		},
		[L["Warrior Set"]] = { 
			40816, 40856, 40778, 40797, 40836, 40819, 40859, 40783, 40801, 40840, 40823, 40862, 40786, 40804, 40844
		},

	},
	[format(L["Arena Season %d"], 6)] = {
		[L["Death Knight"]] = { 40827, 40868, 40787, 40809, 40848 },
		[L["Druid Set"]] = { 41327, 41281, 41316, 41293, 41304, 41678, 41715, 41661, 41773, 41667, 
			41321, 41275, 41310, 41287, 41298 },
		[L["Hunter Set"]] = { 41157, 41217, 41087, 41143, 41205 },
		[L["Mage Set"]] = { 41946, 41965, 41953, 41971, 41959 },
		[L["Paladin Set"]] = { 40828, 40869, 40788, 40808, 40849, 40933, 40963, 40907, 40927, 40939 },
		[L["Priest Set"]] = { 41915, 41934, 41921, 41940, 41927, 41854, 41869, 41859, 41874, 41864 },
		[L["Rogue Set"]] = {	41672, 41683, 41650, 41767, 41655 },
		[L["Shaman Set"]] = { 41019, 41044, 40993, 41007, 41033, 41151, 41211, 41081, 41137, 41199, 
			41013, 41038, 40992, 41001, 41027 },
		[L["Warlock Set"]] = { 41993, 42011, 41998, 42017, 42005 },
		[L["Warrior Set"]] = { 40826, 40866, 40789, 40807, 40847 },
	},
	[format(L["Arena Season %d"], 7)] = {
		[L["Death Knight"]] = { 40830, 40871, 40791, 40811, 40851 },
		[L["Druid Set"]] = { 41328, 41282, 41317, 41294, 41305, 41679, 41716, 41662, 41774, 41668, 
			41322, 41276, 41311, 41288, 41299 },
		[L["Hunter Set"]] = { 41158, 41218, 41088, 41144, 41206 },
		[L["Mage Set"]] = { 41947, 41966, 41954, 41972, 41960 },
		[L["Paladin Set"]] = { 40831, 40872, 40792, 40812, 40852, 40934, 40964, 40910, 40928, 40940 },
		[L["Priest Set"]] = { 41916, 41935, 41922, 41941, 41928, 41855, 41870, 41860, 41875, 41865 },
		[L["Rogue Set"]] = {	41673, 41684, 41651, 41768, 41656 },
		[L["Shaman Set"]] = { 41020, 41045, 40995, 41008, 41034, 41152, 41212, 41082, 41138, 41200, 
			41014, 41039, 40994, 41002, 41028 },
		[L["Warlock Set"]] = { 41994, 42012, 41999, 42018, 42006 },
		[L["Warrior Set"]] = { 40829, 40870, 40790, 40810, 40850 },
	},
	
	[format(L["Level %d Honor PVP"], 60)] = {	
		[L["Druid Set"]] = { 16451, 16449, 16452, 16448, 16450, 16459, 23308, 23309, 23294, 23280, 
								23295, 23281, 16550, 16551, 16549, 16555, 16552, 16554, 23253, 23254, 
								22877, 22863, 22878, 22852 },
		[L["Hunter Set"]] = { 16465, 16468, 16466, 16463, 16467, 16462, 23306, 23307, 23292, 23279, 
								23293, 23278, 16566, 16568, 16565, 16571, 16567, 16569, 23251, 23252, 
								22874, 22862, 22875, 22843 },
		[L["Mage Set"]] = { 16441, 16444, 16443, 16440, 16442, 16437, 23318, 23319, 23305, 23290, 
								23304, 23291, 16533, 16536, 16535, 16540, 16534, 16539, 23263, 23264, 
								22886, 22870, 22883, 22860 },
		[L["Paladin Set"]] = { 16474, 16476, 16473, 16471, 16475, 16472, 23276, 23277, 23272, 23274, 
								23273, 23275, 29616, 29617, 29615, 29613, 29614, 29612, 29604, 29605, 
								29602, 29600, 29603, 29601 },
		[L["Priest Set"]] = { 17602, 17604, 17605, 17608, 17603, 17607, 23316, 23317, 23303, 23288, 
								23302, 23289, 17623, 17622, 17624, 17620, 17625, 17618, 23261, 23262, 
								22885, 22869, 22882, 22859 },
		[L["Rogue Set"]] = {	16455, 16457, 16453, 16454, 16456, 16446, 23312, 23313, 23298, 23284, 
								23299, 23285, 16561, 16562, 16563, 16560, 16564, 16558, 23257, 23258, 
								22879, 22864, 22880, 22856 },
		[L["Shaman Set"]] = { 29610, 29611, 29609, 29607, 29608, 29606, 29598, 29599, 29596, 29595, 
								29597, 29594, 16578, 16580, 16577, 16574, 16579, 16573, 23259, 23260, 
								22876, 22867, 22887, 22857 },
		[L["Warlock Set"]] = { 17578, 17580, 17581, 17584, 17579, 17583, 23310, 23311, 23297, 23282, 
								23296, 23283, 17591, 17590, 17592, 17588, 17593, 17586, 23255, 23256, 
								22884, 22865, 22881, 22855 },
		[L["Warrior Set"]] = { 16478, 16480, 16477, 16484, 16479, 16483, 23314, 23315, 23300, 23286, 
								23301, 23287, 16542, 16544, 16541, 16548, 16543, 16545, 23244, 23243, 
								22872, 22868, 22873, 22858 },
		[L["Weapons"] .. " (" .. FACTION_ALLIANCE .. ")"] = { 18843, 18847, 23451, 18838, 12584, 23456, 18876, 18827, 18830, 23454, 
								18865, 18867, 23455, 18869, 18873, 18825, 18833, 18836, 18855, 23452, 23453 },
		[L["Weapons"] .. " (" .. FACTION_HORDE .. ")"] = { 18844, 18848, 23466, 18840, 16345, 23467, 18877, 18828, 18831, 23464, 
								18866, 18868, 23465, 18871, 18874, 18826, 18835, 18837, 18860, 23468, 23469 },
		[L["Accessories"] .. " (" .. FACTION_ALLIANCE .. ")"] = { 29465, 29467, 29468, 29471, 35906, 18863, 18856, 18859, 18864, 18862, 
								18857, 29593, 18858, 18854, 18440, 18441, 16342, 18457, 18456, 18455, 
								18454, 18453, 18452, 18449, 18448, 18447, 18445, 18442, 18444, 18443, 
								15196, 15198, 18606, 18839, 18841, 32455 },
		[L["Accessories"] .. " (" .. FACTION_HORDE .. ")"] = { 29466, 29469, 29470, 29472, 34129, 18853, 18846, 18850, 29592, 18851, 
								18849, 18845, 18852, 18834, 18427, 16341, 18461, 18437, 16486, 18436, 
								18434, 18435, 16497, 18432, 16532, 18430, 18429, 15200, 18428, 16335, 
								15197, 15199, 18607, 18839, 18841, 32455 }
	},
	[L["Level 70 Reputation PVP"]] = {	
		[L["Druid Set"]] = { 35357, 35359, 35360, 35356, 35358, 35372, 35374, 35375, 35371, 35373, 
								35362, 35364, 35365, 35361, 35363, 35469, 35470, 35471 },
		[L["Hunter Set"]] = { 35378, 35380, 35376, 35377, 35379, 35475 },
		[L["Mage Set"]] = { 35344, 35343, 35346, 35345, 35347, 35465 },
		[L["Paladin Set"]] = { 35414, 35416, 35412, 35413, 35415, 35404, 35406, 35402, 35403, 35405, 35476, 35477 },
		[L["Priest Set"]] = { 35339, 35341, 35342, 35338, 35340, 35333, 35336, 35337, 35335, 35334, 35467, 35466 },
		[L["Rogue Set"]] = {	35367, 35369, 35370, 35366, 35368, 35468 },
		[L["Shaman Set"]] = { 35383, 35385, 35381, 35382, 35384, 35388, 35390, 35386, 35387, 35389, 
								35393, 35395, 35391, 35392, 35394, 35472, 35473, 35474 },
		[L["Warlock Set"]] = { 35329, 35331, 35332, 35328, 35330, 35464 },
		[L["Warrior Set"]] = { 35409, 35411, 35407, 35408, 35410, 35478 }
	},
	[format(L["Level %d Honor PVP"], 70)] = {	
		[L["Weapons"] .. " (" .. FACTION_ALLIANCE .. ")"] = { 28953, 28947, 28957, 28954, 28955, 28956, 28952, 28943, 28944, 28946, 
								28945, 28950, 28951, 28942, 28948, 28949, 28959, 28940, 28960, 28941	},
		[L["Weapons"] .. " (" .. FACTION_HORDE .. ")"] = {	28928, 28922, 28931, 28929, 28930, 28937, 28926, 28293, 28920, 28921, 
								28918, 28924, 28925, 28917, 28919, 28923, 28935, 28939, 28933, 28938 },
		[L["Accessories"] .. " (" .. FACTION_ALLIANCE .. ")"] = { 25829, 28235, 28237, 28238, 28236, 30349, 28234, 30351, 30348, 30350, 
								28246, 28247 },
		[L["Accessories"] .. " (" .. FACTION_HORDE .. ")"] = { 24551, 28241, 28243, 28239, 28242, 30346, 28240, 30345, 30343, 30344, 
								28246, 28247 },
		[L["Accessories"]] = {	28362, 28119, 28363, 31853, 31839, 31855, 31841, 32453, 28118, 28120, 
								28123, 31838, 31852, 31840, 31854 },
		[L["Non Set Accessories"]] = { 28378, 28377, 33920, 33921, 33922, 35317, 35319, 33923, 33056, 33064,
								33057, 34576, 34577, 34578, 35326, 34579, 34580, 33853, 33918, 35320, 33919 },
		[L["Non Set Cloth"]] = { 33883, 33882, 33884, 33901, 33900, 33902, 33913, 33912, 33914 },
		[L["Non Set Leather"]] = {	33881, 33879, 33880, 33887, 33885, 33886, 33893, 33891, 33892, 33917, 
								33915, 33916 },
		[L["Non Set Mail"]] = {	33876, 33877, 33878, 33894, 33895, 33896, 33897, 33898, 33899, 33906, 
								33907, 33908 },
		[L["Non Set Plate"]] = { 33889, 33888, 33890, 33904, 33903, 33905, 33813, 33811, 33812, 33910, 
								33909, 33911 }
	},
	[format(L["Level %d Honor PVP"], 80)] = {	
		[L["Non Set Accessories"]] = { 42020, 42021, 42022, 42023, 42024, 42025, 42026, 42110, 42112, 42055,	
			42056, 42057, 42058,	42059, 42060, 42061, 42122, 42123, 42128, 42129, 42130, 42131, 42132 },
		[L["Non Set Cloth"]] = { 41907, 41896, 41901, 41878, 41877, 41879, 41908, 41897,	41902, 41892, 41880, 41884 },
		[L["Non Set Leather"]] = {	41638, 41628, 41633, 41332, 41330, 41331, 41830, 41827, 41828, 41639,	
			41629, 41634, 41624,	41616, 41620, 41839, 41831, 41835 },
		[L["Non Set Mail"]] = {	41063, 41068, 41073, 41047, 41050, 41049, 41223, 41233,	41228, 41064,	
			41069, 41074, 41059,	41048, 41054, 41224, 41234, 41229 },
		[L["Non Set Plate"]] = { 40972, 40966, 40973, 40887, 40877, 40878, 40982, 40974,	40975, 40888, 40879, 40880 },
		[L["Savage Gladiator\'s Weapons"]] = { 42294, 42295, 42297, 42445, 42343, 42356, 42448, 42446, 42213, 42217,
				42220, 42221, 42223, 42447, 42557, 42568, 42344, 42296, 42206, 42216,
				42222, 42224, 42218, 42212, 42214, 42219, 42517, 42511, 42556, 42444,
				42618, 42574, 42575, 42576, 42612, 42611, 42595, 42593, 42594	},
		[L["Deadly Gladiator\'s Weapons"]] = {	42317, 42322, 42332, 42346, 42454, 42227, 42248, 42270, 42280, 42290,
				42352, 42327, 42208, 42242, 42275, 42285, 42260, 42232, 42237, 42265,
				42362, 42384, 44420, 44419, 42564, 42570, 42559, 42450, 42490, 42495,
				42485, 42513, 42519, 42502, 42525, 42537, 42531, 42588, 42583, 42578,
				42614, 42852, 42620, 42597, 42607, 42602 },
		[BZ["Wintergrasp"]] = { 43956, 44077, 44066, 44075, 44069, 44068, 44067, 44081, 44084, 44082,
				44076, 44078, 44087, 44088, 44089, 41730, 41732, 41733, 41735, 41739,
				41736, 41738, 41734, 41727, 41740, 41728, 41742, 41743, 41744, 44107,
				44103, 44105, 44102, 44101, 44100, 44099, 44098, 44097, 44091, 44096,
				44092, 44094, 44095, 44093, 44115, 44910, 44909, 44899, 44900, 44907,
				44906, 44908, 44891, 44892, 44893, 44914, 44912, 44903, 44904, 44905,
				44896, 44897, 44898, 44901, 44902, 44894, 44895, },
		[BZ["Grizzly Hills"]] = { 38354, 38355, 38353, 38358, 38359, 38357, 38356, 38360, 38365, 38366,
				38364, 38363, 38362, 37836, 38368, 38367, 38361, 40875, 40822, 40867 },
	},
	
	-- Tier 0 (dungeon 1) is already in the level 60 instances (strat, scholo ..)
	[L["Tier 0.5 Quests"]] = { 
		[L["Druid Set"]] = { 22109, 22112, 22113, 22108, 22110, 22106, 22111, 22107 },
		[L["Hunter Set"]] = { 22013, 22016, 22060, 22011, 22015, 22010, 22017, 22061 },
		[L["Mage Set"]] = { 22065, 22068, 22069, 22063, 22066, 22062, 22067, 22064 },
		[L["Paladin Set"]] = { 22091, 22093, 22089, 22088, 22090, 22086, 22092, 22087 },
		[L["Priest Set"]] = { 22080, 22082, 22083, 22079, 22081, 22078, 22085, 22084 },
		[L["Rogue Set"]] = { 22005, 22008, 22009, 22004, 22006, 22002, 22007, 22003 },
		[L["Shaman Set"]] = { 22097, 22101, 22102, 22095, 22099, 22098, 22100, 22096 },
		[L["Warlock Set"]] = { 22074, 22073, 22075, 22071, 22077, 22070, 22072, 22076 },
		[L["Warrior Set"]] = { 21999, 22001, 21997, 21996, 21998, 21994, 22000, 21995 }
	},	
	-- Dungeon 3 (level 70) is already in the BC 5-men
	
	-- Tier 1 is already in MC
	-- Tier 2 is already in BWL, Ony
	
	[format(L["Tier %d Tokens"], 3)] = {
		[L["Druid Set"]] = { 22490, 22491, 22488, 22495, 22493, 22494, 22489, 22492, 23064 },
		[L["Hunter Set"]] = { 22438, 22439, 22436, 22443, 22441, 22442, 22437, 22440, 23067 },
		[L["Mage Set"]] = { 22498, 22499, 22496, 22503, 22501, 22502, 22497, 22500, 23062 },
		[L["Paladin Set"]] = { 22428, 22429, 22425, 22424, 22426, 22431, 22427, 22430, 23066 },
		[L["Priest Set"]] = { 22514, 22515, 22512, 22519, 22517, 22518, 22513, 22516, 23061 },
		[L["Rogue Set"]] = { 22478, 22479, 22476, 22483, 22481, 22482, 22477, 22480, 23060 },
		[L["Shaman Set"]] = { 22466, 22467, 22464, 22471, 22469, 22470, 22465, 22468, 23065 },
		[L["Warlock Set"]] = { 22506, 22507, 22504, 22511, 22509, 22510, 22505, 22508, 23063 },
		[L["Warrior Set"]] = { 22418, 22419, 22416, 22423, 22421, 22422, 22417, 22420, 23059 }
	},
	[format(L["Tier %d Tokens"], 4)] = {
		[BB["Prince Malchezaar"] .. " (" .. BZ["Karazhan"] .. ")"] = { 29098, 29086, 29093, 29081, 29076, 29068, 29073, 
						29061, 29049, 29058, 29044, 29040, 29028, 29035, 28963, 29011, 29021 },		-- T4 helm
		[BB["High King Maulgar"] .. " (" .. BZ["Gruul's Lair"] .. ")"] = { 29100, 29089, 29095, 29084, 29079, 29070, 29075, 
						29064, 29054, 29060, 29047, 29043, 29031, 29037, 28967, 29016, 29023 },		-- T4 shoulder
		[BB["Magtheridon"] .. " (" .. BZ["Magtheridon's Lair"] .. ")"] = { 29096, 29087, 29091, 29082, 29077, 29066, 29071, 
						29062, 29050, 29056, 29045, 29038, 29029, 29033, 28964, 29012, 29019 },		-- T4 chest
		[BB["The Curator"] .. " (" .. BZ["Karazhan"] .. ")"] = { 29097, 29090, 29092, 29085, 29080, 29067, 29072, 
						29065, 29055, 29057, 29048, 29039, 29032, 29034, 28968, 29017, 29020 },		-- T4 gloves
		[BB["Gruul the Dragonkiller"] .. " (" .. BZ["Gruul's Lair"] .. ")"] = { 29099, 29088, 29094, 29083, 29078, 29069, 29074, 
						29063, 29053, 29059, 29046, 29042, 29030, 29036, 28966, 29015, 29022 }		-- T4 leggings
	},
	[format(L["Tier %d Tokens"], 5)] = {
		[BB["Lady Vashj"] .. " (" .. BZ["Serpentshrine Cavern"] .. ")"] = { 30228, 30219, 30233, 30141, 30206, 30125, 30131,
						30136, 30152, 30161, 30146, 30190, 30166, 30171, 30212, 30115, 30120 },		-- T5 helm
		[BB["Void Reaver"] .. " (" .. BZ["The Eye"] .. ")"] = { 30230, 30221, 30235, 30143, 30210, 30127, 30133, 
						30138, 30154, 30163, 30149, 30194, 30168, 30173, 30215, 30117, 30122 },		-- T5 shoulders
		[BB["Kael'thas Sunstrider"] .. " (" .. BZ["The Eye"] .. ")"] = { 30222, 30216, 30231, 30139, 30196, 30123, 30129, 
						30134, 30150, 30159, 30144, 30185, 30164, 30169, 30214, 30113, 30118 }, 	-- T5 chest
		[BB["Leotheras the Blind"] .. " (" .. BZ["Serpentshrine Cavern"] .. ")"] = { 30223, 30217, 30232, 30140, 30205, 30124, 30130, 
						30135, 30151, 30160, 30145, 30189, 30165, 30170, 30211, 30114, 30119 },		-- T5 gloves
		[BB["Fathom-Lord Karathress"] .. " (" .. BZ["Serpentshrine Cavern"] .. ")"] = { 30229, 30220, 30234, 30142, 30207, 30126, 30132, 
						30137, 30153, 30162, 30148, 30192, 30167, 30172, 30213, 30116, 30121 }		-- T5 leggings
	},
	[format(L["Tier %d Tokens"], 6)] = {
		[BB["Azgalor"] .. " (" .. BZ["Hyjal Summit"] .. ")"] = { 31034, 31032, 31035, 31001, 31055, 30985, 30982, 
						30983, 31060, 31061, 31026, 31011, 31007, 31008, 31050, 30970, 30969 },		-- T6 gloves
		[BB["Archimonde"] .. " (" .. BZ["Hyjal Summit"] .. ")"] = { 31039, 31037, 31040, 31003, 31056, 30987, 30989,
						30988, 31063, 31064, 31027, 31015, 31012, 31014, 31051, 30974, 30972 },		-- T6 helm
		[BB["Mother Shahraz"] .. " (" .. BZ["Black Temple"] .. ")"] = { 31048, 31047, 31049, 31006, 31059, 30997, 30998,
						30996, 31069, 31070, 31030, 31024, 31022, 31023, 31054, 30980, 30979 },		-- T6 shoulders
		[BB["The Illidari Council"] .. " (" .. BZ["Black Temple"] .. ")"] = { 31044, 31045, 31046, 31005, 31058, 30995, 30993, 
						30994, 31068, 31067, 31029, 31021, 31019, 31020, 31053, 30978, 30977 },		-- T6 leggings
		[BB["Illidan Stormrage"] .. " (" .. BZ["Black Temple"] .. ")"] = { 31042, 31041, 31043, 31004, 31057, 30991, 30990, 
						30992, 31066, 31065, 31028, 31018, 31016, 31017, 31052, 30976, 30975 },		-- T6 chest
		[BB["Kalecgos"] .. " (" .. BZ["Sunwell Plateau"] .. ")"] = { 34444, 34445, 34446, 34443, 34447, 34433, 34431, 
						34432, 34435, 34434, 34448, 34439, 34438, 34437, 34436, 34442, 34441 },		-- T6 bracers
		[BB["Brutallus"] .. " (" .. BZ["Sunwell Plateau"] .. ")"] = { 34556, 34554, 34555, 34549, 34557, 34488, 34485, 
						34487, 34527, 34528, 34558, 34545, 34543, 34542, 34541, 34547, 34546 },		-- T6 belt
		[BB["Felmyst"] .. " (" .. BZ["Sunwell Plateau"] .. ")"] = { 34573, 34571, 34572, 34570, 34574, 34560, 34561, 
						34559, 34562, 34563, 34575, 34567, 34565, 34566, 34564, 34568, 34569 }		-- T6 boots
	},
	[format(L["Tier %d Tokens"], 7) .. " (10)"] = {
		[BB["Kel'Thuzad"]] = { 39619, 39625, 39553, 39531, 39545, 39578, 39491, 39628, 39635, 39640,
			39521, 39514, 39561, 39594, 39602, 39583, 39496, 39605, 39610 },
		[BB["Loatheb"]] = { 39621, 39627, 39556, 39542, 39548, 39581, 39494, 39631, 39637, 39642,
			39529, 39518, 39565, 39596, 39604, 39590, 39499, 39608, 39613 },
		[BB["The Four Horsemen"]] = { 39617, 39623, 39554, 39538, 39547, 39579, 39492, 39629, 39633, 39638,
			39523, 39515, 39558, 39592, 39597, 39588, 39497, 39606, 39611 },
		[BB["Thaddius"]] = {	39620, 39626, 39555, 39539, 39546, 39580, 39493, 39630, 39636, 39641,
			39528, 39517, 39564, 39595, 39603, 39589, 39498, 39607, 39612 },
		[BB["Sartharion"]] = { 39618, 39624, 39557, 39543, 39544, 39582, 39495, 39632, 39634, 39639,
			39530, 39519, 39560, 39593, 39601, 39591, 39500, 39609, 39622 },
	},
	[format(L["Tier %d Tokens"], 7) .. " (25)"] = {
		[BB["Kel'Thuzad"]] = { 40565, 40554, 40473, 40461, 40467, 40505, 40416, 40571, 40576, 40581,
			40456, 40447, 40499, 40510, 40521, 40516, 40421, 40528, 40546 },
		[BB["Loatheb"]] = { 40568, 40557, 40494, 40465, 40470, 40507, 40419, 40573, 40578, 40584,
			40459, 40450, 40502, 40513, 40524, 40518, 40424, 40530, 40548 },
		[BB["The Four Horsemen"]] = { 40559, 40550, 40471, 40463, 40469, 40503, 40418, 40569, 40574, 40579,
			40458, 40449, 40495, 40508, 40523, 40514, 40423, 40525, 40544 },
		[BB["Thaddius"]] = {	40567, 40556, 40493, 40462, 40468, 40506, 40417, 40572, 40577, 40583,
			40457, 40448, 40500, 40512, 40522, 40517, 40422, 40529, 40547 },
		[BB["Sartharion"]] = { 40563, 40552, 40472, 40460, 40466, 40504, 40415, 40570, 40575, 40580,
			40454, 40445, 40496, 40509, 40520, 40515, 40420, 40527, 40545 },
	},
	[L["Blizzard Collectables"]] = {	
		[L["WoW Collector Edition"]] = {	13582, 13583, 13584 },
		[L["BC Collector Edition (Europe)"]] = { 25535, 30360 },
		[L["Blizzcon 2005"]] = { 20371 },
		[L["Blizzcon 2007"]] = { 33079 },
		["Worldwide Invitational Paris 2008"] = { 39656 },
		[L["Christmas Gift 2006"]] = { 22114 }
	},
	[L["Upper Deck"]] = {
		[L["Loot Card Items"]] = { 23705, 23713, 23720, 32588, 32566, 32542, 33225, 33224, 33223, 33219, 
					34493, 34492, 34499, 35226, 35225, 35223, 23709, 23714, 23716, 35227, 
					38050, 38301, 38233, 38312, 23709, 38313, 38309, 38310, 38314, 38314, 
					38311, 23716, 23714 }
	},
	
	[L["Heroic Mode Tokens"]] = {	
		[L["Fire Resistance Gear"]] = { 30762, 30764, 30761, 30763, 30776, 30780, 30778, 30779, 30773, 30774, 
								30772, 30770, 30769, 30767, 30766, 30768 },
		[BI["Cloth"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 32090, 32089, 33588, 33589, 33587, 33586, 33291, 33584, 33585 },
		[BI["Cloth"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34924, 34917, 34936, 34938, 34925, 34937, 34918, 34919, 34926	},
		[BI["Leather"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 32088, 33972, 32087, 33287, 33973, 33566, 33579, 33578, 33580, 33557, 
								33540, 33974, 33539, 33559, 33583, 33552, 33538, 33582, 33222, 33577 },
		[BI["Leather"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34906, 34903, 34900, 34927, 34904, 34902, 34901,
								34911, 34929, 34905, 34910, 34928 },
		[BI["Mail"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 32086, 32085, 33970, 33965, 33535, 33532, 33529, 33528, 33534, 33531, 
								33386, 33536, 33280, 33530, 33527, 33537, 33324 },
		[BI["Mail"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34912, 34933, 34930, 34916, 34935, 34932, 34914, 34931, 34934 },
		[BI["Plate"] .. " (" .. BZ["Shattrath City"] ..  ")"] = {	33810, 32083, 32084, 33514, 33522, 33516, 33513, 33520, 33517, 33512, 
								33519, 33331, 33524, 33279, 33501, 33518, 33515, 33207, 33523 },
		[BI["Plate"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34942, 34939, 34921, 34945, 34944, 34941, 34923, 34922, 34946, 34943, 
								34940, 34947 },
		[L["Cloaks"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 29375, 29382, 35321, 33304, 35324, 33484, 29385, 33333, 29369, 33593	},
		[L["Relics"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 29390, 33508, 33509, 33510, 33506, 33507, 33505, 29389, 33503, 33504, 
								33502, 29388 },
		[L["Accessories"] .. " (" .. BZ["Shattrath City"] ..  ")"] = {	33296, 29381, 29374, 29386, 29368, 29373, 29379, 29367, 29384, 23572, 
								35326, 34049, 34163, 34162, 33832, 34050, 29383, 29376, 29387, 29370, 30183 },
		[L["Accessories"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34887, 34890, 34889, 34888, 32227, 32228, 32229,
								32231, 32249, 32230, 35318, 35315, 35316},
		[L["Weapons"] .. " (" .. BZ["Shattrath City"] ..  ")"] = {	29275, 33192, 29268, 29267, 29266, 33334, 29270, 29273, 29272, 29269, 
								29271, 29274, 33325 },
		[L["Weapons"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = {	34894, 34896, 34895, 34893, 34951, 34950, 34949, 34952, 34891, 34898, 34892 },
		[L["Emblems of Valor"]] = { 40724, 40723, 40722, 40721, 40741, 40740, 40751, 40750, 40739, 40738,
				40748, 40749, 40736, 40737, 40746, 40747, 40734, 40733, 40735, 40742,
				40743, 40745, 40719, 40720, 40717, 40718, 40634, 40635, 40636, 40637, 40638, 40639 },
		[L["Emblems of Heroism"]] = { 40697, 40696, 40694, 40695, 40693, 40692, 40691, 40688, 40689, 40610,
				40611, 40612, 40613, 40614, 40615, 43102, 40704, 40702, 40703, 40716, 
				40701, 40700, 40699, 40698, 40679, 40680, 40681, 40678, 40684, 40682,
				40685, 40683, 40711, 40712, 40713, 40707, 40706, 40705, 40715, 40709,
				40710, 40708, 42985, 42984, 42952, 42950, 42951, 42949, 42992, 42991,
				42944, 42945, 42943, 42948, 42947, 42946 }
	},
	
	[L["World Drops"]] = {
		[L["Level 30-39"]] = { 867, 1981, 1980, 869, 1982, 870, 868, 873, 1204, 2825 },
		[L["Level 40-49"]] = { 3075, 940, 14551, 17007, 14549, 1315, 942, 1447, 2164,  2163, 
								809, 871, 2291, 810, 2915, 812, 943, 1169, 1979, 2824, 2100 },
		[L["Level 50-60"]] = { 3475, 14553, 2245, 14552, 14554, 1443, 14558, 2246, 833, 14557,
								1728, 14555, 2244, 2801, 647, 811, 1263, 2243, 944, 1168, 2099 },
		[L["Level 70"]] = { 34703, 28189, 31329, 31340, 31343, 31333, 31330, 31328, 31335, 31320,
								31338, 31321, 31319, 31339, 31326, 31331, 31336, 31332, 31318, 31342, 
								31322, 31334, 34622, 31323 }
	},
	
	-- not in LPT
	[BZ["Onyxia's Lair"] .. " (10)"] = {
		[BB["Onyxia"]] = { 49307, 49316, 49317, 49315, 49318, 49322, 49327, 49328, 49326, 49331,
			49330, 49329, 49319, 49320, 49321, 49333, 49332, 49323, 49325, 49324,
			49306, 49309, 49463, 49310, 49308, 49304, 49437, 49298, 49303, 49296, 
			49299, 49297, 49302, 49301, 49305, 49644, 49485, 49486, 49487, 49295,
			49294, 49636 },
	},
	[BZ["Onyxia's Lair"] .. " (25)"] = {
		[BB["Onyxia"]] = { 49491, 49482, 49483, 49484, 49481, 49477, 49472, 49473, 49471, 49469,
			49468, 49470, 49480, 49479, 49478, 49467, 49466, 49476, 49475, 49474,
			49492, 49489, 49464, 49488, 49490, 49295, 49636, 49294, 49494, 49465,
			49499, 49495, 49501, 49498, 49500, 49496, 49497, 49493, 49644, 49485,
			49486, 49487 },
	},
	
	[BZ["Trial of the Champion"]] = {
		[BB["Faction Champions"]] = {	47173, 47170, 47174, 47175, 47172, 47171 },
		[BB["Argent Confessor Paletress"]] = {	47181, 47218, 47185, 47217, 47177, 47178, 47211, 47176, 47212, 47219,
				47213, 47214 },
		[BB["Eadric the Pure"]] = { 47181, 47185, 47210, 47177, 47202, 47178, 47176, 47197, 47201, 47199,
				47200, 47213 },
		[BB["The Black Knight"]] = { 47232, 47226, 47230, 47221, 47231, 47228, 47220, 47229, 47227, 47222,
				47215, 47216 },
	},
	[BZ["Trial of the Champion"] .. L[" (Heroic)"]] = {
		[BB["Faction Champions"]] = {	45624, 47249, 47248, 47250, 47244, 47243, 47493, 44990 },
		[BB["Argent Confessor Paletress"]] = { 45624, 47498, 47496, 47245, 47497, 47514, 47510, 47495, 47511, 47494, 
				47512, 47500, 47522, 44990 },
		[BB["Eadric the Pure"]] = { 45624, 47501, 47496, 47498, 47504, 47497, 47502, 47495, 47503, 47494, 
				47500, 47509, 47508, 44990 },
		[BB["The Black Knight"]] = { 45624, 47564, 47527, 47560, 47529, 47561, 47563, 47565, 47567, 47562,
				47566, 47569, 49682, 47568, 43102, 44990, 48418	},
	},
	
	[BZ["Trial of the Crusader"] .. " (10)"] = {
		[BB["The Beasts of Northrend"]] = {	47617, 47613, 47608, 47616, 47610, 47611, 47609, 47615, 47614, 47607,
				47578, 47612, 47855, 47857, 47853, 47860, 47850, 47852, 47851, 47859, 47858, 47849,	47854, 47856 },
		[BB["Lord Jaraxxus"]] = { 47663, 47620, 47669, 47621, 49235, 47683, 47680, 47711, 47619, 47679,
				47618, 47703, 47676, 47861, 47865, 47863, 47866, 49236, 47867, 47869, 
				47870, 47872, 47864, 47862, 47868, 47871 },
		[BB["Faction Champions"]] = { 47721, 47719, 47718, 47717, 47720, 47728, 47727, 47726, 47725, 47724,
				47873, 47878, 47875, 47876, 47877, 47880, 47882, 47879, 47881, 47874	},
		[BB["The Twin Val'kyr"]] = { 47745, 49231, 47746, 47739, 47744, 47738, 47747, 47700, 47742, 47736,
				47737, 47743, 47740, 47889, 49232, 47891, 47887, 47893, 47885, 47890, 
				47888, 47913, 47886, 47884, 47892, 47883 },
		[BB["Anub'arak"]] = { 47838, 47837, 47832, 47813, 47829, 47811, 47836, 47830, 47810, 47814,
				47808, 47809, 47816, 47834, 47815, 47835, 47812, 47741, 47906, 47909, 
				47904, 47897, 47901, 47896, 47902, 47908, 47899, 47903, 47898, 47894,
				47905, 47911, 47900, 47910, 47895, 47907 },
		[L["Patterns"]] = { 47654, 47655, 47656, 47657, 47629, 47635, 47631, 47630, 47628, 47634,
				47632, 47633, 47622, 47623, 47627, 47626, 47624, 47625, 47556, 47639, 
				47638, 47637, 47636, 47646, 47647, 47648, 47649, 47650, 47651, 47652,
				47653, 47640, 47641, 47642, 47643, 47644, 47645	},
	},

	[BZ["Trial of the Crusader"] .. " (25)"] = {
		[BB["The Beasts of Northrend"]] = {	46970, 46976, 46992, 46972, 46974, 46988, 46960, 46990, 46962, 46961,
				46985, 46959, 46979, 46958, 46963, 47242, 47257, 47256, 47264, 47258, 47259, 47262, 47251, 47265,
				47254, 47253, 47263, 47252, 47261, 47255, 47260 },
		[BB["Lord Jaraxxus"]] = { 47042, 47051, 47000, 47055, 47056, 46999, 47057, 47052, 46997, 47043,
				47223, 47041, 47053, 46996, 46994, 47242, 47275, 47274, 47270, 47277, 
				47280, 47268, 47279, 47273, 47269, 47272, 47278, 47271, 47276, 47266,
				47267, 47242 },
		[BB["Faction Champions"]] = {	47089, 47081, 47092, 47094, 47071, 47073, 47083, 47090, 47082, 47093,
				47072, 47070, 47080, 47069, 47079, 47242, 47291, 47286, 47293, 47292, 
				47284, 47281, 47289, 47295, 47288, 47294, 47283, 47282, 47290, 47285,
				47287 },
		[BB["The Twin Val'kyr"]] = { 47126, 47141, 47107, 47140, 47106, 47142, 47108, 47121, 47116, 47105,
				47139, 47115, 47138, 47104, 47114, 47242, 47301, 47306, 47308, 47299, 
				47296, 47310, 47298, 47304, 47307, 47305, 47297, 47303, 47309, 47300,
				47302	},
		[BB["Anub'arak"]] = { 47225, 47183, 47203, 47235, 47187, 47194, 47151, 47186, 47204, 47152,
				47184, 47234, 47195, 47150, 47054, 47149, 47182, 47148, 47193, 47233,
				47242, 47328, 47320, 47324, 47326, 47317, 47321, 47313, 47318, 47325, 
				47311, 47319, 47330, 47323, 47312, 47315, 47327, 47316, 47314, 47322,
				47329	},
	},
	
	[BZ["Trial of the Crusader"] .. " (10)" .. L[" (Heroic)"]] = {
		[BB["The Beasts of Northrend"]] = {	47921, 47923, 47919, 47926, 47916, 47918, 47917, 47924, 47925, 47915,
				47920, 47922, 47994, 47996, 47992, 47999, 47989, 47991, 47990, 47998, 
				47997, 47988, 47993, 47995 },
		[BB["Lord Jaraxxus"]] = { 47927, 47931, 47929, 47932, 49238, 47933, 47935, 47937, 47930, 47939,
				47928, 47934, 47938, 48000, 48004, 48002, 48005, 49237, 48006, 48008, 
				48009, 48011, 48003, 48001, 48007, 48010 },
		[BB["Faction Champions"]] = {	47940, 47945, 47942, 47943, 47944, 47947, 47949, 47946, 47948, 47941,
				48012, 48017, 48014, 48015, 48016, 48019, 48021, 48018, 48020, 48013 },
		[BB["The Twin Val'kyr"]] = { 47956, 49234, 47959, 47954, 47961, 47952, 47957, 47955, 47958, 47953,
				47951, 47960, 47950, 48028, 49233, 48034, 48026, 48038, 48024, 48030, 
				48027, 48032, 48025, 48023, 48036, 48022 },
		[BB["Anub'arak"]] = { 47974, 47977, 47972, 47965, 47969, 47964, 47976, 47970, 47967, 47971,
				47966, 47962, 47973, 47979, 47968, 47978, 47963, 47975, 48051, 48054, 
				48049, 48042, 48046, 48041, 48047, 48053, 48044, 48048, 48043, 48039,
				48050, 48056, 48045, 48055, 48040, 48052 },
		[L["Tribute Run"]] = { 47242, 48712, 48708, 48713, 48709, 48714, 48710, 48711, 48673,
				48675, 48674, 48671, 48672, 49044, 48703, 48701, 48695, 48693, 
				48699, 48705, 48697, 48668, 48669, 48670, 48666, 48667, 49046 },
	},
	[BZ["Trial of the Crusader"] .. " (25)" .. L[" (Heroic)"]] = {
		[BB["The Beasts of Northrend"]] = {	46971, 46977, 46993, 46973, 46975, 46989, 46965, 46991, 46968, 46967,
				46986, 46966, 46980, 46969, 46964, 47242, 47418, 47417, 47425, 47419, 
				47420, 47423, 47412, 47426, 47415, 47414, 47424, 47413, 47422, 47416,
				47421 },
		[BB["Lord Jaraxxus"]] = { 47063, 47062, 47004, 47066, 47068, 47002, 47067, 47061, 47003, 47060,
				47224, 47059, 47064, 47001, 46995, 47242, 47436, 47435, 47431, 47438, 
				47441, 47429, 47440, 47434, 47430, 47433, 47439, 47432, 47437, 47427,
				47428	},
		[BB["Faction Champions"]] = {	47095, 47084, 47097, 47096, 47077, 47074, 47087, 47099, 47086, 47098,
				47076, 47075, 47088, 47078, 47085, 47242, 47452, 47447, 47454, 47453, 
				47445, 47442, 47450, 47456, 47449, 47455, 47444, 47443, 47451, 47446,
				47448 },
		[BB["The Twin Val'kyr"]] = { 47129, 47143, 47112, 47145, 47109, 47147, 47111, 47132, 47133, 47110,
				47144, 47131, 47146, 47113, 47130, 47242, 47462, 47467, 47469, 47460, 
				47457, 47471, 47459, 47465, 47468, 47466, 47458, 47464, 47470, 47461,
				47463	},
		[BB["Anub'arak"]] = { 47238, 47192, 47208, 47236, 47189, 47205, 47155, 47190, 47209, 47153,
				47191, 47240, 47207, 47154, 47237, 47157, 47188, 47156, 47206, 47239,
				47242, 47490, 47481, 47485, 47487, 47478, 47482, 47474, 47479, 47486, 
				47472, 47480, 47492, 47484, 47473, 47476, 47489, 47477, 47475, 47483,
				47491 },
		[L["Tribute Run"]] = { 47557, 47558, 47517, 47506, 47515, 47526, 47519, 47524, 47521, 47553,
				47552, 47549, 47545, 47547, 47518, 47513, 47516, 47528, 47520, 47525,
				47523, 47551, 47550, 47548, 47554, 47546 },
	},
	
	-- 3.3

	[BZ["The Forge of Souls"]] = {
		[BB["Bronjahm"]] = {	49788, 49785, 49786, 49787, 49784, 49783, 50317, 50316 },
		[BB["Devourer of Souls"]] = {	49792, 49796, 49798, 49791, 49797, 49794, 49795, 49799, 49800, 49789, 49790, 49793 },
		[L["Trash Mobs"]] = { 49854, 49855, 49853, 49852 },
	},
	[BZ["The Forge of Souls"] .. L[" (Heroic)"]] = {
		[BB["Bronjahm"]] = {	50193, 50197, 50194, 50196, 50191, 50169, 50317, 50316 },
		[BB["Devourer of Souls"]] = {	50213, 50206, 50212, 50214, 50209, 50208, 50207, 50215, 50211, 50198,
				50203, 50210 },
		[L["Trash Mobs"]] = { 50318, 50315, 50319, 50380, 50379 },
	},
	[BZ["Pit of Saron"]] = {
		[BB["Forgemaster Garfrost"]] = {	49805, 49806, 49804, 49803, 49802, 49801 },
		-- temporarily not localized
		["Krick and Ick"] = { 49809, 49810, 49811, 49808, 49812, 49807 },
		[BB["Scourgelord Tyrannus"]] = { 49823, 49825, 49822, 49817, 49824, 49826, 49820, 49819, 49816, 49818,
				49821, 49813, },
		[L["Trash Mobs"]] = { 49854, 49855, 49853, 49852 },
	},
	[BZ["Pit of Saron"] .. L[" (Heroic)"]] = {
		[BB["Forgemaster Garfrost"]] = {	50233, 50234, 50230, 50229, 50228, 50227 },
		-- temporarily not localized
		["Krick and Ick"] = { 50266, 50263, 50624, 50265, 50235, 50262 },
		[BB["Scourgelord Tyrannus"]] = { 50286, 50269, 50270, 50283, 50272, 50285, 50284, 50271, 50259, 50268,
				50267, 50273 },
		[L["Trash Mobs"]] = { 50318, 50315, 50319, 50380, 50379 },
	},
	[BZ["Halls of Reflection"]] = {
		-- temporarily not localized
		[BB["Falric"]] = { 49832, 49828, 49830, 49831, 49829, 49827 },
		[BB["Marwyn"]] = { 49834, 49838, 49837, 49836, 49833, 49835, 49828 },
		[BB["The Lich King"]] = { 49842, 49849, 49848, 49841, 49847, 49851, 49843, 49846, 49839, 49840,
				49845, 49844, },
		[L["Trash Mobs"]] = { 49854, 49855, 49853, 49852 },
	},
	[BZ["Halls of Reflection"] .. L[" (Heroic)"]] = {
		[BB["Falric"]] = { 50292, 50293, 50295, 50294, 50290, 50291 },
		[BB["Marwyn"]] = { 50298, 50299, 50300, 50297, 50260, 50296 },
		[BB["The Lich King"]] = { 50314, 50312, 50308, 50304, 50311, 50305, 50310, 50313, 50306, 50309,
				50302, 50303 },
		[L["Trash Mobs"]] = { 50318, 50315, 50319, 50380, 50379 },
	},
	
	[BZ["Icecrown Citadel"] .. " (10)"] = {
		[BB["Lord Marrowgar"]] = {	50764, 50773, 50774, 50762, 50775, 50772, 50763, 50339, 50771, 50761, 50759, 50760, },
		[BB["Lady Deathwhisper"]] = {	50785, 50782, 50780, 50778, 50783, 50777, 50784, 50779, 50786, 50342, 50781, 50776 },
		[BB["Icecrown Gunship Battle"]] = {	50791, 50795, 50797, 50792, 50789, 50796, 50788, 50790, 50340, 50793, 50787, 50794 },
		[BB["Deathbringer Saurfang"]] = { 50807, 50804, 50799, 50806, 50800, 50801, 50802, 50808, 50809, 50803, 50798, 50805 },
		[BB["Festergut"]] = { 50859, 50988, 50990, 50985, 50858, 50812, 50967, 50811, 50852, 50986, 50810, 50966 },
		[BB["Rotface"]] = { 51007, 51005, 51009, 51002, 51006, 51000, 51008, 51001, 51003, 51004, 50998, 50999 },
		[BB["Professor Putricide"]] = { 51020, 51017, 51013, 51015, 51019, 51014, 51018, 51012, 51016, 50341, 51011, 51010 },
		[BB["Blood Princes"]] = { 51382, 51379, 51380, 51023, 51325, 51383, 51025, 51381, 51024, 51021, 51022, 51326 },
		[BB["Blood-Queen Lana'thel"]] = { 51554, 51552, 51550, 51551, 51386, 51556, 51555, 51548, 51387, 51384, 51385, 51553 },
		[BB["Valithria Dreamwalker"]] = { 51584, 51777, 51585, 51565, 51583, 51566, 51586, 51563, 51564, 51562, 51582, 51561,},
		[BB["Sindragosa"]] = { 51790, 51783, 51789, 51792, 51785, 51782, 51786, 51787, 51026, 51779,
				51784, 51788, 51791 },
		[BB["The Lich King"]] = {	},
	},
	[BZ["Icecrown Citadel"] .. " (25)"] = {
		[BB["Lord Marrowgar"]] = {	49978, 49979, 49950, 49952, 49980, 49951, 49960, 49964, 49975, 49949, 49977, 49967, 49968, 50415, 49976, 50274, 49908 },
		[BB["Lady Deathwhisper"]] = {	49991, 49994, 49987, 49996, 49988, 49993, 49986, 49995, 49983, 49989, 49985, 49990, 49982, 49992, 50034, 50274, 49908 },
		[BB["Icecrown Gunship Battle"]] = {	49998, 50006, 50011, 50001, 50009, 50000, 50003, 50002, 50010, 50274,
				49908, 50005, 50008, 49999, 50359, 50352, 50411 },
		[BB["Deathbringer Saurfang"]] = { 50014, 50333, 50015, 50362, 50412, 50274, 49908, 52027, 52026, 52025, },
		[BB["Festergut"]] = { 50063, 50056, 50062, 50042, 50041, 50059, 50038, 50064, 50413, 50060,
				50037, 50036, 50061, 50414, 50035, 50040, 50226, 50274, 49908, },
		[BB["Rotface"]] = { 50019, 50032, 50026, 50021, 50022, 50030, 50020, 50024, 50027, 50023,
				50025, 50353, 50028, 50016, 50033, 50231, 50274, 49908 },
		[BB["Professor Putricide"]] = { 50067, 50069, 50351, 50179, 50068, 50274, 49908, 52027, 52026, 52025},
		[BB["Blood Princes"]] = { 50074, 50172, 50176, 50073, 50171, 50177, 50071, 50072, 50075, 50175,
				50174, 50170, 50173, 50184, 49919, 50274, 49908 },
		[BB["Blood-Queen Lana'thel"]] = { 50182, 50180, 50354, 50178, 50181, 50065, 50274, 49908, 52027, 52026, 52025 },
		[BB["Valithria Dreamwalker"]] = { 50205, 50418, 50417, 50202, 50188, 50187, 50199, 50192, 50416, 50190,
				50195, 50185, 50186, 50183, 50472, 50274, 49908 },
		[BB["Sindragosa"]] = { 50421, 50424, 50360, 50361, 50423, 50274, 49908, 51026, 52027, 52026, 52025,	},
		[BB["The Lich King"]] = {	},
		[L["Trash Mobs"]] = { 50449, 50450, 50451, 50452, 50447, 50453, 50444 },
	},
	[BZ["Icecrown Citadel"] .. " (10)" .. L[" (Heroic)"]] = {
		[BB["Lord Marrowgar"]] = {	},
		[BB["Lady Deathwhisper"]] = {	},
		[BB["Icecrown Gunship Battle"]] = {	},
		[BB["Deathbringer Saurfang"]] = {	},
		[BB["Festergut"]] = {	},
		[BB["Rotface"]] = {	},
		[BB["Professor Putricide"]] = {	},
		[BB["Blood Princes"]] = {	},
		[BB["Blood-Queen Lana'thel"]] = {	},
		[BB["Valithria Dreamwalker"]] = {	},
		[BB["Sindragosa"]] = {	},
		[BB["The Lich King"]] = {	},
	},
	[BZ["Icecrown Citadel"] .. " (25)" .. L[" (Heroic)"]] = {
		[BB["Lord Marrowgar"]] = {	},
		[BB["Lady Deathwhisper"]] = {	},
		[BB["Icecrown Gunship Battle"]] = {	},
		[BB["Deathbringer Saurfang"]] = {	},
		[BB["Festergut"]] = {	},
		[BB["Rotface"]] = {	},
		[BB["Professor Putricide"]] = {	},
		[BB["Blood Princes"]] = {	},
		[BB["Blood-Queen Lana'thel"]] = {	},
		[BB["Valithria Dreamwalker"]] = {	},
		[BB["Sindragosa"]] = {	},
		[BB["The Lich King"]] = {	},
	},
	
	-- [] = {
	-- },
	
}

local DataProviders

addon.Loots = {}

local ns = addon.Loots		-- ns = namespace

function ns:GetSource(searchedID)
	DataProviders = DataProviders or {			-- list of sources that have a :GetSource() method
		DataStore_Reputations,
		DataStore_Crafts,
		DataStore_Inventory,
	}

	local domain, subDomain
	for _, provider in pairs(DataProviders) do
		domain, subDomain = provider:GetSource(searchedID)
		if domain and subDomain then
			return domain, subDomain
		end
	end
	
	-- extremely fast: takes from 0.3 to 3 ms max, depends on the location of the item in the table (obviously longer if the item is at the end)
	for Instance, BossList in pairs(lootTable) do
		for Boss, LootList in pairs(BossList) do
			for itemID, _ in pairs(LootList) do
				if LootList[itemID] == searchedID then
					return Instance, Boss
				end
			end
		end
	end
	return nil
end

local filters = addon.ItemFilters

local function ParseAltoholicLoots(OnMatch, OnNoMatch)
	assert(type(OnMatch) == "function")
	local count = 0
	
	for Instance, BossList in pairs(lootTable) do
		for Boss, LootList in pairs(BossList) do
			for _, itemID in pairs(LootList) do
				count = count + 1
				filters:SetSearchedItem(itemID)
				
				if filters:ItemPassesFilters() then
					OnMatch(Instance, Boss)
				else
					if OnNoMatch then
						OnNoMatch()
					end
				end
			end
		end
	end
	
	filters:ClearSearchedItem()
	return count
end

local function ParseLPTSet(set, OnMatch, OnNoMatch)
	assert(type(OnMatch) == "function")
	
	local PT = LibStub("LibPeriodicTable-3.1")
	if not PT then return 0 end		-- exit if LPT is not active

	-- LPT stores certain sets twice, but does not offer the possibility to differentiate entries (instances that are part of hubs)
	-- So keep track of the sets we've already parsed, to avoid returning items twice.
	local doneSets = {}
	local count = 0

	for _, list in pairs(PT:GetSetTable(set)) do
		local _, domain, subdomain = strsplit(".", list.set)
		
		if not doneSets[list.set] then			-- if this set hasn't been parsed yet, proceed..
			for itemID, value in pairs(list) do
				if tostring(itemID) ~= "set" then
					count = count + 1
					filters:SetSearchedItem(itemID)
					
					if filters:ItemPassesFilters() then
						OnMatch(domain, subdomain or value)		-- pass the value in case "subdomain" is nil
					else
						if OnNoMatch then
							OnNoMatch()
						end
					end
				end
			end
		end
		doneSets[list.set] = true
	end
	
	filters:ClearSearchedItem()
	return count
end

local allowedQueries, unknownCount

local function OnMatch(domain, subdomain)
	Altoholic.Search:AddResult( {
		id = filters:GetSearchedItemInfo("itemID"),
		iLvl = filters:GetSearchedItemInfo("itemLevel"),
		dropLocation = domain,
		bossName = subdomain,
	} )
end

local function Currency_OnMatch(domain, subdomain)
	Altoholic.Search:AddResult( {
		id = filters:GetSearchedItemInfo("itemID"),
		iLvl = filters:GetSearchedItemInfo("itemLevel"),
		dropLocation = domain,
		bossName = subdomain.."x",
	} )
end

local function OnNoMatch()
--	if FilterByExistence() then return end 	-- if the item exists, do nothing
	if filters:TryFilter("Existence") then return end 	-- if the item exists, do nothing
	unknownCount = unknownCount + 1
	
	if allowedQueries > 0 then
		if Altoholic.Options:Get("SearchAutoQuery") == 1 then		-- if autoquery is enabled
			local itemID = filters:GetSearchedItemInfo("itemID")
			if not addon:IsItemUnsafe(itemID) then		-- if the item is not known to be unsafe
				GameTooltip:SetHyperlink("item:"..itemID..":0:0:0:0:0:0:0")	-- this line queries the server for an unknown id
				GameTooltip:ClearLines(); -- don't leave residual info in the tooltip after the server query

				-- save ALL tested id's, clean the list in OnEnable during the next session.
				-- the unsafe list will be cleaned in OnEnable, by parsing all ids and testing if getiteminfo returns a nil or not, if so, it's a definite unsafe link
				addon:SaveUnsafeItem(itemID)			-- save id to unsafe list
			end
		end
		allowedQueries = allowedQueries - 1
	end
end

function ns:Find()
	unknownCount = 0
	allowedQueries = 5
	local count = ParseAltoholicLoots(OnMatch, OnNoMatch)
	count = count + ParseLPTSet("InstanceLoot", OnMatch, OnNoMatch)
	count = count + ParseLPTSet("InstanceLootHeroic", OnMatch, OnNoMatch)
	count = count + ParseLPTSet("CurrencyItems", Currency_OnMatch, OnNoMatch)

	addon.Options:Set("TotalLoots", count)
	addon.Options:Set("UnknownLoots", unknownCount)
end

function ns:FindUpgrade()
	local function OnMatch(domain, subdomain)
		addon.Search:AddResult( {
			id = filters:GetSearchedItemInfo("itemID"),
			iLvl = filters:GetSearchedItemInfo("itemLevel"),
			dropLocation = domain,
			bossName = subdomain,
		} )
	end
	
	ParseAltoholicLoots(OnMatch)
	ParseLPTSet("InstanceLoot", OnMatch)
	ParseLPTSet("InstanceLootHeroic", OnMatch)
	ParseLPTSet("CurrencyItems", Currency_OnMatch)
end

local tooltipLines			-- cache containing the text lines of the tooltip "+15 stamina, etc.."
local rawItemStats			-- contains the raw stats of the item currently being searched, placed here to avoid creating/deleting the table during the search
local currentItemStats		-- contains the stats of the item for which we'll try to find upgrades

local classExcludedStats
local classBaseStats

local function AddCurrentlyEquippedItem(itemID, class)

	AltoTooltip:SetOwner(AltoholicFrame, "ANCHOR_LEFT")
	local _, itemLink, _, itemLevel = GetItemInfo(itemID)
	AltoTooltip:SetHyperlink(itemLink)
	
	local statLine = addon.Equipment.FormatStats[class]
	local numLines = AltoTooltip:NumLines()
	
	local j=1
	for _, BaseStat in pairs(classBaseStats) do
		for i = 4, numLines do
			local tooltipText = _G[ "AltoTooltipTextLeft" .. i]:GetText()
			if tooltipText then
				if string.find(tooltipText, BaseStat) ~= nil then
					currentItemStats[BaseStat] = tonumber(string.sub(tooltipText, string.find(tooltipText, "%d+")))
					statLine = string.gsub(statLine, "-s", WHITE .. currentItemStats[BaseStat], 1)
					
					rawItemStats[j] = currentItemStats[BaseStat] .. "|0"
					break
				end
			end
		end
		if not currentItemStats[BaseStat] then
			rawItemStats[j] = "0|0"
		
			currentItemStats[BaseStat] = 0 -- Set the current stat to zero if it was not found on the item
			statLine = string.gsub(statLine, "-s", WHITE .. "0", 1)
		end
		j = j + 1
	end
	AltoTooltip:ClearLines();
	
	-- Save currently equipped item to the results table
	addon.Search:AddResult( {
		id = itemID,
		iLvl = itemLevel,
		dropLocation = "Currently equipped",
		stat1 = rawItemStats[1],
		stat2 = rawItemStats[2],
		stat3 = rawItemStats[3],
		stat4 = rawItemStats[4],
		stat5 = rawItemStats[5],
		stat6 = rawItemStats[6]
	} )
end

local function MatchUpgradeByStats(itemID)
	filters:SetSearchedItem(itemID)
	if not filters:ItemPassesFilters() then 
		filters:ClearSearchedItem()
		return
	end

	AltoTooltip:ClearLines();	
	AltoTooltip:SetOwner(AltoholicFrame, "ANCHOR_LEFT");
	AltoTooltip:SetHyperlink(filters:GetSearchedItemInfo("itemLink"))
	
	-- save some time by trying to find out if the item could be excluded
	wipe(tooltipLines)
	for i = 4, AltoTooltip:NumLines() do	-- parse all tooltip lines, one by one, start at 4 since 1= item name, 2 = binds on.., 3 = type/slot/unique ..etc
		-- in this first pass, save the lines into a cache, reused below
		local tooltipLine = _G[ "AltoTooltipTextLeft" .. i]:GetText()
		if tooltipLine then
			if string.find(tooltipLine, L["Socket"]) == nil then
				for _, v in pairs(classExcludedStats) do
					--if string.find(tooltipLine, v, 1, true) ~= nil then return end
					if string.find(tooltipLine, v) ~= nil then return end
				end
				tooltipLines[i] = tooltipLine
			end
		end
	end
	
	local statFound
	local j=1
	for _, BaseStat in pairs(classBaseStats) do

		statFound = nil
		for i, tooltipText in pairs(tooltipLines) do
			--if string.find(tooltipText, BaseStat, 1, true) ~= nil then
			if string.find(tooltipText, BaseStat) ~= nil then
				--local stat = tonumber(string.sub(tooltipText, string.find(tooltipText, "%d+")))
				local stat = tonumber(string.match(tooltipText, "%d+"))
				
				rawItemStats[j] = stat .. "|" .. (stat - currentItemStats[BaseStat])
				table.remove(tooltipLines, i)	-- remove the current entry, so it won't be parsed in the next loop cycle
				statFound = true
				break
			end
		end
		
		if not statFound then
			rawItemStats[j] = "0|" .. (0 - currentItemStats[BaseStat])
		end
		j = j + 1
	end
	
	local iLvl = filters:GetSearchedItemInfo("itemLevel")
	filters:ClearSearchedItem()
		
	-- All conditions ok ? save it
	return true, iLvl
end

-- modify this one after 3.2, to use GetItemStats
function ns:FindUpgradeByStats(currentID, class)
	classExcludedStats = addon.Equipment.ExcludeStats[class]
	classBaseStats = addon.Equipment.BaseStats[class]
	
	rawItemStats = {}
	currentItemStats = {}
	tooltipLines = {}
	
	AddCurrentlyEquippedItem(currentID, class)
	
	for Instance, BossList in pairs(lootTable) do		-- parse the loot table to find an upgrade
		for Boss, LootList in pairs(BossList) do
			for _, itemID in pairs(LootList) do
			
				local matches, itemLevel = MatchUpgradeByStats(itemID)
				
				if matches then
					addon.Search:AddResult( {
						id = itemID,
						iLvl = itemLevel,
						dropLocation = Instance .. ", " .. GREEN .. Boss,
						stat1 = rawItemStats[1],
						stat2 = rawItemStats[2],
						stat3 = rawItemStats[3],
						stat4 = rawItemStats[4],
						stat5 = rawItemStats[5],
						stat6 = rawItemStats[6]
					} )
				end
			end
		end
	end
	
	classExcludedStats = nil
	classBaseStats = nil
	currentItemStats = nil
	tooltipLines = nil
	rawItemStats = nil
end
