local folder, core = ...
local Debug = core.Debug

local EnemyDetect = core:NewModule("EnemyDetect", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale(folder, true)

local LSM = LibStub("LibSharedMedia-3.0", true)
if not LSM then
	return
end

EnemyDetect.name = L["Enemy Detected"]
EnemyDetect.desc = L["When a Enemy is detected in combatlog. (non-BG/city only)"]


--~ local regEvents = {
--~ 	"COMBAT_LOG_EVENT_UNFILTERED",
--~ }


function EnemyDetect:OnInitialize()
--~ 	Debug("EnemyDetect", "OnInitialize")	
	
	self.db = core.db:RegisterNamespace("EnemyDetect", {
		profile = {
			enabled = true,
			sound = "ATT alert",
		},
	})
	
	if not self.db.profile.enabled then
		self:SetEnabledState(false)
	end
end

function EnemyDetect:OnEnable()
--~ 	Debug("EnemyDetect", "OnEnable")

	self:RegisterEvent("ZONE_CHANGED","ZoneChanged")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA","ZoneChanged")
	self:RegisterEvent("ZONE_CHANGED_INDOORS","ZoneChanged")
	self:ZoneChanged("Enable")
end

do
	local ENABLE = ENABLE
	function EnemyDetect:GetOptions()
		return {
			name = self.name,
			type = "group",
			
			get = function(info)
				local key = info[#info]
				return self.db.profile[key]
			end,
			set = function(info, v)
				local key = info[#info]
				self.db.profile[key] = v
			end,
			
			args = {
				Desc = {
					type = "description",
					name = self.desc,
					order = 1,
				},
		
				enabled = {
					type = "toggle",	order	= 10,
					name	= ENABLE,
					desc	= L["Enables / Disables the module."],
					set = function(info, v)
						self.db.profile.enabled = v 
						
						if v == true then
							self:Enable()
						else
							self:Disable()
						end
					end,
					
				},
				
				sound = {
				 type = 'select',	 order	= 11,
				
					dialogControl = 'LSM30_Sound', --Select your widget here
					values = LSM:HashTable('sound'), -- pull in your font list from LSM
					  
					name = L["Sound"],
					desc = L["Sound to play"],
				},
				
				
			}
		}
	end
end

do
	local tonumber = tonumber
	local GetBuildInfo = GetBuildInfo
	local select = select
	local eventVars = 10
	local four_two = false
	if tonumber((select(4, GetBuildInfo()))) >= 40200 then
		eventVars = 12
		four_two = true
	end
	local timestamp, eventType, hideCaster, srcGUID, srcName, srcFlags, srcFlags2, dstGUID, dstName, dstFlags, dstFlags2
	function EnemyDetect:COMBAT_LOG_EVENT_UNFILTERED(event, ...)
	
		if four_two == true then
			timestamp, eventType, hideCaster, srcGUID, srcName, srcFlags, srcFlags2, dstGUID, dstName, dstFlags, dstFlags2 = ...
		else
			timestamp, eventType, hideCaster, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags  = ...-- ***
		end
		
		if (self:FlagIsPlayer(srcFlags) and self:FlagIsEnemy(srcFlags)) then
			core:ToggleGame(self.name.." ("..srcName..")", LSM:Fetch('sound', self.db.profile.sound) )
		elseif (self:FlagIsPlayer(dstFlags) and self:FlagIsEnemy(dstFlags)) then
			core:ToggleGame(self.name.." ("..dstName..")", LSM:Fetch('sound', self.db.profile.sound) )
		end
	end
end

do
	local IsInInstance = IsInInstance
	local iActive, iType
	function EnemyDetect:InBattleground()
		iActive, iType = IsInInstance()
		if iActive and iType == "pvp" then
			--We're in a battlefield.
			return true
		end
		return false
	end
end

do
	local bit_band = bit.band
	local COMBATLOG_OBJECT_REACTION_HOSTILE = COMBATLOG_OBJECT_REACTION_HOSTILE
	
	function EnemyDetect:FlagIsEnemy(flags)
		if bit_band(flags, COMBATLOG_OBJECT_REACTION_HOSTILE) == COMBATLOG_OBJECT_REACTION_HOSTILE then
			return true
		end
		return nil
	end
end

do
	local bit_band = bit.band
	local COMBATLOG_OBJECT_TYPE_PLAYER = COMBATLOG_OBJECT_TYPE_PLAYER
	function EnemyDetect:FlagIsPlayer(flags)
		if bit_band(flags, COMBATLOG_OBJECT_TYPE_PLAYER) == COMBATLOG_OBJECT_TYPE_PLAYER then
			return true
		end
		return nil
	end
end

do
	local GetZonePVPInfo = GetZonePVPInfo
	local pvpType, isSubZonePVP, factionName
	function EnemyDetect:ZoneChanged(event, ...)
		self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
		
	--~ 	Debug("EnemyDetect", "ZoneChanged", event, self:InBattleground(), GetZonePVPInfo())
		if self:InBattleground() then
			return
		end
		pvpType, isSubZonePVP, factionName = GetZonePVPInfo()
		if pvpType == "sanctuary" then --Dalaran, Shat, ect
			return
		end
		
		self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	end
end