local folder, core = ...
local Debug = core.Debug
local LibStub = LibStub
local echo = core.echo

local Mailbox = core:NewModule("Mailbox", "AceTimer-3.0", "AceHook-3.0") --, "AceEvent-3.0", "AceHook-3.0"
local L = LibStub("AceLocale-3.0"):GetLocale(folder, true)


local LSM = LibStub("LibSharedMedia-3.0", true)
if not LSM then
	return
end

Mailbox.name = L["Mailbox"]
Mailbox.desc = L["Toggle on mailbox events."]


--~ local regEvents = {
--~ }
	local loginWindowMode
do
	local GetCVar = GetCVar
	function Mailbox:OnInitialize()
	--~ 	Debug("Mailbox", "OnInitialize", IsAddOnLoaded(addonName))	
		
		self.db = core.db:RegisterNamespace("Mailbox", {
			profile = {
				enabled = true,
				sound = "ATT alert",
				toggleDelay = 3,
				finshedLooting = true,
				
			},
		})
		
		if not self.db.profile.enabled then
			self:SetEnabledState(false)
		end
	
		loginWindowMode = GetCVar("gxWindow")
	end
end

do
	local GetCVar = GetCVar
	function Mailbox:OnEnable()
		if loginWindowMode ~= GetCVar("gxWindow") then
			if GetCVar("gxWindow") == "0" then
				echo(L.moduleCannotFunctionInFullscreen:format(self.name))
			end
			loginWindowMode = GetCVar("gxWindow")
		end
	
	
		if GetCVar("gxWindow") == "1" then
			if self.db.profile.finshedLooting == true then
				self:SecureHook("TakeInboxMoney")
				self:SecureHook("AutoLootMailItem")
				self:SecureHook("TakeInboxItem")
			end
		end
		
		--Redo the options incase the window mode has changed.
		LibStub("AceConfig-3.0"):RegisterOptionsTable(core.title..self.name, self:GetOptions())
	end
end

do 
	local GetCVar = GetCVar
	local pairs = pairs
	local ENABLE = ENABLE
	function Mailbox:GetOptions()
		local opts = {
			name = self.name,
			type = "group",
			get = function(info)
				local key = info[#info]
				return self.db.profile[key]
			end,
			set = function(info, v)
				local key = info[#info]
				self.db.profile[key] = v
			end,
			args = {
				Desc = {
					type = "description",
					name = self.desc,
					order = 3,
				},
				enabled = {
					type = "toggle",	order	= 10,
					name	= ENABLE,
					desc	= L["Enables / Disables the module."],
					set = function(info, v)
						self.db.profile.enabled = v 
						if v == true then
							self:Enable()
						else
							self:Disable()
						end
					end,
					
				},
				sound = {
					type = 'select',	 order	= 11,
					dialogControl = 'LSM30_Sound', --Select your widget here
					values = LSM:HashTable('sound'), -- pull in your font list from LSM
					name = L["Sound"],
					desc = L["Sound to play"],
				},
				
				finshedLooting = {
					type = "toggle",	order	= 12,
					name	= L["Finished Looting"],
					desc	= L["Toggle when you're finished looting mail."],
					set = function(info, v)
						self.db.profile[ info[#info] ] = v
						self:Disable()
						self:Enable()
					end,
				},
				
				
				toggleDelay = {
					type = "range",	order	= 20,
					name	= L["Toggle delay"],
					desc	= L["Wait * seconds to make sure you're finished / complete."].."\n"..L["Slower PCs may need a longer delay."],
					min 	= 1,
					max 	= 10,
					step	= 1,
				},
				
			}
		}
		
		if GetCVar("gxWindow") == "0" then 
			opts.args.windowMode = {
				type = "description",
				name = "|cffff0000 *** "..L.windowModeOnly.." *** |r",
				order = 1,
			}
			
			for name, opt in pairs(opts.args) do 
				opt.disabled = true
			end
		end
		return opts
	end
end

local timerHandler = false

function Mailbox:OpenedMail()
	self:CancelTimer(timerHandler, true)
	timerHandler = self:ScheduleTimer("timerHandler", self.db.profile.toggleDelay, L["Mailbox"]..": "..L["Finished Looting"])
end

function Mailbox:TakeInboxMoney(...)
	self:OpenedMail()
end

function Mailbox:AutoLootMailItem(...)
	self:OpenedMail()
end

function Mailbox:TakeInboxItem(...)
	self:OpenedMail()
end

function Mailbox:timerHandler(what)
	core:ToggleGame(what, LSM:Fetch('sound', self.db.profile.sound) )
end