local folder, core = ...
local print = print

local L = LibStub("AceLocale-3.0"):GetLocale(folder, true)

core.defaultSettings.profile = {
	testOpt = true,
	ignoreWhenDND = true,
	soundOnly = true,
	disableAfterToggle = true,
	altTabDetection = true,
	AFKActivate = false,
	activateOnLogin = false,
}
	
----------------
--     UI     --
----------------
core.CoreOptionsTable = {
	name = core.titleFull,
	type = "group",
	childGroups = "tab",

	args = {
		core={
			name = GAMEOPTIONS_MENU,
			type = "group",
			order = 1,
			
			get = function(info)
				local key = info[#info]
				return core.db.profile[key]
			end,
			set = function(info, v)
				local key = info[#info] 
				core.db.profile[key] = v
			end,
			
			args={
				enable = {
					type = "toggle",	order	= 1,
					name	= L["Active"],
					desc	= L["Activate the addon"],
--~ 					set = function(info,val) 
--~ 						if val == true then
--~ 							core:Enable()
--~ 							print("Alt-Tab Toggle: |cff00ff00"..L["Activated"].."|r")
--~ 						else
--~ 							core:Disable()
--~ 							print("Alt-Tab Toggle: |cffff0000"..L["Deactivated"].."|r")
--~ 						end
--~ 					end,
--~ 					get = function(info) return core:IsEnabled() end
					
					
					set = function(info,val) 
						core.active = val
						if val == true then
							print("Alt-Tab Toggle: |cff00ff00"..L["Activated"].."|r")
						else
							print("Alt-Tab Toggle: |cffff0000"..L["Deactivated"].."|r")
						end
					end,
					get = function(info) return core.active end
					
				},

--~ 				testOpt = {
--~ 					type = "toggle",	order	= 2,
--~ 					name	= "testing!",
--~ 					desc	= "blaw blaw",
--~ 				},
				
				ignoreWhenDND = {
					type = "toggle",	order	= 3,
					name	= L["Ignore when DND"],
					desc	= L["Ignore events when you're Do Not Disturb (/DND)"],
				},

				
				soundOnly = {
					type = "toggle",	order	= 4,
					name	= L["Sound Only"],
					desc	= L["Only play sound on toggle event, don't force WoW to foreground."],
				},
				
				disableAfterToggle = {
					type = "toggle",	order	= 5,
					name	= L["Deactivate after toggle"],
					desc	= L["Deactivate ATT once the game is toggled."],
				},
				
				altTabDetection = {
					type = "toggle",	order	= 6,
					name	= L["Alt Tab Detection"],
					desc	=	L["Toggle game if ATT thinks you're alt tabbed."].."\n"..
								L["This is more of a guess that you've gone alt-tabbed. It's not 100% accurate."],
								
					set = function(info, v)
						core.db.profile.altTabDetection = v
						core:StartAltTabDetection()
					end,
				},
				
				AFKActivate = {
					type = "toggle",	order	= 7,
					name	= L["AFK Activate"],
					desc	= L["Activate when you go away from the keyboard (/afk), Dectivate then you're no longer afk."],
				},
				activateOnLogin = {
					type = "toggle",	order	= 8,
					name	= L["Activate on login"],
					desc	= L["Activate ATT when you login."],
				},
				
			
			}
		},
--~ 		sounds={
--~ 			name = "Sounds", --locale
--~ 			type = "group",
--~ 			order = 2,
--~ 			args={}
--~ 		},
		
	},
	
	
	
}

do
	local tostring = tostring
	local GetAddOnMetadata = GetAddOnMetadata
	local pairs = pairs
	local LibStub = LibStub
	
	function core:BuildAboutMenu()
		local options = core.CoreOptionsTable
		
		options.args.about = {
			type = "group",
			name = L.about,
			order = 99,
			args = {
			}
		}
		
		local fields = {"Author", "X-Category", "X-License", "X-Email", "Email", "eMail", "X-Website", "X-Credits", "X-Localizations", "X-Donate", "X-Bitcoin"}
		local haseditbox = {["X-Website"] = true, ["X-Email"] = true, ["X-Donate"] = true, ["Email"] = true, ["eMail"] = true, ["X-Bitcoin"] = true}
	
		local fNames = {
			["Author"] = L.author,
			["X-License"] = L.license,
			["X-Website"] = L.website,
			["X-Donate"] = L.donate,
			["X-Email"] = L.email,
			["X-Bitcoin"] = L.bitcoinAddress,
		}
		local yellow = "|cffffd100%s|r"
		
		
		
		options.args.about.args.title = {
			type = "description",
			name = yellow:format(L.title..": ")..core.title,
			order = 1,
		}
		options.args.about.args.version = {
			type = "description",
			name = yellow:format(L.version..": ")..core.version,
			order = 2,
		}
		options.args.about.args.notes = {
			type = "description",
			name = yellow:format(L.notes..": ")..tostring(GetAddOnMetadata(folder, "Notes")),
			order = 3,
		}
	
		for i,field in pairs(fields) do
			local val = GetAddOnMetadata(folder, field)
			if val then
				
				if haseditbox[field] then
					options.args.about.args[field] = {
						type = "input",
						name = fNames[field] or field,
						order = i+10,
						desc = L.clickCopy,
						width = "full",
						get = function(info)
							local key = info[#info]
							return GetAddOnMetadata(folder, key)
						end,	
					}
				else
					options.args.about.args[field] = {
						type = "description",
						name = yellow:format((fNames[field] or field)..": ")..val,
						width = "full",
						order = i+10,
					}
				end
		
			end
		end
	
		LibStub("AceConfig-3.0"):RegisterOptionsTable(core.title, options ) --
	end
end