--[[
	This might not be needed. _NPCScan seems to already play a sound and enable sounds when it detects. ATT isn't really helping. =/ 
	I may remove this module later.
]]
local folder, core = ...

local LibStub = LibStub
local Debug = core.Debug
local echo = core.echo

local NPCScan = core:NewModule("NPCScan", "AceHook-3.0") --"AceEvent-3.0", 
local L = LibStub("AceLocale-3.0"):GetLocale(folder, true)

local LSM = LibStub("LibSharedMedia-3.0", true)
if not LSM then
	return
end

NPCScan.name = L["NPC Scan"]
NPCScan.desc = L["Toggle when NPC scan has found a creature."]

local regEvents = {
--~ 	"",
}

local loginWindowMode
do
	local GetCVar = GetCVar
	function NPCScan:OnInitialize()
	--~ 	Debug("NPCScan", "OnInitialize")	
		
		self.db = core.db:RegisterNamespace("NPCScan", {
			profile = {
				enabled = true,
				sound = "ATT alert",
			},
		})
		
		if not self.db.profile.enabled then
			self:SetEnabledState(false)
		end
		
		loginWindowMode = GetCVar("gxWindow")
	end
end

do
	local IsAddOnLoaded = IsAddOnLoaded
	local GetCVar = GetCVar
	local _G = _G
	function NPCScan:OnEnable()
	--~ 	Debug("NPCScan", "OnEnable")
	
		if loginWindowMode ~= GetCVar("gxWindow") then
			if GetCVar("gxWindow") == "0" then
				echo(L.moduleCannotFunctionInFullscreen:format(self.name))
			end
			loginWindowMode = GetCVar("gxWindow")
		end
		
		if IsAddOnLoaded("_NPCScan") and GetCVar("gxWindow") == "1" then
			self:SecureHook(_G._NPCScan.Button, "SetNPC", "SetNPC")
		end
		
		LibStub("AceConfig-3.0"):RegisterOptionsTable(core.title..self.name, self:GetOptions())
	end
end

do
	local ENABLE = ENABLE
	local GetCVar = GetCVar
	local pairs = pairs
	function NPCScan:GetOptions()
		local opts = {
			name = self.name,
			type = "group",
			get = function(info)
				local key = info[#info]
				return self.db.profile[key]
			end,
			set = function(info, v)
				local key = info[#info]
				self.db.profile[key] = v
			end,
			args = {
				Desc = {
					type = "description",
					name = self.desc,
					order = 3,
				},
				enabled = {
					type = "toggle",	order	= 10,
					name	= ENABLE,
					desc	= L["Enables / Disables the module."],
					set = function(info, v)
						self.db.profile.enabled = v 
						if v == true then
							self:Enable()
						else
							self:Disable()
						end
					end,
					
				},
				sound = {
					type = 'select',	 order	= 11,
					dialogControl = 'LSM30_Sound', --Select your widget here
					values = LSM:HashTable('sound'), -- pull in your font list from LSM
					name = L["Sound"],
					desc = L["Sound to play"],
				},
				bsDesc = {
					type = "description",
					name = L["_NPCScan is a addon by saiket which detects rare creatures."],
					order = 12,
				},
			}
		}
		
		if GetCVar("gxWindow") == "0" then 
			opts.args.windowMode = {
				type = "description",
				name = "|cffff0000 *** "..L.windowModeOnly.." *** |r",
				order = 1,
			}
			
			for name, opt in pairs(opts.args) do 
				opt.disabled = true
			end
		end
		return opts
	end
end

function NPCScan:SetNPC( ID, Name )
--~ 	Debug("SetNPC", ID, Name)
	core:ToggleGame(self.name, LSM:Fetch('sound', self.db.profile.sound) )
end
