local Aloft = Aloft
if not Aloft then return end
local AloftModules = AloftModules
if not AloftModules then return end

-----------------------------------------------------------------------------

local dL = { }

local oL = { }

local oT = { }

local mL = AloftLocale.AloftModules

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftVisibility", function()

-----------------------------------------------------------------------------

-- TODO: on the surface, this wastes space in the enUS locale; the metatable could just return the canonical string as the localization;
--       BUT, this serves as a default locale, and also will permit the metatable to check/notify on missing locale strings

--[[ enUS ]] dL["Critter"] = "Critter"

-----------------------------------------------------------------------------

--[[ enUS ]] oL["Visibility"] = "Visibility"
--[[ enUS ]] oL["Extra visibility options"] = "Extra visibility options"

--[[ enUS ]] oL["Show Hostile Players"] = "Show Hostile Players"
--[[ enUS ]] oL["Shows nameplates for hostile players"] = "Shows nameplates for hostile players"
--[[ enUS ]] oL["Show Hostile Pets"] = "Show Hostile Pets"
--[[ enUS ]] oL["Shows nameplates for hostile pets"] = "Shows nameplates for hostile pets"
--[[ enUS ]] oL["Show Hostile NPCs"] = "Show Hostile NPCs"
--[[ enUS ]] oL["Show hostile NPCs"] = "Show hostile NPCs"

--[[ enUS ]] oL["Friendly Players"] = "Friendly Players"
--[[ enUS ]] oL["Selects which friendly players to show"] = "Selects which friendly players to show"
--[[ enUS ]] oL["Show Pet"] = "Show Pet"
--[[ enUS ]] oL["Shows nameplates for your pets"] = "Shows nameplates for your pets"
--[[ enUS ]] oL["Show Group Pets"] = "Show Group Pets"
--[[ enUS ]] oL["Shows nameplates for group pets"] = "Shows nameplates for group pets"
--[[ enUS ]] oL["Show Friendly Pets"] = "Show Friendly Pets"
--[[ enUS ]] oL["Shows nameplates for friendly pets"] = "Shows nameplates for friendly pets"
--[[ enUS ]] oL["Show Friendly NPCs"] = "Show Friendly NPCs"
--[[ enUS ]] oL["Show friendly NPCs"] = "Show friendly NPCs"

--[[ enUS ]] oL["Critters"] = "Critters"
--[[ enUS ]] oL["Visibility options for critters"] = "Visibility options for critters"
--[[ enUS ]] oL["Critter Level"] = "Critter Level"
--[[ enUS ]] oL["Assume neutral units below this level are 'critters'"] = "Assume neutral units below this level are 'critters'"
--[[ enUS ]] oL["Critter Health"] = "Critter Health"
--[[ enUS ]] oL["Assume neutral units below this health are 'critters'"] = "Assume neutral units below this health are 'critters'"
--[[ enUS ]] oL["Show Critters"] = "Show Critters"
--[[ enUS ]] oL["Shows nameplates for critters"] = "Shows nameplates for critters"

--[[ enUS ]] oL["Show Neutral Units"] = "Show Neutral Units"
--[[ enUS ]] oL["Show neutral units"] = "Show neutral units"

--[[ enUS ]] oL["Enable"] = "Enable"
--[[ enUS ]] oL["Exceptions"] = "Exceptions"
--[[ enUS ]] oL["Enable Tremor Totem"] = "Enable Tremor Totem"
--[[ enUS ]] oL["Dedicated Tremor Totem Color"] = "Dedicated Tremor Totem Color"
--[[ enUS ]] oL["Enable Grounding Totem"] = "Enable Grounding Totem"
--[[ enUS ]] oL["Dedicated Grounding Totem Color"] = "Dedicated Grounding Totem Color"
--[[ enUS ]] oL["Enable Earthbind Totem"] = "Enable Earthbind Totem"
--[[ enUS ]] oL["Dedicated Earthbind Totem Color"] = "Dedicated Earthbind Totem Color"
--[[ enUS ]] oL["Enable Cleansing Totem"] = "Enable Cleansing Totem"
--[[ enUS ]] oL["Dedicated Cleansing Totem Color"] = "Dedicated Cleansing Totem Color"
--[[ enUS ]] oL["Enable Mana Tide Totem"] = "Enable Mana Tide Totem"
--[[ enUS ]] oL["Dedicated Mana Tide Totem Color"] = "Dedicated Mana Tide Totem Color"

--[[ enUS ]] oL["Show Hostile Totems/Trap Snakes/Bloodworms"] = "Show Hostile Totems/Trap Snakes/Bloodworms"
--[[ enUS ]] oL["Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"
--[[ enUS ]] oL["Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"
--[[ enUS ]] oL["Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"
--[[ enUS ]] oL["Sets the dedicated color for hostile tremor totem nameplates"] = "Sets the dedicated color for hostile tremor totem nameplates"
--[[ enUS ]] oL["Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"
--[[ enUS ]] oL["Sets the dedicated color for hostile grounding totem nameplates"] = "Sets the dedicated color for hostile grounding totem nameplates"
--[[ enUS ]] oL["Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"
--[[ enUS ]] oL["Sets the dedicated color for hostile earthbind totem nameplates"] = "Sets the dedicated color for hostile earthbind totem nameplates"
--[[ enUS ]] oL["Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"
--[[ enUS ]] oL["Sets the dedicated color for hostile cleansing totem nameplates"] = "Sets the dedicated color for hostile cleansing totem nameplates"
--[[ enUS ]] oL["Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"
--[[ enUS ]] oL["Sets the dedicated color for hostile mana tide totem nameplates"] = "Sets the dedicated color for hostile mana tide totem nameplates"

--[[ enUS ]] oL["Show Friendly Totems/Trap Snakes/Bloodworms"] = "Show Friendly Totems/Trap Snakes/Bloodworms"
--[[ enUS ]] oL["Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"
--[[ enUS ]] oL["Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"
--[[ enUS ]] oL["Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"
--[[ enUS ]] oL["Sets the dedicated color for friendly tremor totem nameplates"] = "Sets the dedicated color for friendly tremor totem nameplates"
--[[ enUS ]] oL["Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"
--[[ enUS ]] oL["Sets the dedicated color for friendly grounding totem nameplates"] = "Sets the dedicated color for friendly grounding totem nameplates"
--[[ enUS ]] oL["Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"
--[[ enUS ]] oL["Sets the dedicated color for friendly earthbind totem nameplates"] = "Sets the dedicated color for friendly earthbind totem nameplates"

--[[ enUS ]] oL["Use Nameplate Alpha In Combat"] = "Use Nameplate Alpha In Combat"
--[[ enUS ]] oL["Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"] = "Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"

--[[ enUS ]] oL["Hide Unit Names"] = "Hide Unit Names"
--[[ enUS ]] oL["Hide nameplates by unit name"] = "Hide nameplates by unit name"
--[[ enUS ]] oL["Hide Unit Name"] = "Hide Unit Name"
--[[ enUS ]] oL["Hide Current Target"] = "Hide Current Target"
--[[ enUS ]] oL["Add current target to list of unit names to hide"] = "Add current target to list of unit names to hide"
--[[ enUS ]] oL["Add given name to list of unit names to hide"] = "Add given name to list of unit names to hide"
--[[ enUS ]] oL["Enter any unit name, then enter <return>"] = "Enter any unit name, then enter <return>"
--[[ enUS ]] oL["Delete Unit Name"] = "Delete Unit Name"
--[[ enUS ]] oL["Select from list of unit names to delete"] = "Select from list of unit names to delete"
--[[ enUS ]] oL["Select a unit name to delete it from the list"] = "Select a unit name to delete it from the list"

--[[ enUS ]] oL["All"] = "All"
--[[ enUS ]] oL["Group Only"] = "Group Only"
--[[ enUS ]] oL["Guild Only"] = "Guild Only"
--[[ enUS ]] oL["None"] = "None"

-----------------------------------------------------------------------------

--[[ enUS ]] oT["Tremor Totem"] = "Tremor Totem"
--[[ enUS ]] oT["Grounding Totem"] = "Grounding Totem"
--[[ enUS ]] oT["Earthbind Totem"] = "Earthbind Totem"
--[[ enUS ]] oT["Cleansing Totem"] = "Cleansing Totem"
--[[ enUS ]] oT["Mana Tide Totem"] = "Mana Tide Totem"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ enUS ]] mL["AloftVisibility"] = "AloftVisibility"
--[[ enUS ]] mL["Control the visibility of various types of nameplates"] = "Control the visibility of various types of nameplates"

-----------------------------------------------------------------------------

local locale = GetLocale()

-----------------------------------------------------------------------------

if (locale == "deDE") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftVisibility", function()

-----------------------------------------------------------------------------

--[[ deDE ]] oT["Tremor Totem"]		= "Totem des Erdstoßes"
--[[ deDE ]] oT["Grounding Totem"]	= "Totem der Erdung"
--[[ deDE ]] oT["Earthbind Totem"]	= "Totem der Erdbindung"
--[[ deDE ]] oT["Cleansing Totem"]	= "Totem der Reinigung"
--[[ deDE ]] oT["Mana Tide Totem"]	= "Totem der Manaflut"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

elseif (locale == "koKR") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftVisibility", function()

-----------------------------------------------------------------------------

--[[ koKR ]] dL["Critter"]	= "동물"

-----------------------------------------------------------------------------

--[[ koKR ]] oL["Visibility"] = "표시"
--[[ koKR ]] oL["Extra visibility options"] = "추가 표시 설정"

--[[ koKR ]] oL["Show Hostile Players"] = "적대적 플레이어 표시"
--[[ koKR ]] oL["Shows nameplates for hostile players"] = "적대적 플레이어의 이름표를 표시합니다."
--[[ koKR ]] oL["Show Hostile Pets"] = "적대적 소환수 표시"
--[[ koKR ]] oL["Shows nameplates for hostile pets"] = "적대적 소환수의 이름표를 표시합니다."
--[[ koKR ]] oL["Show Hostile NPCs"] = "적대적 NPC 표시"
--[[ koKR ]] oL["Show hostile NPCs"] = "적대적 NPC를 표시합니다."

--[[ koKR ]] oL["Friendly Players"] = "우호적 플레이어"
--[[ koKR ]] oL["Selects which friendly players to show"] = "우호적 플레이어의 표시를 선택합니다."
--[[ koKR ]] oL["Show Pet"] = "소환수 표시"
--[[ koKR ]] oL["Shows nameplates for your pets"] = "소환수의 이름표를 표시합니다."
--[[ koKR ]] oL["Show Group Pets"] = "파티 소환수 표시"
--[[ koKR ]] oL["Shows nameplates for group pets"] = "파티 소환수의 이름표를 표시합니다."
--[[ koKR ]] oL["Show Friendly Pets"] = "우호적 소환수 표시"
--[[ koKR ]] oL["Shows nameplates for friendly pets"] = "우호적 소환수의 이름표를 표시합니다."
--[[ koKR ]] oL["Show Friendly NPCs"] = "우호적 NPC 표시"
--[[ koKR ]] oL["Show friendly NPCs"] = "우호적 NPC를 표시합니다."

--[[ koKR ]] oL["Critters"] = "Critters"
--[[ koKR ]] oL["Visibility options for critters"] = "Visibility options for critters"
--[[ koKR ]] oL["Critter Level"] = "Critter Level"
--[[ koKR ]] oL["Assume neutral units below this level are 'critters'"] = "Assume neutral units below this level are 'critters'"
--[[ koKR ]] oL["Critter Health"] = "Critter Health"
--[[ koKR ]] oL["Assume neutral units below this health are 'critters'"] = "Assume neutral units below this health are 'critters'"
--[[ koKR ]] oL["Show Critters"] = "동물 표시"
--[[ koKR ]] oL["Shows nameplates for critters"] = "동물에 대한 이름표를 표시합니다."

--[[ koKR ]] oL["Show Neutral Units"] = "중립적 대상 표시"
--[[ koKR ]] oL["Show neutral units"] = "중립적 대상을 표시합니다."

--[[ koKR ]] oL["Enable"] = "사용"
--[[ koKR ]] oL["Exceptions"] = "Exceptions"
--[[ koKR ]] oL["Enable Tremor Totem"] = "Enable Tremor Totem"
--[[ koKR ]] oL["Dedicated Tremor Totem Color"] = "Dedicated Tremor Totem Color"
--[[ koKR ]] oL["Enable Grounding Totem"] = "Enable Grounding Totem"
--[[ koKR ]] oL["Dedicated Grounding Totem Color"] = "Dedicated Grounding Totem Color"
--[[ koKR ]] oL["Enable Earthbind Totem"] = "Enable Earthbind Totem"
--[[ koKR ]] oL["Dedicated Earthbind Totem Color"] = "Dedicated Earthbind Totem Color"
--[[ koKR ]] oL["Enable Cleansing Totem"] = "Enable Cleansing Totem"
--[[ koKR ]] oL["Dedicated Cleansing Totem Color"] = "Dedicated Cleansing Totem Color"
--[[ koKR ]] oL["Enable Mana Tide Totem"] = "Enable Mana Tide Totem"
--[[ koKR ]] oL["Dedicated Mana Tide Totem Color"] = "Dedicated Mana Tide Totem Color"

--[[ koKR ]] oL["Show Hostile Totems/Trap Snakes/Bloodworms"] = "Show Hostile Totems/Trap Snakes/Bloodworms"
--[[ koKR ]] oL["Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"
--[[ koKR ]] oL["Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"
--[[ koKR ]] oL["Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"
--[[ koKR ]] oL["Sets the dedicated color for hostile tremor totem nameplates"] = "Sets the dedicated color for hostile tremor totem nameplates"
--[[ koKR ]] oL["Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"
--[[ koKR ]] oL["Sets the dedicated color for hostile grounding totem nameplates"] = "Sets the dedicated color for hostile grounding totem nameplates"
--[[ koKR ]] oL["Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"
--[[ koKR ]] oL["Sets the dedicated color for hostile earthbind totem nameplates"] = "Sets the dedicated color for hostile earthbind totem nameplates"
--[[ koKR ]] oL["Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"
--[[ koKR ]] oL["Sets the dedicated color for hostile cleansing totem nameplates"] = "Sets the dedicated color for hostile cleansing totem nameplates"
--[[ koKR ]] oL["Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"
--[[ koKR ]] oL["Sets the dedicated color for hostile mana tide totem nameplates"] = "Sets the dedicated color for hostile mana tide totem nameplates"

--[[ koKR ]] oL["Show Friendly Totems/Trap Snakes/Bloodworms"] = "Show Friendly Totems/Trap Snakes/Bloodworms"
--[[ koKR ]] oL["Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"
--[[ koKR ]] oL["Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"
--[[ koKR ]] oL["Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"
--[[ koKR ]] oL["Sets the dedicated color for friendly tremor totem nameplates"] = "Sets the dedicated color for friendly tremor totem nameplates"
--[[ koKR ]] oL["Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"
--[[ koKR ]] oL["Sets the dedicated color for friendly grounding totem nameplates"] = "Sets the dedicated color for friendly grounding totem nameplates"
--[[ koKR ]] oL["Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"
--[[ koKR ]] oL["Sets the dedicated color for friendly earthbind totem nameplates"] = "Sets the dedicated color for friendly earthbind totem nameplates"

--[[ koKR ]] oL["Use Nameplate Alpha In Combat"] = "Use Nameplate Alpha In Combat"
--[[ koKR ]] oL["Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"] = "Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"

--[[ koKR ]] oL["Hide Unit Names"] = "Hide Unit Names"
--[[ koKR ]] oL["Hide nameplates by unit name"] = "Hide nameplates by unit name"
--[[ koKR ]] oL["Hide Unit Name"] = "Hide Unit Name"
--[[ koKR ]] oL["Hide Current Target"] = "Hide Current Target"
--[[ koKR ]] oL["Add current target to list of unit names to hide"] = "Add current target to list of unit names to hide"
--[[ koKR ]] oL["Add given name to list of unit names to hide"] = "Add given name to list of unit names to hide"
--[[ koKR ]] oL["Enter any unit name, then enter <return>"] = "Enter any unit name, then enter <return>"
--[[ koKR ]] oL["Delete Unit Name"] = "Delete Unit Name"
--[[ koKR ]] oL["Select from list of unit names to delete"] = "Select from list of unit names to delete"
--[[ koKR ]] oL["Select a unit name to delete it from the list"] = "Select a unit name to delete it from the list"

--[[ koKR ]] oL["All"] = "모두"
--[[ koKR ]] oL["Group Only"] = "파티"
--[[ koKR ]] oL["Guild Only"] = "길드"
--[[ koKR ]] oL["None"] = "없음"

-----------------------------------------------------------------------------

-- TODO: need koKR translation for oT

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ koKR ]] mL["AloftVisibility"] = "AloftVisibility"
--[[ koKR ]] mL["Control the visibility of various types of nameplates"] = "Control the visibility of various types of nameplates"

-----------------------------------------------------------------------------

elseif (locale == "ruRU") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftVisibility", function()

-----------------------------------------------------------------------------

--[[ ruRU ]] dL["Critter"] = "Существо"

-----------------------------------------------------------------------------

--[[ ruRU ]] oL["Visibility"] = "Видимость"
--[[ ruRU ]] oL["Extra visibility options"] = "Настройки дополнительной видимости"

--[[ ruRU ]] oL["Show Hostile Players"] = "Отображать враждебных игроков"
--[[ ruRU ]] oL["Shows nameplates for hostile players"] = "Отображает таблички для враждебных игроков"
--[[ ruRU ]] oL["Show Hostile Pets"] = "Отображать враждебных питомцев"
--[[ ruRU ]] oL["Shows nameplates for hostile pets"] = "Отображает таблички для враждебных питомцев"
--[[ ruRU ]] oL["Show Hostile NPCs"] = "Отображать враждебных NPC"
--[[ ruRU ]] oL["Show hostile NPCs"] = "Отображать враждебных NPC"

--[[ ruRU ]] oL["Friendly Players"] = "Дружественные игроки"
--[[ ruRU ]] oL["Selects which friendly players to show"] = "Выбирает, как отображать дружественных игроков"
--[[ ruRU ]] oL["Show Pet"] = "Отображать питомца"
--[[ ruRU ]] oL["Shows nameplates for your pets"] = "Отображает таблички для питомцев"
--[[ ruRU ]] oL["Show Group Pets"] = "Отображать питомцев группы"
--[[ ruRU ]] oL["Shows nameplates for group pets"] = "Отображает таблички для питомцев группы"
--[[ ruRU ]] oL["Show Friendly Pets"] = "Отображать дружественных питомцев"
--[[ ruRU ]] oL["Shows nameplates for friendly pets"] = "Отображает таблички для дружественных питомцев"
--[[ ruRU ]] oL["Show Friendly NPCs"] = "Отображать дружественных NPC"
--[[ ruRU ]] oL["Show friendly NPCs"] = "Отображать дружественных NPC"

--[[ ruRU ]] oL["Critters"] = "Существо"
--[[ ruRU ]] oL["Visibility options for critters"] = "Настройки вида для существ"
--[[ ruRU ]] oL["Critter Level"] = "Уровень существа"
--[[ ruRU ]] oL["Assume neutral units below this level are 'critters'"] = "Нейтральный объект ниже этого уровня предпологаемо будет - 'существо'"
--[[ ruRU ]] oL["Critter Health"] = "Здоровье спутника"
--[[ ruRU ]] oL["Assume neutral units below this health are 'critters'"] = "Нейтральный объект ниже этого уровня здаровья предпологаемо будет 'существо'"
--[[ ruRU ]] oL["Show Critters"] = "Отображать существа"
--[[ ruRU ]] oL["Shows nameplates for critters"] = "Отображает таблички для существ"

--[[ ruRU ]] oL["Show Neutral Units"] = "Отображать нейтральных"
--[[ ruRU ]] oL["Show neutral units"] = "Отображать нейтральных"

--[[ ruRU ]] oL["Enable"] = "Включить"
--[[ ruRU ]] oL["Exceptions"] = "Исключения"
--[[ ruRU ]] oL["Enable Tremor Totem"] = "Включить Тотем трепета"
--[[ ruRU ]] oL["Dedicated Tremor Totem Color"] = "Цвет выделения Тотема трепета"
--[[ ruRU ]] oL["Enable Grounding Totem"] = "Включить Тотем заземления"
--[[ ruRU ]] oL["Dedicated Grounding Totem Color"] = "Цвет выделения Тотема заземления"
--[[ ruRU ]] oL["Enable Earthbind Totem"] = "Включить Тотем оков земли"
--[[ ruRU ]] oL["Dedicated Earthbind Totem Color"] = "Цвет выделения Тотема оков земли"
--[[ ruRU ]] oL["Enable Cleansing Totem"] = "Enable Cleansing Totem"
--[[ ruRU ]] oL["Dedicated Cleansing Totem Color"] = "Dedicated Cleansing Totem Color"
--[[ ruRU ]] oL["Enable Mana Tide Totem"] = "Enable Mana Tide Totem"
--[[ ruRU ]] oL["Dedicated Mana Tide Totem Color"] = "Dedicated Mana Tide Totem Color"

--[[ ruRU ]] oL["Show Hostile Totems/Trap Snakes/Bloodworms"] = "Показывать враждебные тотемы/ловушки/змеи/кровочерви"
--[[ ruRU ]] oL["Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Показывать таблички враждебных тотемов/ловушкек/змеи/кровочервей (влияет на таблички только вне боя)"
--[[ ruRU ]] oL["Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Даже если таблички для враждебных тотемов/ловушкек/змеи/кровочервей скрыты, отображать (с цветовым выделением)"
--[[ ruRU ]] oL["Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"] = "Однозначно показывает таблички враждебного тотема трепета (с цветовым выделением)"
--[[ ruRU ]] oL["Sets the dedicated color for hostile tremor totem nameplates"] = "Установка цвета выделения таблички вреждебного тотема трепета"
--[[ ruRU ]] oL["Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"] = "Однозначно показывает таблички враждебного тотема заземления (с цветовым выделением)"
--[[ ruRU ]] oL["Sets the dedicated color for hostile grounding totem nameplates"] = "становка цвета выделения таблички вреждебного тотема заземления"
--[[ ruRU ]] oL["Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"] = "Однозначно показывает таблички враждебного тотема оков земли (с цветовым выделением)"
--[[ ruRU ]] oL["Sets the dedicated color for hostile earthbind totem nameplates"] = "становка цвета выделения таблички вреждебного тотема оков земли"
--[[ ruRU ]] oL["Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"
--[[ ruRU ]] oL["Sets the dedicated color for hostile cleansing totem nameplates"] = "Sets the dedicated color for hostile cleansing totem nameplates"
--[[ ruRU ]] oL["Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"
--[[ ruRU ]] oL["Sets the dedicated color for hostile mana tide totem nameplates"] = "Sets the dedicated color for hostile mana tide totem nameplates"

--[[ ruRU ]] oL["Show Friendly Totems/Trap Snakes/Bloodworms"] = "Показывать дружественные тотемы/ловушки/змеи/кровочерви"
--[[ ruRU ]] oL["Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Показывать таблички дружественных тотемов/ловушкек/змеи/кровочервей (влияет на таблички только вне боя)"
--[[ ruRU ]] oL["Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Даже если таблички для враждебных тотемов/ловушкек/змеи/кровочервей скрыты, отображать (с цветовым выделением)"
--[[ ruRU ]] oL["Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"] = "Однозначно показывает таблички дружественного тотема трепета (с цветовым выделением)"
--[[ ruRU ]] oL["Sets the dedicated color for friendly tremor totem nameplates"] = "Установка цвета выделения таблички дружественного тотема трепета"
--[[ ruRU ]] oL["Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"] = "Однозначно показывает таблички дружественного тотема заземления (с цветовым выделением)"
--[[ ruRU ]] oL["Sets the dedicated color for friendly grounding totem nameplates"] = "Установка цвета выделения таблички дружественного тотема заземления"
--[[ ruRU ]] oL["Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"] = "Однозначно показывает таблички дружественного тотема оков земли (с цветовым выделением)"
--[[ ruRU ]] oL["Sets the dedicated color for friendly earthbind totem nameplates"] = "Установка цвета выделения таблички дружественного eтотема оков земли"

--[[ ruRU ]] oL["Use Nameplate Alpha In Combat"] = "Use Nameplate Alpha In Combat"
--[[ ruRU ]] oL["Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"] = "Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"

--[[ ruRU ]] oL["Hide Unit Names"] = "Hide Unit Names"
--[[ ruRU ]] oL["Hide nameplates by unit name"] = "Hide nameplates by unit name"
--[[ ruRU ]] oL["Hide Unit Name"] = "Hide Unit Name"
--[[ ruRU ]] oL["Hide Current Target"] = "Hide Current Target"
--[[ ruRU ]] oL["Add current target to list of unit names to hide"] = "Add current target to list of unit names to hide"
--[[ ruRU ]] oL["Add given name to list of unit names to hide"] = "Add given name to list of unit names to hide"
--[[ ruRU ]] oL["Enter any unit name, then enter <return>"] = "Enter any unit name, then enter <return>"
--[[ ruRU ]] oL["Delete Unit Name"] = "Delete Unit Name"
--[[ ruRU ]] oL["Select from list of unit names to delete"] = "Select from list of unit names to delete"
--[[ ruRU ]] oL["Select a unit name to delete it from the list"] = "Select a unit name to delete it from the list"

--[[ ruRU ]] oL["All"] = "Все"
--[[ ruRU ]] oL["Group Only"] = "Только группа"
--[[ ruRU ]] oL["Guild Only"] = "Только гильдия"
--[[ ruRU ]] oL["None"] = "Нет"

-----------------------------------------------------------------------------

-- TODO: need ruRU translation for oT

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ ruRU ]] mL["AloftVisibility"] = "AloftVisibility"
--[[ ruRU ]] mL["Control the visibility of various types of nameplates"] = "Различные настройки отображения"

-----------------------------------------------------------------------------

elseif (locale == "zhCN") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftVisibility", function()

-----------------------------------------------------------------------------

--[[ zhCN ]] dL["Critter"]	= "小动目"

-----------------------------------------------------------------------------

--[[ zhCN ]] oL["Visibility"] = "能见度"
--[[ zhCN ]] oL["Extra visibility options"] = "额外能见度相关设置"

--[[ zhCN ]] oL["Show Hostile Players"] = "显示敌对方玩家"
--[[ zhCN ]] oL["Shows nameplates for hostile players"] = "显示敌对方玩家的姓名板"
--[[ zhCN ]] oL["Show Hostile Pets"] = "显示敌对方宠物"
--[[ zhCN ]] oL["Shows nameplates for hostile pets"] = "显示敌对方宠物的姓名板"
--[[ zhCN ]] oL["Show Hostile NPCs"] = "显示敌对方NPC"
--[[ zhCN ]] oL["Show hostile NPCs"] = "显示敌对方NPC的姓名板"

--[[ zhCN ]] oL["Friendly Players"] = "显示友好方玩家"
--[[ zhCN ]] oL["Selects which friendly players to show"] = "选择显示哪些友好方玩家"
--[[ zhCN ]] oL["Show Pet"] = "显示宠物"
--[[ zhCN ]] oL["Shows nameplates for your pets"] = "显示你的宠物的姓名板"
--[[ zhCN ]] oL["Show Group Pets"] = "显示队友宠物"
--[[ zhCN ]] oL["Shows nameplates for group pets"] = "显示队友的宠物的姓名板"
--[[ zhCN ]] oL["Show Friendly Pets"] = "显示友好方宠物"
--[[ zhCN ]] oL["Shows nameplates for friendly pets"] = "显示友好方宠物的姓名板"
--[[ zhCN ]] oL["Show Friendly NPCs"] = "显示友好方NPC"
--[[ zhCN ]] oL["Show friendly NPCs"] = "显示友好方NPC的姓名板"

--[[ zhCN ]] oL["Critters"] = "Critters"
--[[ zhCN ]] oL["Visibility options for critters"] = "Visibility options for critters"
--[[ zhCN ]] oL["Critter Level"] = "Critter Level"
--[[ zhCN ]] oL["Assume neutral units below this level are 'critters'"] = "Assume neutral units below this level are 'critters'"
--[[ zhCN ]] oL["Critter Health"] = "Critter Health"
--[[ zhCN ]] oL["Assume neutral units below this health are 'critters'"] = "Assume neutral units below this health are 'critters'"
--[[ zhCN ]] oL["Show Critters"] = "显示小动物"
--[[ zhCN ]] oL["Shows nameplates for critters"] = "显示小动物的姓名板"

--[[ zhCN ]] oL["Show Neutral Units"] = "显示中立方单位"
--[[ zhCN ]] oL["Show neutral units"] = "显示中立方单位的姓名板"

--[[ zhCN ]] oL["Enable"] = "启用"
--[[ zhCN ]] oL["Exceptions"] = "Exceptions"
--[[ zhCN ]] oL["Enable Tremor Totem"] = "Enable Tremor Totem"
--[[ zhCN ]] oL["Dedicated Tremor Totem Color"] = "Dedicated Tremor Totem Color"
--[[ zhCN ]] oL["Enable Grounding Totem"] = "Enable Grounding Totem"
--[[ zhCN ]] oL["Dedicated Grounding Totem Color"] = "Dedicated Grounding Totem Color"
--[[ zhCN ]] oL["Enable Earthbind Totem"] = "Enable Earthbind Totem"
--[[ zhCN ]] oL["Dedicated Earthbind Totem Color"] = "Dedicated Earthbind Totem Color"
--[[ zhCN ]] oL["Enable Cleansing Totem"] = "Enable Cleansing Totem"
--[[ zhCN ]] oL["Dedicated Cleansing Totem Color"] = "Dedicated Cleansing Totem Color"
--[[ zhCN ]] oL["Enable Mana Tide Totem"] = "Enable Mana Tide Totem"
--[[ zhCN ]] oL["Dedicated Mana Tide Totem Color"] = "Dedicated Mana Tide Totem Color"

--[[ zhCN ]] oL["Show Hostile Totems/Trap Snakes/Bloodworms"] = "Show Hostile Totems/Trap Snakes/Bloodworms"
--[[ zhCN ]] oL["Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"
--[[ zhCN ]] oL["Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"
--[[ zhCN ]] oL["Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"
--[[ zhCN ]] oL["Sets the dedicated color for hostile tremor totem nameplates"] = "Sets the dedicated color for hostile tremor totem nameplates"
--[[ zhCN ]] oL["Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"
--[[ zhCN ]] oL["Sets the dedicated color for hostile grounding totem nameplates"] = "Sets the dedicated color for hostile grounding totem nameplates"
--[[ zhCN ]] oL["Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"
--[[ zhCN ]] oL["Sets the dedicated color for hostile earthbind totem nameplates"] = "Sets the dedicated color for hostile earthbind totem nameplates"
--[[ zhCN ]] oL["Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"
--[[ zhCN ]] oL["Sets the dedicated color for hostile cleansing totem nameplates"] = "Sets the dedicated color for hostile cleansing totem nameplates"
--[[ zhCN ]] oL["Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"
--[[ zhCN ]] oL["Sets the dedicated color for hostile mana tide totem nameplates"] = "Sets the dedicated color for hostile mana tide totem nameplates"

--[[ zhCN ]] oL["Show Friendly Totems/Trap Snakes/Bloodworms"] = "Show Friendly Totems/Trap Snakes/Bloodworms"
--[[ zhCN ]] oL["Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"
--[[ zhCN ]] oL["Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"
--[[ zhCN ]] oL["Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"
--[[ zhCN ]] oL["Sets the dedicated color for friendly tremor totem nameplates"] = "Sets the dedicated color for friendly tremor totem nameplates"
--[[ zhCN ]] oL["Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"
--[[ zhCN ]] oL["Sets the dedicated color for friendly grounding totem nameplates"] = "Sets the dedicated color for friendly grounding totem nameplates"
--[[ zhCN ]] oL["Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"
--[[ zhCN ]] oL["Sets the dedicated color for friendly earthbind totem nameplates"] = "Sets the dedicated color for friendly earthbind totem nameplates"

--[[ zhCN ]] oL["Use Nameplate Alpha In Combat"] = "Use Nameplate Alpha In Combat"
--[[ zhCN ]] oL["Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"] = "Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"

--[[ zhCN ]] oL["Hide Unit Names"] = "Hide Unit Names"
--[[ zhCN ]] oL["Hide nameplates by unit name"] = "Hide nameplates by unit name"
--[[ zhCN ]] oL["Hide Unit Name"] = "Hide Unit Name"
--[[ zhCN ]] oL["Hide Current Target"] = "Hide Current Target"
--[[ zhCN ]] oL["Add current target to list of unit names to hide"] = "Add current target to list of unit names to hide"
--[[ zhCN ]] oL["Add given name to list of unit names to hide"] = "Add given name to list of unit names to hide"
--[[ zhCN ]] oL["Enter any unit name, then enter <return>"] = "Enter any unit name, then enter <return>"
--[[ zhCN ]] oL["Delete Unit Name"] = "Delete Unit Name"
--[[ zhCN ]] oL["Select from list of unit names to delete"] = "Select from list of unit names to delete"
--[[ zhCN ]] oL["Select a unit name to delete it from the list"] = "Select a unit name to delete it from the list"

--[[ zhCN ]] oL["All"] = "全部"
--[[ zhCN ]] oL["Group Only"] = "仅显示队友"
--[[ zhCN ]] oL["Guild Only"] = "仅显示公会成员"
--[[ zhCN ]] oL["None"] = "无"

-----------------------------------------------------------------------------

-- TODO: need zhCN translation for oT

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ zhCN ]] mL["AloftVisibility"] = "可见度"
--[[ zhCN ]] mL["Control the visibility of various types of nameplates"] = "Control the visibility of various types of nameplates"

-----------------------------------------------------------------------------

elseif (locale == "zhTW") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftVisibility", function()

-----------------------------------------------------------------------------

--[[ zhTW ]] dL["Critter"]	= "小動物"

-----------------------------------------------------------------------------

--[[ zhTW ]] oL["Visibility"] = "能見度"
--[[ zhTW ]] oL["Extra visibility options"] = "額外能見度選項"

--[[ zhTW ]] oL["Show Hostile Players"] = "顯示敵對玩家"
--[[ zhTW ]] oL["Shows nameplates for hostile players"] = "顯示敵對玩家的名牌"
--[[ zhTW ]] oL["Show Hostile Pets"] = "顯示敵對寵物"
--[[ zhTW ]] oL["Shows nameplates for hostile pets"] = "顯示敵對寵物的名牌"
--[[ zhTW ]] oL["Show Hostile NPCs"] = "顯示敵對NPC"
--[[ zhTW ]] oL["Show hostile NPCs"] = "顯示敵對NPC的名牌"

--[[ zhTW ]] oL["Friendly Players"] = "顯示友好玩家"
--[[ zhTW ]] oL["Selects which friendly players to show"] = "選擇顯示哪一些友好玩家"
--[[ zhTW ]] oL["Show Pet"] = "顯示寵物"
--[[ zhTW ]] oL["Shows nameplates for your pets"] = "顯示你的寵物的名牌"
--[[ zhTW ]] oL["Show Group Pets"] = "顯示團體寵物"
--[[ zhTW ]] oL["Shows nameplates for group pets"] = "顯示團體寵物的名牌"
--[[ zhTW ]] oL["Show Friendly Pets"] = "顯示友好寵物"
--[[ zhTW ]] oL["Shows nameplates for friendly pets"] = "顯示友好寵物的名牌"
--[[ zhTW ]] oL["Show Friendly NPCs"] = "顯示友好NPC"
--[[ zhTW ]] oL["Show friendly NPCs"] = "顯示友好NPC的名牌"

--[[ zhTW ]] oL["Critters"] = "Critters"
--[[ zhTW ]] oL["Visibility options for critters"] = "Visibility options for critters"
--[[ zhTW ]] oL["Critter Level"] = "Critter Level"
--[[ zhTW ]] oL["Assume neutral units below this level are 'critters'"] = "Assume neutral units below this level are 'critters'"
--[[ zhTW ]] oL["Critter Health"] = "Critter Health"
--[[ zhTW ]] oL["Assume neutral units below this health are 'critters'"] = "Assume neutral units below this health are 'critters'"
--[[ zhTW ]] oL["Show Critters"] = "顯示小動物"
--[[ zhTW ]] oL["Shows nameplates for critters"] = "顯示小動物的名牌"

--[[ zhTW ]] oL["Show Neutral Units"] = "顯示中立單位"
--[[ zhTW ]] oL["Show neutral units"] = "顯示中立單位的名牌"

--[[ zhTW ]] oL["Enable"] = "啟用"
--[[ zhTW ]] oL["Exceptions"] = "Exceptions"
--[[ zhTW ]] oL["Enable Tremor Totem"] = "Enable Tremor Totem"
--[[ zhTW ]] oL["Dedicated Tremor Totem Color"] = "Dedicated Tremor Totem Color"
--[[ zhTW ]] oL["Enable Grounding Totem"] = "Enable Grounding Totem"
--[[ zhTW ]] oL["Dedicated Grounding Totem Color"] = "Dedicated Grounding Totem Color"
--[[ zhTW ]] oL["Enable Earthbind Totem"] = "Enable Earthbind Totem"
--[[ zhTW ]] oL["Dedicated Earthbind Totem Color"] = "Dedicated Earthbind Totem Color"
--[[ zhTW ]] oL["Enable Cleansing Totem"] = "Enable Cleansing Totem"
--[[ zhTW ]] oL["Dedicated Cleansing Totem Color"] = "Dedicated Cleansing Totem Color"
--[[ zhTW ]] oL["Enable Mana Tide Totem"] = "Enable Mana Tide Totem"
--[[ zhTW ]] oL["Dedicated Mana Tide Totem Color"] = "Dedicated Mana Tide Totem Color"

--[[ zhTW ]] oL["Show Hostile Totems/Trap Snakes/Bloodworms"] = "Show Hostile Totems/Trap Snakes/Bloodworms"
--[[ zhTW ]] oL["Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Shows nameplates for hostile totems/trap snakes/bloodworms (only affects nameplates while out of combat)"
--[[ zhTW ]] oL["Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Even if nameplates for hostile totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"
--[[ zhTW ]] oL["Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile tremor totems (with a dedicated color)"
--[[ zhTW ]] oL["Sets the dedicated color for hostile tremor totem nameplates"] = "Sets the dedicated color for hostile tremor totem nameplates"
--[[ zhTW ]] oL["Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile grounding totems (with a dedicated color)"
--[[ zhTW ]] oL["Sets the dedicated color for hostile grounding totem nameplates"] = "Sets the dedicated color for hostile grounding totem nameplates"
--[[ zhTW ]] oL["Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile earthbind totems (with a dedicated color)"
--[[ zhTW ]] oL["Sets the dedicated color for hostile earthbind totem nameplates"] = "Sets the dedicated color for hostile earthbind totem nameplates"
--[[ zhTW ]] oL["Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile cleansing totems (with a dedicated color)"
--[[ zhTW ]] oL["Sets the dedicated color for hostile cleansing totem nameplates"] = "Sets the dedicated color for hostile cleansing totem nameplates"
--[[ zhTW ]] oL["Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"] = "Explicitly shows nameplates for hostile mana tide totems (with a dedicated color)"
--[[ zhTW ]] oL["Sets the dedicated color for hostile mana tide totem nameplates"] = "Sets the dedicated color for hostile mana tide totem nameplates"

--[[ zhTW ]] oL["Show Friendly Totems/Trap Snakes/Bloodworms"] = "Show Friendly Totems/Trap Snakes/Bloodworms"
--[[ zhTW ]] oL["Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"] = "Shows nameplates for friendly totems/trap snakes/bloodworms (only affects nameplates while out of combat)"
--[[ zhTW ]] oL["Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"] = "Even if nameplates for friendly totems/trap snakes/bloodworms are hidden, display these (with a dedicated color)"
--[[ zhTW ]] oL["Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly tremor totems (with a dedicated color)"
--[[ zhTW ]] oL["Sets the dedicated color for friendly tremor totem nameplates"] = "Sets the dedicated color for friendly tremor totem nameplates"
--[[ zhTW ]] oL["Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly grounding totems (with a dedicated color)"
--[[ zhTW ]] oL["Sets the dedicated color for friendly grounding totem nameplates"] = "Sets the dedicated color for friendly grounding totem nameplates"
--[[ zhTW ]] oL["Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"] = "Explicitly shows nameplates for friendly earthbind totems (with a dedicated color)"
--[[ zhTW ]] oL["Sets the dedicated color for friendly earthbind totem nameplates"] = "Sets the dedicated color for friendly earthbind totem nameplates"

--[[ zhTW ]] oL["Use Nameplate Alpha In Combat"] = "Use Nameplate Alpha In Combat"
--[[ zhTW ]] oL["Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"] = "Controls nameplate visibility in combat by setting nameplate alpha to 0 (requires AloftAlpha module to be enabled at UI load, and the nameplate remains mouse-sensitive until combat ends)"

--[[ zhTW ]] oL["Hide Unit Names"] = "Hide Unit Names"
--[[ zhTW ]] oL["Hide nameplates by unit name"] = "Hide nameplates by unit name"
--[[ zhTW ]] oL["Hide Unit Name"] = "Hide Unit Name"
--[[ zhTW ]] oL["Hide Current Target"] = "Hide Current Target"
--[[ zhTW ]] oL["Add current target to list of unit names to hide"] = "Add current target to list of unit names to hide"
--[[ zhTW ]] oL["Add given name to list of unit names to hide"] = "Add given name to list of unit names to hide"
--[[ zhTW ]] oL["Enter any unit name, then enter <return>"] = "Enter any unit name, then enter <return>"
--[[ zhTW ]] oL["Delete Unit Name"] = "Delete Unit Name"
--[[ zhTW ]] oL["Select from list of unit names to delete"] = "Select from list of unit names to delete"
--[[ zhTW ]] oL["Select a unit name to delete it from the list"] = "Select a unit name to delete it from the list"

--[[ zhTW ]] oL["All"] = "全部"
--[[ zhTW ]] oL["Group Only"] = "唯有團體"
--[[ zhTW ]] oL["Guild Only"] = "唯有公會"
--[[ zhTW ]] oL["None"] = "無"

-----------------------------------------------------------------------------

-- TODO: need zhTW translation for oT

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ zhTW ]] mL["AloftVisibility"] = "可見度"
--[[ zhTW ]] mL["Control the visibility of various types of nameplates"] = "Control the visibility of various types of nameplates"

-----------------------------------------------------------------------------

end

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftVisibility", function()

-----------------------------------------------------------------------------

AloftLocale.AloftVisibilityData = setmetatable(dL, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
dL = nil

-----------------------------------------------------------------------------

AloftLocale.AloftVisibilityOptions = setmetatable(oL, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
oL = nil

-----------------------------------------------------------------------------

AloftLocale.AloftVisibilityTotems = setmetatable(oT, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
oT = nil

-----------------------------------------------------------------------------

end)
