local Aloft = Aloft
if not Aloft then return end
local AloftModules = AloftModules
if not AloftModules then return end

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftPlayerTitle", function()

if not Aloft:GetModule("PlayerTitleData", true) then return end
if not AloftLocale or not AloftLocale.AloftPlayerTitleDataOptions then return end

-----------------------------------------------------------------------------

local AloftPlayerTitleData = Aloft:GetModule("PlayerTitleData")

local L = AloftLocale.AloftPlayerTitleDataOptions

-----------------------------------------------------------------------------

Aloft.Options.args.data.args.playerTitle =
{
	type = 'toggle',
	width = 'full',
	name = L["Save Player Title Data"],
	desc = L["Stores player title information between sessions"],
	disabled = function(i) return not Aloft:IsEnabled() or not AloftPlayerTitleData:IsEnabled() or not AloftPlayerTitleData.db or not AloftPlayerTitleData.db.profile end,
	get = function(i) return AloftPlayerTitleData.db.profile.save end,
	set = AloftPlayerTitleData.SetSaveData
}

-----------------------------------------------------------------------------

end)
