local Aloft = Aloft
if not Aloft then return end
local AloftModules = AloftModules
if not AloftModules then return end

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftCastBarTimeText", function()

local AloftCastBar = Aloft:GetModule("CastBar", true)
if not AloftCastBar then return end

-----------------------------------------------------------------------------

local AloftCastBarTimeText = Aloft:NewModule("CastBarTimeText", Aloft, "AceEvent-3.0")
AloftCastBarTimeText.dynamic = "AloftCastBarTimeText"

-----------------------------------------------------------------------------

AloftCastBarTimeText.namespace = "castBarTimeText"
AloftCastBarTimeText.defaults =
{
	profile =
	{
		enable			= true,
		font			= "Arial Narrow",
		fontSize		= 9,
		shadow			= true,
		alignment		= "RIGHT",
		outline			= "",
		offsets =
		{
			left		= 0,
			right		= -5,
			vertical	= 0,
		},
		color			= { 1, 1, 1, 1 },
	},
}

-----------------------------------------------------------------------------

local lastCastTimeValue = 0
local castBarTimeTextRegion

-----------------------------------------------------------------------------

function AloftCastBarTimeText:Update()
	self:CreateFrame()
	self:RegisterEvents()

	if self.db.profile.enable then
		for aloftData in Aloft:IterateVisibleNameplates() do
			self:SetupFrame("AloftCastBarTimeText:Update", aloftData)
		end
	end
end

-----------------------------------------------------------------------------

function AloftCastBarTimeText:CreateFrame()
	if not self.db.profile.enable then
		if castBarTimeTextRegion then
			castBarTimeTextRegion:Hide()
		end
		return
	end

	if not castBarTimeTextRegion then
		castBarTimeTextRegion = UIParent:CreateFontString()
	end

	self:PrepareText(castBarTimeTextRegion, self.db.profile)
end

function AloftCastBarTimeText:RegisterEvents()
	self:UnregisterAllEvents()
	self:UnregisterAllMessages()
	self:CancelAllTimers()

	if self.db.profile.enable then
		self:RegisterMessage("Aloft:SetupFrame", "SetupFrame")
		self:RegisterMessage("Aloft:OnCastBarValueChanged", "UpdateText")
		self:RegisterMessage("Aloft:OnNameplateHide", "OnNameplateHide")
		self:RegisterMessage("Aloft:OnCastFrameShow", "OnCastFrameShow")
		self:RegisterMessage("Aloft:OnCastFrameHide", "OnCastFrameHide")
	end
end

-----------------------------------------------------------------------------

function AloftCastBarTimeText:OnInitialize()
	if self.db ~= Aloft.AloftDB:GetNamespace(self.namespace, true) then self.db = Aloft.AloftDB:RegisterNamespace(self.namespace, self.defaults) end
end

function AloftCastBarTimeText:OnEnable()
	self:UnregisterAllEvents()
	self:UnregisterAllMessages()
	self:CancelAllTimers()

	self:RegisterMessage("Aloft:SetAll", function(message, type, value)
		if AloftCastBarTimeText.db.profile[type] then
			AloftCastBarTimeText.db.profile[type] = value
			self:Update()
		end
	end)

	self:Update()
end

function AloftCastBarTimeText:OnDisable()
	self:UnregisterAllEvents()
	self:UnregisterAllMessages()
	self:CancelAllTimers()

	if castBarTimeTextRegion then
		castBarTimeTextRegion:Hide()
	end
end

function AloftCastBarTimeText:SetupFrame(message, aloftData)
	lastCastTimeValue = 0
	if aloftData:IsTarget() then
		self:OnCastFrameShow(message, aloftData)
	end
end

function AloftCastBarTimeText:UpdateText(message, aloftData)
	if self.db.profile.enable and AloftCastBar:IsDisplayEnabled() then
		local castBar = aloftData.castBar
		local minValue, maxValue = castBar:GetMinMaxValues()
		local value = castBar:GetValue()

		local castFrame = AloftCastBar:GetCastFrame()
		if value > minValue and value < maxValue and castFrame and castFrame:IsVisible() and (not aloftData.alphaOverride or aloftData.alphaOverride > 0) then
			local text = castBarTimeTextRegion:SetText(("%.2f"):format((value > lastCastTimeValue) and (maxValue-value) or (value-minValue)))
			lastCastTimeValue = value

			local _, _, _, a = castBar:GetStatusBarColor()
			castBarTimeTextRegion:SetAlpha(a)
			-- ChatFrame7:AddMessage("AloftCastBarTimeText:UpdateText(): " .. tostring(aloftData.name) .. "/" .. tostring(castBarTimeTextRegion:GetText()))
			castBarTimeTextRegion:Show()
			return
		end
	else
		-- ChatFrame7:AddMessage("AloftCastBarTimeText:UpdateText(): disabled")
	end

	lastCastTimeValue = 0
	castBarTimeTextRegion:SetText("")
	castBarTimeTextRegion:Hide()
end

function AloftCastBarTimeText:OnNameplateHide(message, aloftData)
	if aloftData.isTarget or aloftData:IsTarget() then
		self:OnCastFrameHide(message, aloftData)
	end
end

function AloftCastBarTimeText:OnCastFrameShow(message, aloftData)
	-- ChatFrame7:AddMessage("AloftCastBarTimeText:OnCastFrameShow(): enter " .. tostring(aloftData.name))

	lastCastTimeValue = aloftData.castBar:GetValue()

	local castFrame = AloftCastBar:GetCastFrame()
	if castFrame then
		castBarTimeTextRegion:SetParent(castFrame)
		castBarTimeTextRegion:SetDrawLayer("OVERLAY")

		-- ChatFrame7:AddMessage("AloftCastBarTimeText:OnCastFrameShow(): position")
		castBarTimeTextRegion:ClearAllPoints()
		castBarTimeTextRegion:SetPoint("TOPLEFT", castFrame, "TOPLEFT", self.db.profile.offsets.left, self.db.profile.offsets.vertical)
		castBarTimeTextRegion:SetPoint("BOTTOMRIGHT", castFrame, "BOTTOMRIGHT", self.db.profile.offsets.right, self.db.profile.offsets.vertical)
	end
end

function AloftCastBarTimeText:OnCastFrameHide(message, aloftData)
	castBarTimeTextRegion:Hide()
end

-----------------------------------------------------------------------------

end)
