local Aloft = Aloft
if not Aloft then return end
local AloftModules = AloftModules
if not AloftModules then return end

-----------------------------------------------------------------------------

local L = { }

local mL = AloftLocale.AloftModules

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftAutoShow", function()

-----------------------------------------------------------------------------

-- TODO: on the surface, this wastes space in the enUS locale; the metatable could just return the canonical string as the localization;
--       BUT, this serves as a default locale, and also will permit the metatable to check/notify on missing locale strings

-- some of these duplicate labels for keybindings; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ enUS ]] L["Show Neutral/Enemy Name Plates"] = "Show Neutral/Enemy Name Plates"
--[[ enUS ]] L["Show nameplates for neutral or hostile units"] = "Show nameplates for neutral or hostile units"
--[[ enUS ]] L["Show Friendly Name Plates"] = "Show Friendly Name Plates"
--[[ enUS ]] L["Show nameplates for friendly units"] = "Show nameplates for friendly units"
--[[ enUS ]] L["Show All Name Plates"] = "Show All Name Plates"
--[[ enUS ]] L["Show Nameplates"] = "Show Nameplates"

-- player states; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ enUS ]] L["Player State"] = "Player State"
--[[ enUS ]] L["Combat"] = "Combat"
--[[ enUS ]] L["Flagged/PvP"] = "Flagged/PvP"
--[[ enUS ]] L["Resting"] = "Resting"
--[[ enUS ]] L["Group"] = "Group"
--[[ enUS ]] L["Default"] = "Default"

-- player locations; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ enUS ]] L["Player Location"] = "Player Location"
--[[ enUS ]] L["World"] = "World"
--[[ enUS ]] L["Battleground"] = "Battleground"
--[[ enUS ]] L["Arena"] = "Arena"
--[[ enUS ]] L["5-Man Instance"] = "5-Man Instance"
--[[ enUS ]] L["Raid Instance"] = "Raid Instance"

--[[ enUS ]] L["Set All"] = "Set All"

--[[ enUS ]] L["Overlap Name Plates"] = "Overlap Name Plates"
--[[ enUS ]] L["Overlap nameplates"] = "Overlap nameplates"

--[[ enUS ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"
--[[ enUS ]] L["Overlap Options"] = "Overlap Options"
--[[ enUS ]] L["Options controlling auto-overlap"] = "Options controlling auto-overlap"
--[[ enUS ]] L["Bounce Nameplates on Overlap Change"] = "Bounce Nameplates on Overlap Change"
--[[ enUS ]] L["Quicky toggle nameplates (bounce) when overlap settings are automatically changed"] = "Quicky toggle nameplates (bounce) when overlap settings are automatically changed"
--[[ enUS ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"

--[[ enUS ]] L["Auto-overlap all nameplates based on player state (subject to Visibility options)"] = "Auto-overlap all nameplates based on player state (subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates by default (subject to Visibility options)"] = "Auto-overlap all nameplates by default (subject to Visibility options)"

--[[ enUS ]] L["Auto-overlap all nameplates based on player location (subject to Visibility options)"] = "Auto-overlap all nameplates based on player location (subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ enUS ]] L["Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates (subject to Visibility options)"

--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting combat (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates by default (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates by default (subject to Visibility options)"

--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ enUS ]] L["Auto-show/hide all friendly nameplates (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates (subject to Visibility options)"

--[[ enUS ]] L["Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting combat (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates by default (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates by default (subject to Visibility options)"

--[[ enUS ]] L["Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ enUS ]] L["Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ enUS ]] L["All Nameplates"] = "All Nameplates"
--[[ enUS ]] L["All nameplates"] = "All nameplates"
--[[ enUS ]] L["Pet Nameplates"] = "Pet Nameplates"
--[[ enUS ]] L["Pet nameplates"] = "Pet nameplates"
--[[ enUS ]] L["Guardian Nameplates"] = "Guardian Nameplates"
--[[ enUS ]] L["Guardian nameplates"] = "Guardian nameplates"
--[[ enUS ]] L["Totem Nameplates"] = "Totem Nameplates"
--[[ enUS ]] L["Totem nameplates"] = "Totem nameplates"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ enUS ]] mL["AloftAutoShow"] = "AloftAutoShow"
--[[ enUS ]] mL["Automatically show/hide nameplates based on various events and conditions"] = "Automatically show/hide nameplates based on various events and conditions"

-----------------------------------------------------------------------------

local locale = GetLocale()

-----------------------------------------------------------------------------

if (locale == "koKR") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftAutoShow", function()

-----------------------------------------------------------------------------

-- some of these duplicate labels for keybindings; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ koKR ]] L["Show Neutral/Enemy Name Plates"] = "Show Neutral/Enemy Name Plates"
--[[ koKR ]] L["Show nameplates for neutral or hostile units"] = "중립적 혹은 적대적 대상에 대한 이름표를 표시합니다."
--[[ koKR ]] L["Show Friendly Name Plates"] = "Show Friendly Name Plates"
--[[ koKR ]] L["Show nameplates for friendly units"] = "우호적 대상에 대한 이름표를 표시합니다."
--[[ koKR ]] L["Show All Name Plates"] = "Show All Name Plates"
--[[ koKR ]] L["Show Nameplates"] = "이름표 표시"

-- player states; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ koKR ]] L["Combat"] = "Combat"
--[[ koKR ]] L["Flagged/PvP"] = "Flagged/PvP"
--[[ koKR ]] L["Resting"] = "Resting"
--[[ koKR ]] L["Group"] = "Group"
--[[ koKR ]] L["Default"] = "Default"

-- player locations; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ koKR ]] L["Player Location"] = "Player Location"
--[[ koKR ]] L["World"] = "World"
--[[ koKR ]] L["Battleground"] = "Battleground"
--[[ koKR ]] L["Arena"] = "Arena"
--[[ koKR ]] L["5-Man Instance"] = "5-Man Instance"
--[[ koKR ]] L["Raid Instance"] = "Raid Instance"

--[[ koKR ]] L["Set All"] = "Set All"

--[[ koKR ]] L["Overlap Name Plates"] = "Overlap Name Plates"
--[[ koKR ]] L["Overlap nameplates"] = "Overlap nameplates"

--[[ koKR ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"
--[[ koKR ]] L["Overlap Options"] = "Overlap Options"
--[[ koKR ]] L["Options controlling auto-overlap"] = "Options controlling auto-overlap"
--[[ koKR ]] L["Bounce Nameplates on Overlap Change"] = "Bounce Nameplates on Overlap Change"
--[[ koKR ]] L["Quicky toggle nameplates (bounce) when overlap settings are automatically changed"] = "Quicky toggle nameplates (bounce) when overlap settings are automatically changed"
--[[ koKR ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"

--[[ koKR ]] L["Auto-overlap all nameplates based on player state (subject to Visibility options)"] = "Auto-overlap all nameplates based on player state (subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates by default (subject to Visibility options)"] = "Auto-overlap all nameplates by default (subject to Visibility options)"

--[[ koKR ]] L["Auto-overlap all nameplates based on player location (subject to Visibility options)"] = "Auto-overlap all nameplates based on player location (subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ koKR ]] L["Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates (subject to Visibility options)"

--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting combat (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates by default (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates by default (subject to Visibility options)"

--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ koKR ]] L["Auto-show/hide all friendly nameplates (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates (subject to Visibility options)"

--[[ koKR ]] L["Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting combat (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates by default (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates by default (subject to Visibility options)"

--[[ koKR ]] L["Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ koKR ]] L["Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ koKR ]] L["All Nameplates"] = "All Nameplates"
--[[ koKR ]] L["All nameplates"] = "All nameplates"
--[[ koKR ]] L["Pet Nameplates"] = "Pet Nameplates"
--[[ koKR ]] L["Pet nameplates"] = "Pet nameplates"
--[[ koKR ]] L["Guardian Nameplates"] = "Guardian Nameplates"
--[[ koKR ]] L["Guardian nameplates"] = "Guardian nameplates"
--[[ koKR ]] L["Totem Nameplates"] = "Totem Nameplates"
--[[ koKR ]] L["Totem nameplates"] = "Totem nameplates"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ koKR ]] mL["AloftAutoShow"] = "AloftAutoShow"
--[[ koKR ]] mL["Automatically show/hide nameplates based on various events and conditions"] = "Automatically show/hide nameplates based on various events and conditions"

-----------------------------------------------------------------------------

elseif (locale == "ruRU") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftAutoShow", function()

-----------------------------------------------------------------------------

-- some of these duplicate labels for keybindings; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ ruRU ]] L["Show Neutral/Enemy Name Plates"] = "Отображать таблички нейтральных/враждебных"
--[[ ruRU ]] L["Show nameplates for neutral or hostile units"] = "Отображать таблички для нейтральных или враждебных"
--[[ ruRU ]] L["Show Friendly Name Plates"] = "Отображать таблички дружественных"
--[[ ruRU ]] L["Show nameplates for friendly units"] = "Отображать таблички для дружественных"
--[[ ruRU ]] L["Show All Name Plates"] = "Отображать все таблички"
--[[ ruRU ]] L["Show Nameplates"] = "Отображать таблички"

-- player states; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ ruRU ]] L["Player State"] = "Состояние игрока"
--[[ ruRU ]] L["Combat"] = "Бой"
--[[ ruRU ]] L["Flagged/PvP"] = "Флаг/PvP"
--[[ ruRU ]] L["Resting"] = "Отдых"
--[[ ruRU ]] L["Group"] = "Группа"
--[[ ruRU ]] L["Default"] = "По умолчанию"

-- player locations; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ ruRU ]] L["Player Location"] = "Местонахождение игрока"
--[[ ruRU ]] L["World"] = "Мир"
--[[ ruRU ]] L["Battleground"] = "Поля сражений"
--[[ ruRU ]] L["Arena"] = "Арена"
--[[ ruRU ]] L["5-Man Instance"] = "Инстансы на 5-чел"
--[[ ruRU ]] L["Raid Instance"] = "Рейдовые инстансыe"

--[[ ruRU ]] L["Set All"] = "Выбрать всё"

--[[ ruRU ]] L["Overlap Name Plates"] = "Overlap Name Plates"
--[[ ruRU ]] L["Overlap nameplates"] = "Overlap nameplates"

--[[ ruRU ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"
--[[ ruRU ]] L["Overlap Options"] = "Overlap Options"
--[[ ruRU ]] L["Options controlling auto-overlap"] = "Options controlling auto-overlap"
--[[ ruRU ]] L["Bounce Nameplates on Overlap Change"] = "Bounce Nameplates on Overlap Change"
--[[ ruRU ]] L["Quicky toggle nameplates (bounce) when overlap settings are automatically changed"] = "Quicky toggle nameplates (bounce) when overlap settings are automatically changed"
--[[ ruRU ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"

--[[ ruRU ]] L["Auto-overlap all nameplates based on player state (subject to Visibility options)"] = "Auto-overlap all nameplates based on player state (subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates by default (subject to Visibility options)"] = "Auto-overlap all nameplates by default (subject to Visibility options)"

--[[ ruRU ]] L["Auto-overlap all nameplates based on player location (subject to Visibility options)"] = "Auto-overlap all nameplates based on player location (subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ ruRU ]] L["Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных (относится к настройкам Вида)"

--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных оснавываяс на состаянии игрока (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting combat (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных при входе/выходе из боя (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных при присутствии/отсутствии метки PvP (и не находясь в бою; относится к настройкам Вида"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных при входе/выходе из состояния отдыха (и не находясь в бою или помеченным; относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных вступая/выходя из группы (и не находясь в бою, помеченным, или отдыхая; относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates by default (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных по умолчанию (относится к настройкам Вида)"

--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных основываясь на местонахождение игрока (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных при входе/выходе из мира (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных при входе/выходе из поля боя (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных при входе/выходе из арены (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных при входе/выходе из подземелья на 5-чел (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Авто-показать/скрыть все таблички нейтральных и враждебных при входе/выходе из рейдового подземелья (относится к настройкам Вида)"

--[[ ruRU ]] L["Auto-show/hide all friendly nameplates (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички (относится к настройкам Вида)"

--[[ ruRU ]] L["Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички основываясь на состоянии игрока (относится к настройкам Видаs)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on entering/exiting combat (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички при входе/выходе из боя (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички при присутствии/отсутствии метки PvP (и не находясь в бою; относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички при входе/выходе из состояния отдыха (и не находясь в бою или помеченным; относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички вступая/выходя из группы (и не находясь в бою, помеченным, или отдыхая; относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates by default (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички по умолчанию (относится к настройкам Вида)"

--[[ ruRU ]] L["Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички основываясь на местонахождение игрока (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички при входе/выходе из мира (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички при входе/выходе из поля боя (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички  при входе/выходе из арены (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички при входе/выходе из подземелья на 5-чел (относится к настройкам Вида)"
--[[ ruRU ]] L["Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Авто-показать/скрыть все дружественные таблички при входе/выходе из рейдового подземелья (относится к настройкам Вида)"

--[[ ruRU ]] L["All Nameplates"] = "All Nameplates"
--[[ ruRU ]] L["All nameplates"] = "All nameplates"
--[[ ruRU ]] L["Pet Nameplates"] = "Pet Nameplates"
--[[ ruRU ]] L["Pet nameplates"] = "Pet nameplates"
--[[ ruRU ]] L["Guardian Nameplates"] = "Guardian Nameplates"
--[[ ruRU ]] L["Guardian nameplates"] = "Guardian nameplates"
--[[ ruRU ]] L["Totem Nameplates"] = "Totem Nameplates"
--[[ ruRU ]] L["Totem nameplates"] = "Totem nameplates"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ ruRU ]] mL["AloftAutoShow"] = "AloftAutoShow"
--[[ ruRU ]] mL["Automatically show/hide nameplates based on various events and conditions"] = "Автоматически показывает/скрывает таблички основываясь на различных критериях и событиях"

-----------------------------------------------------------------------------

elseif (locale == "zhCN") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftAutoShow", function()

-----------------------------------------------------------------------------

-- some of these duplicate labels for keybindings; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ zhCN ]] L["Show Neutral/Enemy Name Plates"] = "Show Neutral/Enemy Name Plates"
--[[ zhCN ]] L["Show nameplates for neutral or hostile units"] = "显示中立或敌对单位的姓名板"
--[[ zhCN ]] L["Show Friendly Name Plates"] = "Show Friendly Name Plates"
--[[ zhCN ]] L["Show nameplates for friendly units"] = "显示友方单位的姓名板"
--[[ zhCN ]] L["Show All Name Plates"] = "Show All Name Plates"
--[[ zhCN ]] L["Show Nameplates"] = "显示姓名板"

--[[ zhCN ]] L["Combat"] = "战斗"
--[[ zhCN ]] L["Flagged/PvP"] = "Flagged/PvP"
--[[ zhCN ]] L["Resting"] = "休息"
--[[ zhCN ]] L["Group"] = "小队"
--[[ zhCN ]] L["Default"] = "默认"

-- player locations; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ zhCN ]] L["Player Location"] = "Player Location"
--[[ zhCN ]] L["World"] = "World"
--[[ zhCN ]] L["Battleground"] = "Battleground"
--[[ zhCN ]] L["Arena"] = "Arena"
--[[ zhCN ]] L["5-Man Instance"] = "5-Man Instance"
--[[ zhCN ]] L["Raid Instance"] = "Raid Instance"

--[[ zhCN ]] L["Set All"] = "全部"

--[[ zhCN ]] L["Overlap Name Plates"] = "Overlap Name Plates"
--[[ zhCN ]] L["Overlap nameplates"] = "Overlap nameplates"

--[[ zhCN ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"
--[[ zhCN ]] L["Overlap Options"] = "Overlap Options"
--[[ zhCN ]] L["Options controlling auto-overlap"] = "Options controlling auto-overlap"
--[[ zhCN ]] L["Bounce Nameplates on Overlap Change"] = "Bounce Nameplates on Overlap Change"
--[[ zhCN ]] L["Quicky toggle nameplates (bounce) when overlap settings are automatically changed"] = "Quicky toggle nameplates (bounce) when overlap settings are automatically changed"
--[[ zhCN ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"

--[[ zhCN ]] L["Auto-overlap all nameplates based on player state (subject to Visibility options)"] = "Auto-overlap all nameplates based on player state (subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates by default (subject to Visibility options)"] = "Auto-overlap all nameplates by default (subject to Visibility options)"

--[[ zhCN ]] L["Auto-overlap all nameplates based on player location (subject to Visibility options)"] = "Auto-overlap all nameplates based on player location (subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ zhCN ]] L["Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates (subject to Visibility options)"] = "自动显示/隐藏所有中立和敌对姓名板（受控于可见度选项）"

--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting combat (subject to Visibility options)"] = "进入/离开战斗时自动显示/隐藏所有中立和敌对姓名板（受控于可见度选项）"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates by default (subject to Visibility options)"] = "默认自动显示/隐藏所有中立和敌对姓名板（受控于可见度选项）"

--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ zhCN ]] L["Auto-show/hide all friendly nameplates (subject to Visibility options)"] = "自动显示/隐藏所有友方姓名板（受控于可见度选项）"

--[[ zhCN ]] L["Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on entering/exiting combat (subject to Visibility options)"] = "进入/离开战斗时自动显示/隐藏所有友方姓名板（受控于可见度选项）"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates by default (subject to Visibility options)"] = "默认自动显示/隐藏所有友方姓名板（受控于可见度选项）"

--[[ zhCN ]] L["Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ zhCN ]] L["Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ zhCN ]] L["All Nameplates"] = "All Nameplates"
--[[ zhCN ]] L["All nameplates"] = "All nameplates"
--[[ zhCN ]] L["Pet Nameplates"] = "Pet Nameplates"
--[[ zhCN ]] L["Pet nameplates"] = "Pet nameplates"
--[[ zhCN ]] L["Guardian Nameplates"] = "Guardian Nameplates"
--[[ zhCN ]] L["Guardian nameplates"] = "Guardian nameplates"
--[[ zhCN ]] L["Totem Nameplates"] = "Totem Nameplates"
--[[ zhCN ]] L["Totem nameplates"] = "Totem nameplates"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ zhCN ]] mL["AloftAutoShow"] = "自动显示"
--[[ zhCN ]] mL["Automatically show/hide nameplates based on various events and conditions"] = "在特定事件和状态下自动显示/隐藏姓名板"

-----------------------------------------------------------------------------

elseif (locale == "zhTW") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftAutoShow", function()

-----------------------------------------------------------------------------

-- some of these duplicate labels for keybindings; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ zhTW ]] L["Show Neutral/Enemy Name Plates"] = "Show Neutral/Enemy Name Plates"
--[[ zhTW ]] L["Show nameplates for neutral or hostile units"] = "顯示中立或敵對單位的名牌"
--[[ zhTW ]] L["Show Friendly Name Plates"] = "Show Friendly Name Plates"
--[[ zhTW ]] L["Show nameplates for friendly units"] = "顯示友好單位的名牌"
--[[ zhTW ]] L["Show All Name Plates"] = "Show All Name Plates"
--[[ zhTW ]] L["Show Nameplates"] = "顯示名牌"

--[[ zhTW ]] L["Combat"] = "戰斗"
--[[ zhTW ]] L["Flagged/PvP"] = "Flagged/PvP"
--[[ zhTW ]] L["Resting"] = "休息"
--[[ zhTW ]] L["Group"] = "小隊"
--[[ zhTW ]] L["Default"] = "默認"

-- player locations; should match strings in Aloft/Aloft.lua and Aloft localizations
--[[ zhTW ]] L["Player Location"] = "Player Location"
--[[ zhTW ]] L["World"] = "World"
--[[ zhTW ]] L["Battleground"] = "Battleground"
--[[ zhTW ]] L["Arena"] = "Arena"
--[[ zhTW ]] L["5-Man Instance"] = "5-Man Instance"
--[[ zhTW ]] L["Raid Instance"] = "Raid Instance"

--[[ zhTW ]] L["Set All"] = "全部"

--[[ zhTW ]] L["Overlap Name Plates"] = "Overlap Name Plates"
--[[ zhTW ]] L["Overlap nameplates"] = "Overlap nameplates"

--[[ zhTW ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"
--[[ zhTW ]] L["Overlap Options"] = "Overlap Options"
--[[ zhTW ]] L["Options controlling auto-overlap"] = "Options controlling auto-overlap"
--[[ zhTW ]] L["Bounce Nameplates on Overlap Change"] = "Bounce Nameplates on Overlap Change"
--[[ zhTW ]] L["Quicky toggle nameplates (bounce) when overlap settings are automatically changed"] = "Quicky toggle nameplates (bounce) when overlap settings are automatically changed"
--[[ zhTW ]] L["Auto-overlap all nameplates"] = "Auto-overlap all nameplates"

--[[ zhTW ]] L["Auto-overlap all nameplates based on player state (subject to Visibility options)"] = "Auto-overlap all nameplates based on player state (subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting combat (subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-overlap all nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates by default (subject to Visibility options)"] = "Auto-overlap all nameplates by default (subject to Visibility options)"

--[[ zhTW ]] L["Auto-overlap all nameplates based on player location (subject to Visibility options)"] = "Auto-overlap all nameplates based on player location (subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting the world (subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ zhTW ]] L["Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-overlap all nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates (subject to Visibility options)"] = "自動顯示/隱藏所有中立和敵對名牌（受控於可見度選項）"

--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates based on player state (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting combat (subject to Visibility options)"] = "進入/離開戰鬥時自動顯示/隱藏所有中立和敵對名牌（受控於可見度選項）"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates by default (subject to Visibility options)"] = "預設自動顯示/隱藏所有中立和敵對名牌（受控於可見度選項）"

--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates based on player location (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting the world (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-show/hide all neutral and hostile nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ zhTW ]] L["Auto-show/hide all friendly nameplates (subject to Visibility options)"] = "自動顯示/隱藏所有友方名牌（受控於可見度選項）"

--[[ zhTW ]] L["Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates based on player state (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on entering/exiting combat (subject to Visibility options)"] = "進入/離開戰鬥時自動顯示/隱藏所有友方名牌（受控於可見度選項）"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on flagging/unflagging for PvP (and not in combat; subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting resting state (and not in combat or flagged; subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting groups (and not in combat, flagged, or resting; subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates by default (subject to Visibility options)"] = "預設自動顯示/隱藏所有友方名牌（受控於可見度選項）"

--[[ zhTW ]] L["Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates based on player location (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting the world (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting battlegrounds (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting arenas (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting 5-man instances (subject to Visibility options)"
--[[ zhTW ]] L["Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"] = "Auto-show/hide all friendly nameplates on entering/exiting raid instances (subject to Visibility options)"

--[[ zhTW ]] L["All Nameplates"] = "All Nameplates"
--[[ zhTW ]] L["All nameplates"] = "All nameplates"
--[[ zhTW ]] L["Pet Nameplates"] = "Pet Nameplates"
--[[ zhTW ]] L["Pet nameplates"] = "Pet nameplates"
--[[ zhTW ]] L["Guardian Nameplates"] = "Guardian Nameplates"
--[[ zhTW ]] L["Guardian nameplates"] = "Guardian nameplates"
--[[ zhTW ]] L["Totem Nameplates"] = "Totem Nameplates"
--[[ zhTW ]] L["Totem nameplates"] = "Totem nameplates"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ zhTW ]] mL["AloftAutoShow"] = "自動顯示"
--[[ zhTW ]] mL["Automatically show/hide nameplates based on various events and conditions"] = "自動在特定的事件和狀態下顯示/隱藏名牌"

-----------------------------------------------------------------------------

end

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftAutoShow", function()

-----------------------------------------------------------------------------

AloftLocale.AloftAutoShowOptions = setmetatable(L, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
L = nil

-----------------------------------------------------------------------------

end)
