local Aloft = Aloft
if not Aloft then return end
if not AloftLocale then return end

-----------------------------------------------------------------------------

local L = { }

-----------------------------------------------------------------------------

-- TODO: on the surface, this wastes space in the enUS locale; the metatable could just return the canonical string as the localization;
--       BUT, this serves as a default locale, and also will permit the metatable to check/notify on missing locale strings

--[[ enUS ]] L["Target Tracking"] = "Target Tracking"
--[[ enUS ]] L["Various target tracking options"] = "Various target tracking options"

--[[ enUS ]] L["Treat Rares and Bosses as Unique (Experimental)"] = "Treat Rares and Bosses as Unique (Experimental)"
--[[ enUS ]] L["Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"] = "Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"

--[[ enUS ]] L["Enable Focus Tracking"] = "Enable Focus Tracking"
--[[ enUS ]] L["Enable group focus target tracking"] = "Enable group focus target tracking"
--[[ enUS ]] L["Focus Tracking Update Interval"] = "Focus Tracking Update Interval"
--[[ enUS ]] L["The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"] = "The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"

-----------------------------------------------------------------------------

local locale = GetLocale()

-----------------------------------------------------------------------------

if (locale == "koKR") then

-----------------------------------------------------------------------------

--[[ koKR ]] L["Target Tracking"] = "Target Tracking"
--[[ koKR ]] L["Various target tracking options"] = "Various target tracking options"

--[[ koKR ]] L["Treat Rares and Bosses as Unique (Experimental)"] = "Treat Rares and Bosses as Unique (Experimental)"
--[[ koKR ]] L["Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"] = "Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"

--[[ koKR ]] L["Enable Focus Tracking"] = "Enable Focus Tracking"
--[[ koKR ]] L["Enable group focus target tracking"] = "Enable group focus target tracking"
--[[ koKR ]] L["Focus Tracking Update Interval"] = "Focus Tracking Update Interval"
--[[ koKR ]] L["The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"] = "The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"

-----------------------------------------------------------------------------

elseif (locale == "ruRU") then

-----------------------------------------------------------------------------

--[[ ruRU ]] L["Target Tracking"] = "Отслеживание цели"
--[[ ruRU ]] L["Various target tracking options"] = "Настройки отслеживания цели"

--[[ ruRU ]] L["Treat Rares and Bosses as Unique (Experimental)"] = "Рассматривать редких и боссов как уникальные (Тестируется)"
--[[ ruRU ]] L["Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"] = "Цели редких и элитных боссов (пологаясь на классификаци и уровень) отслеживаются если их имена уникальные (Тестируется)"

--[[ ruRU ]] L["Enable Focus Tracking"] = "Включить отслеживание фокуса"
--[[ ruRU ]] L["Enable group focus target tracking"] = "Включить отслеживание фокуса"
--[[ ruRU ]] L["Focus Tracking Update Interval"] = "Скорость обновления отслеживания фокуса"
--[[ ruRU ]] L["The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"] = "Значение времени в секундах, между обновлением фокуса (0.0 максимальная скорость)"

-----------------------------------------------------------------------------

elseif (locale == "zhCN") then

-----------------------------------------------------------------------------

--[[ zhCN ]] L["Target Tracking"] = "Target Tracking"
--[[ zhCN ]] L["Various target tracking options"] = "Various target tracking options"

--[[ zhCN ]] L["Treat Rares and Bosses as Unique (Experimental)"] = "Treat Rares and Bosses as Unique (Experimental)"
--[[ zhCN ]] L["Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"] = "Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"

--[[ zhCN ]] L["Enable Focus Tracking"] = "Enable Focus Tracking"
--[[ zhCN ]] L["Enable group focus target tracking"] = "Enable group focus target tracking"
--[[ zhCN ]] L["Focus Tracking Update Interval"] = "Focus Tracking Update Interval"
--[[ zhCN ]] L["The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"] = "The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"

-----------------------------------------------------------------------------

elseif (locale == "zhTW") then

-----------------------------------------------------------------------------

--[[ zhTW ]] L["Target Tracking"] = "Target Tracking"
--[[ zhTW ]] L["Various target tracking options"] = "Various target tracking options"

--[[ zhTW ]] L["Treat Rares and Bosses as Unique (Experimental)"] = "Treat Rares and Bosses as Unique (Experimental)"
--[[ zhTW ]] L["Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"] = "Rare and elite boss targets (based on classification and level) are tracked as if their names are unique (experimental)"

--[[ zhTW ]] L["Enable Focus Tracking"] = "Enable Focus Tracking"
--[[ zhTW ]] L["Enable group focus target tracking"] = "Enable group focus target tracking"
--[[ zhTW ]] L["Focus Tracking Update Interval"] = "Focus Tracking Update Interval"
--[[ zhTW ]] L["The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"] = "The amount of time, in seconds, between group focus updates (0.0 is as fast as possible)"

-----------------------------------------------------------------------------

end

-----------------------------------------------------------------------------

AloftLocale.AloftTargetTrackingData = setmetatable(L, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
L = nil