local Aloft = Aloft
if not Aloft then return end
if not AloftLocale or not AloftLocale.AloftStateIcon then return end

-----------------------------------------------------------------------------

local AloftStateIcon = Aloft:NewModule("StateIcon", Aloft, "AceEvent-3.0", "AceTimer-3.0")

-----------------------------------------------------------------------------

AloftStateIcon.namespace = "stateIcon"
AloftStateIcon.defaults =
{
	profile =
	{
		enable			= true,
		alpha			= 1.0,
		reverse			= false,
		point			= "CENTER",
		relativeToPoint	= "RIGHT",
		offsetX			= -4,
		offsetY			= -1,
		height			= 34,
		width			= 46,
	},
}

-----------------------------------------------------------------------------

function AloftStateIcon:UpdateAll()
	for aloftData in Aloft:IterateNameplates() do
		self:SetupFrame("AloftStateIcon:UpdateAll", aloftData)
	end
end

-----------------------------------------------------------------------------

function AloftStateIcon:OnInitialize()
	if self.db ~= Aloft.AloftDB:GetNamespace(self.namespace, true) then self.db = Aloft.AloftDB:RegisterNamespace(self.namespace, self.defaults) end
end

function AloftStateIcon:OnEnable()
	self:RegisterMessage("Aloft:SetupFrame", "SetupFrame")
	self:RegisterMessage("Aloft:OnNameplateShow", "OnNameplateShow")
	self:UpdateAll()
end

function AloftStateIcon:OnDisable()
	self:UnregisterAllEvents()
	self:UnregisterAllMessages()
	self:CancelAllTimers()

	for aloftData in Aloft:IterateNameplates() do
		local stateIconRegion = aloftData.stateIconRegion

		if stateIconRegion then
			stateIconRegion:ClearAllPoints()
			stateIconRegion:SetPoint("CENTER", aloftData.levelTextRegion, "CENTER", 4.70, 1.57)
			stateIconRegion:SetWidth(46)
			stateIconRegion:SetHeight(34)
			stateIconRegion:SetAlpha(1)
			if stateIconRegion.ULx then
				stateIconRegion:SetTexCoord(stateIconRegion.ULx, stateIconRegion.ULy, stateIconRegion.LLx, stateIconRegion.LLy, stateIconRegion.URx, stateIconRegion.URy, stateIconRegion.LRx, stateIconRegion.LRy) -- un-flip/mirror horizontally, restore to original values
			end
			stateIconRegion:SetDrawLayer("OVERLAY")
		end
	end
end

function AloftStateIcon:SetupFrame(message, aloftData)
	if aloftData then -- apparently we can get here with a nil nameplate
		local stateIconRegion = aloftData.stateIconRegion

		if stateIconRegion --[[and stateIconRegion:IsVisible()]] then
			if not stateIconRegion.ULx then
				stateIconRegion.ULx, stateIconRegion.ULy, stateIconRegion.LLx, stateIconRegion.LLy, stateIconRegion.URx, stateIconRegion.URy, stateIconRegion.LRx, stateIconRegion.LRy = stateIconRegion:GetTexCoord() -- collect the coordinates currently in use
			end
			if self.db.profile.reverse then
				stateIconRegion:SetTexCoord(stateIconRegion.URx, stateIconRegion.URy, stateIconRegion.LRx, stateIconRegion.LRy, stateIconRegion.ULx, stateIconRegion.ULy, stateIconRegion.LLx, stateIconRegion.LLy) -- flip/mirror horizontally
			else
				stateIconRegion:SetTexCoord(stateIconRegion.ULx, stateIconRegion.ULy, stateIconRegion.LLx, stateIconRegion.LLy, stateIconRegion.URx, stateIconRegion.URy, stateIconRegion.LRx, stateIconRegion.LRy) -- un-flip/mirror horizontally, restore to original values
			end

			-- NOTE: odd artifacts ensue when we attach to layoutFrame; works better when we attach to levelTextRegion
			self:PlaceFrame(stateIconRegion, aloftData.layoutFrame, self.db.profile, 0, 0)
			stateIconRegion:SetDrawLayer("OVERLAY")
			stateIconRegion:SetBlendMode("BLEND")
		end
	end
end

function AloftStateIcon:OnNameplateShow(message, aloftData)
	self:SetupFrame(message, aloftData)
	--[[
	self:ScheduleTimer(function(aloftData) AloftStateIcon:DoNameplateShow(aloftData) end, 0.0, aloftData) -- next frame
	]]
end

function AloftStateIcon:DoNameplateShow(aloftData)
	self:SetupFrame("AloftStateIcon:DoNameplateShow", aloftData)
end

-----------------------------------------------------------------------------
