local Aloft = Aloft
if not Aloft then return end
if not AloftLocale then return end

-----------------------------------------------------------------------------

local L = { }

-----------------------------------------------------------------------------

-- TODO: on the surface, this wastes space in the enUS locale; the metatable could just return the canonical string as the localization;
--       BUT, this serves as a default locale, and also will permit the metatable to check/notify on missing locale strings

--[[ enUS ]] L["HostileNameplatesEnabled"] = "Hostile nameplates |cff00ff00enabled|r."
--[[ enUS ]] L["HostileNameplatesDisabled"] = "Hostile nameplates |cffff0000disabled|r."
--[[ enUS ]] L["FriendlyNameplatesEnabled"] = "Friendly nameplates |cff00ff00enabled|r."
--[[ enUS ]] L["FriendlyNameplatesDisabled"] = "Friendly nameplates |cffff0000disabled|r."

--[[ enUS ]] L["Report Status Changes"] = "Report Status Changes"
--[[ enUS ]] L["Prints the status of nameplates whenever they change"] = "Prints the status of nameplates whenever they change"

-----------------------------------------------------------------------------

local locale = GetLocale()

-----------------------------------------------------------------------------

if (locale == "koKR") then

-----------------------------------------------------------------------------

--[[ koKR ]] L["HostileNameplatesEnabled"] = "적대적 대상의 이름표 : |cff00ff00표시|r."
--[[ koKR ]] L["HostileNameplatesDisabled"] = "적대적 대상의 이름표 : |cffff0000숨김|r."
--[[ koKR ]] L["FriendlyNameplatesEnabled"] = "우호적 대상의 이름표 : |cff00ff00표시|r."
--[[ koKR ]] L["FriendlyNameplatesDisabled"] = "우호적 대상의 이름표 : |cffff0000숨김|r."

--[[ koKR ]] L["Report Status Changes"] = "상태 변경 알림"
--[[ koKR ]] L["Prints the status of nameplates whenever they change"] = "이름표의 표시 상태 변경시 대화창에 표시합니다."

-----------------------------------------------------------------------------

elseif (locale == "ruRU") then

-----------------------------------------------------------------------------

--[[ ruRU ]] L["HostileNameplatesEnabled"] = "Таблички враждебных |cff00ff00включены|r."
--[[ ruRU ]] L["HostileNameplatesDisabled"] = "Таблички враждебных |cffff0000отключены|r."
--[[ ruRU ]] L["FriendlyNameplatesEnabled"] = "Таблички дружественных |cff00ff00включены|r."
--[[ ruRU ]] L["FriendlyNameplatesDisabled"] = "Таблички дружественных |cffff0000отключены|r."

--[[ ruRU ]] L["Report Status Changes"] = "Сообщать об изменении статуса"
--[[ ruRU ]] L["Prints the status of nameplates whenever they change"] = "Печатает статус табличек при их изменении"

-----------------------------------------------------------------------------

elseif (locale == "zhCN") then

-----------------------------------------------------------------------------

--[[ zhCN ]] L["HostileNameplatesEnabled"] = "敌对姓名板|cff00ff00已启用|r。"
--[[ zhCN ]] L["HostileNameplatesDisabled"] = "敌对姓名板|cffff0000已禁用|r。"
--[[ zhCN ]] L["FriendlyNameplatesEnabled"] = "友方姓名板|cff00ff00已启用|r。"
--[[ zhCN ]] L["FriendlyNameplatesDisabled"] = "友方姓名板|cffff0000已禁用|r。"

--[[ zhCN ]] L["Report Status Changes"] = "报告状态变化"
--[[ zhCN ]] L["Prints the status of nameplates whenever they change"] = "报告姓名板的状态变化"

-----------------------------------------------------------------------------

elseif (locale == "zhTW") then

-----------------------------------------------------------------------------

--[[ zhTW ]] L["HostileNameplatesEnabled"] = "敵對名牌|cff00ff00已啟用|r。"
--[[ zhTW ]] L["HostileNameplatesDisabled"] = "敵對名牌|cffff0000已停用|r。"
--[[ zhTW ]] L["FriendlyNameplatesEnabled"] = "友好名牌|cff00ff00已啟用|r。"
--[[ zhTW ]] L["FriendlyNameplatesDisabled"] = "友好名牌|cffff0000已停用|r。"

--[[ zhTW ]] L["Report Status Changes"] = "報告狀態變化"
--[[ zhTW ]] L["Prints the status of nameplates whenever they change"] = "報告名牌的狀態變化"

-----------------------------------------------------------------------------

end

-----------------------------------------------------------------------------

AloftLocale.AloftReportStatusChanges = setmetatable(L, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
L = nil
