local Aloft = Aloft
if not Aloft then return end
local AloftModules = AloftModules
if not AloftModules then return end

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftPresets", function()

-----------------------------------------------------------------------------
--
-- To add more presets, create your own files with their data table
-- And add them into Aloft's by using:
--   Aloft:GetModule("Presets"):AddPreset(presetName, presetDataTable)
--
-- The table contains keys which are module db namespaces, and the values
-- that they override from the default
--
-- Guideline list of interrelated variables:
--  healthText: enable, mode, format
--  guildText: enable, attachFormat, attachToName, useShort, showOwn, nameText.format
--  guildText: enable, attachToName, useShort, showOwn, format
--  levelText: enable, showRace, showClassification, showCreatureType, format
--
-----------------------------------------------------------------------------

if not Aloft:GetModule("Presets", true) then return end
if not AloftLocale or not AloftLocale.AloftPresets then return end

-----------------------------------------------------------------------------

local AloftPresets = Aloft:GetModule("Presets")

local L = AloftLocale.AloftPresets

-----------------------------------------------------------------------------

Aloft.Options.args.basic.args.presets.type = 'select'
Aloft.Options.args.basic.args.presets.width = 'full'
Aloft.Options.args.basic.args.presets.name = L["Presets"]
Aloft.Options.args.basic.args.presets.desc = L["Preset configurations"]
Aloft.Options.args.basic.args.presets.order = 700
Aloft.Options.args.basic.args.presets.disabled = function(i) return not Aloft:IsEnabled() or not AloftPresets:IsEnabled() end
Aloft.Options.args.basic.args.presets.get = function(i) return lastPreset end
Aloft.Options.args.basic.args.presets.set = function(i, v) AloftPresets:Set(v) end
Aloft.Options.args.basic.args.presets.disabled = function(i) return not Aloft:IsEnabled() end

-----------------------------------------------------------------------------

end)
