local Aloft = Aloft
if not Aloft then return end
local AloftModules = AloftModules
if not AloftModules then return end
if not AloftLocale or not AloftLocale.AloftModules then return end

-----------------------------------------------------------------------------

local dL = { }

local oL = { }

local mL = AloftLocale.AloftModules

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftPlayerTitle", function()

-----------------------------------------------------------------------------

-- TODO: on the surface, this wastes space in the enUS locale; the metatable could just return the canonical string as the localization;
--       BUT, this serves as a default locale, and also will permit the metatable to check/notify on missing locale strings


--[[ enUS ]] dL["PrefixTest"] = "(.*) %s(.*)"
--[[ enUS ]] dL["SuffixTest1"] = "(.*)%s, (.*)"
--[[ enUS ]] dL["SuffixTest2"] = "(.*)%s (.*)"

--[[ enUS ]] dL["Unknown"] = "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ enUS ]] oL["Save Player Title Data"] = "Save Player Title Data"
--[[ enUS ]] oL["Stores player title information between sessions"] = "Stores player title information between sessions"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ enUS ]] mL["AloftPlayerTitle"] = "AloftPlayerTitle"
--[[ enUS ]] mL["Gather and display player titles on nameplates"] = "Gather and display player titles on nameplates"

-----------------------------------------------------------------------------

local locale = GetLocale()

-----------------------------------------------------------------------------

if (locale == "koKR") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftPlayerTitle", function()

-----------------------------------------------------------------------------

--[[ koKR ]] dL["PrefixTest"] = "(.*) %s(.*)"
--[[ koKR ]] dL["SuffixTest1"] = "(.*)%s, (.*)"
--[[ koKR ]] dL["SuffixTest2"] = "(.*)%s (.*)"

--[[ koKR ]] dL["Unknown"] = "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ koKR ]] oL["Save Player Title Data"] = "Save Player Title Data"
--[[ koKR ]] oL["Stores player title information between sessions"] = "Stores player title information between sessions"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ koKR ]] mL["AloftPlayerTitle"] = "AloftPlayerTitle"
--[[ koKR ]] mL["Gather and display player titles on nameplates"] = "Gather and display player titles on nameplates"

-----------------------------------------------------------------------------

elseif (locale == "ruRU") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftPlayerTitle", function()

-----------------------------------------------------------------------------

--[[ ruRU ]] dL["PrefixTest"] = "(.*) %s(.*)"
--[[ ruRU ]] dL["SuffixTest1"] = "(.*)%s, (.*)"
--[[ ruRU ]] dL["SuffixTest2"] = "(.*)%s (.*)"

--[[ ruRU ]] dL["Unknown"] = "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ ruRU ]] oL["Save Player Title Data"] = "Записать данные о титулах игрока"
--[[ ruRU ]] oL["Stores player title information between sessions"] = "Сохранять данные о титулах игрока между сессиями"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ ruRU ]] mL["AloftPlayerTitle"] = "AloftPlayerTitle"
--[[ ruRU ]] mL["Gather and display player titles on nameplates"] = "Отображает титул игрока"

-----------------------------------------------------------------------------

elseif (locale == "zhCN") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftPlayerTitle", function()

-----------------------------------------------------------------------------

--[[ zhCN ]] dL["PrefixTest"] = "(.*) %s(.*)"
--[[ zhCN ]] dL["SuffixTest1"] = "(.*)%s, (.*)"
--[[ zhCN ]] dL["SuffixTest2"] = "(.*)%s (.*)"

--[[ zhCN ]] dL["Unknown"] = "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ zhCN ]] oL["Save Player Title Data"] = "保存玩家头衔数据"
--[[ zhCN ]] oL["Stores player title information between sessions"] = "在两次登录的间隔保存玩家头衔数据"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ zhCN ]] mL["AloftPlayerTitle"] = "玩家称号"
--[[ zhCN ]] mL["Gather and display player titles on nameplates"] = "在姓名板上显示玩家称号"

-----------------------------------------------------------------------------

elseif (locale == "zhTW") then

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftPlayerTitle", function()

-----------------------------------------------------------------------------

--[[ zhTW ]] dL["PrefixTest"] = "(.*) %s(.*)"
--[[ zhTW ]] dL["SuffixTest1"] = "(.*)%s, (.*)"
--[[ zhTW ]] dL["SuffixTest2"] = "(.*)%s (.*)"

--[[ zhTW ]] dL["Unknown"] = "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ zhTW ]] oL["Save Player Title Data"] = "保存玩家頭銜數據"
--[[ zhTW ]] oL["Stores player title information between sessions"] = "登入期間保存玩家頭銜數據"

-----------------------------------------------------------------------------

end)

-----------------------------------------------------------------------------

--[[ zhTW ]] mL["AloftPlayerTitle"] = "玩家稱號"
--[[ zhTW ]] mL["Gather and display player titles on nameplates"] = "在名牌上顯示玩家稱號"

-----------------------------------------------------------------------------

end

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftPlayerTitle", function()

-----------------------------------------------------------------------------

AloftLocale.AloftPlayerTitleData = setmetatable(dL, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
dL = nil

AloftLocale.AloftPlayerTitleDataOptions = setmetatable(oL, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
oL = nil

-----------------------------------------------------------------------------

end)
