local Aloft = Aloft
if not Aloft then return end
local AloftModules = AloftModules
if not AloftModules then return end

-----------------------------------------------------------------------------

-- AloftModules:AddInitializer("AloftHealthBarDeficit", function()

if not Aloft:GetModule("HealthBarDeficit", true) then return end
if not AloftLocale or not AloftLocale.AloftHealthBarDeficit then return end

-----------------------------------------------------------------------------

local AloftHealthBarDeficit = Aloft:GetModule("HealthBarDeficit")

local L = AloftLocale.AloftHealthBarDeficit

-----------------------------------------------------------------------------

-- inject our external module options into the appropriate internal module options
Aloft.Options.args.healthBar.args.deficit =
{
	type = 'toggle',
	name = L["Deficit Health Bar"],
	desc = L["Display health bar as a deficit (grows from right as health is lost)"],
	disabled = function(i)
					-- ChatFrame7:AddMessage("Aloft.Options.args.healthBar.args.deficit.disabled(): " .. tostring(Aloft:IsEnabled()) .. "/" .. tostring(AloftHealthBarDeficit:IsEnabled()) .. "/" .. tostring(AloftHealthBarDeficit.db) .. "/" .. tostring(AloftHealthBarDeficit.db.profile))
					return not Aloft:IsEnabled() or not AloftHealthBarDeficit:IsEnabled() or not AloftHealthBarDeficit.db or not AloftHealthBarDeficit.db.profile
				end,
	get = function(i) return AloftHealthBarDeficit.db.profile.enable end,
	set = function(i, v) AloftHealthBarDeficit.db.profile.enable = v Aloft:DetermineDataSources() AloftHealthBarDeficit:UpdateAll() end,
	order = 99
}

-----------------------------------------------------------------------------

-- end)
