local Aloft = Aloft
if not Aloft then return end
local AloftModules = AloftModules
if not AloftModules then return end

-----------------------------------------------------------------------------

AloftModules:AddInitializer("AloftCrowdControl", function()

if not Aloft:GetModule("CrowdControl", true) then return end

-----------------------------------------------------------------------------

local AloftCrowdControlSpellIcon = Aloft:NewModule("CrowdControlSpellIcon", Aloft, "AceEvent-3.0", "AceTimer-3.0")
AloftCrowdControlSpellIcon.dynamic = "AloftCrowdControl"

local AloftCrowdControl = Aloft:GetModule("CrowdControl")

-----------------------------------------------------------------------------

AloftCrowdControlSpellIcon.namespace = "crowdControlSpellIcon"
AloftCrowdControlSpellIcon.defaults =
{
	profile =
	{
		enable			= false,
		point			= "RIGHT",
		relativeToPoint	= "LEFT",
		offsetX			= 0,
		offsetY			= 0,
		size			= 12,
	},
}

-----------------------------------------------------------------------------

local crowdControlSpellIconRegion = nil

-----------------------------------------------------------------------------

function AloftCrowdControlSpellIcon:UpdateAll()
	self:CreateFrame()
	self:RegisterEvents()

	if self.db.profile.enable then
		self:SetupFrame("AloftCrowdControlSpellIcon:UpdateAll")
	end
end

-----------------------------------------------------------------------------

function AloftCrowdControlSpellIcon:CreateFrame()
	if not self.db.profile.enable then
		if crowdControlSpellIconRegion then
			crowdControlSpellIconRegion:Hide()
		end
		return
	end

	if not crowdControlSpellIconRegion and AloftCrowdControl.crowdControlExtraFrame then
		local crowdControlExtraFrame = AloftCrowdControl.crowdControlExtraFrame
		crowdControlSpellIconRegion = crowdControlExtraFrame:CreateTexture(nil, "OVERLAY")
		crowdControlSpellIconRegion:SetBlendMode("BLEND")
		crowdControlSpellIconRegion:Hide()
	end
end

-----------------------------------------------------------------------------

function AloftCrowdControlSpellIcon:RegisterEvents()
	self:UnregisterAllEvents()
	self:UnregisterAllMessages()
	self:CancelAllTimers()

	if self.db.profile.enable then
		self:RegisterMessage("Aloft:SetupFrame", "SetupFrame")
		self:RegisterMessage("Aloft:OnNameplateShow", "OnCrowdControlBarShow")
		self:RegisterMessage("Aloft:OnNameplateHide", "OnCrowdControlBarHide")
		self:RegisterMessage("Aloft:OnCrowdControlBarShow", "OnCrowdControlBarShow")
		self:RegisterMessage("Aloft:OnCrowdControlBarHide", "OnCrowdControlBarHide")
	end
end

-----------------------------------------------------------------------------

function AloftCrowdControlSpellIcon:OnInitialize()
	if self.db ~= Aloft.AloftDB:GetNamespace(self.namespace, true) then self.db = Aloft.AloftDB:RegisterNamespace(self.namespace, self.defaults) end
end

function AloftCrowdControlSpellIcon:OnEnable()
	-- ChatFrame7:AddMessage("AloftCrowdControlSpellIcon:OnEnable(): enter")
	self:UpdateAll()
end

function AloftCrowdControlSpellIcon:OnDisable()
	self:UnregisterAllEvents()
	self:UnregisterAllMessages()
	self:CancelAllTimers()

	if crowdControlSpellIconRegion then
		crowdControlSpellIconRegion:Hide()
	end
end

function AloftCrowdControlSpellIcon:SetupFrame(message)
end

function AloftCrowdControlSpellIcon:OnCrowdControlBarShow(message, aloftData)
	self:PlaceFrame(crowdControlSpellIconRegion, AloftCrowdControl.crowdControlExtraFrame, self.db.profile)
	crowdControlSpellIconRegion:SetTexture(AloftCrowdControl.crowdControlSpellIcon)
	crowdControlSpellIconRegion:Show()

	self:CancelAllTimers()
	self:ScheduleRepeatingTimer(function(crowdControlFrame) AloftCrowdControlSpellIcon:UpdateAlpha(crowdControlFrame) end, 0.1, AloftCrowdControl.crowdControlFrame)
end

function AloftCrowdControlSpellIcon:OnCrowdControlBarHide(message, aloftData)
	self:CancelAllTimers()
	crowdControlSpellIconRegion:SetTexture("")
	crowdControlSpellIconRegion:Hide()
end

function AloftCrowdControlSpellIcon:UpdateAlpha(crowdControlFrame)
	local crowdControlRegion = AloftCrowdControl.crowdControlFrame and AloftCrowdControl.crowdControlFrame.crowdControlRegion
	if crowdControlRegion then
		local _, _, _, a = AloftCrowdControl.crowdControlFrame.crowdControlRegion:GetVertexColor()
		crowdControlSpellIconRegion:SetAlpha(a)
	end
end

-----------------------------------------------------------------------------

end)
